local LOG_MAX_ITEMS = 5
    
local clear_all = ngx.var.clear_all
local clear_ip = ngx.var.clear_ip
local clear_user = ngx.var.clear_user

-- Method to print the dict keys
-- print only n items of the dict not all the items.
local printLockedUserNames = function(shared_dict) 
    local keys = shared_dict:get_keys(LOG_MAX_ITEMS)
    table.sort(keys)
    for _,k in ipairs(keys) do
        ngx.log(ngx.INFO,"Existing value for the key ", k, " value is ", shared_dict:get(k))
    end
end


local flushAllUnAuthorizedUsersInfo = function() 
    local clientstorage = ngx.shared.clientstorage
    printLockedUserNames(clientstorage)
    ngx.log(ngx.INFO,"Clearing client storage dictionary")
    clientstorage:flush_all()
    clientstorage:flush_expired()

    
    local blockingresources = ngx.shared.blockingresources
    printLockedUserNames(blockingresources)
    ngx.log(ngx.INFO,"Clearing blocking resources dictionary")
    blockingresources:flush_all()
    blockingresources:flush_expired()

    
    local credentialsstore = ngx.shared.credentialsstore
    printLockedUserNames(credentialsstore)
    ngx.log(ngx.INFO,"Clearing credentials store resources")
    credentialsstore:flush_all()
    credentialsstore:flush_expired()
end

local flushLockedOutIP = function(key) 
    local clientstorage = ngx.shared.clientstorage
    printLockedUserNames(clientstorage)
    ngx.log(ngx.INFO,"Clearing client storage dictionary for IP ", key)
    if clientstorage:get(key) ~= nil then
        clientstorage:set(key, nil, 0)
        clientstorage:flush_expired()
    end
    
    local blockingresources = ngx.shared.blockingresources
    printLockedUserNames(blockingresources)
    ngx.log(ngx.INFO,"Clearing blocking resources dictionary for IP ", key)
    if blockingresources:get(key) ~= nil then
        blockingresources:set(key, nil, 0)
        blockingresources:flush_expired()
    end
end

local flushLockedOutUser = function(key) 
    local credentialsstore = ngx.shared.credentialsstore
    printLockedUserNames(credentialsstore)
    ngx.log(ngx.INFO,"Clearing credentials store resources for UserId ", key)
    if credentialsstore:get(key) ~= nil then
        credentialsstore:set(key, nil, 0)
        credentialsstore:flush_expired()
    end
end


ngx.log(ngx.INFO,"[", clear_all ,"] is [", clear_all, "], clear_ip is  [", clear_ip, "], clear_user is [", clear_user, "]")

if clear_all ~= nil and clear_all ~= '' then
    flushAllUnAuthorizedUsersInfo()
else
    if clear_ip ~= nil and clear_ip ~= '' then
        flushLockedOutIP(clear_ip)
    end
    if clear_user ~= nil and clear_user ~= '' then
        flushLockedOutUser(clear_user)
    end
end