--[[
   This module is used to kick start a health check on cloud connect nodes defined as upstream servers for dr api.
   It uses "resty.upstream.healthcheck_tls" and passes the required parameters for health check.
   These parameters are defined in cloudconnect.env, to understand more about how these parameters affect health check refer to cloudconnect.env.
]]
        local hc = require "resty.upstream.healthcheck_tls"
        
        local ok, err = hc.spawn_checker{
            shm = "healthcheck",  
            upstream = "cloudconnect_backend_${NGX_CLOUDCONNECT_HOSTNAME}", 
            type = "https",
            http_req = "GET ${NGX_CLOUDCONNECT_HEALTHCHECK_API} HTTP/1.0\r\nHost: ${NGX_PRXY_CLOUDCONNECT_HOSTNAME}\r\n\r\n",
            interval = ${NGX_CLOUDCONNECT_HEALTHCHECK_INTERVAL},
            timeout = ${NGX_CLOUDCONNECT_HEALTHCHECK_TIMEOUT},
            fall = ${NGX_CLOUDCONNECT_HEALTHCHECK_FALL},
            rise = ${NGX_CLOUDCONNECT_HEALTHCHECK_RISE}, 
            valid_statuses = ${NGX_CLOUDCONNECT_HEALTHCHECK_RESPONSE_CODES},
            concurrency = ${NGX_CLOUDCONNECT_HEALTHCHECK_CONCURRENCY}, 
			host = "${NGX_PRXY_CLOUDCONNECT_HOSTNAME}",
            ssl_verify = $NGX_CLOUDCONNECT_HEALTHCHECK_SSL_VERIFY,
        }
        if not ok then
            ngx.log(ngx.ERR, "Failed to spawn active health checker: ", err)
            return
        end