#!/bin/bash

SCRIPTPATH=$(dirname ${0})

LOG_FILE=${SCRIPTPATH}/generate_config.log

# ANSI color codes
COLOR_WARN='\033[0;33m'   # Yellow for warnings
COLOR_ERROR='\033[0;31m'  # Red for errors
COLOR_RESET='\033[0m'     # Reset to default color

log_info() {
    echo -e "[INFO]: $@"
    echo `date "+%m/%d/%Y %H:%M:%S :"` "[INFO]: $@" >> ${LOG_FILE}
}

log_warn() {
    echo -e "${COLOR_WARN}[WARN]: $@${COLOR_RESET}"
    echo `date "+%m/%d/%Y %H:%M:%S :"` "[WARN]: $@" >> ${LOG_FILE}
}

log_error() {
    echo -e "${COLOR_ERROR}[ERROR]: $@${COLOR_RESET}" >&2
    echo `date "+%m/%d/%Y %H:%M:%S :"` "[ERROR]: $@" >> ${LOG_FILE}
}

function logInfoOnlyToFile()
{
   echo `date "+%m/%d/%Y %H:%M:%S :"` "$@" >> ${LOG_FILE}
}

