#!/bin/bash

CURRENT_SCRIPTPATH=$(dirname "${0}")

source "${CURRENT_SCRIPTPATH}"/common_utils.sh
source "${CURRENT_SCRIPTPATH}"/upgrade_utils.sh

# Version path to follow to upgrade the corresponding env file.
# Note: This must be always sorted values and corresponding upgrade funtions must be present on this file.
# Eg: If the value contains "0, 2.5, 3.2" the following functions must be present
# upgrade_0_to_2dot5(), upgrade_2dot5_to_3dot2()
VERSION_PATH="0, 2.0, 2.1, 2.2, 2.3, 2.4, 2.5, 2.6, 2.7, 2.8, 2.9"

# Function to upgrade 15.0 config
function upgrade_0_to_2dot0() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.0"

    add_multiline_comment_and_property $env_file "#IPTable hardening related Configs\n#IPTables hardening is enabled if NGX_IPTABLES_HARDENING is 1 and NGX_EXTERNAL_INTERFACE value is non empty" "NGX_IPTABLES_HARDENING" "1"

    # Should we get the input from user to update the interface name?
    update_property $env_file "NGX_THIRDPARTYGADGETURLLIST_SHRD_DICT_SIZE" "100m"

    remove_property $env_file "NGX_CLIENT_MAX_BODY_SIZE"
    remove_property $env_file "NGX_LARGE_CLIENT_HEADER_BUFFER_NUM"
    remove_property $env_file "NGX_LARGE_CLIENT_HEADER_BUFFER_SIZE"


    add_multiline_comment_and_property $env_file "# Restricts direct connections to the proxy. Only NGX_LOAD_BALANCER_IPS will be allowed to connect to the proxy.\n# Ensure NGX_LOAD_BALANCER_IPS is not empty if NGX_TRAFFIC_RESTRICTED is true." "NGX_TRAFFIC_RESTRICTED" "true"
    add_multiline_comment_and_property $env_file "# HTTP2 support by default disabled.\n# Enabled if required." "NGX_HTTP2_SUPPORT" "off"

    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

# function to upgrade 2.0 to 2.1
function upgrade_2dot0_to_2dot1() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.1"
    add_multiline_comment_and_property $env_file "# NGINX jsp rate limit" "NGX_JSP_REQUEST_RATE_LIMIT" "1r/s"
    add_multiline_comment_and_property $env_file "# Valid User-Agents regex\n# Allow only requests from FireFox, Chrome, Edge and Safari." "NGX_VALID_USER_AGENTS_REGEX" "\"~*(^Mozilla/5\.0 .*(Firefox|Chrome|Edg|Safari)/[0-9]+)\""
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

# function to upgrade 2.1 to 2.2
function upgrade_2dot1_to_2dot2() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.2"
    add_multiline_comment_and_property $env_file "# By default SeLinux on the hostbox is enforce, reverse proxy started with secured mode with predefined set of container-selinux rules.\n# Set it to true to ignore the SeLinux enforcement." "NGX_IGNORE_SELINUX" "false"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

# function to upgrade 2.3 to 2.4
function upgrade_2dot3_to_2dot4() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.4"
    add_multiline_comment_and_property $env_file "# If value set to true - Limit the upstream max connections based on the installer.env's AGENT_COUNT\n# If set to false, no limit in upstream max_conns will be used" "NGX_SET_UPSTREAM_MAX_CONNS" "true"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}



# function to upgrade 2.2 to 2.3
function upgrade_2dot2_to_2dot3() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.3"
    add_multiline_comment_and_property $env_file "# Enable websocket authentication - It is enabled by default, support only true or false\n" "NGX_AUTHENTICATE_WEBSOCKET" "true"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

# function to upgrade 2.4 to 2.5
function upgrade_2dot4_to_2dot5() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.5"
    add_multiline_comment_and_property $env_file "# By default user-agents are validated with allowed list\n# true - uses the NGX_VALID_USER_AGENTS_REGEX to validate the user-agent\n# false - uses default block list to block the invalid user-agent" "NGX_USE_REGEX_TO_VALIDATE_USER_AGENT" "true"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

# function to upgrade 2.4 to 2.5
function upgrade_2dot5_to_2dot6() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.6"
    remove_property $env_file "NGX_DNS_RSLVR"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

# function to upgrade 2.6 to 2.7
function upgrade_2dot6_to_2dot7() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.7"
    add_multiline_comment_and_property $env_file "# Log level of error.log file, by default info \n# debug, info, warn, error, crit and alert emerg are supported." "NGX_ERR_LOG_LEVEL" "info"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}


# function to upgrade 2.7 to 2.8
function upgrade_2dot7_to_2dot8() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.8"
    update_property $env_file "NGX_HTTP2_SUPPORT" "on"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

# function to upgrade 2.8 to 2.9
function upgrade_2dot8_to_2dot9() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.9"
    remove_property $env_file "NGX_VALID_USER_AGENTS_REGEX"
    add_multiline_comment_and_property $env_file "# Valid User-Agents regex\n# Allow only requests from FireFox, Chrome, Edge, Safari and Apache Shindig." "NGX_VALID_USER_AGENTS_REGEX" "\"~*(^Mozilla/5\.0 .*(Firefox|Chrome|Edg|Safari)/[0-9]+|Apache Shindig)\""
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

# Function to upgrade 12.6.2 ES config
# For ES release the global variable value CONFIG_VERSION should be set as 1.01
# core config will upgraded from to 1.01.
function upgrade_0_to_1dot01() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION=" "CONFIG_VERSION" "1.01"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}
