#!/bin/bash

CURRENT_SCRIPTPATH=$(dirname "${0}")

source "${CURRENT_SCRIPTPATH}"/common_utils.sh
source "${CURRENT_SCRIPTPATH}"/upgrade_utils.sh

# Version path to follow to upgrade the corresponding env file.
# Note: This must be always sorted values and corresponding upgrade funtions must be present on this file.
# Eg: If the value contains "0, 2.5, 3.2" the following functions must be present
# upgrade_0_to_2dot5(), upgrade_2dot5_to_3dot2()
VERSION_PATH="0, 2.0"

# Function to upgrade 15.0 config
function upgrade_0_to_2dot0() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.0"
    add_multiline_comment_and_property $env_file "# referer_hash_bucket_size value" "NGX_IDS_REFERER_HASH_BUCKET_SIZE" "256"
    add_multiline_comment_and_property $env_file "###Following are the IPTable specific configurations###\n###These values will take effect only when core.env's NGX_IPTABLES_HARDENING value is set as 1 and NGX_EXTERNAL_INTERFACE is present\n" "IPTABLES_CONNECTION_LIMIT_ABOVE" "6"
    add_multiline_comment_and_property $env_file "" "IPTABLES_HASH_LIMIT_UPTO" "2/sec"
    add_multiline_comment_and_property $env_file "" "IPTABLES_HASH_LIMIT_BURST" "4"
    add_multiline_comment_and_property $env_file "" "IPTABLES_LOG_LIMIT_BURST" "1"
    add_multiline_comment_and_property $env_file "" "IPTABLES_LOG_LIMIT" "1/min"
    add_multiline_comment_and_property $env_file "# Sets the maximum allowed size of the client request body" "NGX_CLIENT_MAX_BODY_SIZE" "12K"
    add_multiline_comment_and_property $env_file "# Sets the maximum size of buffers used for reading large client request header. A request line cannot exceed the size of one buffer\n# Buffers are allocated only on demand" "NGX_LARGE_CLIENT_HEADER_BUFFER_SIZE" "8K"
    add_multiline_comment_and_property $env_file "" "NGX_LARGE_CLIENT_HEADER_BUFFER_NUM" "2"
    add_multiline_comment_and_property $env_file "# Defines a timeout for reading client request header" "NGX_CLIENT_HEADER_TIMEOUT" "10s"
    add_multiline_comment_and_property $env_file "# Defines a timeout for reading client request body. The timeout is set only for a\n# period between two successive read operations, not for the transmission of the whole request body" "NGX_CLIENT_BODY_TIMEOUT" "10s"
    add_multiline_comment_and_property $env_file "# Sets a timeout during which a keep-alive client connection will stay open on the server side" "NGX_KEEPALIVE_TIMEOUT" "10s"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}


# Function to upgrade 12.6.2 ES config
# For ES release the global variable value CONFIG_VERSION should be set as 1.01
# finesse config will upgrade from to 1.01.
function upgrade_0_to_1dot01() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION=" "CONFIG_VERSION" "1.01"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

