#!/bin/bash

CURRENT_SCRIPTPATH=$(dirname "${0}")

source "${CURRENT_SCRIPTPATH}"/common_utils.sh
source "${CURRENT_SCRIPTPATH}"/upgrade_utils.sh

# Version path to follow to upgrade the corresponding env file.
# Note: This must be always sorted values and corresponding upgrade funtions must be present on this file.
# Eg: If the value contains "0, 2.5, 3.2" the following functions must be present
# upgrade_0_to_2dot5(), upgrade_2dot5_to_3dot2()
VERSION_PATH="0, 2.0, 2.1, 2.2, 2.3, 2.4, 2.5"


# Function to upgrade 15.0 config
function upgrade_0_to_2dot0() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.0"
    add_multiline_comment_and_property $env_file "# Max number of agents installation is going to have; using this value installer can suggest some of the resource parameters dyamically.\n# Possible values are in the folds of 2000, any other numbers will be rounded to nearest 2000." "MAX_NUMBER_OF_AGENTS" "2000"
    
    add_multiline_comment_and_property $env_file "# Live log shipping configurations\n# Specifies whether live shipping of access/error logs is enabled." "NGX_LIVE_LOG_SHIPPING_ENABLED" "false"
    add_multiline_comment_and_property $env_file "# The container name in log messages" "NGX_LIVE_LOG_SHIPPING_CONTAINER_NAME" "\${CONTAINER_NAME}"
    add_multiline_comment_and_property $env_file "# RSyslog server to which the logs should be shipped" "NGX_LIVE_LOG_SHIPPING_SERVER_HOST" "rsyslogserver.cisco.com"
    add_multiline_comment_and_property $env_file "# The server port to which the logs should be shipped" "NGX_LIVE_LOG_SHIPPING_SERVER_PORT" "5001"
    add_multiline_comment_and_property $env_file "# Flag denoting whether TLS authentication is enabled for live log shipping.\n# 1 implies it is enabled and 0 implies it is disabled." "NGX_LIVE_LOG_SERVER_CRT_AUTH" "1"
    add_multiline_comment_and_property $env_file "# The certificate of logging server" "NGX_LIVE_LOG_SHIPPING_SERVER_CERT" "\${NGX_SSL_DIR}/logging_server.crt"
    add_multiline_comment_and_property $env_file "# Specifies a file with the certificate in the PEM format for communicating with the logging server" "NGX_LIVE_LOG_SHIPPING_CLIENT_CERT" "\${NGX_SSL_DIR}/reverseproxy.crt"
    add_multiline_comment_and_property $env_file "# Specifies a file with the secret key in the PEM format for communicating with the logging server" "NGX_LIVE_LOG_SHIPPING_CLIENT_KEY" "\${NGX_SSL_DIR}/reverseproxy.key"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

# Function to upgrade 15.0 config
function upgrade_2dot0_to_2dot1() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.1"
    add_multiline_comment_and_property $env_file "# Running multiple proxy containers on the same host can be supported using multiple DNS hostnames mapped to distinct IP addresses on the same host. \n# These addresses have to be configured against the same external nic configured for the reverse proxy container as part of the install_os_settings.sh configuration.\n# Specify one of the external nic IP addresses as the PROXY_BINDING_IP. This will cause the traffic intended to the respective hostname to be served by the container bound to that IP.\n# Eg: If the external nic is ens192, and it has 192.168.1.69, 192.168.1.70 as the IP addresses listed on the nic, use 192.168.1.69 as the value of PROXY_BINDING_IP for one of the container and 192.168.1.70 address as the value of the other container.\n# Note: It will have have no impact on the following cases (value will be ignored even if it is configured)\n#       1. CONTAINER_NETWORK_MODE is set to host. (unsupported)\n#       2. External nic has single IP configured." "PROXY_BINDING_IP" ""
    update_property $env_file "CONTAINER_NETWORK_MODE" "bridge"
    update_property $env_file "CONTAINER_IMAGE" "reverse-proxy-openresty-container:15.0.1-SNAPSHOT"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}


# function to upgrade 2.1 to 2.2
function upgrade_2dot1_to_2dot2() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.2"
    add_or_update_config_version $env_file "TEMPLATE_TYPE" "TEMPLATE_TYPE" "installer"
    remove_property $env_file "MEM_SWAPPINESS"
    remove_property $env_file "NGX_CONFIGURED_COMPONENTS_LIST"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

# function to upgrade 2.2 to 2.3
function upgrade_2dot2_to_2dot3() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.3"
    update_property $env_file "CONTAINER_IMAGE" "localhost/reverse-proxy-openresty-container:15.0.1-SNAPSHOT"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

# function to upgrade 2.3 to 2.4
function upgrade_2dot3_to_2dot4() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.4"
    add_multiline_comment_and_property $env_file "# userid, its uid and user group name - used to start the openresty container\n# change them if required.\n" "NGX_USER_USERID" "nginxuser"
    add_multiline_comment_and_property $env_file "# Nginx user's UID" "NGX_USER_UID" "9876"
    add_multiline_comment_and_property $env_file "# Nginx Usergroup" "NGX_USER_USERGROUP" "nginxusergroup"
    add_multiline_comment_and_property $env_file "" "FAST_CGI_TEMP" "\${HOST_WORKING_DIR}/fastcgi_temp" "noquotes"
    add_multiline_comment_and_property $env_file "" "UWSGI_TEMP" "\${HOST_WORKING_DIR}/uwsgi_temp" "noquotes"
    add_multiline_comment_and_property $env_file "" "SCGI_TEMP" "\${HOST_WORKING_DIR}/scgi_temp" "noquotes"
    add_multiline_comment_and_property $env_file "" "HOST_LOG_ROTATE_DIR" "\${HOST_WORKING_DIR}/log_rotate" "noquotes"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

# function to upgrade 2.4 to 2.5
function upgrade_2dot4_to_2dot5() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION" "CONFIG_VERSION" "2.5"
    add_multiline_comment_and_property $env_file "# The proxy binds to an internal IP for hosting the static proxymap file. In case of a host having more than 2 NICS or a single internal LAN NIC with multiple IP's configured, the exact IP address the container must bind to can be specified using PROXY_BINDING_INTERNAL_IP. This can also be used to bind different containers to different internal Ip addresses if required." "PROXY_BINDING_INTERNAL_IP" ""
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}

# Function to upgrade 12.6.2 ES config
# For ES release the global variable value CONFIG_VERSION should be set as 1.01
# finesse config will upgrade from to 1.01.
function upgrade_0_to_1dot01() {
    local env_file
    env_file=$1
    log_info "Starting env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
    add_or_update_config_version $env_file "CONFIG_VERSION=" "CONFIG_VERSION" "1.01"
    update_property $env_file "CONTAINER_IMAGE" "reverse-proxy-openresty-container:12.6.2-ES-SNAPSHOT"
    log_info "Completing env upgrade script name: ${0} function name: ${FUNCNAME[0]}"
}
