local _utils = require("utils")
local _strutils = require("strutils")

local _authHeader = {}

--[[
   Function to return user from authorization header as input
   NOTE: IN CASE OF ANYTHING MISSING OR INVALID AUTHORIZATION HEADER, RETURN 401 UNATHORISED
]]
function _authHeader.getUserFromAuthHeader (authorization)
   -- check if authorization header is Basic, else return 401 unauthorized
   if not _utils.isBasic(authorization) then
      ngx.log(ngx.ERR, "Not basic auth - authorization=", authorization)
      return ngx.exit(ngx.HTTP_UNAUTHORIZED)
   end

   -- get the encoded authorization value. if empty then return 401 unauthorized
   local basicb64 = string.sub(authorization, 7)   
   if _strutils.isEmpty(basicb64) then
      ngx.log(ngx.ERR, "Empty basic auth - authorization=", authorization)
      return ngx.exit(ngx.HTTP_UNAUTHORIZED)
   end

   -- decode the encoded base64 value. if empty then return 401 unauthorized
   local basic = ngx.decode_base64(basicb64)   
   if _strutils.isEmpty(basic) then
      ngx.log(ngx.ERR, "Couldn't decode base64 - basicb64=", basicb64)
      return ngx.exit(ngx.HTTP_UNAUTHORIZED)
   end

   -- get the username from the decoded value. if empty then return 401 unauthorized
   local user = _utils.getCredentialsFromBasic(basic)
   if _strutils.isEmpty(user) then
      ngx.log(ngx.ERR, "Couldn't extract user from basic auth - basic=", basic)
      return ngx.exit(ngx.HTTP_UNAUTHORIZED)
   end
   return user
end

--[[
   Function to return token from authorization header as input
]]
function _authHeader.getBearerToken(str)
   local token = str:match("Bearer%s+([%S]+)")
   return token
end

return _authHeader
