--[[
   Checks if the cors headers are populated in the shared dictionary.If populated return from here, else 
   populate the headers in the shared dictionary and return with http response OK.
]]

local _strutils = require("strutils")    

if (ngx.ctx.skipPopulatingcorsheaders) then 
   ngx.log(ngx.NOTICE, "Skip populating the CORS headers in the store as they are already populated")
   return ngx.HTTP_OK
end
  
local upstreamservername = ngx.var.upstreamservername
 
 if _strutils.isEmpty(upstreamservername) then
      return
 end
  
  local corsheadersstore = ngx.shared.corsheadersstore  
  local resty_lock = require "resty.lock"
  local lock = resty_lock:new("corsheadersstore")
  -- Take the lock on per servername
  local elapsed = lock:lock("corsheaderslock"..upstreamservername)
  if not elapsed then
      ngx.log(ngx.ERR, "Lock held by another request  [", ngx.worker.id(), " ] ")
      return ngx.HTTP_OK
  end  
  
  -- Flush all the expired entries
  corsheadersstore:flush_expired()
  -- Populate the headers from the response.
  
   local responseheaders = ngx.resp.get_headers()
-- Concat the string in the format order of Headers, origin , methods, headers, credentials

local headerString
local corsAllowHeaders = responseheaders["access-control-allow-headers"]
local corsallowOrigins = responseheaders["access-control-allow-origin"]
local corsAllowMethods = responseheaders["access-control-allow-methods"]
local corsExposedHeaders = responseheaders["access-control-expose-headers"]
local corsAllowCredentials = responseheaders["access-control-allow-credentials"]


  headerString = (corsAllowHeaders and corsAllowHeaders or "").."\n"..
  (corsallowOrigins and corsallowOrigins or "").."\n" ..
  (corsAllowMethods and corsAllowMethods or "").."\n" ..
  (corsExposedHeaders and corsExposedHeaders or "").."\n"..
  (corsAllowCredentials and corsAllowCredentials or "").."\n"
  
   corsheadersstore:set(upstreamservername, headerString, 300)
  
  local ok, err = lock:unlock()
   if not ok then
   		ngx.log(ngx.ERR, "Failed to unlock from corsheadersstore [", ngx.worker.id(), " ] ")
   		return ngx.HTTP_OK
   end     
  return ngx.HTTP_OK
