-- This module will be used to log the messages in syslog
-- module used https://luarocks.org/modules/membphis/lua-resty-logger-socket
-- enable syslog in centos 8: https://www.itzgeek.com/how-tos/linux/centos-how-tos/how-to-setup-centralized-syslog-server-on-centos-8-rhel-8.html
-- here we use udp socket to perform syslog messaging in local centos server

local _syslogwriter = {}



function _syslogwriter.logMessage(message)

  local logger = require "resty.logger.socket"
  if not logger.initted() then
       local ok, err = logger.init{
            host = ngx.var.syslog_server_ip,
            port = tonumber(ngx.var.syslog_server_udp_port),
            flush_limit = 20000,
            sock_type ='udp',
            periodic_flush =20,
       }
       if not ok then
            ngx.log(ngx.ERR, "Failed to initialize the _syslogwriter: ",err)
            return
       end
  end

  local bytes, err = logger.log(message)
  if err then
        ngx.log(ngx.ERR, "Failed to log message using _syslogwriter: ", err)
        return
  end


end


return _syslogwriter