/********************************************************************************\
*  This sample is supplied as is with no implied warranty.  
*  It is designed to assist you in using the Cisco AnyConnect VPN API. 
*  It is assumed that you will build a production application and 
*  refer to this sample as a reference only.
\********************************************************************************/
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using VpnApiLib;

namespace CSharpComSample
{
    public partial class MessagesDlg : Form
    {
        public MessagesDlg()
        {
            InitializeComponent();
        }

        public void AddMessage(string noticeString, MessageType eMessageType)
        {
            string severity = "Unknown";
            switch (eMessageType)
            {
                case MessageType.MsgType_Error:
                    severity = "Error";
                    break;
                case MessageType.MsgType_Info:
                    severity = "Informational";
                    break;

                case MessageType.MsgType_Status:
                    severity = "Status";
                    break;
                case MessageType.MsgType_Warn:
                    severity = "Warning";
                    break;
            }

            DateTime dt = DateTime.Now;
            string message = "[" + dt.ToString() + " - " + severity + "] ";
            message += noticeString + "\r\n";
            messagesTextBox.AppendText(message);
        }

        private void MessagesDlg_FormClosing(object sender, FormClosingEventArgs e)
        {
            e.Cancel = true;
            Hide();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            messagesTextBox.Clear();
        }
    }
}