/**************************************************************************
*       Copyright  2009, Cisco Systems, All Rights Reserved
***************************************************************************
*
*  File:    PreferenceUpdate.h
*  Author:  Ivonne Olavarrieta Arruti
*  Date:    06/2009
*
***************************************************************************
*
*   Preference Update Interface declaration for the Client API. 
*
***************************************************************************/

#ifndef _PREFERENCEUPDATE_
#define _PREFERENCEUPDATE_

#include "api.h"

class VPN_VPNAPI IPreferenceUpdateCB
{    
public:
    /*
    ** IPreferenceUpdateCB::OnLoadPreferencesComplete
    **   Callback method invoked when the loadPreferences operation has completed
    **   and preferences have been reloaded.
    **
    **   NOTE: Implementations of this callback must be thread safe.
    */
    virtual void OnLoadPreferencesComplete() = 0;

    /*
    ** bool IPreferenceUpdateCB::IsPreferenceOverridable
    **   Callback method invoked during preference loading to verify if the specified preference 
    **   pertaining is overridable by consumer.
    **
    **   IN const PreferenceId ePreferenceId
    **
    **   NOTE: Implementations of this callback must be thread safe.
    */
    virtual bool IsPreferenceOverridable(const PreferenceId ePreferenceId) = 0;

    /*
    ** void IPreferenceUpdateCB::OverridePreferenceValue
    **   Callback method invoked during preference loading to override the specified value,
    **   if necessary.
    **   rbOverriden must be set to true if the preference value was overriden by consumer.
    **
    **   IN const PreferenceId ePreferenceId
    **   INOUT tstring rPrefenceValue
    **   OUT bool& rbOverriden
    **
    **   NOTE: Implementations of this callback must be thread safe.
    */
    virtual void OverridePreferenceValue(const PreferenceId ePreferenceId,
                                         tstring& rPrefenceValue,
                                         bool& rbOverriden) = 0;

protected:
    // Deletions should not be done via a callback Interface base class pointer.
    // By declaring the destructor as protected, we prevent this.
    //
    virtual ~IPreferenceUpdateCB() {}
};



#endif // _PREFERENCEUPDATE_

