/******************************************************************************\
 *  This sample is supplied as is with no implied warranty.  
 *  It is designed to assist you in using the Cisco AnyConnect VPN API. 
 *  It is assumed that you will build a production application and 
 *  refer to this sample as a reference only.
 \*****************************************************************************/

// PromptDialog.cpp : implementation file
//

#include "stdafx.h"
#include "Gui.h"
#include "PromptDialog.h"
#include "GUIClientImpl.h"


// promptDialog dialog

IMPLEMENT_DYNAMIC(PromptDialog, CDialog)

PromptDialog :: PromptDialog(MainDialog* pParent /*=NULL*/)
	          : CDialog(PromptDialog::IDD, pParent),
                m_text1(_T("")),
                m_text2(_T("")),
                m_text3(_T(""))
{
    parentWindow = pParent;
}

PromptDialog :: ~PromptDialog() { }

void PromptDialog :: DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Text(pDX, IDC_EDIT1, m_text1);
    DDX_Text(pDX, IDC_EDIT2, m_text2);
    DDX_Text(pDX, IDC_EDIT3, m_text3);
}


BEGIN_MESSAGE_MAP(PromptDialog, CDialog)
    ON_EN_CHANGE(IDC_EDIT1, &PromptDialog::OnEnChangeEdit1)
    ON_EN_CHANGE(IDC_EDIT2, &PromptDialog::OnEnChangeEdit2)
    ON_EN_CHANGE(IDC_EDIT3, &PromptDialog::OnEnChangeEdit3)
    ON_BN_CLICKED(IDOK, &PromptDialog::OnBnClickedOk)
END_MESSAGE_MAP()



// PromptDialog message handlers

void PromptDialog :: OnEnChangeEdit1()
{
    UpdateData(true);   
}    

void PromptDialog :: OnEnChangeEdit2()
{
    UpdateData(true);   
}

void PromptDialog :: OnEnChangeEdit3()
{
    UpdateData(true);   
}

void PromptDialog :: OnBnClickedOk()
{
    UpdateData(true);
    parentWindow->m_pApiImpl->ms_group = m_text1;
    parentWindow->m_pApiImpl->ms_user = m_text2;
    parentWindow->m_pApiImpl->ms_pswd = m_text3;
    OnOK();
}


BOOL
PromptDialog :: OnInitDialog()
{

    CDialog::OnInitDialog();

    std::list<tstring> :: iterator name_iter;
    for (name_iter = parentWindow->m_promptNames.begin();
         name_iter != parentWindow->m_promptNames.end(); ++name_iter)
    {
        PromptEntry *entry = parentWindow->m_pPromptInfo->getPromptEntry(*name_iter);

        if (entry->getPromptType() == Prompt_Combo)
        {
            GetDlgItem(IDC_EDIT1)->EnableWindow(true);
            m_text1 = entry->getPromptLabel().c_str();
        }

        tstring promptName = entry->getPromptName();
        if (promptName == L"username")
        {
            GetDlgItem(IDC_EDIT2)->EnableWindow(true);
            m_text2 = entry->getValue().c_str();
        }
        else if (promptName == L"password")
        {
            GetDlgItem(IDC_EDIT3)->EnableWindow(true);
            m_text3 = entry->getValue().c_str();
        }
    }

    UpdateData(false);

    return true;
 }
