/**************************************************************************
*   Copyright (c) 2022-2023 Cisco Systems, Inc.
*   All Rights Reserved. Cisco Highly Confidential.
***************************************************************************
* 
*   File:   ClientIfcCommon.h
*   Author: Chris Fitzgerald
*   Date:   03/2022
* 
***************************************************************************
*   Client Interface Common defines for the Client API.
***************************************************************************/
#ifndef _CLIENTIFCCOMMON_
#define _CLIENTIFCCOMMON_

/*
* Platforms capable of supporting SNAK.
*/
#if defined(PLATFORM_WIN_APP)
  #define ANYCONNECT_USE_SNAK
#endif

/*
* Aggregate the compiler directives that together identify desktop platforms into a single define.
*/
#if (defined(_WIN32) || defined(PLATFORM_DARWIN) \
     || (defined(PLATFORM_LINUX) && !defined(ANYCONNECT_USE_SNAK) && !defined (PLATFORM_ANDROID))) \
     && !defined(PLATFORM_WIN_APP)
#define PLATFORM_DESKTOP
#endif

/*
* Platforms capable of supporting our standard interprocess communication mechanisms. At present,
* all platforms on which the client is deployed support our standard IPC mechanisms.
*/
#define INTERPROCESS_COMMUNICATION_SUPPORTED

/*
* Platforms capable of supporting host data objects.
*/
#if defined(PLATFORM_ANDROID) || defined(PLATFORM_APPLE_SSLVPN)
  #define HOST_DATA_SUPPORTED
#endif

/*
* Platforms capable of supporting manual import of PKCS12 certificates.
*/
#if defined(PLATFORM_APPLE_SSLVPN) || defined(PLATFORM_ANDROID) || defined(PLATFORM_WIN_APP)
  #define MANUAL_PKCS12_IMPORT_SUPPORTED
#endif

/*
* Platforms capable of supporting importing of program data (e.g. localization and profile).
*/
#if defined(PLATFORM_ANDROID)
  #define PROGRAM_DATA_IMPORT_SUPPORTED
#endif

/*
* Platforms capable of supporting prefilled connection credentials via URI handling or API calls.
*/
#if defined(PLATFORM_ANDROID)
  #define CREDENTIAL_PREFILL_SUPPORTED
#endif

/*
* Platforms capable of supporting dynamic update of the local policy.
*/
#if defined(PLATFORM_ANDROID)
  #define DYNAMIC_UPDATE_LOCAL_POLICY
#endif // PLATFORM_ANDROID

#if defined(MANUAL_PKCS12_IMPORT_SUPPORTED)
  #if defined(HAVE_STDINT_H)
    #include <stdint.h>
  #else
    typedef unsigned char uint8_t;
  #endif
#endif // MANUAL_PKCS12_IMPORT_SUPPORTED

#if defined(PLATFORM_WIN_APP)
  typedef unsigned char uint8_t;
#endif

/*
*  Platforms capable of supporting local policy directory changes.
*/
#if defined(PLATFORM_DESKTOP) && !defined(DYNAMIC_UPDATE_LOCAL_POLICY)
//#define LOCAL_POLICY_DIR_CHANGE_SUPPORTED
#endif

/*
*  Platforms capable of supporting profile file directory changes.
*/
#if defined(PLATFORM_DESKTOP)
//#define PROFILE_FILES_DIR_CHANGE_SUPPORTED
#endif

/*
*  Platforms capable of supporting event notifications to the VPN API.
*/
#if defined(LOCAL_POLICY_DIR_CHANGE_SUPPORTED) || defined(PROFILE_FILES_DIR_CHANGE_SUPPORTED)
  #define VPNAPI_EVENT_NOTIFICATION_SUPPORTED
#endif

#endif // _CLIENTIFCCOMMON_
