/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.anyconnect.configxmlgen;

import com.cisco.anyconnect.configxmlgen.AnyConnectConfigurationGenerator;
import com.cisco.anyconnect.configxmlgen.ConfigXMLException;
import com.cisco.anyconnect.configxmlgen.GenTestDialog;
import com.cisco.anyconnect.configxmlgen.XmlElemTable;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.StringReader;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ConfigXMLGen
implements AnyConnectConfigurationGenerator {
    private static final int USAGE_ERROR = 99;
    private static final String TOPLEVEL_KEY = "anyCfg";
    private static final String BASEURI_KEY = "anyCfg.uri";
    private static final String BASEDIR_KEY = "anyCfg.LocalDir";
    private static final String TEXTCONTENT_KEY = "Anchoredoverlay";
    private static final String TEXTCONTENT1_KEY = "Dropdown";
    private static final String TEXTCONTENT2_KEY = "Textbox";
    private static final String BOOLCONTENT_KEY = "Checkbox";
    private static final String ACSUBDIR_KEY = "anyCfg.AnyConnectPackage.Anchoredoverlay";
    private static final String VPNPROFILE_KEY = "anyCfg.ProfileVPN.Anchoredoverlay";
    private static final String ISEPOSTUREPROFILE_KEY = "anyCfg.ProfileISEPosture.Anchoredoverlay";
    private static final String ISEPOSTUREJSONPROFILE_KEY = "anyCfg.ProfileISEPostureJSON.Anchoredoverlay";
    private static final String NAMPROFILE_KEY = "anyCfg.ProfileNAM.Anchoredoverlay";
    private static final String WSPROFILE_KEY = "anyCfg.ProfileWebSecurity.Anchoredoverlay";
    private static final String FAPROFILE_KEY = "anyCfg.ProfileFireAMP.Anchoredoverlay";
    private static final String NVMPROFILE_KEY = "anyCfg.ProfileNVM.Anchoredoverlay";
    private static final String UMBRELLAPROFILE_KEY = "anyCfg.ProfileUmbrella.Anchoredoverlay";
    private static final String ZTAPROFILE_KEY = "anyCfg.ProfileZTAEnrollmentChoices.Anchoredoverlay";
    private static final String TEPROFILE_KEY = "anyCfg.ProfileThousandEyes.Anchoredoverlay";
    private static final String CEFPROFILE_KEY = "anyCfg.ProfileCustomerFeedback.Anchoredoverlay";
    private static final String COMPLIANCE_KEY = "anyCfg.ComplianceModule.Anchoredoverlay";
    private static final String CUSTOMIZATION_KEY = "anyCfg.CustomizationBundle.Anchoredoverlay";
    private static final String LOCALIZATION_KEY = "anyCfg.LocalizationBundle.Anchoredoverlay";
    private static final String VPNMODULE_KEY = "anyCfg.ModuleSelectionVPN.Checkbox";
    private static final String ZTAMODULE_KEY = "anyCfg.ModuleSelectionZTA.Checkbox";
    private static final String NAMMODULE_KEY = "anyCfg.ModuleSelectionNAM.Checkbox";
    private static final String WSMODULE_KEY = "anyCfg.ModuleSelectionWebSecurity.Checkbox";
    private static final String FIREAMPMODULE_KEY = "anyCfg.ModuleSelectionFireAMP.Checkbox";
    private static final String NVMMODULE_KEY = "anyCfg.ModuleSelectionNVM.Checkbox";
    private static final String UMBRELLAMODULE_KEY = "anyCfg.ModuleSelectionUmbrella.Checkbox";
    private static final String POSTUREMODULE_KEY = "anyCfg.ModuleSelectionPosture.Checkbox";
    private static final String ISEPOSTUREMODULE_KEY = "anyCfg.ModuleSelectionISEPosture.Checkbox";
    private static final String SBLMODULE_KEY = "anyCfg.ModuleSelectionSBL.Checkbox";
    private static final String DARTMODULE_KEY = "anyCfg.ModuleSelectionDART.Checkbox";
    private static final String CLOUDMANAGEMENTMODULE_KEY = "anyCfg.ModuleSelectionCloudManagement.Checkbox";
    private static final String DEFERREDUPDATEALLOWED_KEY = "anyCfg.DeferredUpdateAllowed.Dropdown";
    private static final String DEFERREDUPDATEMINVER_KEY = "anyCfg.DeferredUpdateMinimumVersion.Textbox";
    private static final String DEFERREDUPDATEALLOWED_COMPLIANCE_KEY = "anyCfg.DeferredUpdateAllowed_ComplianceModule.Dropdown";
    private static final String DEFERREDUPDATEMINVER_COMPLIANCE_KEY = "anyCfg.DeferredUpdateMinimumVersion_ComplianceModule.Textbox";
    private static final String DEFERREDUPDATETIMEOUT_KEY = "anyCfg.DeferredUpdateDismissTimeout.Textbox";
    private static final String DEFERREDUPDATERESPONSE_KEY = "anyCfg.DeferredUpdateDismissResponse.Dropdown";
    private static final String UNINSTALL_OLD_NACMODULE_KEY = "anyCfg.UninstallCiscoNACModule.Checkbox";
    private static final String DEBUG_LOG_LEVEL = "LogLevel";
    private static final int DEBUG_LOG_STANDARD = 3;
    private int debugLogLevel = -1;
    private String msPlatformType;
    private String msACPackageDir;
    private String msUninstallNACTrnsfmURI;
    private XmlElemTable msACElementsTable;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            GenTestDialog genTestDialog = new GenTestDialog();
            genTestDialog.setVisible(true);
        } else {
            String string;
            String string2 = null;
            Object var2_3 = null;
            String string3 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                string = stringArray[i];
                if (string.equalsIgnoreCase("-i")) {
                    if (i == stringArray.length - 1) {
                        ConfigXMLGen.usage();
                    }
                    String string4 = stringArray[++i];
                    string2 = ConfigXMLGen.contentsOf(string4);
                    continue;
                }
                if (string.equalsIgnoreCase("-c")) {
                    if (i == stringArray.length - 1) {
                        ConfigXMLGen.usage();
                    }
                    string3 = stringArray[++i];
                    continue;
                }
                ConfigXMLGen.usage();
            }
            if (string2 == null || var2_3 == null) {
                ConfigXMLGen.usage();
            }
            ConfigXMLGen configXMLGen = new ConfigXMLGen();
            try {
                string = configXMLGen.GenerateConfigurationXML(string2);
                if (string3 == null) {
                    System.out.print(string);
                } else {
                    ConfigXMLGen.saveOutputFile(string3, string);
                }
            }
            catch (ConfigXMLException configXMLException) {
                System.out.println("Exception:" + configXMLException);
            }
        }
    }

    static void saveOutputFile(String string, String string2) {
        block5: {
            File file = new File(string);
            if (!file.exists()) {
                try {
                    if (file.createNewFile()) {
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        fileOutputStream.write(string2.getBytes());
                        fileOutputStream.close();
                        break block5;
                    }
                    System.out.println("Cannot create file:" + string);
                }
                catch (Exception exception) {
                    System.out.println("Error writing config file:" + exception.toString());
                }
            } else {
                System.out.println("File already exists:" + string);
            }
        }
    }

    static String contentsOf(String string) {
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            return new String(byArray);
        }
        catch (Exception exception) {
            System.out.println("Exception:" + exception);
            return "";
        }
    }

    private static void usage() {
        System.out.println("Usage: java ConfigXMLGen -i <input XML file> [-c <config XML file>]");
        System.exit(99);
    }

    @Override
    public String GenerateConfigurationXML(String string) throws ConfigXMLException {
        this.msACElementsTable = this.ingestXml(string);
        Integer n = Integer.getInteger(DEBUG_LOG_LEVEL);
        if (n != null) {
            this.debugLogLevel = n;
        }
        this.debugOut("########################### input ############################");
        this.debugOut("internalized input:" + this.msACElementsTable);
        String string2 = this.msACElementsTable == null ? "" : this.genOutputXml();
        this.debugOut("########################### output ############################");
        this.debugOut("outputXml:" + string2);
        this.debugOut("########################### end ############################");
        return string2;
    }

    private XmlElemTable ingestXml(String string) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            Document document;
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                document = documentBuilder.parse(new InputSource(new StringReader(string)));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
            Element element = document.getDocumentElement();
            XmlElemTable xmlElemTable = new XmlElemTable();
            this.processSubelement(xmlElemTable, "", element);
            return xmlElemTable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void processSubelement(XmlElemTable xmlElemTable, String string, Node node) {
        String string2 = node.getNodeName();
        if (node.getNodeType() == 1) {
            Object object;
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap.getLength() > 0) {
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    object = namedNodeMap.item(i).getNodeName();
                    String string3 = namedNodeMap.item(i).getNodeValue();
                    xmlElemTable.put(string + string2, object, string3);
                }
            }
            String string4 = "";
            object = node.getChildNodes();
            int n = object.getLength();
            if (n <= 1) {
                if (n == 1) {
                    if (object.item(0).getNodeType() == 3) {
                        string4 = object.item(0).getNodeValue();
                        xmlElemTable.put(string + string2, string4);
                    }
                    if (object.item(0).getNodeType() == 1) {
                        Node node2 = object.item(0);
                        this.processSubelement(xmlElemTable, string + string2 + ".", node2);
                    }
                    return;
                }
                xmlElemTable.put(string + string2, string4);
                return;
            }
            for (int i = 0; i < n; ++i) {
                Node node3 = object.item(i);
                this.processSubelement(xmlElemTable, string + string2 + ".", node3);
            }
            xmlElemTable.put(string + string2, string4);
        }
    }

    private String genOutputXml() throws ConfigXMLException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        stringBuffer.append("<config-auth client=\"vpn\" type=\"complete\">\n");
        stringBuffer.append("  <version who=\"ise\">3.3</version>\n");
        stringBuffer.append("  <config client=\"vpn\" type=\"private\">\n");
        String string = (String)this.msACElementsTable.get(BASEDIR_KEY);
        if (string == null) {
            throw new ConfigXMLException("Package base location not available");
        }
        String string2 = (String)this.msACElementsTable.get(BASEURI_KEY);
        if (string2 == null) {
            throw new ConfigXMLException("Package base uri not available");
        }
        this.outputBaseConfig("    ", string, stringBuffer);
        this.outputOpaque("    ", string, stringBuffer);
        this.outputProfileManifest("    ", string2, string, stringBuffer);
        this.outputCustomizationManifest("    ", string, string2, stringBuffer);
        String string3 = (String)this.msACElementsTable.get(LOCALIZATION_KEY);
        if (string3 != null && !string3.trim().isEmpty() && this.fileCountTwoLevelDirWalk(string, string3) > 0) {
            this.outputLocalizationManifest("    ", string, string3, string2, stringBuffer);
        }
        stringBuffer.append("  </config>\n");
        stringBuffer.append("</config-auth>\n");
        return stringBuffer.toString();
    }

    private void outputBaseConfig(String string, String string2, StringBuffer stringBuffer) throws ConfigXMLException {
        stringBuffer.append(string).append("<vpn-base-config>\n");
        String string3 = "";
        String string4 = null;
        string4 = (String)this.msACElementsTable.get(VPNMODULE_KEY);
        if (string4 != null && string4.equals("true")) {
            string3 = string3 + (string3.isEmpty() ? "" : ",") + "vpn";
        }
        if ((string4 = (String)this.msACElementsTable.get(ZTAMODULE_KEY)) != null && string4.equals("true")) {
            string3 = string3 + (string3.isEmpty() ? "" : ",") + "zta";
        }
        if ((string4 = (String)this.msACElementsTable.get(NAMMODULE_KEY)) != null && string4.equals("true")) {
            string3 = string3 + (string3.isEmpty() ? "" : ",") + "nam";
        }
        if ((string4 = (String)this.msACElementsTable.get(WSMODULE_KEY)) != null && string4.equals("true")) {
            string3 = string3 + (string3.isEmpty() ? "" : ",") + "websecurity";
        }
        if ((string4 = (String)this.msACElementsTable.get(FIREAMPMODULE_KEY)) != null && string4.equals("true")) {
            string3 = string3 + (string3.isEmpty() ? "" : ",") + "ampenabler";
        }
        if ((string4 = (String)this.msACElementsTable.get(NVMMODULE_KEY)) != null && string4.equals("true")) {
            string3 = string3 + (string3.isEmpty() ? "" : ",") + "nvm";
        }
        if ((string4 = (String)this.msACElementsTable.get(UMBRELLAMODULE_KEY)) != null && string4.equals("true")) {
            string3 = string3 + (string3.isEmpty() ? "" : ",") + "umbrella";
        }
        if ((string4 = (String)this.msACElementsTable.get(POSTUREMODULE_KEY)) != null && string4.equals("true")) {
            string3 = string3 + (string3.isEmpty() ? "" : ",") + "posture";
        }
        if ((string4 = (String)this.msACElementsTable.get(ISEPOSTUREMODULE_KEY)) != null && string4.equals("true")) {
            string3 = string3 + (string3.isEmpty() ? "" : ",") + "iseposture";
        }
        if ((string4 = (String)this.msACElementsTable.get(SBLMODULE_KEY)) != null && string4.equals("true")) {
            string3 = string3 + (string3.isEmpty() ? "" : ",") + "sbl";
        }
        if ((string4 = (String)this.msACElementsTable.get(DARTMODULE_KEY)) != null && string4.equals("true")) {
            string3 = string3 + (string3.isEmpty() ? "" : ",") + "dart";
        }
        if ((string4 = (String)this.msACElementsTable.get(CLOUDMANAGEMENTMODULE_KEY)) != null && string4.equals("true")) {
            string3 = string3 + (string3.isEmpty() ? "" : ",") + "cloud_management";
        }
        stringBuffer.append(string).append("  <optional-modules>" + string3 + "</optional-modules>\n");
        String string5 = (String)this.msACElementsTable.get(BASEURI_KEY);
        String string6 = (String)this.msACElementsTable.get(ACSUBDIR_KEY);
        if (string6 == null) {
            throw new ConfigXMLException("AnyConnect package base uri not available");
        }
        stringBuffer.append(string).append("  <base-package-uri>" + string5 + string6 + "</base-package-uri>\n");
        this.msACPackageDir = string6;
        String string7 = (String)this.msACElementsTable.get(COMPLIANCE_KEY);
        if (string7 != null && !string7.trim().isEmpty()) {
            stringBuffer.append(string).append("  <base-opswat-package-uri>" + string5 + string7 + "</base-opswat-package-uri>\n");
        }
        stringBuffer.append(string).append("</vpn-base-config>\n");
    }

    private void outputOpaque(String string, String string2, StringBuffer stringBuffer) throws ConfigXMLException {
        String string3;
        Object object;
        String string4;
        Object object2;
        String string5;
        stringBuffer.append(string).append("<opaque is-for=\"vpn-client\">\n");
        String string6 = (String)this.msACElementsTable.get(ACSUBDIR_KEY);
        if (string6 == null) {
            throw new ConfigXMLException("Unable to access AnyConnect package");
        }
        File file = new File(string2 + string6 + "headinfo.txt");
        if (!file.exists()) {
            throw new ConfigXMLException("Unable to access headinfo.txt within " + string2);
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            string5 = null;
            while ((string5 = bufferedReader.readLine()) != null) {
                object2 = new StringTokenizer(string5, "=,");
                string4 = ((StringTokenizer)object2).nextToken();
                if (string4.equals("vpn-private-config-import")) {
                    object = ((StringTokenizer)object2).nextToken();
                    string3 = ((StringTokenizer)object2).nextToken();
                    this.embedOutputFile(string + "  ", string3, string2 + string6, (String)object, stringBuffer);
                    continue;
                }
                if (string4.equals("device-id")) {
                    this.msPlatformType = ((StringTokenizer)object2).nextToken().trim();
                    continue;
                }
                if (!string4.equals("uninstall-cisco-nac-transform")) continue;
                this.msUninstallNACTrnsfmURI = ((StringTokenizer)object2).nextToken().trim();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new ConfigXMLException("Error accessing AnyConnect package headinfo.txt", exception);
        }
        string5 = (String)this.msACElementsTable.get(COMPLIANCE_KEY);
        if (string5 != null && !string5.trim().isEmpty()) {
            object2 = new File(string2 + string5 + "headinfo.txt");
            if (!((File)object2).exists()) {
                throw new ConfigXMLException("Unable to access headinfo.txt within " + string2);
            }
            bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader((File)object2));
                string4 = null;
                while ((string4 = bufferedReader.readLine()) != null) {
                    if (string4.trim().isEmpty() || !(string3 = ((StringTokenizer)(object = new StringTokenizer(string4, "=,"))).nextToken()).equals("vpn-private-config-import")) continue;
                    String string7 = ((StringTokenizer)object).nextToken();
                    String string8 = ((StringTokenizer)object).nextToken();
                    this.embedOutputFile(string + "  ", string8, string2 + string5, string7, stringBuffer);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                throw new ConfigXMLException("Error accessing Compliance package headinfo.txt", exception);
            }
        }
        this.outputCustomAttrs(string + "  ", stringBuffer);
        stringBuffer.append(string).append("</opaque>\n");
    }

    private void embedOutputFile(String string, String string2, String string3, String string4, StringBuffer stringBuffer) throws ConfigXMLException {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(new File(string3 + string4)));
            String string5 = null;
            stringBuffer.append(string).append("<" + string2 + ">\n");
            String string6 = string + "  ";
            string5 = bufferedReader.readLine();
            if (string5 == null || !string5.startsWith("<?xml")) {
                throw new ConfigXMLException("Invalid package file component:" + string3 + string4);
            }
            while ((string5 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string6).append(string5).append("\n");
            }
            stringBuffer.append(string).append("</" + string2 + ">\n");
            bufferedReader.close();
        }
        catch (Exception exception) {
            throw new ConfigXMLException("Cannot read file:" + string3 + string4, exception);
        }
    }

    private void outputCustomAttrs(String string, StringBuffer stringBuffer) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        stringBuffer.append(string).append("<custom-attr>\n");
        String string7 = (String)this.msACElementsTable.get(DEFERREDUPDATEALLOWED_KEY);
        if (string7 != null) {
            string6 = string7.toLowerCase().equals("yes") ? "true" : "false";
            stringBuffer.append(string + "  ").append("<DeferredUpdateAllowed>" + string6 + "</DeferredUpdateAllowed>\n");
        }
        if ((string6 = (String)this.msACElementsTable.get(DEFERREDUPDATEMINVER_KEY)) != null) {
            stringBuffer.append(string + "  ").append("<DeferredUpdateMinimumVersion>" + string6 + "</DeferredUpdateMinimumVersion>\n");
        }
        if ((string5 = (String)this.msACElementsTable.get(DEFERREDUPDATETIMEOUT_KEY)) != null) {
            stringBuffer.append(string + "  ").append("<DeferredUpdateDismissTimeout>" + string5 + "</DeferredUpdateDismissTimeout>\n");
        }
        if ((string4 = (String)this.msACElementsTable.get(DEFERREDUPDATERESPONSE_KEY)) != null) {
            stringBuffer.append(string + "  ").append("<DeferredUpdateDismissResponse>" + string4.toLowerCase() + "</DeferredUpdateDismissResponse>\n");
        }
        if ((string3 = (String)this.msACElementsTable.get(DEFERREDUPDATEALLOWED_COMPLIANCE_KEY)) != null) {
            string2 = string3.toLowerCase().equals("yes") ? "true" : "false";
            stringBuffer.append(string + "  ").append("<DeferredUpdateAllowed_ComplianceModule>" + string2 + "</DeferredUpdateAllowed_ComplianceModule>\n");
        }
        if ((string2 = (String)this.msACElementsTable.get(DEFERREDUPDATEMINVER_COMPLIANCE_KEY)) != null) {
            stringBuffer.append(string + "  ").append("<DeferredUpdateMinimumVersion_ComplianceModule>" + string2 + "</DeferredUpdateMinimumVersion_ComplianceModule>\n");
        }
        stringBuffer.append(string).append("</custom-attr>\n");
    }

    private void outputProfileManifest(String string, String string2, String string3, StringBuffer stringBuffer) throws ConfigXMLException {
        if (!(this.emptyProfileFile(VPNPROFILE_KEY) && this.emptyProfileFile(NAMPROFILE_KEY) && this.emptyProfileFile(WSPROFILE_KEY) && this.emptyProfileFile(CEFPROFILE_KEY) && this.emptyProfileFile(ISEPOSTUREPROFILE_KEY) && this.emptyProfileFile(FAPROFILE_KEY) && this.emptyProfileFile(NVMPROFILE_KEY) && this.emptyProfileFile(UMBRELLAPROFILE_KEY) && this.emptyProfileFile(ISEPOSTUREJSONPROFILE_KEY) && this.emptyProfileFile(ZTAPROFILE_KEY) && this.emptyProfileFile(TEPROFILE_KEY))) {
            stringBuffer.append(string).append("<vpn-profile-manifest>\n");
            stringBuffer.append(string + "  ").append("<vpn rev=\"1.0\">\n");
            this.outputProfileFile(string + "    ", string2, string3, VPNPROFILE_KEY, "user", stringBuffer);
            this.outputProfileFile(string + "    ", string2, string3, NAMPROFILE_KEY, "nam", stringBuffer);
            this.outputProfileFile(string + "    ", string2, string3, WSPROFILE_KEY, "websecurity", stringBuffer);
            this.outputProfileFile(string + "    ", string2, string3, CEFPROFILE_KEY, "feedback", stringBuffer);
            this.outputProfileFile(string + "    ", string2, string3, ISEPOSTUREPROFILE_KEY, "iseposture", stringBuffer);
            this.outputProfileFile(string + "    ", string2, string3, ISEPOSTUREJSONPROFILE_KEY, "iseposturejson", stringBuffer);
            this.outputProfileFile(string + "    ", string2, string3, FAPROFILE_KEY, "ampenabler", stringBuffer);
            this.outputProfileFile(string + "    ", string2, string3, NVMPROFILE_KEY, "nvm", stringBuffer);
            this.outputProfileFile(string + "    ", string2, string3, UMBRELLAPROFILE_KEY, "umbrella", stringBuffer);
            this.outputProfileFile(string + "    ", string2, string3, ZTAPROFILE_KEY, "zta", stringBuffer);
            this.outputProfileFile(string + "    ", string2, string3, TEPROFILE_KEY, "thousandeyes", stringBuffer);
            stringBuffer.append(string + "  ").append("</vpn>\n");
            stringBuffer.append(string).append("</vpn-profile-manifest>\n");
        }
    }

    private boolean emptyProfileFile(String string) {
        String string2 = (String)this.msACElementsTable.get(string);
        return string2 == null || string2.trim().isEmpty();
    }

    private void outputProfileFile(String string, String string2, String string3, String string4, String string5, StringBuffer stringBuffer) throws ConfigXMLException {
        String string6 = (String)this.msACElementsTable.get(string4);
        if (string6 == null || string6.trim().isEmpty()) {
            return;
        }
        String string7 = string3 + string6;
        try {
            Object object;
            File file = new File(string7);
            String string8 = string2 + string6;
            if (file.isDirectory()) {
                object = file.listFiles();
                if (((File[])object).length == 0) {
                    this.debugOut("Diplomat warning: directory " + string7 + " contains no files");
                } else {
                    if (((File[])object).length > 1) {
                        this.debugOut("Diplomat warning: directory " + string7 + " contains multiple files; using first");
                    } else if (object[0].isDirectory()) {
                        this.debugOut("Diplomat warning: " + string7 + object[0].getName() + " is a directory");
                    }
                    string8 = string8 + object[0].getName();
                    string7 = string7 + object[0].getName();
                }
            }
            object = new File(string7);
            String string9 = this.fileHash((File)object);
            stringBuffer.append(string).append("<file type=\"profile\" service-type=\"" + string5 + "\">\n");
            stringBuffer.append(string + "  ").append("<uri>" + string8 + "</uri>\n");
            stringBuffer.append(string + "  ").append("<hash type=\"sha256\">" + string9 + "</hash>\n");
            stringBuffer.append(string).append("</file>\n");
        }
        catch (Exception exception) {
            throw new ConfigXMLException("Unable to read access profile:" + string7, exception);
        }
    }

    private void outputCustomizationManifest(String string, String string2, String string3, StringBuffer stringBuffer) throws ConfigXMLException {
        String string4 = (String)this.msACElementsTable.get(CUSTOMIZATION_KEY);
        Boolean bl = string4 != null && !string4.trim().isEmpty() && this.fileCountTwoLevelDirWalk(string2, string4) > 0;
        String string5 = (String)this.msACElementsTable.get(UNINSTALL_OLD_NACMODULE_KEY);
        Boolean bl2 = string5 != null && string5.equals("true");
        if (bl.booleanValue() || bl2.booleanValue()) {
            stringBuffer.append(string).append("<vpn-customization-manifest>\n");
            stringBuffer.append(string).append("<vpn rev=\"1.0\">\n");
            if (bl.booleanValue()) {
                this.outputTwoLevelDirWalk(string + "  ", "app=\"AnyConnect\" ", string2, string4, string3, "platform", "type", stringBuffer);
            }
            if (bl2.booleanValue() && this.msUninstallNACTrnsfmURI != null && this.msPlatformType != null) {
                String string6 = this.msACPackageDir + this.msUninstallNACTrnsfmURI;
                this.genBuiltInTransforms(string3 + string6, string2 + string6, stringBuffer);
            } else {
                this.debugOut("Diplomat info: Not generating manifest for Cisco NAC uninstall transform.");
            }
            stringBuffer.append(string).append("</vpn>\n");
            stringBuffer.append(string).append("</vpn-customization-manifest>\n");
        }
    }

    private void outputLocalizationManifest(String string, String string2, String string3, String string4, StringBuffer stringBuffer) throws ConfigXMLException {
        stringBuffer.append(string).append("<vpn-language-manifest>\n");
        stringBuffer.append(string).append("<vpn rev=\"1.0\">\n");
        this.outputTwoLevelDirWalk(string + "  ", "", string2, string3, string4, "type", "lang", stringBuffer);
        stringBuffer.append(string).append("</vpn>\n");
        stringBuffer.append(string).append("</vpn-language-manifest>\n");
    }

    private void genBuiltInTransforms(String string, String string2, StringBuffer stringBuffer) {
        File file = new File(string2);
        if (!file.isFile()) {
            return;
        }
        stringBuffer.append("<file app=\"AnyConnect\" platform=\"" + this.msPlatformType + "\" type=\"transform\">\n");
        stringBuffer.append("<uri>" + string + "</uri>\n");
        stringBuffer.append("<hash type=\"sha256\">" + this.fileHash(file) + "</hash>\n");
        stringBuffer.append("</file>\n");
    }

    private int fileCountTwoLevelDirWalk(String string, String string2) {
        int n = 0;
        File file = new File(string + string2);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                File[] fileArray2 = fileArray[i].listFiles();
                for (int j = 0; j < fileArray2.length; ++j) {
                    if (!fileArray2[j].isDirectory()) continue;
                    File[] fileArray3 = fileArray2[j].listFiles();
                    for (int k = 0; k < fileArray3.length; ++k) {
                        File file2 = fileArray3[k];
                        if (!file2.isFile()) continue;
                        ++n;
                    }
                }
            }
        }
        return n;
    }

    private void outputTwoLevelDirWalk(String string, String string2, String string3, String string4, String string5, String string6, String string7, StringBuffer stringBuffer) throws ConfigXMLException {
        String string8 = string + "  ";
        File file = new File(string3 + string4);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                String string9 = fileArray[i].getName();
                File[] fileArray2 = fileArray[i].listFiles();
                for (int j = 0; j < fileArray2.length; ++j) {
                    if (!fileArray2[j].isDirectory()) continue;
                    String string10 = fileArray2[j].getName();
                    File[] fileArray3 = fileArray2[j].listFiles();
                    for (int k = 0; k < fileArray3.length; ++k) {
                        File file2 = fileArray3[k];
                        if (!file2.isFile()) continue;
                        stringBuffer.append(string8).append("<file " + string2 + string6 + "=\"" + string9 + "\" " + string7 + "=\"" + string10 + "\">\n");
                        stringBuffer.append(string8 + "  ").append("<uri>" + string5 + string4 + string9 + "/" + string10 + "/" + file2.getName() + "</uri>\n");
                        stringBuffer.append(string8 + "  ").append("<hash type=\"sha256\">" + this.fileHash(file2) + "</hash>\n");
                        stringBuffer.append(string8).append("</file>\n");
                    }
                }
            }
        }
    }

    private String fileHash(File file) {
        if (file.isFile()) {
            try {
                int n;
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                FileInputStream fileInputStream = new FileInputStream(file);
                DigestInputStream digestInputStream = new DigestInputStream(fileInputStream, messageDigest);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(digestInputStream);
                while ((n = bufferedInputStream.read()) != -1) {
                }
                StringBuilder stringBuilder = new StringBuilder();
                byte[] byArray = messageDigest.digest();
                for (int i = 0; i < byArray.length; ++i) {
                    stringBuilder.append(String.format("%02x", byArray[i] & 0xFF));
                }
                bufferedInputStream.close();
                return stringBuilder.toString().toUpperCase();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                exception.printStackTrace();
            }
        } else {
            this.debugOut("Diplomat warning: " + file.getName() + " is not a file, no hash computed");
        }
        return "0000000000000000000000000000000000000000";
    }

    private void debugOut(String string) {
        this.debugOut(3, string);
    }

    private void debugOut(int n, String string) {
        if (n <= this.debugLogLevel) {
            System.out.println(string);
        }
    }
}

