/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.anyconnect.configxmlgen;

import com.cisco.anyconnect.configxmlgen.ConfigXMLException;
import com.cisco.anyconnect.configxmlgen.ConfigXMLGen;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;

public class GenTestDialog
extends JFrame {
    private JButton btnGenerate;
    private JButton btnSave;
    private JButton btnSelectFile;
    private ButtonGroup buttonGroup1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JRadioButton radConfig;
    private JRadioButton radInput;
    private JTextField txtInputFile;
    private JTextArea txtOutput;
    private JTextField txtOutputFile;

    public GenTestDialog() {
        this.initComponents();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel2 = new JLabel();
        this.txtOutputFile = new JTextField();
        this.btnSelectFile = new JButton();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.txtOutput = new JTextArea();
        this.jLabel4 = new JLabel();
        this.txtInputFile = new JTextField();
        this.radInput = new JRadioButton();
        this.radConfig = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.btnSave = new JButton();
        this.btnGenerate = new JButton();
        this.setDefaultCloseOperation(3);
        this.jLabel2.setText("Input XML:");
        this.btnSelectFile.setText("Browse...");
        this.btnSelectFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenTestDialog.this.btnSelectFileActionPerformed(actionEvent);
            }
        });
        this.jLabel3.setFont(new Font("Tahoma", 1, 12));
        this.jLabel3.setHorizontalAlignment(0);
        this.jLabel3.setText("AnyConnect Downloader Config XML Generation for ISE Integration Test Tool");
        this.txtOutput.setColumns(20);
        this.txtOutput.setRows(5);
        this.jScrollPane1.setViewportView(this.txtOutput);
        this.jLabel4.setText("Output XML:");
        this.txtInputFile.setEditable(false);
        this.buttonGroup1.add(this.radInput);
        this.radInput.setSelected(true);
        this.radInput.setText("ISE Input");
        this.buttonGroup1.add(this.radConfig);
        this.radConfig.setText("Config (Output)");
        this.jLabel5.setText("Select XML file:");
        this.btnSave.setText("Save");
        this.btnSave.setEnabled(false);
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenTestDialog.this.btnSaveActionPerformed(actionEvent);
            }
        });
        this.btnGenerate.setText("Generate");
        this.btnGenerate.setEnabled(false);
        this.btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GenTestDialog.this.btnGenerateActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 657, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, 657, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING, -1, 107, Short.MAX_VALUE).addComponent(this.jLabel5, -1, 107, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtOutputFile, -2, 448, -2).addGroup(groupLayout.createSequentialGroup().addComponent(this.radInput, -2, 159, -2).addGap(69, 69, 69).addComponent(this.radConfig, -2, 126, -2)))).addGroup(groupLayout.createSequentialGroup().addComponent(this.jLabel2, -1, 107, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtInputFile, -2, 448, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnGenerate, -1, 92, Short.MAX_VALUE).addComponent(this.btnSave, -1, 92, Short.MAX_VALUE).addComponent(this.btnSelectFile, -1, 92, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.radInput)).addComponent(this.btnSelectFile).addComponent(this.radConfig)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtOutputFile, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.btnSave)).addGap(11, 11, 11).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtInputFile, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.btnGenerate)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -1, 434, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void btnSelectFileActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("Xml files (*.xml)", "xml");
        String string = null;
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showDialog(null, "Select");
        if (n == 0) {
            string = jFileChooser.getSelectedFile().getAbsolutePath();
            if ((string = string.replace('\\', '/')).lastIndexOf(".") == -1) {
                string = string + ".xml";
            }
            JTextField jTextField = this.radInput.isSelected() ? this.txtInputFile : this.txtOutputFile;
            jTextField.setText(string);
            this.enableButtons();
        }
    }

    private void btnSaveActionPerformed(ActionEvent actionEvent) {
        ConfigXMLGen.saveOutputFile(this.txtOutputFile.getText(), this.txtOutput.getText());
    }

    private void btnGenerateActionPerformed(ActionEvent actionEvent) {
        this.testCreateConfigXml();
    }

    private void enableButtons() {
        this.btnGenerate.setEnabled(!this.txtInputFile.getText().isEmpty() && !this.txtInputFile.getText().isEmpty());
        this.btnSave.setEnabled(!this.txtOutput.getText().isEmpty() && !this.txtOutputFile.getText().isEmpty());
    }

    private void testCreateConfigXml() {
        String string = this.txtInputFile.getText();
        if (string != null && !string.trim().isEmpty()) {
            try {
                ConfigXMLGen configXMLGen = new ConfigXMLGen();
                String string2 = configXMLGen.GenerateConfigurationXML(ConfigXMLGen.contentsOf(string));
                this.txtOutput.setText(string2);
            }
            catch (ConfigXMLException configXMLException) {
                this.txtOutput.setText(configXMLException.toString());
            }
        }
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new GenTestDialog().setVisible(true);
            }
        });
    }
}

