/* global us */

/**************************************************************************
*   Copyright (c) 2021, 2025 Cisco Systems, Inc.
*   All Rights Reserved. Cisco Highly Confidential.
***************************************************************************
*
*   File:    main.js
*
***************************************************************************
*   Main Javascript for Cisco Secure Client Manual Download.
***************************************************************************/
var iStatus = 0;

//---------- Platform Checks  ----------
var agt = navigator.userAgent.toLowerCase();
var IsLinux64 = ( ( agt.indexOf("linux") !== -1 ) && ( agt.indexOf("x86_64") !== -1) );
var IsLinux = ( agt.indexOf("linux") !== -1 );
var IsIntelMacOsX = ( ( agt.indexOf("intel mac os x") !== -1) );
var IsWinNT = ((agt.indexOf("windows nt") !== -1));
var IsArm = false;

(async () => {
    IsArm = await is_ARM();
})();

//---------- Browser Checks  ----------
var IsIE = ( (( agt.indexOf( "msie" ) !== -1 ) || ( agt.indexOf( "trident" ) !== -1 )) && ( agt.indexOf( "opera" ) === -1 ) );
var IsEdge = (navigator.appVersion.indexOf('Edge') > -1); // IE Edge
var IsIEorEDGE = (IsIE || IsEdge);


//---------- Global Defs  ----------
var language = 0;
var clientName = "Cisco Secure Client";

function hasClass(el, className)
{
    if (el.classList)
        return el.classList.contains(className);
    else
        return !!el.className.match(new RegExp('(\\s|^)' + className + '(\\s|$)'));
}

function addClass(el, className)
{
    if (el.classList)
        el.classList.add(className);
    else if (!hasClass(el, className))
        el.className += " " + className;
}

function removeClass(el, className)
{
    if (el.classList)
        el.classList.remove(className);
    else if (hasClass(el, className))
    {
        var reg = new RegExp('(\\s|^)' + className + '(\\s|$)');
        el.className=el.className.replace(reg, ' ');
    }
}

function skipToManualInstall()
{
    iStatus = 1;
    Launch();
}

// 0 Package is not compatible with endpoint system, query the gateway for another package
// 1 Manual Download

function Start( iStatusf )
{
    iStatus = iStatusf;
    language = 0;

    Launch();
}

function ToggleHelpButtonEnable(helpButtonState)
{
    if (helpButtonState)
    {
        var helpBtn = GetElement("helpButton");
        if (helpBtn)
        {
            helpBtn.style.visibility = "hidden";
        }
    }
}

function GetElement (idTag)
{
    return document.getElementById(idTag);
}

function updateMessage()
{
    document.getElementById( "idDivMessage" ).innerHTML = aszMessage[language][ Math.abs( iStatus ) ];
}

function Launch()
{
    updateMessage();
    switch ( iStatus )
    {
    case 0:
        // Package not compatible with OS -- try the next package
        var new_path = window.location.href;
        var pos = new_path.indexOf("/stc/") + 5;
        if (pos !== 4)
        {
            var current = new_path.charAt(pos);
            current++;
            new_path = new_path.substring(0, pos) + current + new_path.substring(pos + 1);
            window.location.href = new_path;
        }
        break;
    case 1:
        showManualDownload();
        break;
    }
}

//-----------------------------------------------------------------
//Checks for Empty String.  
//Returns true if str is empty,blank, null or undefined. 
//-----------------------------------------------------------------
function empty(str)
{
    return typeof str == 'undefined' || !str || str.length === 0 || str === "" || !/[^\s]/.test(str) || /^\s*$/.test(str) || str.replace(/\s/g, "") === "";
}

//-----------------------------------------------------------------
//Opens the Tip/Help Windows
//-----------------------------------------------------------------
function openTipsWindow()
{
    var helpfile = "tips.htm";
   
    window.open(helpfile, 'tips',
      'width=' + 975 + ',height='+ screen.height + ',scrollbars=yes,toolbar=no,directories=no,' +
        'status=no,menubar=no,top=0,screenY=0,resizable,' );
}

//-----------------------------------------------------------------
//Closes Tips/Help Window
//-----------------------------------------------------------------
function closeopenTipsWindow()
{
    window.close();   // Closes the new window
}

function showManualDownload()
{
    //Set Action Panel Header text
    document.getElementById("provisioning_action_label").textContent="Download & Install";
    
    //Set Manual Install instructions
    showInstallInstructions("manual");

    //Adds this alternative text to action panel text.
    GetElement("idDivMessage").innerHTML += '<div class="panel panel--loose panel--ltgray text-center"><div class="section"><button id="manualInstallButton" type="button" value="Download" class="btn btn--primary" onclick="downloadACPackage();">Download</button></div></div>';
    
    //Set action text to appropriate item.
    var platformTxt = "";
    if (IsIntelMacOsX)
    {
        platformTxt = "macOS";
    }
    else if (IsWinNT)
    {
        platformTxt = "Windows"; 
    }
    else if (IsLinux || IsLinux64)
    {
        platformTxt = "Linux";
    }
    else
    {
        platformTxt = "";
    }
    //Set Download button with Platform information (ie "Download for Mac")
    setDownloadButtonTxt("Download for " + platformTxt);
}

//-----------------------------------------------------------------
//Sets Download Button Text Contents
//-----------------------------------------------------------------
function setDownloadButtonTxt(buttonTxt)
{
    var ButtonText = "Download";
  
    if (!empty(buttonTxt))
    {
        ButtonText = buttonTxt;
        
    }
    //Sets Download button text
    document.getElementById("manualInstallButton").textContent = ButtonText;   
}

//-----------------------------------------------------------------
// This configures wheather the auto install instructions are enabled
// or the manual install instructions.
//-----------------------------------------------------------------
function showInstallInstructions(mode)
{
    //Sets appropriate instruction visiblity
    switch ( mode )
    {
    case 'manual':
        document.getElementById("manual_install_instructions").style.display = 'block';
        break;
    default:
        document.getElementById("manual_install_instructions").style.display = 'none';
        break;
    }
}

//-----------------------------------------------------------------
// This method loads the user Install instructions into there
// corresponding divs in the page.
//-----------------------------------------------------------------
function loadInstructionPages()
{
    $.get('manual-instructions.html', function(data) {
        $('#manual_install_instructions').html(data);
    });
}

//-----------------------------------------------------------------
// This method loads the webpage icons/images
//-----------------------------------------------------------------
function loadIcons()
{
    //help icon
    var cui_cisco_help_icon = document.getElementById("cui_cisco_help_icon");
    var edge_cisco_help_icon = document.getElementById("edge_cisco_help_icon");

    //info icon
    var cui_cisco_info_icon = document.getElementById("cui_cisco_info_icon");
    var edge_cisco_info_icon = document.getElementById("edge_cisco_info_icon");

    var cui_cisco_success_icon = document.getElementById("cui_cisco_success_icon");
    var edge_cisco_success_icon = document.getElementById("edge_cisco_success_icon");

    var cui_cisco_warn_icon = document.getElementById("cui_cisco_warn_icon");
    var edge_cisco_warn_icon = document.getElementById("edge_cisco_warn_icon");

    var cui_cisco_error_icon = document.getElementById("cui_cisco_error_icon");
    var edge_cisco_error_icon = document.getElementById("edge_cisco_error_icon");

    var ac_expand_collapse_icons = document.getElementById("ac_expand_collapse_icons");

    /*
    In order to display icons appropriately on the Edge & IE browser it was necessary
    to replace the CUIs framework font icons with our own.  Once the CUIs team
    addresses this issue we can remove this handling.
     */

    if ( IsIEorEDGE )
    {
        cui_cisco_help_icon.style.display = "none";
        edge_cisco_help_icon.style.display = "block";

        cui_cisco_info_icon.style.display  = "none";
        edge_cisco_info_icon.style.display = "float";

        cui_cisco_success_icon.style.display  = "none";
        edge_cisco_success_icon.style.display = "float";

        cui_cisco_warn_icon.style.display  = "none";
        edge_cisco_warn_icon.style.display = "float";

        cui_cisco_error_icon.style.display  = "none";
        edge_cisco_error_icon.style.display = "float";

        ac_expand_collapse_icons.style.display = "none";
    }
    else
    {
        cui_cisco_help_icon.style.display = "block";
        edge_cisco_help_icon.style.display = "none";

        cui_cisco_info_icon.style.display  = "float";
        edge_cisco_info_icon.style.display = "none";

        cui_cisco_success_icon.style.display  = "float";
        edge_cisco_success_icon.style.display = "none";

        cui_cisco_warn_icon.style.display  = "float";
        edge_cisco_warn_icon.style.display = "none";

        cui_cisco_error_icon.style.display  = "float";
        edge_cisco_error_icon.style.display = "none";

        ac_expand_collapse_icons.style.display = "block";
    }

}

function downloadACPackage()
{
    //Dismiss any Alert Showing
    setAlert(0,' ');
    
    var InstallerPackage = "binaries/" + packageInstaller;
    
    window.open(InstallerPackage);
}

//-----------------------------------------------------------------
// This Method will set/show alerts to user
// alert_type   = 0 = Clear Alerts
//              = 1 = informational 
//              = 2 = success
//              = 3 = warning
//              = 4 = danger
//              
//-----------------------------------------------------------------
function setAlert(ac_alert_type, ac_message)
{
    var info_alert_item, success_alert_item, warning_alert_item, danger_alert_item, buffer, final_alert_message;
    info_alert_item = document.getElementById("ac_info_alert");
    success_alert_item = document.getElementById("ac_success_alert");
    warning_alert_item  = document.getElementById("ac_warning_alert");
    danger_alert_item   = document.getElementById("ac_danger_alert");
    
    buffer = '\t';
    
    //Sets appropriate alert type visiblity
    switch ( ac_alert_type )
    {
    case 0:             
        {
            //Info Alert
            final_alert_message = ' '; 
            info_alert_item.style.display = 'none';
            success_alert_item.style.display = 'none';
            warning_alert_item.style.display = 'none';
            danger_alert_item.style.display = 'none';
        }
        break;
    case 1:
        {
            //Info Alert
            final_alert_message = 'Information:' + buffer + ac_message;
            info_alert_item.style.display = 'block';
            success_alert_item.style.display = 'none';
            warning_alert_item.style.display = 'none';
            danger_alert_item.style.display = 'none';
        }
        break;
    case 2:
        {
            //Success Alert
            final_alert_message = 'Success: ' + buffer + ac_message;
            info_alert_item.style.display = 'none';
            success_alert_item.style.display = 'block';
            warning_alert_item.style.display = 'none';
            danger_alert_item.style.display = 'none';

        }
        break;
    case 3:
        {
            //Warning Alert
            final_alert_message = 'Warning: ' + buffer + ac_message;
            info_alert_item.style.display = 'none';
            success_alert_item.style.display = 'none';
            warning_alert_item.style.display = 'block';
            danger_alert_item.style.display = 'none';
        }
        break;
    case 4:
        {
            //Danger Alert
            final_alert_message = 'Error: ' + buffer + ac_message;            
            info_alert_item.style.display = 'none';
            success_alert_item.style.display = 'none';
            warning_alert_item.style.display = 'none';
            danger_alert_item.style.display = 'block';
        }
        break;
    }
    
    //Set the Alert Text
    $('.alert__message').html(final_alert_message);
}

//-----------------------------------------------------------------
// This handler is called when manual download tab option is 
// clicked by the user.  It toggles the active option as well as sets
// the status step to the appropriate manual step to download.
//-----------------------------------------------------------------
function manual_prov_tab_clicked()
{
    //Clear any Potential Alerts
    setAlert(0,' ');
    
    //Skips to Manual Install Steps
    skipToManualInstall();
}

//-----------------------------------------------------------------
// This method toggles the instruction div.
//-----------------------------------------------------------------
function toggle_install_instructions()
{
    var ele         = document.getElementById("toggleInstructions");
    var infoopen    = document.getElementById("infoopen");
    var infoclosed  = document.getElementById("infoclosed");

    if (ele.style.display == "block")
    {
        ele.style.display = "none";

        infoopen.style.display = "none";
        infoclosed.style.display = "block";
    }
    else
    {
        ele.style.display = "block";
        infoopen.style.display = "block";
        infoclosed.style.display = "none";
    }
}

//-----------------------------------------------------------------
// This method find if the client is ARM or x86_64 (Edge & Chrome only)
//-----------------------------------------------------------------
async function is_ARM() {
    if (navigator.userAgentData) 
    {
        try 
        {
            const ua = await navigator.userAgentData.getHighEntropyValues(['architecture']);
            return ua.architecture === 'arm';
        } 
        catch (error) 
        {
            return false;
        }
    }
    return false;
}


//-----------------------------------------------------------------
//-----------------------------------------------------------------
//-----------------------------------------------------------------
//-----------------------------------------------------------------
//-----------------------------------------------------------------
//                  END OF MAIN.JS 
//-----------------------------------------------------------------
//-----------------------------------------------------------------
//-----------------------------------------------------------------
//-----------------------------------------------------------------
//-----------------------------------------------------------------
