<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:fn="http://www.w3.org/2005/xpath-functions"
    xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:exsl="http://exslt.org/common"
    extension-element-prefixes="exsl"
    
    xmlns:lookup="http://www.cisco.com/2007/CSSCValidationRules/5.0.40">

  <xsl:output method="xml"  encoding="UTF-8" indent="yes"/>

  <xsl:template match="/">
    <xsl:element name="br_results">
      <!-- business rules -->
      <xsl:call-template name="Rule1.1.1"/>
      <xsl:call-template name="Rule1.1.2"/>
      <xsl:call-template name="Rule1.1.3"/>
      <xsl:call-template name="Rule1.2.1a"/>
      <xsl:call-template name="Rule1.2.1b"/>
      <xsl:call-template name="Rule1.2.1c"/>

      <!-- policy rules -->
      <xsl:call-template name="Rule2.1a"/>
      <xsl:call-template name="Rule2.1b"/>
      <xsl:call-template name="Rule2.1c"/>
      <xsl:call-template name="Rule2.1c1"/>
      <xsl:call-template name="Rule2.1d"/>
      <xsl:call-template name="Rule2.1e"/>
      <xsl:call-template name="Rule2.1f"/>
      <xsl:call-template name="Rule2.1g"/>
      <xsl:call-template name="Rule2.1h"/>
      <xsl:call-template name="Rule2.1i"/>
      <xsl:call-template name="Rule2.1j"/>
      <xsl:call-template name="Rule2.1k"/>
      <xsl:call-template name="Rule2.1l"/>
      <xsl:call-template name="Rule2.1m"/>

      <xsl:call-template name="Rule2.2a"/>
      <xsl:call-template name="Rule2.2b"/>
      <xsl:call-template name="Rule2.2c"/>
      <xsl:call-template name="Rule2.2d"/>
      <xsl:call-template name="Rule2.2e"/>
      <xsl:call-template name="Rule2.2f"/>
      <xsl:call-template name="Rule2.2g"/>
      <xsl:call-template name="Rule2.2h"/>

      <xsl:call-template name="Rule3a"/>
      <xsl:call-template name="Rule3b"/>
      <xsl:call-template name="Rule3c"/>
    </xsl:element>
  </xsl:template>


  <xsl:template name="Rule1.1.1">
    <!-- 1.1.1 eapFast authenticateWithPassword inner method existence  -->
    <xsl:call-template name="ViolatingNetworksTemplate">
      <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[.//eapFast/authMethods[builtinMethods/authenticateWithPassword and not(.//methods/*)]]"/>
      <xsl:with-param name="ruleId" select="'Rule1.1.1'"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="Rule1.1.2">
    <!-- 1.1.2 eapPeap authenticateWithPassword inner method existence  -->
    <xsl:call-template name="ViolatingNetworksTemplate">
      <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[.//eapPeap/authMethods/builtinMethods[authenticateWithPassword and not(.//methods/*)]]"/>
      <xsl:with-param name="ruleId" select="'Rule1.1.2'"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="Rule1.1.3">
    <!-- 1.1.3 eapTtls authenticateWithPassword inner method existence  -->
    <xsl:call-template name="ViolatingNetworksTemplate">
      <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[.//eapTtls[eapMethods and not(eapMethods/*)]]"/>
      <xsl:with-param name="ruleId" select="'Rule1.1.3'"/>
    </xsl:call-template>
  </xsl:template>


  <xsl:template name="Rule1.2.1a">
    <!-- 1.2.1a Check for correct collectionBehavior when passwordFromUser  -->
    <xsl:call-template name="ViolatingNetworksTemplate">
      <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[(.//userAuthentication | .//user)[
            .//passwordSource[passwordFromUser] and not(.//collectionBehavior/withPassword)]]"/>
      <xsl:with-param name="ruleId" select="'Rule1.2.1a'"/>
    </xsl:call-template>
  </xsl:template>

  <xsl:template name="Rule1.2.1b">
    <!-- 1.2.1b Check for correct collectionBehavior when certificateFromUser  -->
    <xsl:call-template name="ViolatingNetworksTemplate">
      <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[(.//userAuthentication | .//user)[
            .//certificateSource[certificateFromUser] and not(.//collectionBehavior/withCertificate)]]"/>
      <xsl:with-param name="ruleId" select="'Rule1.2.1b'"/>
    </xsl:call-template>
  </xsl:template>
  
  <xsl:template name="Rule1.2.1c">
    <!-- 1.2.1c Check for correct collectionBehavior when tokenSource  -->
    <xsl:call-template name="ViolatingNetworksTemplate">
      <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[(.//userAuthentication | .//user)[
            .//tokenSource and not(.//collectionBehavior/withToken)]]"/>
      <xsl:with-param name="ruleId" select="'Rule1.2.1c'"/>
    </xsl:call-template>
  </xsl:template>

  <!--   ............................       BEGIN POLICY CHECKING  .................................................. -->
  <!-- Rule 2.1 is broken into subrule.  This makes condition-specific messages easier -->

  <xsl:template name="Rule2.1a">
    <!-- 2.1a Association Mode impact: openNoEncryption mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/openNoEncryption)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="//wifiNetwork[openNetwork]"/>
        <xsl:with-param name="ruleId" select="'Rule2.1a'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.1b">
    <!-- 2.1b Association Mode impact: openStaticWep mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/openStaticWep)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wifiNetwork[
                    .//sharedKeyNetwork/*/wep/ieee80211Authentication = 'open']  )"/>
        <xsl:with-param name="ruleId" select="'Rule2.1b'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.1c">
    <!-- 2.1c Association Mode impact: sharedStaticWep mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/sharedStaticWep)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wifiNetwork[
                    .//sharedKeyNetwork/*/wep/ieee80211Authentication = 'shared']  )"/>
        <xsl:with-param name="ruleId" select="'Rule2.1c'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.1c1">
    <!-- 2.1c1 Association Mode impact: open1xDynamicWep mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/open1xDynamicWep)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wifiNetwork[
                    .//authenticationNetwork/associationMode/wep]  )"/>
        <xsl:with-param name="ruleId" select="'Rule2.1c1'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.1d">
    <!-- 2.1d Association Mode impact: wpaPersonalTkip mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/wpaPersonalTkip)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wifiNetwork[
                    .//sharedKeyNetwork/*/wpa/encryption = 'TKIP']  )"/>
        <xsl:with-param name="ruleId" select="'Rule2.1d'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.1e">
    <!-- 2.1e Association Mode impact: wpaPersonalAes mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/wpaPersonalAes)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wifiNetwork[
                    .//sharedKeyNetwork/*/wpa/encryption = 'AES']  )"/>
        <xsl:with-param name="ruleId" select="'Rule2.1e'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.1f">
    <!-- 2.1f Association Mode impact: wpa2PersonalTkip mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/wpa2PersonalTkip)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wifiNetwork[
                    .//sharedKeyNetwork/*/wpa2/encryption = 'TKIP']  )"/>
        <xsl:with-param name="ruleId" select="'Rule2.1f'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.1g">
    <!-- 2.1g Association Mode impact: wpa2PersonalAes mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/wpa2PersonalAes)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wifiNetwork[
                    .//sharedKeyNetwork/*/wpa2/encryption = 'AES']  )"/>
        <xsl:with-param name="ruleId" select="'Rule2.1g'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.1h">
    <!-- 2.1h Association Mode impact: wpaEnterpriseTkip mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/wpaEnterpriseTkip)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wifiNetwork[
                    .//authenticationNetwork/associationMode/wpa/encryption = 'TKIP']  )"/>
        <xsl:with-param name="ruleId" select="'Rule2.1h'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.1i">
    <!-- 2.1i Association Mode impact: wpaEnterpriseAes mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/wpaEnterpriseAes)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wifiNetwork[
                    .//authenticationNetwork/associationMode/wpa/encryption = 'AES']  )"/>
        <xsl:with-param name="ruleId" select="'Rule2.1i'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.1j">
    <!-- 2.1j Association Mode impact: wpa2EnterpriseTkip mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/wpa2EnterpriseTkip)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wifiNetwork[
                    .//authenticationNetwork/associationMode/wpa2/encryption = 'TKIP']  )"/>
        <xsl:with-param name="ruleId" select="'Rule2.1j'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.1k">
    <!-- 2.1k Association Mode impact: wpa2EnterpriseAes mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/wpa2EnterpriseAes)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wifiNetwork[
                    .//authenticationNetwork/associationMode/wpa2/encryption = 'AES']  )"/>
        <xsl:with-param name="ruleId" select="'Rule2.1k'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.1l">
    <!-- 2.1.l Association Mode impact: cckmEnterpriseTkip mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/cckmEnterpriseTkip)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wifiNetwork[
                    .//authenticationNetwork/associationMode/cckm/encryption = 'TKIP']  )"/>
        <xsl:with-param name="ruleId" select="'Rule2.1l'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.1m">
    <!-- 2.1m Association Mode impact: cckmEnterpriseAes mode  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedAssociationModes/cckmEnterpriseAes)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wifiNetwork[
                    .//authenticationNetwork/associationMode/cckm/encryption = 'AES']  )"/>
        <xsl:with-param name="ruleId" select="'Rule2.1m'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.2a">
    <!-- 2.2a EAP method impact: eapMd5  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedEapMethods/eapMd5)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[(.//machineAuthentication|.//machine|.//authenticationMethod)/eapMd5]"/>
        <xsl:with-param name="ruleId" select="'Rule2.2a'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.2b">
    <!-- 2.2b EAP method impact: eapMschapv2  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedEapMethods/eapMschapv2)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[(.//machineAuthentication|.//machine|.//authenticationMethod)/eapMschapv2]"/>
        <xsl:with-param name="ruleId" select="'Rule2.2b'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.2c">
    <!-- 2.2c EAP method impact: eapGtc  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedEapMethods/eapGtc)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[(.//machineAuthentication|.//machine|.//authenticationMethod)/eapGtc]"/>
        <xsl:with-param name="ruleId" select="'Rule2.2c'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.2d">
    <!-- 2.2d EAP method impact: leap  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedEapMethods/leap)" >

      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[(.//machineAuthentication|.//machine|.//authenticationMethod)/leap]"/>
        <xsl:with-param name="ruleId" select="'Rule2.2d'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.2e">
    <!-- 2.2e EAP method impact: Tls  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedEapMethods/eapTls)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[(.//machineAuthentication|.//machine|.//authenticationMethod)/eapTls]"/>
        <xsl:with-param name="ruleId" select="'Rule2.2e'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.2f">
    <!-- 2.2f EAP method impact: Ttls  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedEapMethods/eapTtls)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[(.//machineAuthentication|.//machine|.//authenticationMethod)/eapTtls]"/>
        <xsl:with-param name="ruleId" select="'Rule2.2f'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.2g">
    <!-- 2.2g EAP method impact: Peap  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedEapMethods/eapPeap)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[(.//machineAuthentication|.//machine|.//authenticationMethod)/eapPeap]"/>
        <xsl:with-param name="ruleId" select="'Rule2.2g'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule2.2h">
    <!-- 2.2f EAP method impact: Fast  -->
    <xsl:if test="not(/configuration/networkPolicy/allowedEapMethods/eapFast)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="(//wiredNetwork|//wifiNetwork)[(.//machineAuthentication|.//machine|.//authenticationMethod)/eapFast]"/>
        <xsl:with-param name="ruleId" select="'Rule2.2h'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>


  <xsl:template name="Rule3a">
    <!-- 3a User Control Policy rules: Media support -->
    <xsl:if test="//userControlPolicy/allowedMedia and
                                not( //userControlPolicy/allowedMedia/wired or //userControlPolicy/allowedMedia/wifi )">
      <xsl:call-template name="InstanciateRuleTemplate">
        <xsl:with-param name="ruleId" select="'Rule3a'"/>
        <xsl:with-param name="arguments" select="/.."/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule3b">
    <!-- 3b User Control Policy rules: Media present -->
    <xsl:if test="not(//userControlPolicy/allowedMedia/wired)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="//wiredNetwork"/>
        <xsl:with-param name="ruleId" select="'Rule3b'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="Rule3c">
    <!-- 3c User Control Policy rules: Media present -->
    <xsl:if test="not(//userControlPolicy/allowedMedia/wifi)" >
      <xsl:call-template name="ViolatingNetworksTemplate">
        <xsl:with-param name="violatingNetworks" select="//wifiNetwork"/>
        <xsl:with-param name="ruleId" select="'Rule3c'"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <!-- END OF RULES / BEGINNING OF UTILITY ROUTINES -->

  <xsl:variable name="apos">'</xsl:variable>

  <xsl:template name="ViolatingNetworksTemplate">
    <xsl:param name="violatingNetworks"/>
    <xsl:param name="ruleId"/>

    <xsl:if test="count($violatingNetworks) > 0">
      <xsl:variable name="moreNetworks">
        <xsl:choose>
          <xsl:when test="count($violatingNetworks) > 1">Networks</xsl:when>
          <xsl:otherwise>Network</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:variable name="violatingNetworksAsString">
        <xsl:call-template name="NodeListToString">
          <xsl:with-param name="nodeList" select="$violatingNetworks/displayName"/>
          <xsl:with-param name="separatorString" select="', '"/>
          <xsl:with-param name="quotingChar" select="'&#34;'"/>
        </xsl:call-template>
      </xsl:variable>

      <xsl:variable name="ruleMessageArgs">
        <xsl:call-template name="MakeArgument">
          <xsl:with-param name="name" select="'moreNetworks'"/>
          <xsl:with-param name="content" select="$moreNetworks"/>
        </xsl:call-template>
        <xsl:call-template name="MakeArgument">
          <xsl:with-param name="name" select="'violatingNetworksAsString'"/>
          <xsl:with-param name="content" select="$violatingNetworksAsString"/>
        </xsl:call-template>
      </xsl:variable>
      <xsl:call-template name="InstanciateRuleTemplate">
        <xsl:with-param name="ruleId" select="$ruleId"/>
        <xsl:with-param name="arguments" select="$ruleMessageArgs"/>
      </xsl:call-template>
    </xsl:if>
  </xsl:template>

  <xsl:template name="MakeArgument">
    <xsl:param name="name"/>
    <xsl:param name="content"/>
    <xsl:element name="argument">
      <xsl:element name="name">
        <xsl:value-of select="$name"/>
      </xsl:element>
      <xsl:element name="content">
        <xsl:value-of select="$content"/>
      </xsl:element>
    </xsl:element>
  </xsl:template>

  <xsl:template name="InstanciateStringTemplate">
    <xsl:param name="template"/>
    <xsl:param name="parameterMark"/>
    <xsl:param name="parameters"/>

    <xsl:param name="partialInstance"/>

    <xsl:choose>
      <xsl:when test="string-length($template) > 0 and contains($template, $parameterMark)">
        <xsl:if test="not(contains(substring-after($template, $parameterMark), $parameterMark))">
          <xsl:message terminate="yes">
            <xsl:value-of select="concat('Template contains an unpaired parameter mark ', $apos, $parameterMark, $apos, '. Left to process: ', $apos, $template, $apos)"/>
          </xsl:message>
        </xsl:if>
        <xsl:variable name="betweenMarks" select="substring-before(substring-after($template, $parameterMark), $parameterMark)"/>
        <xsl:choose>
          <xsl:when test="string-length($betweenMarks) = 0">
            <xsl:call-template name="InstanciateStringTemplate">
              <xsl:with-param name="template" select="substring-after(substring-after($template, $parameterMark), $parameterMark)"/>
              <xsl:with-param name="parameterMark" select="$parameterMark"/>
              <xsl:with-param name="parameters" select="$parameters"/>
              <xsl:with-param name="partialInstance" select="concat($partialInstance, substring-before($template, $parameterMark), $parameterMark)"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <!-- next line ALTOVA only.  Will break libxml -->
            <!--xsl:variable name="paramValue" select="$parameters/argument/content[../name = $betweenMarks]"/-->
            <!-- next line libxml only.  Will break ALTOVA -->
            <xsl:variable name="paramValue" select="exsl:node-set($parameters)/argument/content[../name = $betweenMarks]"/>
            <xsl:if test="not($paramValue)">
              <xsl:message terminate="yes">
                <xsl:value-of select="concat('Could not find a parameter named ', $apos, $betweenMarks, $apos)"/>
              </xsl:message>
            </xsl:if>
            <xsl:call-template name="InstanciateStringTemplate">
              <xsl:with-param name="template" select="substring-after(substring-after($template, $parameterMark), $parameterMark)"/>
              <xsl:with-param name="parameterMark" select="$parameterMark"/>
              <xsl:with-param name="parameters" select="$parameters"/>
              <xsl:with-param name="partialInstance" select="concat($partialInstance, substring-before($template, $parameterMark), $paramValue)"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="string-length($template) > 0 and not(contains($template, $parameterMark))">
        <xsl:value-of select="concat($partialInstance, $template)"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$partialInstance"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="InstanciateRuleTemplate">
    <xsl:param name="ruleId"/>
    <xsl:param name="arguments"/>

    <xsl:variable name="ruleTemplate">
      <xsl:apply-templates select="$validationRulesLookupTable">
        <xsl:with-param name="id" select="$ruleId"/>
      </xsl:apply-templates>
    </xsl:variable>

    <xsl:element name="br_failure">
      <xsl:call-template name="InstanciateStringTemplate">
        <xsl:with-param name="template" select="$ruleTemplate"/>
        <xsl:with-param name="parameterMark" select="'@'"/>
        <xsl:with-param name="parameters" select="$arguments"/>
        <xsl:with-param name="partialInstance" select="''"/>
      </xsl:call-template>
    </xsl:element>
  </xsl:template>

  <xsl:template name="NodeListToString">
    <xsl:param name="nodeList"/>
    <xsl:param name="separatorString"/>
    <xsl:param name="quotingChar"/>

    <xsl:for-each select="$nodeList">
      <xsl:variable name="listItemString">
        <xsl:choose>
          <xsl:when test="$quotingChar != ''">
            <xsl:value-of select="concat($quotingChar, ., $quotingChar)"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="."/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>
      <xsl:choose>
        <xsl:when test="$separatorString != '' and . != $nodeList[position() = 1]">
          <xsl:value-of select="concat($separatorString, $listItemString)"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="$listItemString"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="LookForDuplicates">
    <xsl:param name="list"/>
    <xsl:param name="duplicates"/>

    <xsl:choose>
      <xsl:when test="count($list) > 1">
        <xsl:variable name="car" select="$list[position() = 1]"/>
        <xsl:variable name="cdr" select="$list[position() > 1]"/>
        <xsl:choose>
          <xsl:when test="$cdr = $car and not($duplicates = $car)">
            <xsl:call-template name="LookForDuplicates">
              <xsl:with-param name="list" select="$cdr"/>
              <xsl:with-param name="duplicates" select="$duplicates | $car"/>
            </xsl:call-template>
          </xsl:when>
          <xsl:otherwise>
            <xsl:call-template name="LookForDuplicates">
              <xsl:with-param name="list" select="$cdr"/>
              <xsl:with-param name="duplicates" select="$duplicates"/>
            </xsl:call-template>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="NodeListToString">
          <xsl:with-param name="nodeList" select="$duplicates"/>
          <xsl:with-param name="separatorString" select="', '"/>
          <xsl:with-param name="quotingChar" select="'&#34;'"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <lookup:rules>
    <lookup:rule>
      <lookup:id>Rule1.1.1</lookup:id>
      <lookup:template>[Rule 1.1.1 violation] @moreNetworks@ @violatingNetworksAsString@ EapFast authentication settings should use at least one of the following methods as inner method: eapMschapv2 or eapGtc</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule1.1.2</lookup:id>
      <lookup:template>[Rule 1.1.2 violation] @moreNetworks@ @violatingNetworksAsString@ EapPeap authentication settings should use at least one of the following methods as inner method: eapMschapv2 or eapGtc</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule1.1.3</lookup:id>
      <lookup:template>[Rule 1.1.3 violation] @moreNetworks@ @violatingNetworksAsString@ EapTtls authentication settings should use at least one of the following methods as inner eap method: eapMschapv2 or eapMd5</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule1.2.1a</lookup:id>
      <lookup:template>[Rule 1.2.1a violation] @moreNetworks@ @violatingNetworksAsString@ Collection behavior for user authentication with passwordFromUser must be authenticateWithPassword!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule1.2.1b</lookup:id>
      <lookup:template>[Rule 1.2.1b violation] @moreNetworks@ @violatingNetworksAsString@ Collection behavior for user authentication with certificateFromUser must be authenticateWithCertificate!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule1.2.1c</lookup:id>
      <lookup:template>[Rule 1.2.1c violation] @moreNetworks@ @violatingNetworksAsString@ Collection behavior for user authentication with tokens must be authenticateWithToken!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1a</lookup:id>
      <lookup:template>[Rule 2.1a violation] @moreNetworks@ @violatingNetworksAsString@ openNetwork only allowed when openNoEncryption mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1b</lookup:id>
      <lookup:template>[Rule 2.1b violation] @moreNetworks@ @violatingNetworksAsString@: wep with ieee80211Authentication/open only allowed when policy openStaticWep mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1c</lookup:id>
      <lookup:template>[Rule 2.1c violation] @moreNetworks@ @violatingNetworksAsString@: wep with ieee80211Authentication/shared only allowed when policy sharedStaticWep mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1c1</lookup:id>
      <lookup:template>[Rule 2.1c1 violation] @moreNetworks@ @violatingNetworksAsString@: Authentication network with association mode WEP only allowed when policy open1xDynamicWep mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1d</lookup:id>
      <lookup:template>[Rule 2.1d violation] @moreNetworks@ @violatingNetworksAsString@: wpa with encryption/TKIP only allowed when policy wpaPersonalTkip mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1e</lookup:id>
      <lookup:template>[Rule 2.1e violation] @moreNetworks@ @violatingNetworksAsString@: wpa with encryption/AES only allowed when policy wpaPersonalAes mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1f</lookup:id>
      <lookup:template>[Rule 2.1f violation] @moreNetworks@ @violatingNetworksAsString@: wpa2 with encryption/TKIP only allowed when policy wpa2PersonalTkip mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1g</lookup:id>
      <lookup:template>[Rule 2.1g violation] @moreNetworks@ @violatingNetworksAsString@: wpa2 with encryption/AES only allowed when policy wpa2PersonalAes mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1h</lookup:id>
      <lookup:template>[Rule 2.1h violation] @moreNetworks@ @violatingNetworksAsString@: wpa with encryption/TKIP only allowed when policy wpaEnterpriseTkip mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1i</lookup:id>
      <lookup:template>[Rule 2.1i violation] @moreNetworks@ @violatingNetworksAsString@: wpa with encryption/AES only allowed when policy wpaEnterpriseAes mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1j</lookup:id>
      <lookup:template>[Rule 2.1j violation] @moreNetworks@ @violatingNetworksAsString@: wpa2 with encryption/TKIP only allowed when policy wpa2EnterpriseTkip mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1k</lookup:id>
      <lookup:template>[Rule 2.1k violation] @moreNetworks@ @violatingNetworksAsString@: wpa2 with encryption/AES only allowed when policy wpa2EnterpriseAes mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1l</lookup:id>
      <lookup:template>[Rule 2.1l violation] @moreNetworks@ @violatingNetworksAsString@: cckm with encryption/TKIP only allowed when policy cckmEnterpriseTkip mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.1m</lookup:id>
      <lookup:template>[Rule 2.1m violation] @moreNetworks@ @violatingNetworksAsString@: cckm with encryption/AES only allowed when policy cckmEnterpriseAes mode is selected!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.2a</lookup:id>
      <lookup:template>[Rule 2.2a violation] @moreNetworks@ @violatingNetworksAsString@ : eapMd5 requires allowedEapMethods/eapMd5.</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.2b</lookup:id>
      <lookup:template>[Rule 2.2b violation] @moreNetworks@ @violatingNetworksAsString@: eapMschapv2 requires allowedEapMethods/eapMschapv2 mode.</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.2c</lookup:id>
      <lookup:template>[Rule 2.2c violation] @moreNetworks@ @violatingNetworksAsString@: eapGtc requires allowedEapMethods/eapGtc mode.</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.2d</lookup:id>
      <lookup:template>[Rule 2.2d violation] @moreNetworks@ @violatingNetworksAsString@: leap requires allowedEapMethods/leap mode.</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.2e</lookup:id>
      <lookup:template>[Rule 2.2e violation] @moreNetworks@ @violatingNetworksAsString@: eapTls requires allowedEapMethods/eapTls mode.</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.2f</lookup:id>
      <lookup:template>[Rule 2.2f violation] @moreNetworks@ @violatingNetworksAsString@: eapTtls requires allowedEapMethods/eapTtls mode.</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.2g</lookup:id>
      <lookup:template>[Rule 2.2g violation] @moreNetworks@ @violatingNetworksAsString@: eapPeap requires allowedEapMethods/eapPeap mode.</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule2.2h</lookup:id>
      <lookup:template>[Rule 2.2h violation] @moreNetworks@ @violatingNetworksAsString@: eapFast requires allowedEapMethods/eapFast mode.</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule3a</lookup:id>
      <lookup:template>[Rule 3a violation] At least one media type must be specified for userControyPolicy/allowedMedia!</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule3b</lookup:id>
      <lookup:template>[Rule 3b violation] @moreNetworks@ @violatingNetworksAsString@: wiredNetwork may not be present unless userControlPolicy/allowedMedia/wired is present.</lookup:template>
    </lookup:rule>
    <lookup:rule>
      <lookup:id>Rule3c</lookup:id>
      <lookup:template>[Rule 3c violation] @moreNetworks@ @violatingNetworksAsString@: wifiNetwork may not be present unless userControlPolicy/allowedMedia/wifi is present.</lookup:template>
    </lookup:rule>
  </lookup:rules>

  <xsl:key name="validationRulesLookupKey" match="lookup:rule" use="lookup:id"/>
  <xsl:variable name="validationRulesLookupTable" select="document('')/*/lookup:rules"/>

  <xsl:template match="lookup:rules">
    <xsl:param name="id"/>
    <xsl:value-of select="key('validationRulesLookupKey', $id)/lookup:template"/>
  </xsl:template>

</xsl:stylesheet>
