CXX = clang++
CPPFLAGS = -DCAPI_EXPORTS
CXXFLAGS = -std=c++11 -arch x86_64 -arch arm64 -g
LDFLAGS = -dynamiclib
INCLUDES = -I../../include
VPNLIB_DIR = ../../lib/MAC/Intel
LIBS = -L${VPNLIB_DIR} -lvpnapi -lxml2 -lz -lvpncommoncrypt -lvpncommon ${VPNLIB_DIR}/libaccurl.a ${VPNLIB_DIR}/libacciscocrypto.a ${VPNLIB_DIR}/libacciscossl.a -lpthread
FRAMEWORKS = -framework SystemConfiguration -framework Security -framework CoreFoundation -framework CoreServices -framework IOKit

all: libvpncapi

#compile cpp files
%.o:%.cpp
	@echo compiling $<
	${CXX} ${CPPFLAGS} ${CXXFLAGS} ${INCLUDES} -c $<

libvpncapi: PrivateApi.o vpncapi.o
	${CXX} ${LDFLAGS} PrivateApi.o vpncapi.o -o libvpncapi.dylib ${FRAMEWORKS} ${LIBS}

clean:
	rm -f *.dylib *.o
