using System;
using System.IO;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using VpnApiLib;

namespace ScriptBuddy
{
    public partial class Form1 : Form
    {
        private VpnApiClass vpnApi = null;
        private VPNState previousVpnState = VPNState.UNKNOWN;
        private System.ComponentModel.BackgroundWorker scriptFiringWorker = null;

        private delegate void LabelStringDelegate(Label theControl, string stringVal);
        private delegate void ProcessEventsDelegate();

        public Form1()
        {
            InitializeComponent();

            this.menuItemShow.Click += new System.EventHandler(this.menuItemShow_Click);
            this.menuItemDisconnect.Click += new System.EventHandler(this.menuItemDisconnect_Click);
            this.menuItemExit.Click += new System.EventHandler(this.menuItemExit_Click);
            this.Deactivate += new EventHandler(Form1_Deactivate);
        }

        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            InitializeBackgoundWorker();
            InitializeVpnApi();
        }

        // Set up the BackgroundWorker object by 
        // attaching event handlers. 
        private void InitializeBackgoundWorker()
        {
            scriptFiringWorker = new System.ComponentModel.BackgroundWorker();
            scriptFiringWorker.DoWork +=
                new DoWorkEventHandler(scriptFiringWorker_DoWork);
            scriptFiringWorker.RunWorkerCompleted +=
                new RunWorkerCompletedEventHandler(scriptFiringWorker_RunWorkerCompleted);
            scriptFiringWorker.ProgressChanged +=
                new ProgressChangedEventHandler(scriptFiringWorker_ProgressChanged);
        }

        private void InitializeVpnApi()
        {
            //API VPN API INIT
            try
            {
                vpnApi = new VpnApiClass();

                //Only the State Notification and Exit Notice Events 
                //are needed for the script buddy application, but the other 
                //Notifications are added to show how that would 
                //be done.
                //
                
            //wire up the Banner Notification event mechanism
                vpnApi.VpnBannerNotification
                    += new IVpnApiEvents_VpnBannerNotificationEventHandler(VpnBannerNotificationEventHandler);
            //wire up the Event Available event mechanism
                vpnApi.VpnEventAvailableNotification
                    += new IVpnApiEvents_VpnEventAvailableNotificationEventHandler(VpnEventAvailableNotificationEventHandler);
            //wire up the Exit Notification event mechanism
                vpnApi.VpnExitNotification
                    += new IVpnApiEvents_VpnExitNotificationEventHandler(VpnExitNotificationEventHandler);
            //wire up the Service Ready Notification event mechanism
                vpnApi.VpnServiceReadyNotification
                    += new IVpnApiEvents_VpnServiceReadyNotificationEventHandler(VpnServiceReadyNotificationEventHandler);
            //wire up the User Prompt Notification event mechanism
                vpnApi.VpnUserPromptNotification
                    += new IVpnApiEvents_VpnUserPromptNotificationEventHandler(VpnUserPromptNotificationEventHandler);
            //wire up the Web Launch Host Notification event mechanism
                vpnApi.VpnWebLaunchHostNotification
                    += new IVpnApiEvents_VpnWebLaunchHostNotificationEventHandler(VpnWebLaunchHostNotificationEventHandler);
            //wire up the WMHint Notification event mechanism
                vpnApi.VpnWMHintNotification
                    += new IVpnApiEvents_VpnWMHintNotificationEventHandler(VpnWMHintNotificationEventHandler);
            //wire up the Stats Notification event mechanism
                vpnApi.VpnStatsNotification
                    += new IVpnApiEvents_VpnStatsNotificationEventHandler(VpnStatsNotificationEventHandler);
            //wire up the State Notification event mechanism
                vpnApi.VpnStateNotification
                    += new IVpnApiEvents_VpnStateNotificationEventHandler(VpnStateNotificationEventHandler);
            //wire up the Notice Notification event mechanism
                vpnApi.VpnNoticeNotification
                    += new IVpnApiEvents_VpnNoticeNotificationEventHandler(VpnNoticeNotificationEventHandler);

            //Enable the consumer driven event model before the attach call.
               // vpnApi.EnableConsumerDrivenEventModel = true;
                
            //Start the AnyConnect VPN API by attaching to it.
                vpnApi.Attach(false  /*not SBL mode*/,
                              false, /*not primary gui*/
                              false, /*want to be a diminished API user*/
                              true); /*suppress auto-connect at launch*/


            }
            catch (Exception exception)
            {
                //add your logging/messagebox implementation here
                MessageBox.Show(exception.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        private void processEvents()
        {
            try
            {
                vpnApi.ProcessEvents();
            }
            catch (Exception exception)
            {
                //add your logging/messagebox implementation here
                MessageBox.Show(exception.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        //show the main window on double click
        private void ScriptBuddyNotifyIcon_MouseDoubleClick(object Sender, MouseEventArgs e)
        {
            menuItemShow_Click(Sender, e);
        }

        //Disconect the tunnel when tray notification menu item selected.
        private void menuItemDisconnect_Click(object Sender, EventArgs e)
        {
            try
            {
                vpnApi.DisconnectVpn();
            }
            catch (Exception exception)
            {
                //add your logging/messagebox implementation here
                MessageBox.Show(exception.Message, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }
        //show the form when tray notification menu item selected
        private void menuItemShow_Click(object Sender, EventArgs e)
        {
            this.Show();
            if (this.WindowState == FormWindowState.Minimized)
            {
                this.WindowState = FormWindowState.Normal;
            }
        }
        private void menuItemExit_Click(object Sender, EventArgs e)
        {
            Application.Exit();            
        }

        //hide the form when it is deactivated.
        private void Form1_Deactivate(object Sender, EventArgs e)
        {
            this.Hide();
        }
        
        //helper to show the AnyConnect log.
        private void linkAnyConnectLog_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            AnyConnectEventLogForm form = new AnyConnectEventLogForm();
            form.Show();
        }


        //for setting labels in the owning thread for the control.
        //
        void labelStringDelegateMethod(Label theControl, string stringVal)
        {
            theControl.Text = stringVal;
            theControl.Update();
        }

        private void scriptFiringWorker_DoWork(object Sender, DoWorkEventArgs e)
        {
            BackgroundWorker worker = Sender as BackgroundWorker;
            if (worker.CancellationPending)
            {
                e.Cancel = true;
            }
            else
            {
                //fire the script
                System.Diagnostics.Process process = new System.Diagnostics.Process();
                System.Diagnostics.ProcessStartInfo startInfo
                    = new System.Diagnostics.ProcessStartInfo((string)e.Argument);

                process.StartInfo = startInfo;

                try
                {
                    bool bReturn = process.Start();
                    if (bReturn)
                    {
                        process.WaitForExit();
                        e.Result = process.ExitCode;
                    }
                }
                catch (Win32Exception w32Exception)
                {
                    e.Cancel = true;
                    e.Result = w32Exception.ErrorCode;
                }
                catch
                {
                    e.Cancel = true;
                    e.Result = -1;
                }
            }
        }

        private void scriptFiringWorker_RunWorkerCompleted(object Sender, RunWorkerCompletedEventArgs e)
        {
            BackgroundWorker worker = Sender as BackgroundWorker;
            if ((int)e.Result != 0)
            {
                //disconnect the tunnel on error.
                //
                try
                {
                    vpnApi.DisconnectVpn();
                }
                catch
                {
                }
            }
        }

        private void scriptFiringWorker_ProgressChanged(object Sender, ProgressChangedEventArgs e)
        {
            BackgroundWorker worker = Sender as BackgroundWorker;
        }


////////////////////////////// VPN API COM CALLBACKS /////////////////////////////////
///// NOTE:  COM Callbacks may be called in a different thread than the UI Controls 
/////        You cannot directly access controls from a thread that did not         
/////        create the control.  You will get an InvalidOperationException         
/////        if you attempt to do so.  Test for this case and delegate as needed.                                               
//////////////////////////////////////////////////////////////////////////////////////
        //Process State callbacks
        private void VpnStateNotificationEventHandler(VPNState eState, VPNSubState eSubState, string stateString)
        {
            if (this.StateStringCtrl.InvokeRequired)
            {
                //process control on owning thread by using a delegate invoker
                object[] stringArray = new object[2];
                stringArray[0] = this.StateStringCtrl;
                stringArray[1] = stateString;
                this.StateStringCtrl.Invoke(new LabelStringDelegate(labelStringDelegateMethod),
                                            stringArray);
            }
            else
            {
                //call the delegate method directly
                labelStringDelegateMethod(this.StateStringCtrl, stateString);
            }

            if (previousVpnState != eState)
            {
                switch(eState)
                {
                case VPNState.CONNECTED:
                    {
                        //just fire this as the app may have been started after AnyConnect
                        //was already connected, but was just reconnecting.
                        //
                        if (previousVpnState != VPNState.RECONNECTING)
                        {
                            Fire_Connected();
                        }

                        //enable the menu item for Disconnect
                        this.menuItemDisconnect.Enabled = true;
                    }
                    break;
                case VPNState.DISCONNECTED:
                    {
                        if (previousVpnState == VPNState.DISCONNECTING)
                        {
                            Fire_Disconnected();
                        }

                        //enable the menu item for Disconnect
                        this.menuItemDisconnect.Enabled = false;
                    }
                    break;
                }
            }

            this.previousVpnState = eState;
        }

        private void Fire_Connected()
        {
            //Any connected scripts to fire?
            try
            {
                DirectoryInfo dir = new DirectoryInfo(".\\Scripts");
                foreach (FileInfo fileinfo in dir.GetFiles("OnConnect.*"))
                {
                    long size = fileinfo.Length;
                    if (size != 0)
                    {
                        //invoke the async worker
                        scriptFiringWorker.RunWorkerAsync(fileinfo.FullName);
                    }
                }
            }
            catch
            {
            }
        }

        private void Fire_Disconnected()
        {
            //Any connected scripts to fire?
            try
            {
                DirectoryInfo dir = new DirectoryInfo(".\\Scripts");
                foreach (FileInfo fileinfo in dir.GetFiles("OnDisconnect.*"))
                {
                    long size = fileinfo.Length;
                    if (size != 0)
                    {
                        //invoke the async worker
                        scriptFiringWorker.RunWorkerAsync(fileinfo.FullName);
                    }
                }
            }
            catch
            {
            }
        }

        //Exit notification.  An Exit notification MUST be obeyed.  The vpndownloader will terminate
        //any process that has the vpn components loaded in memory.  This includes the COM API dll.
        //
        private void VpnExitNotificationEventHandler(string strExitMessage, int exitCode)
        {
        }

        //Process Stats callbacks
        private void VpnStatsNotificationEventHandler(IVpnStats pVpnStats)
        {
            //this is just to show how you would consume stats and is not intended for ScriptBuddy.
            //
            IInterfaceCollection RouteInterface = pVpnStats.NonsecureRoutes;
            if (RouteInterface.Count > 0)
            {
                IRouteInfo RouteInfo = (IRouteInfo)RouteInterface[1];
                if (RouteInfo != null)
                {
                    string Network = RouteInfo.Network;
                }
            }
        }

        //Process Notice callbacks
        private void VpnNoticeNotificationEventHandler(string noticeString, MessageType eMessageType)
        {
            ///...
        }

        private void VpnBannerNotificationEventHandler(string strBannerMessage)
        {
            ///...
        }

        private void VpnEventAvailableNotificationEventHandler()
        {
            this.Invoke(new ProcessEventsDelegate(processEvents));
        }

        private void VpnServiceReadyNotificationEventHandler()
        {
        }

        private void VpnUserPromptNotificationEventHandler(IConnectPromptInfo pConnectPromptInfo)
        {
        }

        private void VpnWebLaunchHostNotificationEventHandler(string strActiveHost)
        {
        }

        private void VpnWMHintNotificationEventHandler(WMHint eHint, WMHintReason eReason)
        {
        }
   }
}