#*****************************************************************************
#  This sample is supplied as is with no implied warranty.  
#  It is designed to assist you in using the Cisco AnyConnect VPN API. 
#  It is assumed that you will build a production application and 
#  refer to this sample as a reference only.
#*****************************************************************************
CXX = g++
CPPFLAGS = -DHAVE_CONFIG_H -DPLATFORM_LINUX
CXXFLAGS = -g -O0 -Wall -std=c++17 -Wall -fstack-protector-all -fPIC -Wa,--noexecstack -Wno-ctor-dtor-privacy -fno-strict-aliasing
CXXFLAGS += -I. -I../../include -I/usr/include/libxml2
LIB_DIR = ../../lib/Linux/Intel_64
CURL_VER = 4
LIBS = -lvpnapi -lrt -lz -lvpncommoncrypt -lvpncommon -lpthread -lacciscocrypto -lacciscossl -lxml2 -lboost_regex -ldl `pkg-config --libs gio-2.0 libsystemd`
LDFLAGS = -pie -Wl,-z,relro,-z,now,-z,noexecstack
DYLIB_DIR = /opt/cisco/secureclient/lib

all: client client_so

client: CLIClientMain.o CLIClientImpl.o
	@echo -e "\nLinking using static libs..."
	${CXX} -L${LIB_DIR} -o client CLIClientMain.o CLIClientImpl.o \
	${LIBS} -laccurl \
	${LDFLAGS} -Wl,--disable-new-dtags,-rpath=${LIB_DIR}

client_so: CLIClientMain.o CLIClientImpl.o
	@echo -e "\nLinking using dynamic libs..."
	${CXX} -L${DYLIB_DIR} -o client_so CLIClientMain.o CLIClientImpl.o \
	 ${LIBS} ${DYLIB_DIR}/libaccurl.so.${CURL_VER} \
	${LDFLAGS} -Wl,--disable-new-dtags,-rpath=${DYLIB_DIR}


clean:
	rm -f *.o client client_so
