/*
 * Decompiled with CFR 0.152.
 */
package VPNJava;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Elf_Ehdr {
    private static final int EI_MAG0 = 0;
    private static final int EI_MAG1 = 1;
    private static final int EI_MAG2 = 2;
    private static final int EI_MAG3 = 3;
    private static final int EI_CLASS = 4;
    private static final int EI_DATA = 5;
    private static final int EI_VERSION = 6;
    private static final int EI_OSABI = 7;
    private static final int EI_ABIVERSION = 8;
    private static final int EI_PAD = 9;
    private static final int EI_NIDENT = 16;
    private static final byte ELFMAG0 = 127;
    private static final byte ELFMAG1 = 69;
    private static final byte ELFMAG2 = 76;
    private static final byte ELFMAG3 = 70;
    private static final int ELFCLASSNONE = 0;
    private static final int ELFCLASS32 = 1;
    private static final int ELFCLASS64 = 2;
    private static final int ELFCLASSNUM = 3;
    private static final int ELFDATANONE = 0;
    private static final int ELFDATA2LSB = 1;
    private static final int ELFDATA2MSB = 2;
    private static final int ELFDATANUM = 3;
    private static final int EM_NONE = 0;
    private static final int EM_M32 = 1;
    private static final int EM_SPARC = 2;
    private static final int EM_386 = 3;
    private static final int EM_68K = 4;
    private static final int EM_88K = 5;
    private static final int EM_486 = 6;
    private static final int EM_860 = 7;
    private static final int EM_MIPS = 8;
    private static final int EM_X86_64 = 62;
    public static final short SHN_XINDEX = -1;
    private Elf_Ehdr_struct elfStruct;

    public Elf_Ehdr(byte[] byArray) {
        int n;
        boolean bl = System.getProperty("os.arch").indexOf("64") != -1;
        int n2 = n = bl ? 64 : 52;
        if (n > byArray.length) {
            return;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.elfStruct = bl ? new Elf64_Ehdr_struct(byteBuffer) : new Elf32_Ehdr_struct(byteBuffer);
    }

    public boolean IsElfFile() {
        return this.elfStruct.IsElfFile();
    }

    public long GetElfBinaryLength() {
        return this.elfStruct.length();
    }

    public long get_e_shoff() {
        return this.elfStruct.e_shoff;
    }

    public short get_e_shnum() {
        return this.elfStruct.e_shnum;
    }

    public short get_e_shstrndx() {
        return this.elfStruct.s_shstrndx;
    }

    private class Elf64_Ehdr_struct
    extends Elf_Ehdr_struct {
        Elf64_Ehdr_struct(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.e_type = byteBuffer.getShort();
            this.e_machine = byteBuffer.getShort();
            this.e_version = byteBuffer.getInt();
            this.e_entry = byteBuffer.getLong();
            this.e_phoff = byteBuffer.getLong();
            this.e_shoff = byteBuffer.getLong();
            this.e_flags = byteBuffer.getInt();
            this.e_ehsize = byteBuffer.getShort();
            this.e_phentsize = byteBuffer.getShort();
            this.e_phnum = byteBuffer.getShort();
            this.e_shentsize = byteBuffer.getShort();
            this.e_shnum = byteBuffer.getShort();
            this.s_shstrndx = byteBuffer.getShort();
        }

        @Override
        public boolean IsElfFile() {
            return 127 == this.e_ident[0] && 69 == this.e_ident[1] && 76 == this.e_ident[2] && 70 == this.e_ident[3] && 2 == this.e_ident[4] && 1 == this.e_ident[5] && 62 == this.e_machine;
        }
    }

    private class Elf32_Ehdr_struct
    extends Elf_Ehdr_struct {
        Elf32_Ehdr_struct(ByteBuffer byteBuffer) {
            super(byteBuffer);
            this.e_type = byteBuffer.getShort();
            this.e_machine = byteBuffer.getShort();
            this.e_version = byteBuffer.getInt();
            this.e_entry = byteBuffer.getInt();
            this.e_phoff = byteBuffer.getInt();
            this.e_shoff = byteBuffer.getInt();
            this.e_flags = byteBuffer.getInt();
            this.e_ehsize = byteBuffer.getShort();
            this.e_phentsize = byteBuffer.getShort();
            this.e_phnum = byteBuffer.getShort();
            this.e_shentsize = byteBuffer.getShort();
            this.e_shnum = byteBuffer.getShort();
            this.s_shstrndx = byteBuffer.getShort();
        }

        @Override
        public boolean IsElfFile() {
            return 127 == this.e_ident[0] && 69 == this.e_ident[1] && 76 == this.e_ident[2] && 70 == this.e_ident[3] && 1 == this.e_ident[4] && 1 == this.e_ident[5] && 3 == this.e_machine;
        }
    }

    private abstract class Elf_Ehdr_struct {
        public byte[] e_ident = new byte[16];
        public short e_type;
        public short e_machine;
        public int e_version;
        public long e_entry;
        public long e_phoff;
        public long e_shoff;
        public int e_flags;
        public short e_ehsize;
        public short e_phentsize;
        public short e_phnum;
        public short e_shentsize;
        public short e_shnum;
        public short s_shstrndx;

        public long length() {
            return this.e_shoff + (long)(this.e_shnum * this.e_shentsize);
        }

        Elf_Ehdr_struct(ByteBuffer byteBuffer) {
            for (int i = 0; i < 16; ++i) {
                this.e_ident[i] = byteBuffer.get();
            }
        }

        public abstract boolean IsElfFile();
    }
}

