/*
 * Decompiled with CFR 0.152.
 */
package VPNJava;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Elf_Shdr {
    private Elf_Shdr_struct _shdr;
    private static boolean bIs64 = -1 != System.getProperty("os.arch").indexOf("64");

    public static int size() {
        if (bIs64) {
            return 64;
        }
        return 40;
    }

    int get_sh_name() {
        return this._shdr.sh_name;
    }

    int get_sh_type() {
        return this._shdr.sh_type;
    }

    long get_sh_flags() {
        return this._shdr.sh_flags;
    }

    long get_sh_addr() {
        return this._shdr.sh_addr;
    }

    long get_sh_offset() {
        return this._shdr.sh_offset;
    }

    long get_sh_size() {
        return this._shdr.sh_size;
    }

    int get_sh_link() {
        return this._shdr.sh_link;
    }

    int get_sh_info() {
        return this._shdr.sh_info;
    }

    long get_sh_addralign() {
        return this._shdr.sh_addralign;
    }

    long get_sh_entsize() {
        return this._shdr.sh_entsize;
    }

    public Elf_Shdr(byte[] byArray, int n) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, Elf_Shdr.size());
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this._shdr = bIs64 ? new Elf64_Shdr_struct(byteBuffer) : new Elf32_Shdr_struct(byteBuffer);
    }

    private class Elf64_Shdr_struct
    extends Elf_Shdr_struct {
        Elf64_Shdr_struct(ByteBuffer byteBuffer) {
            this.sh_name = byteBuffer.getInt();
            this.sh_type = byteBuffer.getInt();
            this.sh_flags = byteBuffer.getLong();
            this.sh_addr = byteBuffer.getLong();
            this.sh_offset = byteBuffer.getLong();
            this.sh_size = byteBuffer.getLong();
            this.sh_link = byteBuffer.getInt();
            this.sh_info = byteBuffer.getInt();
            this.sh_addralign = byteBuffer.getLong();
            this.sh_entsize = byteBuffer.getLong();
        }
    }

    private class Elf32_Shdr_struct
    extends Elf_Shdr_struct {
        Elf32_Shdr_struct(ByteBuffer byteBuffer) {
            this.sh_name = byteBuffer.getInt();
            this.sh_type = byteBuffer.getInt();
            this.sh_flags = byteBuffer.getInt();
            this.sh_addr = byteBuffer.getInt();
            this.sh_offset = byteBuffer.getInt();
            this.sh_size = byteBuffer.getInt();
            this.sh_link = byteBuffer.getInt();
            this.sh_info = byteBuffer.getInt();
            this.sh_addralign = byteBuffer.getInt();
            this.sh_entsize = byteBuffer.getInt();
        }
    }

    public abstract class Elf_Shdr_struct {
        int sh_name;
        int sh_type;
        long sh_flags;
        long sh_addr;
        long sh_offset;
        long sh_size;
        int sh_link;
        int sh_info;
        long sh_addralign;
        long sh_entsize;
    }
}

