/*
 * Decompiled with CFR 0.152.
 */
package VPNJava;

import VPNJava.BinaryFile;
import VPNJava.CodeSignException;
import VPNJava.CodeSignTlv;
import VPNJava.Elf_Ehdr;
import VPNJava.Elf_Shdr;
import VPNJava.ISignFile;
import VPNJava.LogInterface;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SignFile
implements ISignFile {
    private static final String m_strBashHeader_bash = "#!/bin/bash";
    private static final String m_strBashHeader_sh = "#!/bin/sh";
    private static final String m_strBashSizeVariable = "BASH_BASE_SIZE=";
    private static final String m_strBashSizeVariableDefault = "0x00000000";
    private static final String m_strTimestampVariable = "CISCO_AC_TIMESTAMP=";
    private static final String m_strTimestampVariableDefault = "0x0000000000000000";
    private byte[] m_bFileBuf = null;
    private byte[] m_bBinaryBuf = null;
    private CodeSignTlv m_csTlv = null;
    private LogInterface m_logger = null;

    public SignFile() {
    }

    public SignFile(LogInterface logInterface) {
        this.m_logger = logInterface;
    }

    public void toLog(String string) {
        if (this.m_logger != null) {
            this.m_logger.log(string);
        }
    }

    public void toDebugLog(String string) {
        if (this.m_logger != null) {
            this.m_logger.debuglog(string);
        }
    }

    @Override
    public void Open(String string) throws FileNotFoundException, CodeSignException {
        this.ClearPrivateData();
        try {
            this.toLog("Reading file " + string);
            this.m_bFileBuf = BinaryFile.Read(string);
            this.m_bBinaryBuf = this.GetBinary();
            this.m_csTlv = this.GetTlv();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (CodeSignException codeSignException) {
            throw codeSignException;
        }
    }

    @Override
    public byte[] GetBinary() throws CodeSignException {
        if (null != this.m_bBinaryBuf) {
            return this.m_bBinaryBuf;
        }
        if (this.IsBashFile()) {
            byte[] byArray = this.GetBashBinary();
            this.toLog("Got binary from bash file.  Length = " + byArray.length);
            return byArray;
        }
        if (new Elf_Ehdr(this.m_bFileBuf).IsElfFile()) {
            byte[] byArray = this.GetElfBinary();
            this.toLog("Got binary from ELF file.  Length = " + byArray.length);
            return byArray;
        }
        throw new CodeSignException("Only support signable bash or binary files");
    }

    @Override
    public CodeSignTlv GetTlv() throws NullPointerException, CodeSignException {
        if (null == this.m_bFileBuf || null == this.m_bBinaryBuf) {
            throw new NullPointerException("GetTlv - Signable file was not openned");
        }
        this.toLog("Reading CSTLV...");
        if (null != this.m_csTlv) {
            return this.m_csTlv;
        }
        if (this.m_bBinaryBuf.length == this.m_bFileBuf.length) {
            throw new CodeSignException("File has not been signed, there is no signature structure attached to the file");
        }
        CodeSignTlv codeSignTlv = new CodeSignTlv(this.m_logger);
        byte[] byArray = new byte[this.m_bFileBuf.length - this.m_bBinaryBuf.length];
        System.arraycopy(this.m_bFileBuf, this.m_bBinaryBuf.length, byArray, 0, byArray.length);
        codeSignTlv.SetCodeSignTlv(byArray);
        this.toLog("CSTLV length = " + byArray.length);
        return codeSignTlv;
    }

    public boolean SetTlv(byte[] byArray) throws IllegalArgumentException {
        if (null == byArray) {
            throw new IllegalArgumentException("byte[] parameter must not be null");
        }
        if (null == this.m_csTlv) {
            this.m_csTlv = new CodeSignTlv(this.m_logger);
        }
        this.m_csTlv.SetCodeSignTlv(byArray);
        return true;
    }

    @Override
    public boolean SetTlv(CodeSignTlv codeSignTlv) throws IllegalArgumentException {
        if (null == codeSignTlv) {
            throw new IllegalArgumentException("CodeSignTlv parameter must not be null");
        }
        this.m_csTlv = codeSignTlv;
        return true;
    }

    @Override
    public void Write(String string) throws Exception {
        byte[] byArray = this.m_csTlv.GetCodeSignTlv();
        if (null != byArray) {
            int n = byArray.length + this.m_bBinaryBuf.length;
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.m_bBinaryBuf, 0, byArray2, 0, this.m_bBinaryBuf.length);
            System.arraycopy(byArray, 0, byArray2, this.m_bBinaryBuf.length, byArray.length);
            BinaryFile.Write(string, byArray2);
        }
    }

    private void ClearPrivateData() {
        this.m_bFileBuf = null;
        this.m_bBinaryBuf = null;
        this.m_csTlv = null;
    }

    private boolean IsBashFile() throws NullPointerException {
        if (null == this.m_bFileBuf) {
            throw new NullPointerException("IsBashFile - Sign File must be open before checking type");
        }
        String string = new String(this.m_bFileBuf, 0, 20);
        return string.startsWith(m_strBashHeader_bash) || string.startsWith(m_strBashHeader_sh);
    }

    private boolean isElfFile() throws NullPointerException {
        if (null == this.m_bFileBuf) {
            throw new NullPointerException("isElfFile - Sign File must be open before checking type");
        }
        Elf_Ehdr elf_Ehdr = new Elf_Ehdr(this.m_bFileBuf);
        return elf_Ehdr.IsElfFile();
    }

    private byte[] GetBashBinary() throws CodeSignException {
        int n = this.GetBashBinaryLength();
        byte[] byArray = new byte[n];
        System.arraycopy(this.m_bFileBuf, 0, byArray, 0, n);
        return byArray;
    }

    private byte[] GetElfBinary() throws CodeSignException {
        long l = this.getElfBinaryLength();
        if (l <= 0L) {
            throw new CodeSignException("The length of the ELF file is zero");
        }
        int n = (int)l;
        if (n < 0) {
            throw new CodeSignException("The length of the ELF file is out of range");
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.m_bFileBuf, 0, byArray, 0, n);
        return byArray;
    }

    private int GetBashBinarySizeOffset() throws CodeSignException {
        if (null == this.m_bFileBuf) {
            throw new CodeSignException("SignFile has not been initialized.  Must call SignFile.open");
        }
        String string = new String(this.m_bFileBuf, 0, 1000);
        int n = string.indexOf(m_strBashSizeVariable);
        if (-1 == n) {
            throw new CodeSignException("Not a signable Bashe file");
        }
        this.toDebugLog("SignFile::GetBashBinarySizeOffset iOffsetBashSize = " + n);
        this.toDebugLog("SignFile::GetBashBinarySizeOffset m_strBashSizeVariable.length() = " + m_strBashSizeVariable.length());
        this.toDebugLog("SignFile::GetBashBinarySizeOffset iOffsetBashSize = " + (n += m_strBashSizeVariable.length()));
        return n;
    }

    private int GetTimestamp_BASHOffset() throws CodeSignException {
        if (null == this.m_bFileBuf) {
            throw new CodeSignException("SignFile has not been initialized.  Must call SignFile.open");
        }
        String string = new String(this.m_bFileBuf, 0, 1000);
        int n = string.indexOf(m_strTimestampVariable);
        if (-1 == n) {
            throw new CodeSignException("Not a signable Bash file");
        }
        this.toDebugLog("SignFile::GetTimestamp_BASHOffset iOffsetTimestamp = " + n);
        this.toDebugLog("SignFile::GetTimestamp_BASHOffset m_strTimestampVariable.length() = " + m_strTimestampVariable.length());
        this.toDebugLog("SignFile::GetTimestamp_BASHOffset iOffsetTimestamp = " + (n += m_strTimestampVariable.length()));
        return n;
    }

    private int GetBashBinaryLength() throws CodeSignException {
        int n = 0;
        n = this.GetBashBinarySizeOffset();
        String string = new String(this.m_bFileBuf, 0, 1000);
        String string2 = string.substring(n, n + m_strBashSizeVariableDefault.length());
        this.toDebugLog("SignFile::GetBashBinaryLength strBaseSize = " + string2);
        Integer n2 = Integer.decode(string2);
        int n3 = n2;
        this.toDebugLog("SignFile::GetBashBinaryLength iBaseSize = " + n3);
        if (0 == n3) {
            return this.m_bFileBuf.length;
        }
        return n3;
    }

    private void SetBashBinaryLength(int n) throws CodeSignException {
        String string = Integer.toHexString(n);
        String string2 = "0x";
        for (int i = 0; i < 8 - string.length(); ++i) {
            string2 = string2 + "0";
        }
        String string3 = string2 + string;
        byte[] byArray = string3.getBytes();
        int n2 = this.GetBashBinarySizeOffset();
        System.arraycopy(byArray, 0, this.m_bBinaryBuf, n2, byArray.length);
    }

    private long getElfBinaryLength() throws CodeSignException {
        Elf_Ehdr elf_Ehdr = new Elf_Ehdr(this.m_bFileBuf);
        if (!elf_Ehdr.IsElfFile()) {
            throw new CodeSignException("Unable to retrieve length of non-Elf file");
        }
        return elf_Ehdr.GetElfBinaryLength();
    }

    public void SetTimestamp(long l) throws CodeSignException, Exception {
        if (this.IsBashFile()) {
            this.SetTimestamp_BASH(l);
        } else {
            Elf_Ehdr elf_Ehdr = new Elf_Ehdr(this.m_bFileBuf);
            if (elf_Ehdr.IsElfFile()) {
                this.SetTimestamp_ELF(l);
            }
        }
    }

    public long GetTimestamp() throws CodeSignException {
        if (this.IsBashFile()) {
            return this.GetTimestamp_BASH();
        }
        Elf_Ehdr elf_Ehdr = new Elf_Ehdr(this.m_bFileBuf);
        if (elf_Ehdr.IsElfFile()) {
            return this.GetTimestamp_ELF();
        }
        return 0L;
    }

    private long GetTimestamp_ELF() throws CodeSignException {
        ElfFile_Timestamp elfFile_Timestamp = new ElfFile_Timestamp(this.m_bFileBuf);
        return elfFile_Timestamp.get();
    }

    private long GetTimestamp_BASH() throws CodeSignException {
        int n = this.GetTimestamp_BASHOffset();
        if (n == 0) {
            return 0L;
        }
        String string = new String(this.m_bFileBuf, 0, 1000);
        String string2 = string.substring(n + 2, n + 2 + m_strTimestampVariableDefault.length() - 2);
        this.toDebugLog("SignFile::GetTimestamp_BASH strTimestamp = " + string2);
        long l = 0L;
        try {
            l = Long.parseLong(string2, 16);
        }
        catch (Exception exception) {
            return 0L;
        }
        this.toDebugLog("SignFile::GetTimestamp_BASH timestamp = " + l);
        return l;
    }

    private void SetTimestamp_ELF(long l) throws CodeSignException {
        throw new CodeSignException("Not implemented");
    }

    private void SetTimestamp_BASH(long l) throws CodeSignException {
        String string = Long.toHexString(l);
        String string2 = "0x";
        for (int i = 0; i < 16 - string.length(); ++i) {
            string2 = string2 + "0";
        }
        String string3 = string2 + string;
        byte[] byArray = string3.getBytes();
        int n = this.GetTimestamp_BASHOffset();
        System.arraycopy(byArray, 0, this.m_bBinaryBuf, n, byArray.length);
    }

    final class ElfFile_Timestamp {
        private final byte[] TIMESTAMP_SECTION = new byte[]{95, 95, 116, 105, 109, 101, 115, 116, 97, 109, 112, 0};
        private byte[] _data;

        public byte[] getData() {
            return this._data;
        }

        public void setData(byte[] byArray) {
            this._data = byArray;
        }

        public ElfFile_Timestamp(byte[] byArray) {
            this.init();
            this.setData(byArray);
        }

        public long get() throws CodeSignException {
            int n = this.moveTo(this.TIMESTAMP_SECTION);
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.getData(), n, 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            long l = byteBuffer.getLong();
            return l;
        }

        public void set(long l) throws CodeSignException {
            int n = this.moveTo(this.TIMESTAMP_SECTION);
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.getData(), n, 8);
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.putLong(l);
        }

        private void init() {
            this.setData(null);
        }

        private int moveTo(byte[] byArray) throws CodeSignException {
            Elf_Shdr elf_Shdr;
            int n = -1;
            Elf_Ehdr elf_Ehdr = new Elf_Ehdr(this.getData());
            long l = elf_Ehdr.get_e_shoff();
            if (0L > l || 0 > (int)l) {
                throw new CodeSignException("iFirstSectionHeader out of range");
            }
            int n2 = (int)l;
            int n3 = elf_Ehdr.get_e_shnum();
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            boolean bl = false;
            int n7 = 0;
            long l2 = 0L;
            if (-1 == elf_Ehdr.get_e_shstrndx()) {
                elf_Shdr = new Elf_Shdr(this.getData(), n2);
                Elf_Shdr elf_Shdr2 = new Elf_Shdr(this.getData(), n2 + elf_Shdr.get_sh_link() * Elf_Shdr.size());
                l2 = elf_Shdr2.get_sh_offset();
            } else {
                elf_Shdr = new Elf_Shdr(this.getData(), n2 + elf_Ehdr.get_e_shstrndx() * Elf_Shdr.size());
                l2 = elf_Shdr.get_sh_offset();
            }
            if (0L > l2 || 0 > (int)l2) {
                throw new CodeSignException("iSectionNameTable out of range");
            }
            n4 = (int)l2;
            n7 = n2;
            while (!bl && n6 < n3) {
                elf_Shdr = new Elf_Shdr(this.getData(), n7);
                n5 = n4 + elf_Shdr.get_sh_name();
                if (this.EqualByteStrings(byArray, this.getData(), n5)) {
                    bl = true;
                    long l3 = elf_Shdr.get_sh_offset();
                    if (0L > l3 || 0 > (int)l3) {
                        throw new CodeSignException("sectionDataOffset out of range");
                    }
                    n = (int)l3;
                    continue;
                }
                ++n6;
                n7 += Elf_Shdr.size();
            }
            return n;
        }

        private boolean EqualByteStrings(byte[] byArray, byte[] byArray2, int n) {
            boolean bl = true;
            int n2 = 0;
            int n3 = 0;
            while (bl && byArray[n2] != 0 && byArray2[n + n3] != 0 && n2 < byArray.length && n + n3 < byArray2.length) {
                bl = byArray[n2] == byArray2[n + n3];
                if (!bl) continue;
                ++n2;
                ++n3;
            }
            return bl && n2 == byArray.length - 1 && n2 == n3 && n + n3 < byArray2.length;
        }
    }
}

