/*
 * Decompiled with CFR 0.152.
 */
package VPNJava;

import VPNJava.BinaryFile;
import VPNJava.CodeSignException;
import VPNJava.CodeSignTlv;
import VPNJava.LogInterface;
import VPNJava.SignFile;
import VPNJava.VerifyFileSignatureJNI;
import VPNJava.WhichOs;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.CertPathParameters;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;

public class VerifyFileSignatureJava {
    private String m_strCatalog = null;
    private static final String JNIVERIFY = "jniverify";
    private LogInterface m_logger = null;

    public VerifyFileSignatureJava(LogInterface logInterface) {
        this.m_logger = logInterface;
    }

    public VerifyFileSignatureJava() {
    }

    private void log(String string) {
        if (this.m_logger != null) {
            this.m_logger.log(string);
        }
    }

    private void debuglog(String string) {
        if (this.m_logger != null) {
            this.m_logger.debuglog(string);
        }
    }

    public void SetCatalog(String string) throws IllegalArgumentException, FileNotFoundException {
        if (null == string) {
            throw new IllegalArgumentException("Catalog Path must not be null");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new FileNotFoundException("Catalog files does not exist");
        }
        this.m_strCatalog = new String(string);
    }

    public boolean IsValid(String string, String string2, long l) throws IllegalArgumentException, FileNotFoundException, Exception {
        boolean bl = true;
        if (WhichOs.isOsWindows()) {
            bl = false;
        } else if (WhichOs.isOsLinux()) {
            bl = true;
        } else if (WhichOs.isOsMac()) {
            String string3 = new String(".sh");
            bl = string.endsWith(string3);
        } else {
            this.log("No signature checking on this OS");
            return false;
        }
        if (bl) {
            return this.IsValidProprietary(string, string2, l);
        }
        return this.IsValidJNI(string, string2, l);
    }

    public boolean IsValidJNI(String string, String string2, long l) {
        try {
            this.loadLib(JNIVERIFY);
        }
        catch (Exception exception) {
            this.log("loadLib Exception " + exception);
            return false;
        }
        VerifyFileSignatureJNI verifyFileSignatureJNI = new VerifyFileSignatureJNI();
        return verifyFileSignatureJNI.IsValid(string, string2, l);
    }

    public boolean IsValidProprietary(String string, String string2, long l) throws IllegalArgumentException, FileNotFoundException {
        try {
            if (null == string) {
                throw new IllegalArgumentException("Path variable must not be null");
            }
            boolean bl = false;
            CodeSignTlv codeSignTlv = null;
            if (null != this.m_strCatalog) {
                this.log("Extracting TLV from catalog");
                codeSignTlv = this.ExtractTlv_Catalog();
            } else {
                this.log("Extracting TLV from file " + string);
                codeSignTlv = this.ExtractTlv_File(string);
            }
            if (codeSignTlv == null) {
                this.log("File contains no TLV");
                return false;
            }
            if (!codeSignTlv.IsValid()) {
                this.log("Invalid signature structure attached to file");
                return false;
            }
            byte[] byArray = codeSignTlv.GetSignature(string);
            byte[] byArray2 = codeSignTlv.GetCert();
            if (byArray == null) {
                this.log("TLV contains no signature");
                return false;
            }
            this.log("TLV signature length " + byArray.length);
            if (byArray2 == null) {
                this.log("TLV contains no certificate");
                return false;
            }
            this.log("TLV certificate length " + byArray2.length);
            byte[] byArray3 = codeSignTlv.GetImCert();
            Certificate certificate = null;
            Certificate certificate2 = null;
            try {
                certificate2 = this.GenerateCertificate(byArray2);
                if (null != byArray3) {
                    certificate = this.GenerateCertificate(byArray3);
                }
            }
            catch (CertificateException certificateException) {
                this.log("GenerateCertificate threw CertificateException " + certificateException);
            }
            byte[] byArray4 = null;
            SignFile signFile = new SignFile();
            if (null == this.m_strCatalog) {
                this.log("Opening file: " + string);
                signFile.Open(string);
                byArray4 = signFile.GetBinary();
                this.log("File binary has length " + byArray4.length);
            } else {
                try {
                    byArray4 = BinaryFile.Read(string);
                }
                catch (Exception exception) {
                    this.log("Error " + exception.getMessage() + " reading " + string);
                    return false;
                }
            }
            try {
                Signature signature = Signature.getInstance("Sha1withRSA");
                signature.initVerify(certificate2.getPublicKey());
                signature.update(byArray4);
                bl = signature.verify(byArray);
                if (!bl) {
                    this.log(string + " failed code signature validation");
                    return bl;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.log("NoSuchAlgorithmException " + noSuchAlgorithmException);
                return false;
            }
            catch (InvalidKeyException invalidKeyException) {
                this.log("InvalidKeyException " + invalidKeyException);
                return false;
            }
            catch (SignatureException signatureException) {
                this.log("SignatureException " + signatureException);
                return false;
            }
            if (!this.CheckSigner(certificate2, string2)) {
                this.log("Validation failed because common name did not match");
                return false;
            }
            bl = this.ValidateCertificate(certificate2, certificate, string);
            if (!bl) {
                return false;
            }
            long l2 = 0L;
            if (null == this.m_strCatalog) {
                l2 = signFile.GetTimestamp();
                if (0L == l2) {
                    this.log("Error getting timestamp.");
                    return false;
                }
            } else {
                throw new CodeSignException("Getting timestamp from catalog file not implemented");
            }
            if (l2 < l) {
                this.log("Timestamp indicates this should not be loaded/launched (killdate)");
                return false;
            }
            Date date = new Date(l2 * 1000L);
            X509Certificate x509Certificate = (X509Certificate)certificate2;
            try {
                x509Certificate.checkValidity(date);
                bl = true;
            }
            catch (Exception exception) {
                this.log("CertPathValidatorException " + exception.getMessage());
                return false;
            }
            return bl;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log("IsValid FileNotFoundException " + fileNotFoundException);
            throw fileNotFoundException;
        }
        catch (CodeSignException codeSignException) {
            this.log("When validating signature a CodeSignException occurred " + codeSignException);
            return false;
        }
    }

    private CodeSignTlv ExtractTlv_Catalog() throws FileNotFoundException {
        CodeSignTlv codeSignTlv = new CodeSignTlv(this.m_logger);
        this.debuglog("Extract tlv from file: " + this.m_strCatalog);
        byte[] byArray = BinaryFile.Read(this.m_strCatalog);
        codeSignTlv.SetCodeSignTlv(byArray);
        return codeSignTlv;
    }

    private CodeSignTlv ExtractTlv_File(String string) throws FileNotFoundException, CodeSignException {
        CodeSignTlv codeSignTlv = null;
        try {
            SignFile signFile = new SignFile(this.m_logger);
            signFile.Open(string);
            codeSignTlv = signFile.GetTlv();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (CodeSignException codeSignException) {
            throw codeSignException;
        }
        return codeSignTlv;
    }

    private Certificate GenerateCertificate(byte[] byArray) throws IllegalArgumentException, CertificateException {
        if (null == byArray) {
            throw new IllegalArgumentException("Cert byte array must not be null");
        }
        Certificate certificate = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        certificate = certificateFactory.generateCertificate(byteArrayInputStream);
        return certificate;
    }

    private boolean CheckSigner(Certificate certificate, String string) {
        String string2;
        X509Certificate x509Certificate = (X509Certificate)certificate;
        Principal principal = x509Certificate.getSubjectDN();
        String string3 = principal.getName();
        this.debuglog("certificate SubjectDN name is:" + principal.getName());
        int n = string3.indexOf("CN=");
        if (n == -1) {
            this.debuglog("CN not found.");
            return false;
        }
        int n2 = -1;
        int n3 = string3.indexOf("\"", n += "CN=".length());
        if (n3 != -1) {
            n = n3 + "\"".length();
            n2 = string3.indexOf("\"", n);
        }
        if (n2 == -1 && (n2 = string3.indexOf(",", n)) == -1) {
            n2 = string3.length();
        }
        return 0 == string.compareTo(string2 = string3.substring(n, n2));
    }

    private boolean ValidateCertificate(Certificate certificate, Certificate certificate2, String string) throws IllegalArgumentException {
        if (null == certificate) {
            throw new IllegalArgumentException("Cert must not be null");
        }
        try {
            Object object;
            Object object2;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            arrayList.add(certificate);
            if (null != certificate2) {
                arrayList.add(certificate2);
            }
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            String string2 = System.getProperty("java.home") + File.separatorChar + "lib" + File.separatorChar + "security" + File.separatorChar + "cacerts";
            keyStore.load(new FileInputStream(string2), null);
            this.debuglog("cacerts path " + string2);
            Enumeration<String> enumeration = keyStore.aliases();
            HashSet<TrustAnchor> hashSet = new HashSet<TrustAnchor>();
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                if (!keyStore.isCertificateEntry((String)object2)) continue;
                object = new TrustAnchor((X509Certificate)keyStore.getCertificate((String)object2), null);
                hashSet.add((TrustAnchor)object);
            }
            object2 = certificateFactory.generateCertPath(arrayList);
            object = new PKIXParameters(hashSet);
            ((PKIXParameters)object).setRevocationEnabled(false);
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            try {
                PKIXCertPathValidatorResult pKIXCertPathValidatorResult = (PKIXCertPathValidatorResult)certPathValidator.validate((CertPath)object2, (CertPathParameters)object);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                String string3 = certPathValidatorException.getCause().getClass().getName();
                if (string3.indexOf("CertificateExpiredException") == -1) {
                    throw certPathValidatorException;
                }
            }
        }
        catch (CertPathValidatorException certPathValidatorException) {
            this.log("CertPathValidatorException " + certPathValidatorException);
            return false;
        }
        catch (Exception exception) {
            this.log("ValidateCertificate Exception " + exception);
            return false;
        }
        return true;
    }

    private void loadLib(String string) throws IOException {
        int n;
        String string2 = null;
        String string3 = null;
        if (WhichOs.isOsWindows()) {
            string = string + ".dll";
        } else if (WhichOs.isOsMac()) {
            string = string + ".so";
        } else {
            return;
        }
        string2 = "/VPNJava/" + string;
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddhhmmssS");
        string3 = simpleDateFormat.format(calendar.getTime());
        string3 = string3 + string;
        InputStream inputStream = this.getClass().getResourceAsStream(string2);
        File file = new File(System.getProperty("java.io.tmpdir") + File.separatorChar + string3);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) >= 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        inputStream.close();
        ((OutputStream)fileOutputStream).close();
        System.load(file.getAbsolutePath());
    }

    private Certificate getCertificateFromPKCS(byte[] byArray) {
        Certificate certificate = null;
        try {
            boolean bl = false;
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(new ByteArrayInputStream(byArray), null);
            Enumeration<String> enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string)) continue;
                if (bl) {
                    this.log("More than one key exists in the PKCS12 certificate");
                }
                certificate = keyStore.getCertificate(string);
            }
        }
        catch (Exception exception) {
            this.log("Failed in retreiving private key: " + exception.getMessage());
        }
        return certificate;
    }

    public static String MakeCatFilePath(String string) {
        String string2 = string;
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        string2 = string2 + ".ctl";
        return string2;
    }
}

