#!/bin/bash

version() { echo "$@" | awk -F. '{ printf("%d%03d%05d\n", $1,$2,$3); }'; }

dist=`grep DISTRIB_ID /etc/*-release | awk -F '=' '{print $2}'`

if [ -f /opt/acnvm/bin/acnvmcollector ]; then

    if /opt/acnvm/bin/acnvmcollector -v > /dev/null 2>&1; then

        installed_version=$(/opt/acnvm/bin/acnvmcollector -v | sed -n 's/.*version \([^ ]*\).*/\1/p')
        installing_version=$(./acnvmcollector -v | sed -n 's/.*version \([^ ]*\).*/\1/p')

        if [ $installed_version = "$installing_version" ]; then
                echo "Collector with same version already installed."
                exit 1
        else
                if [ $(version $installed_version) -ge $(version $installing_version) ]; then
                    echo "Collector with higher version already installed."
                    exit 1
                else
                    echo "Upgrading Collector from $installed_version to $installing_version"
                fi
        fi
    fi
fi


if [ "$dist" = "Ubuntu" ]; then
  sh ./install_ubuntu.sh
else
  sh ./install_centos.sh
fi