#!/bin/bash

if [ $(id -u) -ne 0 ]; then
    echo "You need super user privileges to run this script."
    exit 1
fi

echo "Uninstalling Cisco acnvmcollector"

echo "Stopping the AC NVM service..."
systemctl stop acnvm  >/dev/null 2>&1
/etc/init.d/acnvmcollectord stop  >/dev/null 2>&1

echo "Removing obsolete files..."
rm -f /usr/local/bin/acnvmcollector

echo "Removing app files"
ACNVM_PATH="/opt/acnvm"

rm -Rf $ACNVM_PATH/bin
rm -Rf $ACNVM_PATH/lib
rm -Rf $ACNVM_PATH/logs