'''
Created on March 11, 2016

@author: Akshay Ahluwalia

Copyright (c) 2016 by Cisco Systems, Inc.
All rights reserved.

Classes used for Login.
'''
from devpkg.utils.util import asciistr
from devpkg.base.command_executor import CommandExecutor
from devpkg.base.command_interaction import CommandInteraction
from devpkg.base import command_dispatch
from fmc.config_keeper import ConfigKeeper

class LoginExecutor(CommandExecutor):
    """
    Specialized Executor that performs the login information as well as storing Token Data and setting up the dispatcher
    """
    def __init__(self, dispatcher):
        """
        Sets up the Login executor
        @param dispathcer: an object of the CommandDispather class
        """
        from fmc.parsers import dispatch_executor
        CommandExecutor.__init__(self,dispatcher, CommandInteraction("Login"), None, dispatch_executor)
        self.command_holder.response_parser = save_login_information
        self.command_holder.response_parser_arg = {"command_executor": self}

    def postexecute(self):
        return self.command_holder.postexecute(self, "Cannot find device with ip " + self.dispatch.device_ip)

def save_login_information(response, command_executor):
    """
    Used to store the Token information.
    Also saves the domain_uuid
    @param response: the response from the request
    @param command_executor: Holds command and dispatcher information.
    """
    from fmc.parsers import parse_response_for_target_in_header
    command_executor.dispatch.auth_token = parse_response_for_target_in_header(response, 'x-auth-access-token')
    command_executor.dispatch.domain_uuid = parse_response_for_target_in_header(response, 'DOMAIN_UUID')
    command_dispatch.TokenObjectHelper.add_new_token(command_executor.dispatch)

def save_device_information(response, command_executor):
    """
    Saves the device information such as FTD ID.
    @param response: the response from the request
    @param command_executor: Holds command and dispatcher information.
    """
    from fmc.parsers import parse_response_for_target
    command_executor.dispatch.device_uuid = asciistr(parse_response_for_target(response, 'id'))#get the id
    command_executor.dispatch.device_name = asciistr(parse_response_for_target(response, "name"))
    command_executor.dispatch.ftd_mode = asciistr(parse_response_for_target(response, 'ftdMode'))
    if not command_executor.dispatch.device_uuid == "None":#if we found an id
        if command_executor.probe != None and not isinstance(command_executor.probe, list):
            ldev = command_executor.probe.ldev_id
            command_executor.probe.config_keeper.set(command_executor.dispatch.device_ip + ':' + ldev + ':' + 'device_uuid', command_executor.dispatch.device_uuid)
            command_executor.probe.config_keeper.set(command_executor.dispatch.device_ip + ':' + ldev + ':' + 'device_name', command_executor.dispatch.device_name)
            command_executor.probe.config_keeper.set('ftd_mode', command_executor.dispatch.ftd_mode)
        command_executor.command_holder.param_uuid = command_executor.dispatch.device_uuid    
