'''
Created on Jun 12, 2013

@author: dli

Copyright (c) 2013 by Cisco Systems
'''

from devpkg.base.dmobject import DMObject
from devpkg.utils.state_type import State


class SimpleType(DMObject):
    '''
    
    For simple configuration object, such as hostname, where the number of attribute is
    only one: hostname <name_str>.
    For format a input string to use in terms to follow protocol, such as:
        <inline_set>_uuid
    You can supply dm_gen_template in the initializer using the Python formatting string:
        '%(inline_set)s_uuid'
    Assuming you have "inline_set" defined.
    
    '''
    def __init__(self,
                 ifc_key = "",
                 dm_key = "",
                 dm_gen_template = None,
                 dm_key_command = None,
                 defaults = None,
                 is_removable = True,
                 response_parser = None,
                 command_executor = None,
                 dependent_on = None,
                 delete_executor = None,
                 probe = None,
                 **kwargs):
        '''
        @see DMObject.__init__
        @param dm_gen_template: str
            The template for generate formatted string. e.g. '%(inline_set)s_uuid'.
        @param dm_key_command: str
            The command for communicate to device to fetch configurations. e.g. 'getInlineSetByName'
        @param is_removable: boolean
            Specifies if the configuration is removable.
        @param response_parser: func
            Responser parser for the device communication response.
        '''
        DMObject.__init__(self, ifc_key, dm_key, probe=probe)
        self.kwargs = kwargs
        self.dm_gen_template = dm_gen_template
        self.dm_key_command = dm_key_command
        self.defaults = defaults
        self.is_removable = is_removable
        self.response_parser = response_parser
        self.command_executor = command_executor
        self.delete_executor = delete_executor
        self.dependent_on = dependent_on
        self.probe = probe
        

    def get_action(self):
        '''
        @return the State for this object
        '''
#         return self.delta_ifc_cfg_value['state']
    
        state = self.delta_ifc_cfg_value['state']
        if state == State.NOCHANGE and self.dependent_on is not None:
            state = self.get_state()
            
        if state == State.NOCHANGE or state == None:
            state = self.get_top_state_recursive()
        return state
        
    'ToDo: CSCvd20931 - Comment out the code block for now to improve the coder coverage. The code is not executed for current implementation.'
#     def set_action(self, state):
#         'Set the state for this object'
#         self.delta_ifc_cfg_value['state'] = state

    def ifc2dm(self, no_dm_cfg_stack, dm_cfg_list):
        '''Generate device configuration from IFC configuration delta.
        @see DMObject.ifc2dm for parameter details
        '''
        
        if not self.has_ifc_delta_cfg():
            return
        action = self.get_action()
        if action == State.NOCHANGE:
            return
        
        if action in (State.CREATE, State.MODIFY):
#             self.generate_cli(asa_cfg_list, self.get_cli())
            self.generate_command(dm_cfg_list, self.dm_gen_template, response_parser = self.response_parser, probe=self.probe, **self.kwargs)
        elif action == State.DESTROY and self.is_removable:
#             self.generate_cli(no_asa_cfg_stack, 'no ' + self.get_cli())
            self.generate_command(dm_cfg_list, self.dm_gen_template, response_parser = self.response_parser, probe=self.probe, **self.kwargs)
        #Otherwise action == State.NOCHANGE or action == State.DESTROY and !is_removable: do nothing.

    'ToDo: CSCvd20931 - Comment out the code block for now to improve the coder coverage. The code is not executed for current implementation.'
#     def __str__(self):
#         '''
#         @return: the user-readable string of this configuration object
#         '''
#         if not self.has_ifc_delta_cfg():
#             return ""
# 
#         state = self.delta_ifc_cfg_value['state']
# 
#         if (state == State.CREATE):
#             state = "Create"
#         elif (state == State.MODIFY):
#             state = "Modify"
#         elif (state == State.DESTROY):
#             state = "Destroy"
#         return "%s %s" % (state, self.get_cli())
