'''
Created on Apr 12, 2015

@author: Puneet Garg

Copyright (c) 2015 by Cisco Systems, Inc.
All rights reserved.

Classes used for Interfaces.
'''

from devpkg.base.dmlist import DMList
from devpkg.base.dmobject import DMObject
from devpkg.base.validators import Validator
from devpkg.utils.state_type import State

class InterfaceConfig(DMObject, Validator):
    '''
    Interface related configuration

    '''

    def __init__(self,
                 ifc_key = "",
                 dm_key = "",
                 dm_gen_template = None,
                 dm_key_command = None,
                 defaults = None,
                 is_removable = True,
                 response_parser = None,
                 probe = None):
        DMObject.__init__(self, ifc_key, dm_key, probe=probe)
        'Must be in the order in which to generate the command'
        self.probe = probe
        
    def ifc2dm(self, no_dm_cfg_stack, dm_cfg_list):
        'Populate current instance recursive state based on children and dependent objects.'
        self.recursive_state = self.get_state_recursive()
        
        
        local_dm_cfg_list = []
        
        # Process for commands if state modified.
        if self.get_state() != State.DESTROY:
            super(InterfaceConfig, self).ifc2dm(no_dm_cfg_stack, local_dm_cfg_list)

        # Add command for later execution.        
        if local_dm_cfg_list.__len__() > 0 and local_dm_cfg_list[0].params.__len__() > 0:    
            dm_cfg_list.extend(local_dm_cfg_list)

    #@property
    #def nameif(self):
    #    'The instance name is used for the interface nameif'
    #    return self.ifc_key

class InterfaceConfigs(DMList):
    'A list of Interfaces'

    def __init__(self, name = InterfaceConfig.__name__, child_class = InterfaceConfig, probe = None):
        super(InterfaceConfigs, self).__init__(name, child_class, probe=probe)
        self.probe = probe

    def ifc2dm(self, no_dm_cfg_stack,  dm_cfg_list):
        super(InterfaceConfigs, self).ifc2dm(no_dm_cfg_stack,  dm_cfg_list)
