'''
Created on Apr 12, 2015

@author: Puneet Garg

Copyright (c) 2015 by Cisco Systems, Inc.
All rights reserved.

Classes used for device request and response parser utilities.
'''
from devpkg.utils.util import asciistr
from fmc.parsers import is_dict_in_list, execute_request, generate_request_url, parse_response_for_target
from devpkg.base.command_interaction import CommandResult, CommandInteraction, CommandParam
import traceback
import devpkg.utils.env as env
import json
from devpkg.utils.errors import DeviceConfigError
from devpkg.utils.errors import FaultCode
from fmc.config_keeper import ConfigKeeper


'''
GET/POST Globals
'''
GET = "GET"
POST= "POST"
DELETE = "DELETE"
PUT = "PUT"


'''
Requests parameters JSONs.
'''


def get_json(command_executor):
    '''
    This function is called to generate FSMC API request JSON.

    @param command_executor: Holds command and dispatcher information.
    @return: JSON
    '''
    json_param = ""
    try:
        if command_executor.command_holder.does_id_exist():
            json_param = command_executor.command_holder.dataParam.param_uuid
        else:
            json_param = command_executor.command_holder.defaultData.param_uuid
        
        # Do removal first before addition
        if len(command_executor.command_holder.removable) > 0:
            orig_param = dict(json_param)
            for json_key, json_value in orig_param.iteritems():
                command_executor.command_holder.remove_value_from_dict(json_key, json_value, json_param)
                
        for paramKey, paramValue in command_executor.command_holder.params.iteritems():
            if paramValue.param_uuid == "<deviceUUID>":
                paramValue.param_uuid = command_executor.dispatch.device_uuid
            elif paramValue.param_uuid == "<deviceNAME>":
                paramValue.param_uuid = command_executor.dispatch.device_ip
            #We can cut a lot of the if statements that are here by just using our own known system
            
            if paramKey == command_executor.command_holder.command:
                continue
            if not paramValue.should_add_to_json():
                continue
            try:
                #for acrule only
                
                if paramKey == "sourceZones" or paramKey == "destinationZones":
                    for val in paramValue.param_uuid['objects']:
                        if not dict(json_param).has_key(paramKey):
                            json_param[paramKey] = {'objects': []}
                        val['id'] = asciistr(val['id'].toDict()['param_uuid'])
                        json_param[paramKey]['objects'].append(val)
                    continue
                if dict(json_param).has_key(paramValue.param_formatter) and isinstance(json_param[paramValue.param_formatter], list) and len(paramValue.param_uuid) > 0:
                    if paramKey == "inlinepairs":
                        specialArg = "first"
                    else:
                        specialArg = None
                    if isinstance(paramValue.param_uuid, list):
                        for stuff in paramValue.param_uuid:
                            if not is_dict_in_list(stuff, json_param[paramValue.param_formatter], specialArg):
                                json_param[paramValue.param_formatter].append(stuff) 
                    else: 
                        if not is_dict_in_list(paramValue.param_uuid, json_param[paramValue.param_formatter], specialArg):
                            json_param[paramValue.param_formatter].append(paramValue.param_uuid)
                    continue
                json_param[paramValue.param_formatter] = paramValue.param_uuid
            except:
                pass
                
        if 'metadata' in json_param:
            del json_param['metadata']
        if 'links' in json_param:
            del json_param['links']
        if 'rules' in json_param:
            del json_param['rules']
        if 'paging' in json_param:
            del json_param['paging']
        if 'ipv6' in json_param:
            del json_param['ipv6']
        if "commentHistoryList" in json_param:
            del json_param["commentHistoryList"]
        if "enableAntiSpoofing" in json_param:
            del json_param["enableAntiSpoofing"]
        if "fragmentReassembly" in json_param:
            del json_param["fragmentReassembly"]
        if "enableDNSLookup" in json_param:
            del json_param["enableDNSLookup"]
        
        # Below code fixes the json.dumps function call for subinterface and physical interface
        if dict(json_param).has_key('type') and json_param['type'] in ('SubInterface', 'PhysicalInterface', 'EtherChannelInterface'):
            if dict(json_param).has_key('securityZone') and json_param['securityZone'].has_key('id'):
                if isinstance(json_param['securityZone']['id'], CommandParam):
                    id_from_param = asciistr(json_param['securityZone']['id'].toDict()['param_uuid'])
                    if not id_from_param == '':
                        json_param['securityZone']['id'] = id_from_param
                    else:
                        json_param['securityZone']['id'] = command_executor.probe.config_keeper.get_id_from_securityzones(json_param['securityZone']['id'].param_value['name'])
                if len(json_param['securityZone']['id']) == 0:
                    cmd_dict = command_executor.command_holder.toDict()
                    if cmd_dict.has_key('removable') and cmd_dict['removable'].has_key('securityZone'):
                        json_param['securityZone']['id'] = command_executor.probe.config_keeper.get_id_from_securityzones(cmd_dict['removable']['securityZone'][0]['param_value']['name'])
            if json_param['type'] == 'EtherChannelInterface':  # in case of port-channel, need to remove these fields in the REST API
                if "loadBalancing" in json_param:
                    del json_param["loadBalancing"]
                if "maxActivePhysicalInterface" in json_param:
                    del json_param["maxActivePhysicalInterface"]
                if "minActivePhysicalInterface" in json_param:
                    del json_param["minActivePhysicalInterface"]
        json_dumps = json.dumps(json_param, cls=CommandInteraction.CommandInteractionEncoder)
        return json_dumps
    except Exception as e:
        env.debug("Unexpected exception: " + asciistr(e) + '\n' + traceback.format_exc() + '\n' + asciistr(json_param))
        raise DeviceConfigError([(command_executor.command_holder.model_key, FaultCode.CONFIGURATION_ERROR, "Unexpected exception: " + asciistr(e) + asciistr(json_param))])

'''
Requests executors.
'''

def physical_interface_enable_executor(command_executor):
    '''
    This function is called to enable a physical interface
    
    @param command_executor: Holds command and dispatcher information.
    @return: Success or Faults results.
    '''
    param_json = get_json(command_executor)
    url = generate_request_url(command_executor)
    param_dict = json.loads(param_json)

    param_dict['enabled'] = "true"
    # Since FMC6.4.0, MTU cannot be modified for interface without a nameif
    if param_dict.has_key("ifname") and param_dict.has_key("MTU"):
        param_dict['MTU'] = 1500
    param_json = json.dumps(param_dict)
    return execute_request(command_executor, url, param_json, None, PUT)[0]

def interface_executor(command_executor):
    '''
    This function is called to execute interface requests.

    @param command_executor: Holds command and dispatcher information.
    @return: Success or Faults results.
    '''
    param_json = get_json(command_executor)
    'ToDo: CSCvd20931 - Comment out the code block for now to improve code coverage, as the code is not executed in current implementations.'
    """
    if param_json is None:
        return [None]"""
    url = command_executor.dispatch.url + command_executor.command_holder.get_url(domainUUID=command_executor.dispatch.domain_uuid, deviceUUID=command_executor.dispatch.device_uuid)

    params = command_executor.command_holder.params
    is_virtual = command_executor.dispatch.is_device_virtual
    is_vlan_used = False if 'isVlanUsed' not in params else params['isVlanUsed'].param_value

    if is_virtual:
        param_dict = json.loads(param_json)
        # updating mtu, ipv4, and ipv6 when available in command_executor
        cmd_params = command_executor.command_holder.toDict()['params']
        if cmd_params.has_key('mtu') and cmd_params['mtu'].has_key('param_uuid'):
            param_dict['MTU'] = int(cmd_params['mtu']['param_uuid'])
        if cmd_params.has_key('ipv4') and cmd_params['ipv4'].has_key('param_uuid'):
            param_dict['ipv4'] = cmd_params['ipv4']['param_uuid']
        if cmd_params.has_key('ipv6') and cmd_params['ipv6'].has_key('param_uuid'):
            param_dict['ipv6'] = cmd_params['ipv6']['param_uuid']
        # Since FMC6.4.0, MTU cannot be modified for interface without a nameif
        if param_dict.has_key("ifname") and param_dict.has_key("MTU"):
            if param_dict['MTU'] < 64:
                param_dict['MTU'] = 1500
                param_json = json.dumps(param_dict)
        if is_vlan_used is False:
            # If it virtual FTD without vlan trunking support, then update physical interface
            response_errors = execute_request(command_executor, url, param_json, None, PUT)[0]
            return response_errors

    # Else, if physical FTD, or virtual FTD with vlan trunking supported
    logical_int_errors = create_sub_interface(command_executor, param_json, url)
    return logical_int_errors

def create_sub_interface(command_executor, param_json=None, url=None):
    '''
    This function is called to execute create logical interface requests.

    @param command_executor: Holds command and dispatcher information.
    @return: Success or Faults results.
    '''
    'ToDo: CSCvd20931 - Comment out the code block for now to improve code coverage, as the code is not executed in current implementations.'
    """if param_json is None:
        param_json = get_json(command_executor)
        
        if param_json is None:
            return [None]"""
    command_result =  CommandResult(
                    cli=command_executor.command_holder.command,
                    err_type='error',
                    err_msg=None,
                    model_key=command_executor.command_holder.model_key)
    command_result.lookup_key = None
    command_result.resource = command_executor.command_holder.idParam
    command_result.resource_key = 'param_uuid'
        
    param_dict = json.loads(param_json)
    
    # updating mtu, ipv4, and ipv6 when available in command_executor
    cmd_params = command_executor.command_holder.toDict()['params']
    if cmd_params.has_key('mtu') and cmd_params['mtu'].has_key('param_uuid'):
        param_dict['MTU'] = int(cmd_params['mtu']['param_uuid'])
    if cmd_params.has_key('ipv4') and cmd_params['ipv4'].has_key('param_uuid'):
        param_dict['ipv4'] = cmd_params['ipv4']['param_uuid']
    if cmd_params.has_key('ipv6') and cmd_params['ipv6'].has_key('param_uuid'):
        param_dict['ipv6'] = cmd_params['ipv6']['param_uuid']

    if param_dict.has_key("MTU"): #the MTU comes up as 0 sometimes and we cannot give a 0 to the fmc
        if param_dict['MTU'] < 64:
            param_dict['MTU'] = 1500
    param_json = json.dumps(param_dict)
    if not command_executor.command_holder.does_id_exist(): #something happened and we need to create the thing
        url = command_executor.dispatch.url + command_executor.command_holder.get_url(domainUUID=command_executor.dispatch.domain_uuid, deviceUUID=command_executor.dispatch.device_uuid, new=True)
        url = url[:-1]
        command_executor.command_holder.response_parser = parse_response_for_target
        command_executor.command_holder.response_parser_arg = {"target" : "id"}
        return execute_request(command_executor, url, param_json, command_result, POST)[0]
        
    else:
        return execute_request(command_executor, url, param_json, command_result, PUT)[0]

'ToDo: CSCvd20931 - Comment out the code block for now to improve code coverage, as the code is not executed in current implementations.'
"""
def interface_health_executor(command_executor):
    '''
    This function is called to execute device changes apply requests.

    @param command_executor: Holds command and dispatcher information.
    @return: Success or Faults results.
    '''
    'This is read only FSMC API calls. So no need to apply changes in FSMC.'
    command_executor.dispatch.is_apply_changes = False
    
    results = [None] * len(command_executor.command_holder.params)
    count = 0
    url = command_executor.dispatch.url + command_executor.command_holder.get_url(domainUUID=command_executor.dispatch.domain_uuid, deviceUUID=command_executor.dispatch.device_uuid)
    for paramValue in command_executor.command_holder.params.itervalues():
        response = execute_request(command_executor, url, paramValue.param_value, None)[1]
        success = CommandResult(cli="Health", err_type="success", err_msg=response.text, model_key=paramValue.param_value)
        results[count] = success
        count = count + 1
    return results
"""
