'''
Created on Apr 21, 2014

@author: jeffryp

Copyright (c) 2013 by Cisco Systems, Inc.
All rights reserved.
'''

from devpkg.utils.util import asciistr
from devpkg.base.dmlist import DMList
from devpkg.base.dmobject import DMObject
from ftd import FTD
from devpkg.utils.state_type import State, Type

class SharedConfigs(DMList):
    'Container for the group SharedConfig translator, one per graph'

    def __init__(self):
        DMList.__init__(self, SharedConfig.__name__, SharedConfig)
#         self.cli_prefixes = NGIPS().get_cli_prefixes()

    'ToDo: CSCvd20931 - Comment out the code block for now to improve the coder coverage since it is not executed in current implementation. vnsMGrpCfg is empty from current device_specification_ftd.xml'
#     def get_cli_prefixes(self):
#         return self.cli_prefixes
# 
#     def get_translator(self, cli):
#         if self.is_my_cli(cli):
#             for child in self.children.itervalues():
#                 if hasattr(self, 'get_translator'):
#                     result = child.get_translator(cli)
#                     if result:
#                         return result
# 
#     def is_my_cli(self, cli):
#         'filter out'
#         if isinstance(cli, basestring):
#             cli_prefix = cli.split()[0]
#         else:
#             cli_prefix = cli.command.split()[0]
#         return cli_prefix in self.cli_prefixes

class SharedConfig(DMObject):
    '''
    This is the group configuration of the device, assuming the name of "MGrpCfg"
    element in the device_specifcation is "GroupConfig".

    Add group configuration objects by calling self.register_child(dmobj) in
    the constructor as it is done in DeviceModel.__init(self)__.
    '''

    def __init__(self, instance):
        DMObject.__init__(self, asciistr(instance)) # Normalize instance to a string
        self.register_child(FTD())

    'ToDo: CSCvd20931 - Comment out the code block for now to improve the coder coverage since it is not executed in current implementation. vnsMGrpCfg is empty from current device_specification_ftd.xml'
#     def create_missing_ifc_delta_cfg(self):
#         'Override the default to take care of the way self.delta_ifc_key is created'
# 
#         if  not self.has_ifc_delta_cfg():
#             '@todo isolate changes to key creation'
#             self.delta_ifc_key = Type.GRP, SharedConfig.__name__, self.ifc_key,
#             self.delta_ifc_cfg_value = {'state': State.NOCHANGE, 'value': {}}
#             ancestor = self.get_ifc_delta_cfg_ancestor()
#             if ancestor:
#                 ancestor.delta_ifc_cfg_value['value'][self.delta_ifc_key] =  self.delta_ifc_cfg_value
# 
#         for child in self.children.values():
#             child.create_missing_ifc_delta_cfg()
