/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm;

import com.macrovision.flexlm.ConnectionData;
import com.macrovision.flexlm.ConnectionDataAdapter;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.hostid.AnyId;
import com.macrovision.flexlm.hostid.CompositeId;
import com.macrovision.flexlm.hostid.DemoId;
import com.macrovision.flexlm.hostid.DiskSerialId;
import com.macrovision.flexlm.hostid.DisplayId;
import com.macrovision.flexlm.hostid.DomainId;
import com.macrovision.flexlm.hostid.EthernetId;
import com.macrovision.flexlm.hostid.FlexId1;
import com.macrovision.flexlm.hostid.FlexId2;
import com.macrovision.flexlm.hostid.FlexId3;
import com.macrovision.flexlm.hostid.FlexId4;
import com.macrovision.flexlm.hostid.FlexId5;
import com.macrovision.flexlm.hostid.FlexId6;
import com.macrovision.flexlm.hostid.FlexlockId;
import com.macrovision.flexlm.hostid.HostIdList;
import com.macrovision.flexlm.hostid.HostnameId;
import com.macrovision.flexlm.hostid.Intel32Id;
import com.macrovision.flexlm.hostid.Intel64Id;
import com.macrovision.flexlm.hostid.Intel96Id;
import com.macrovision.flexlm.hostid.InternetId;
import com.macrovision.flexlm.hostid.LongId;
import com.macrovision.flexlm.hostid.SernumId;
import com.macrovision.flexlm.hostid.StringId;
import com.macrovision.flexlm.hostid.UserId;
import java.util.Vector;

public abstract class HostId
implements Comparable,
FlexlmConstants {
    private static boolean initializing;
    private int[] compositeTypes;
    protected ConnectionData connData;

    protected HostId() {
    }

    private static native String lGetNativeHostId(int var0, int[] var1, int var2);

    public abstract boolean isCurrentHost();

    public abstract HostId createNew(String var1) throws FlexlmException;

    protected boolean matches(HostId hostId) {
        return this.equals(hostId);
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public abstract int getType();

    public String toString() {
        String string = this.getKeyword();
        if (string != null) {
            return string + "=" + this.getValue();
        }
        return "" + this.getValue();
    }

    public abstract String getKeyword();

    public abstract HostId[] getCurrentHostIds();

    public abstract Object getValue();

    static void registerVendorHostId(HostId hostId, Vector vector) throws FlexlmException {
        if (hostId.getType() < 1000) {
            throw new FlexlmException(-504, 7001);
        }
        HostId.registerHostId(hostId, vector);
    }

    private static void registerHostId(HostId hostId, Vector vector) throws FlexlmException {
        String string = hostId.getKeyword();
        int n = hostId.getType();
        int n2 = 0;
        while (n2 < vector.size()) {
            HostId hostId2 = (HostId)vector.elementAt(n2);
            String string2 = hostId2.getKeyword();
            if (string2 != null && string != null && string2.equals(string)) {
                throw new FlexlmException(-504, 7002);
            }
            if (hostId2.getType() == n) {
                throw new FlexlmException(-504, 7009);
            }
            ++n2;
        }
        vector.add(hostId);
    }

    public boolean isThisHost(VendorInfo vendorInfo) {
        boolean bl = false;
        if (vendorInfo.getUseNativeHostIds()) {
            int n;
            int n2 = this.getType();
            int[] nArray = vendorInfo.getCompositeHostIdTypes();
            int n3 = n = nArray == null ? 0 : nArray.length;
            if (n2 < 0) {
                HostId[] hostIdArray = (HostId[])this.getValue();
                int n4 = 0;
                while (n4 < hostIdArray.length) {
                    String string = HostId.lGetNativeHostId(hostIdArray[n4].getType(), nArray, n);
                    if (string != null && string.length() > 0) {
                        HostId hostId = HostId.parseHostId(string, vendorInfo);
                        if (hostId.getType() < 0) {
                            HostId[] hostIdArray2 = (HostId[])hostId.getValue();
                            int n5 = 0;
                            while (n5 < hostIdArray2.length) {
                                if (hostIdArray[n4].matches(hostIdArray2[n5])) {
                                    bl = true;
                                    break;
                                }
                                ++n5;
                            }
                        } else if (hostIdArray[n4].matches(hostId)) {
                            bl = true;
                            break;
                        }
                    }
                    ++n4;
                }
            } else {
                String string = HostId.lGetNativeHostId(n2, nArray, n);
                if (string != null && string.length() > 0) {
                    HostId hostId = HostId.parseHostId(string, vendorInfo);
                    if (hostId.getType() < 0) {
                        HostId[] hostIdArray = (HostId[])hostId.getValue();
                        int n6 = 0;
                        while (n6 < hostIdArray.length) {
                            if (this.matches(hostIdArray[n6])) {
                                bl = true;
                                break;
                            }
                            ++n6;
                        }
                    } else {
                        bl = this.matches(hostId);
                    }
                }
            }
        } else {
            bl = this.isCurrentHost();
        }
        return bl;
    }

    static Vector initializeHostIdList() throws FlexlmException {
        Vector vector = new Vector();
        try {
            HostId.registerHostId(new AnyId(), vector);
            HostId.registerHostId(new CompositeId(), vector);
            HostId.registerHostId(new DemoId(), vector);
            HostId.registerHostId(new DiskSerialId(), vector);
            HostId.registerHostId(new DisplayId(), vector);
            HostId.registerHostId(new DomainId(), vector);
            HostId.registerHostId(new EthernetId(), vector);
            HostId.registerHostId(new FlexId1(), vector);
            HostId.registerHostId(new FlexId2(), vector);
            HostId.registerHostId(new FlexId3(), vector);
            HostId.registerHostId(new FlexId4(), vector);
            HostId.registerHostId(new FlexId5(), vector);
            HostId.registerHostId(new FlexId6(), vector);
            HostId.registerHostId(new FlexlockId(), vector);
            HostId.registerHostId(new HostnameId(), vector);
            HostId.registerHostId(new InternetId(), vector);
            HostId.registerHostId(new Intel32Id(), vector);
            HostId.registerHostId(new Intel64Id(), vector);
            HostId.registerHostId(new Intel96Id(), vector);
            HostId.registerHostId(new LongId(), vector);
            HostId.registerHostId(new SernumId(), vector);
            HostId.registerHostId(new StringId(), vector);
            HostId.registerHostId(new UserId(), vector);
        }
        catch (FlexlmException flexlmException) {
            throw new FlexlmException(-506, 7008);
        }
        return vector;
    }

    public static HostId parseHostId(String string, VendorInfo vendorInfo) {
        int n;
        if (string == null || string.length() == 0 || vendorInfo == null) {
            return null;
        }
        String string2 = string.trim();
        if (string2.startsWith("\"")) {
            try {
                string2 = string2.substring(1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new RuntimeException(indexOutOfBoundsException.getMessage());
            }
        }
        if (string2.endsWith("\"")) {
            try {
                string2 = string2.substring(0, string2.length() - 1);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new RuntimeException(indexOutOfBoundsException.getMessage());
            }
        }
        if (string2.length() == 0) {
            return null;
        }
        Vector vector = vendorInfo.getHostIdList();
        HostId hostId = null;
        try {
            n = string2.indexOf(" ");
            if (n > 0) {
                hostId = new HostIdList(string2, vendorInfo);
                return hostId;
            }
        }
        catch (FlexlmException flexlmException) {
            // empty catch block
        }
        n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            HostId hostId2 = (HostId)vector.elementAt(n2);
            try {
                hostId = hostId2.createNew(string2);
                break;
            }
            catch (FlexlmException flexlmException) {
                ++n2;
            }
        }
        return hostId;
    }

    public int getCryptCode() {
        return 19917114;
    }

    public static HostId[] getCurrentTypeHostIds(int n, VendorInfo vendorInfo, ConnectionData connectionData) {
        Vector vector = vendorInfo.getHostIdList();
        int[] nArray = vendorInfo.getCompositeHostIdTypes();
        int n2 = nArray == null ? 0 : nArray.length;
        int n3 = 0;
        while (n3 < vector.size()) {
            HostId hostId = (HostId)vector.elementAt(n3);
            hostId.setConnectionData(connectionData);
            if (hostId.getType() == n) {
                if (vendorInfo.getUseNativeHostIds()) {
                    String string = HostId.lGetNativeHostId(n, nArray, n2);
                    if (string != null && !string.equals("")) {
                        HostId hostId2 = HostId.parseHostId(string, vendorInfo);
                        if (hostId2 instanceof HostIdList) {
                            return (HostId[])hostId2.getValue();
                        }
                        HostId[] hostIdArray = new HostId[]{hostId2};
                        return hostIdArray;
                    }
                } else {
                    return hostId.getCurrentHostIds();
                }
            }
            ++n3;
        }
        return null;
    }

    public void setConnectionData(ConnectionData connectionData) {
        this.connData = connectionData;
    }

    public ConnectionData getConnectionData() {
        return this.connData;
    }

    protected ConnectionData currentConnectionData() {
        return this.connData == null ? new ConnectionDataAdapter() : this.connData;
    }

    protected boolean isHex(String string) {
        boolean bl = true;
        long l = 0L;
        try {
            l = Long.parseLong(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    protected int compareValueTo(Object object) {
        Object object2 = this.getValue();
        if (object2 == null) {
            if (object == null) {
                return 0;
            }
            return -1;
        }
        return object2.toString().compareTo(object.toString());
    }

    public int compareTo(Object object) {
        int n;
        if (object == null) {
            return 1;
        }
        if (!(object instanceof HostId)) {
            return 1;
        }
        HostId hostId = (HostId)object;
        int n2 = this.getType();
        if (n2 != (n = hostId.getType())) {
            return n2 - n;
        }
        return this.compareValueTo(hostId.getValue());
    }
}

