/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.comm;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.comm.CommRev;

public class MessageHeader
implements FlexlmConstants {
    private static final int headerLength = 20;
    private byte[] rawHeader;
    private int messageType;
    private int messageLength;
    private int messageId;
    private int sessionId;
    private int reserved;

    protected MessageHeader(byte[] byArray) throws FlexlmException {
        if (byArray.length != 20) {
            throw new FlexlmException(-506, 1017);
        }
        this.rawHeader = byArray;
        CommRev commRev = CommRev.getCommRevInstance(byArray);
        if (!commRev.checkHeaderChecksum(byArray)) {
            throw new FlexlmException(-12, 1019);
        }
        this.messageType = commRev.getMessageType(byArray);
        this.messageLength = commRev.getMessageLength(byArray, this.messageType);
    }

    protected static int getHeaderLength() {
        return 20;
    }

    protected int getMessageLength() {
        return this.messageLength;
    }

    protected int getType() {
        return this.messageType;
    }

    protected byte[] getRawHeader() {
        return this.rawHeader;
    }
}

