/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm;

import com.macrovision.flexlm.Feature;
import com.macrovision.flexlm.FlexlmConstants;
import java.util.Vector;

public class FeatureUsage
implements FlexlmConstants {
    private String featureName;
    private String featureId;
    private Vector associatedFeatures;
    private int revision;
    private int timeout;
    private int linger;
    private int dupMask;
    private int nReserved;
    private int totalInUse;
    private int floatInUse;
    private int userCount;
    private int numberLicenses;
    private int queuedCount;
    private int overdraft;

    public FeatureUsage(String string, String string2) {
        this.featureName = string;
        this.featureId = string2;
    }

    public FeatureUsage(String string, String string2, Feature feature, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11) {
        this.featureName = string;
        this.featureId = string2;
        this.associatedFeatures = new Vector();
        this.associatedFeatures.add(feature);
        this.revision = n;
        this.timeout = n2;
        this.linger = n3;
        this.dupMask = n4;
        this.nReserved = n5;
        this.totalInUse = n6;
        this.floatInUse = n7;
        this.userCount = n8;
        this.numberLicenses = n9;
        this.queuedCount = n10;
        this.overdraft = n11;
    }

    public void addUsage(FeatureUsage featureUsage, Feature feature) {
        if (featureUsage != null) {
            this.nReserved += featureUsage.getReservedCount();
            this.totalInUse += featureUsage.getCountInUse();
            this.numberLicenses += featureUsage.getCount();
            this.floatInUse += featureUsage.getNonReservedCountInUse();
            this.queuedCount += featureUsage.getQueuedCount();
            this.overdraft += featureUsage.getOverdraftCount();
            this.userCount += featureUsage.getNCheckouts();
            if (this.associatedFeatures == null) {
                this.associatedFeatures = new Vector();
            }
            this.associatedFeatures.add(feature);
        }
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public Feature[] getFeatures() {
        return this.associatedFeatures == null ? null : this.associatedFeatures.toArray(new Feature[this.associatedFeatures.size()]);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getLinger() {
        return this.linger;
    }

    public int getDupMask() {
        return this.dupMask;
    }

    public int getReservedCount() {
        return this.nReserved;
    }

    public int getCount() {
        return this.numberLicenses;
    }

    public int getCountInUse() {
        return this.totalInUse;
    }

    public int getNCheckouts() {
        return this.userCount;
    }

    public int getNonReservedCountInUse() {
        return this.floatInUse;
    }

    public int getQueuedCount() {
        return this.queuedCount;
    }

    public int getOverdraftCount() {
        return this.overdraft;
    }
}

