/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.hostid;

import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.hostid.SimpleHostId;

public abstract class IntelHostId
extends SimpleHostId {
    int[] intelHostid;

    public IntelHostId(String string) throws FlexlmException {
        super(string);
    }

    protected void initHostId(String string) throws FlexlmException {
        this.initHostIdValue(string);
    }

    protected void initHostIdValue(String string) throws FlexlmException {
        int n = this.getGroupCount();
        this.intelHostid = new int[n / 2];
        if (string.length() != n * 5 - 1) {
            throw new FlexlmException(-503, 2021);
        }
        int[] nArray = new int[n];
        String string2 = string;
        int n2 = 0;
        while (n2 < n) {
            String string3;
            if (n2 < n - 1) {
                if (string2.charAt(4) != '-') {
                    throw new FlexlmException(-503, 2022);
                }
                string3 = string2.substring(0, 4);
                string2 = string2.substring(5);
            } else {
                string3 = string2;
            }
            nArray[n2] = this.parseHexPiece(string3);
            if (nArray[n2] < 0 || nArray[n2] >= 65536) {
                throw new FlexlmException(-503, 2024);
            }
            ++n2;
        }
        int n3 = n / 2;
        int n4 = 0;
        while (n4 < n3) {
            this.intelHostid[n3 - n4 - 1] = nArray[2 * n4] << 16 | nArray[2 * n4 + 1];
            ++n4;
        }
    }

    protected int parseHexPiece(String string) throws FlexlmException {
        try {
            return Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            throw new FlexlmException(-503, 2023);
        }
    }

    protected abstract int getGroupCount();

    public String getKeyword() {
        return null;
    }

    public int getCryptCode() {
        return 0;
    }

    public Object getValue() {
        return this.intelHostid;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.intelHostid.length - 1;
        while (n >= 0) {
            int n2 = this.intelHostid[n] >> 16 & 0xFFFF;
            int n3 = this.intelHostid[n] & 0xFFFF;
            if (n2 < 16) {
                stringBuffer.append("000");
            } else if (n2 < 256) {
                stringBuffer.append("00");
            } else if (n2 < 4096) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toString(n2, 16));
            stringBuffer.append("-");
            if (n3 < 16) {
                stringBuffer.append("000");
            } else if (n3 < 256) {
                stringBuffer.append("00");
            } else if (n3 < 4096) {
                stringBuffer.append("0");
            }
            stringBuffer.append(Integer.toString(n3, 16));
            if (n > 0) {
                stringBuffer.append("-");
            }
            --n;
        }
        return stringBuffer.toString();
    }

    protected int compareValueTo(Object object) {
        int[] nArray = (int[])object;
        int n = this.intelHostid.length - nArray.length;
        if (n != 0) {
            return n;
        }
        int n2 = 0;
        while (n2 < this.intelHostid.length) {
            long l = (long)this.intelHostid[n2] & 0xFFFFFFFFL;
            long l2 = (long)nArray[n2] & 0xFFFFFFFFL;
            long l3 = l - l2;
            if (l3 < 0L) {
                return -1;
            }
            if (l3 > 0L) {
                return 1;
            }
            ++n2;
        }
        return 0;
    }
}

