/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.misc;

import java.math.BigInteger;
import java.security.PublicKey;

public class FlexlmPublicKey
implements PublicKey {
    protected byte[] rawKey;

    public FlexlmPublicKey(String string, String string2) {
        BigInteger bigInteger = new BigInteger(string2, 16);
        this.rawKey = bigInteger.toByteArray();
        this.L_G(this.rawKey, string);
    }

    protected void L_G(byte[] byArray, String string) {
        byte[] byArray2 = string.getBytes();
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (n2 % 2 == 0) {
                int n3 = n2;
                byArray[n3] = (byte)(byArray[n3] - byArray2[n]);
            } else if (n2 % 3 == 0) {
                int n4 = n2;
                byArray[n4] = (byte)(byArray[n4] ^ byArray2[n]);
            } else {
                int n5 = n2;
                byArray[n5] = (byte)(byArray[n5] + byArray2[n]);
            }
            if (++n >= byArray2.length) {
                n = 0;
            }
            ++n2;
        }
    }

    public String getAlgorithm() {
        return "ECDSA";
    }

    public byte[] getEncoded() {
        return this.rawKey;
    }

    public String getFormat() {
        return "RAW";
    }
}

