/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.comm;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.comm.CheckinMessage;
import com.macrovision.flexlm.comm.CheckoutMessage;
import com.macrovision.flexlm.comm.CommRev;
import com.macrovision.flexlm.comm.FeatBundleMessage;
import com.macrovision.flexlm.comm.FeatureAvailableMessage;
import com.macrovision.flexlm.comm.ForceCheckinMessage;
import com.macrovision.flexlm.comm.GenericDaemonInfoMessage;
import com.macrovision.flexlm.comm.HandshakeMessage;
import com.macrovision.flexlm.comm.HeartbeatMessage;
import com.macrovision.flexlm.comm.HeartbeatResponseMessage;
import com.macrovision.flexlm.comm.HelloMessage;
import com.macrovision.flexlm.comm.HostIdMessage;
import com.macrovision.flexlm.comm.LicenseFileDataMessage;
import com.macrovision.flexlm.comm.MessageHeader;
import com.macrovision.flexlm.comm.NUsersMessage;
import com.macrovision.flexlm.comm.NeedHostIdMessage;
import com.macrovision.flexlm.comm.NewReportlogMessage;
import com.macrovision.flexlm.comm.NoSuchFeatureMessage;
import com.macrovision.flexlm.comm.NoUserMessage;
import com.macrovision.flexlm.comm.NotAdminMessage;
import com.macrovision.flexlm.comm.OKMessage;
import com.macrovision.flexlm.comm.QueuedMessage;
import com.macrovision.flexlm.comm.RereadMessage;
import com.macrovision.flexlm.comm.SendLicenseFileDataMessage;
import com.macrovision.flexlm.comm.ShutdownMessage;
import com.macrovision.flexlm.comm.SwitchDebuglogMessage;
import com.macrovision.flexlm.comm.SwitchReportlogMessage;
import com.macrovision.flexlm.comm.TooSoonMessage;
import com.macrovision.flexlm.comm.TryAnotherMessage;
import com.macrovision.flexlm.comm.UserlistMessage;
import com.macrovision.flexlm.comm.Username2Message;
import com.macrovision.flexlm.comm.UsernameMessage;
import com.macrovision.flexlm.comm.VDInfoMessage;
import com.macrovision.flexlm.comm.WhatMessage;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.util.StringTokenizer;

public class CommRev3
extends CommRev
implements FlexlmConstants,
FlexlmInternalConstants {
    private static final int CHUNKSIZE = 147;
    protected static final int COMMAND = 0;
    private static final int CHECKSUM = 1;
    private static final int DATA = 2;
    private static final byte HANDSHAKE = 97;
    private static final byte HEARTBEAT = 103;
    private static final byte HELLO = 104;
    private static final byte CHECKIN = 105;
    private static final byte LIST = 108;
    private static final byte CHECKOUT = 111;
    private static final byte SHUTDOWN = 113;
    private static final byte FORCE_CHECKIN = 117;
    private static final byte SWITCH = 119;
    private static final byte FORCE_CHECKIN_H = 35;
    private static final byte DAEMON_INFO = 61;
    private static final byte SENDHOSTID = 126;
    private static final byte REREAD = 38;
    private static final byte SWITCH_REPORT = 94;
    private static final byte NEWREPLOG = 123;
    private static final byte SENDLFDATA = 36;
    private static final byte TRY_ANOTHER = 65;
    private static final byte BUSY = 66;
    private static final byte BUSY_NEW = 68;
    private static final byte FEATURE_AVAILABLE = 70;
    private static final byte HEARTBEAT_RESPONSE = 71;
    private static final byte NOT_ADMIN = 72;
    private static final byte TOO_SOON = 73;
    private static final byte NO_USER = 74;
    private static final byte OK = 79;
    private static final byte LICENSE_FILE_DATA = 76;
    private static final byte FEAT_BUNDLE = 77;
    private static final byte NUSERS = 78;
    private static final byte GENERIC_DAEMON_INFO = 80;
    private static final byte QUEUED = 81;
    private static final byte NEED_HOSTID = 84;
    private static final byte USERNAME = 85;
    private static final byte WHAT = 87;
    private static final byte USERNAME2 = 88;
    private static final byte NOSUCHFEATURE = 63;
    public static final int MAX_CHECKOUTDATA_LENGTH = 32;
    public static final int MAX_USERNAME_LENGTH = 20;
    public static final int MAX_SERVERNAME_LENGTH = 32;
    public static final int MAX_DISPLAYNAME_LENGTH = 32;
    public static final int MAX_HOSTNAME_LENGTH = 64;
    private static CommRev3 instance;
    private static final int CI_FEATURE = 2;
    private static final int CI_FEATURE_LENGTH = 30;
    private static final int CI_CODE = 33;
    private static final int CI_CODE_LENGTH = 20;
    private static final int CI_USE_VENDORDEF = 54;
    private static final int CI_USE_VENDORDEF_LENGTH = 1;
    private static final int CI_VENDORDEF = 55;
    private static final int CI_VENDORDEF_LENGTH = 32;
    private static final int CO_NLICENSES = 2;
    private static final int CO_NLICENSES_LENGTH = 4;
    private static final int CO_WAIT = 7;
    private static final int CO_WAIT_LENGTH = 1;
    private static final int CO_FEATURE = 8;
    private static final int CO_FEATURE_LENGTH = 30;
    private static final int CO_VERSION = 39;
    private static final int CO_VERSION_LENGTH = 10;
    private static final int CO_DUPGROUP = 50;
    private static final int CO_DUPGROUP_LENGTH = 10;
    private static final int CO_LINGER = 61;
    private static final int CO_LINGER_LENGTH = 10;
    private static final int CO_CODE = 72;
    private static final int CO_CODE_LENGTH = 20;
    private static final int CO_VENDORDEF = 93;
    private static final int CO_VENDORDEF_LENGTH = 32;
    private static final int CO_HOSTID = 126;
    private static final int CO_HOSTID_LENGTH = 12;
    private static final int CO_SERNUM = 139;
    private static final int CO_SERNUM_LENGTH = 2;
    private static final int CO_FLAGS = 141;
    private static final int CO_FLAGS_LENGTH = 2;
    private static final int CO_ULTIMATEDENIAL = 143;
    private static final int CO_ULTIMATEDENIAL_LENGTH = 1;
    private static final int FB_REV = 2;
    private static final int FB_REV_LENGTH = 10;
    private static final int FB_TIMEOUT = 13;
    private static final int FB_TIMEOUT_LENGTH = 10;
    private static final int FB_LINGER = 24;
    private static final int FB_LINGER_LENGTH = 10;
    private static final int FB_DUP_SELECT = 35;
    private static final int FB_DUP_SELECT_LENGTH = 10;
    private static final int FB_RES = 46;
    private static final int FB_RES_LENGTH = 10;
    private static final int FB_TOTAL_IN_USE = 57;
    private static final int FB_TOTAL_IN_USE_LENGTH = 10;
    private static final int FB_FLOAT_IN_USE = 68;
    private static final int FB_FLOAT_IN_USE_LENGTH = 10;
    private static final int FB_USER_COUNT = 79;
    private static final int FB_USER_COUNT_LENGTH = 10;
    private static final int FB_NUM_LICENSES = 90;
    private static final int FB_NUM_LICENSES_LENGTH = 10;
    private static final int FB_QUEUED_COUNT = 101;
    private static final int FB_QUEUED_COUNT_LENGTH = 10;
    private static final int FB_OVERDRAFT = 112;
    private static final int FB_OVERDRAFT_LENGTH = 10;
    private static final int FB_BORROWED = 123;
    private static final int FB_BORROWED_LENGTH = 10;
    private static final int FA_FEATURE = 2;
    private static final int FA_FEATURE_LENGTH = 31;
    private static final int FA_QUEUED_PACKAGE = 33;
    private static final int FA_QUEUED_PACKAGE_LENGTH = 1;
    private static final int FC_FEATURE = 2;
    private static final int FC_FEATURE_LENGTH = 30;
    private static final int FC_USER = 33;
    private static final int FC_USER_LENGTH = 20;
    private static final int FC_HOST = 54;
    private static final int FC_HOST_LENGTH = 32;
    private static final int FC_DISP = 87;
    private static final int FC_DISP_LENGTH = 32;
    private static final int FC_CODE = 120;
    private static final int FC_CODE_LENGTH = 1;
    private static final int FC_FORCE = 121;
    private static final int FC_FORCE_LENGTH = 20;
    private static final int FC_SERVER = 33;
    private static final int FC_SERVER_LENGTH = 32;
    private static final int FC_PORT = 66;
    private static final int FC_PORT_LENGTH = 10;
    private static final int FC_HANDLE = 77;
    private static final int FC_HANDLE_LENGTH = 10;
    private static final int GD_USER_INIT1 = 2;
    private static final int GD_USER_INIT1_LENGTH = 1;
    private static final int GD_USER_INIT2 = 3;
    private static final int GD_USER_INIT2_LENGTH = 1;
    private static final int GD_OUTFILTER = 4;
    private static final int GD_OUTFILTER_LENGTH = 1;
    private static final int GD_INFILTER = 5;
    private static final int GD_INFILTER_LENGTH = 1;
    private static final int GD_CALLBACK = 6;
    private static final int GD_CALLBACK_LENGTH = 1;
    private static final int GD_VENDOR_MSG = 7;
    private static final int GD_VENDOR_MSG_LENGTH = 1;
    private static final int GD_VENDOR_CHALLENGE = 8;
    private static final int GD_VENDOR_CHALLENGE_LENGTH = 1;
    private static final int GD_LOCKFILE = 9;
    private static final int GD_LOCKFILE_LENGTH = 1;
    private static final int GD_READ_WAIT = 10;
    private static final int GD_READ_WAIT_LENGTH = 11;
    private static final int GD_DUMP_SEND_DATA = 21;
    private static final int GD_DUMP_SEND_DATA_LENGTH = 1;
    private static final int GD_NORMAL_HOSTID = 22;
    private static final int GD_NORMAL_HOSTID_LENGTH = 1;
    private static final int GD_CONN_TIMEOUT = 23;
    private static final int GD_CONN_TIMEOUT_LENGTH = 11;
    private static final int GD_ENFORCE_STARTDATE = 34;
    private static final int GD_ENFORCE_STARTDATE_LENGTH = 1;
    private static final int GD_TELL_STARTDATE = 35;
    private static final int GD_TELL_STARTDATE_LENGTH = 1;
    private static final int GD_MIN_USER_TIMEOUT = 36;
    private static final int GD_MIN_USER_TIMEOUT_LENGTH = 11;
    private static final int GD_MIN_LMREMOVE = 47;
    private static final int GD_MIN_LMREMOVE_LENGTH = 11;
    private static final int GD_USE_FEATSET = 58;
    private static final int GD_USE_FEATSET_LENGTH = 1;
    private static final int GD_DUP_SEL = 59;
    private static final int GD_DUP_SEL_LENGTH = 11;
    private static final int GD_USE_ALL_FEATS = 70;
    private static final int GD_USE_ALL_FEATS_LENGTH = 1;
    private static final int GD_DO_CHECKROOT = 71;
    private static final int GD_DO_CHECKROOT_LENGTH = 1;
    private static final int GD_SHOW_VENDORDEF = 72;
    private static final int GD_SHOW_VENDORDEF_LENGTH = 1;
    private static final int GD_ALLOW_BORROW = 73;
    private static final int GD_ALLOW_BORROW_LENGTH = 1;
    private static final int GD_REDIRECT_VERIFY = 74;
    private static final int GD_REDIRECT_VERIFY_LENGTH = 1;
    private static final int GD_DAEMON_PERIODIC = 75;
    private static final int GD_DAEMON_PERIODIC_LENGTH = 1;
    private static final int GD_COMPARE_ON_INCREMENT = 76;
    private static final int GD_COMPARE_ON_INCREMENT_LENGTH = 1;
    private static final int GD_COMPARE_ON_UPGRADE = 77;
    private static final int GD_COMPARE_ON_UPGRADE_LENGTH = 1;
    private static final int GD_VERSION = 78;
    private static final int GD_VERSION_LENGTH = 10;
    private static final int GD_REVISION = 89;
    private static final int GD_REVISION_LENGTH = 10;
    private static final int GD_LITE = 100;
    private static final int GD_LITE_LENGTH = 1;
    private static final int GD_LMGRD_START = 101;
    private static final int GD_LMGRD_START_LENGTH = 8;
    private static final int GD_VD_START = 110;
    private static final int GD_VD_START_LENGTH = 8;
    private static final int GD_VD_TIME = 119;
    private static final int GD_VD_TIME_LENGTH = 8;
    private static final int HS_CRYPT = 2;
    private static final int HS_CRYPT_LENGTH = 2;
    private static final int HS_HDATA = 4;
    private static final int HS_HDATA_LENGTH = 8;
    private static final int HS_TIME = 13;
    private static final int HS_TIME_LENGTH = 8;
    private static final int HS_HDATA2 = 22;
    private static final int HS_HDATA3 = 31;
    private static final int HS_HDATA4 = 40;
    private static final int HS_GROUPID = 49;
    private static final int HS_GROUPID_LENGTH = 4;
    private static final int HS_CBFLAG = 53;
    private static final int HS_CBFLAG_LENGTH = 2;
    private static final int HE_VERSION = 2;
    private static final int HE_VERSION_LENGTH = 2;
    private static final int HE_USERNAME = 4;
    private static final int HE_USERNAME_LENGTH = 20;
    private static final int HE_HOSTNAME = 25;
    private static final int HE_HOSTNAME_LENGTH = 32;
    private static final int HE_VENDORNAME = 58;
    private static final int HE_VENDORNAME_LENGTH = 10;
    private static final int HE_DISPLAY = 69;
    private static final int HE_DISPLAY_LENGTH = 32;
    private static final int HE_REQUIREDCOMM = 102;
    private static final int HE_REQUIREDCOMM_LENGTH = 2;
    private static final int HE_UDPTIMEOUT = 104;
    private static final int HE_UDPTIMEOUT_LENGTH = 10;
    private static final int HE_PID = 115;
    private static final int HE_PID_LENGTH = 10;
    private static final int HE_PLATFORM = 126;
    private static final int HE_PLATFORM_LENGTH = 12;
    private static final int HE_FLEXVERSION = 139;
    private static final int HE_FLEXVERSION_LENGTH = 1;
    private static final int HE_FLEXREVISION = 140;
    private static final int HE_FLEXREVISION_LENGTH = 1;
    private static final int HE_TCPTIMEOUT = 141;
    private static final int HE_TCPTIMEOUT_LENGTH = 2;
    private static final int HE_REALVER = 144;
    private static final int HE_REALVER_LENGTH = 1;
    private static final int SH_HOSTID = 2;
    private static final int SH_HOSTID_LENGTH = 41;
    private static final int SH_HOSTID_TYPE = 44;
    private static final int SH_HOSTID_TYPE_LENGTH = 10;
    private static final int LF_DATABYTE_COUNT = 2;
    private static final int LF_DATABYTE_COUNT_LENGTH = 10;
    private static final int LF_DATABYTES = 13;
    private static final int LF_DATABYTES_LENGTH = 134;
    private static final int NU_NUSERS = 2;
    private static final int NU_NUSERS_LENGTH = 10;
    private static final int NU_NLICENSES = 13;
    private static final int NU_NLICENSES_LENGTH = 10;
    private static final int NU_TIME = 24;
    private static final int NU_TIME_LENGTH = 10;
    private static final int OK_VER = 2;
    private static final int OK_VER_LENGTH = 10;
    private static final int OK_REV = 13;
    private static final int OK_REV_LENGTH = 10;
    private static final int OK_PATCH = 24;
    private static final int OK_PATCH_LENGTH = 1;
    private static final int OK_COMMVER = 25;
    private static final int OK_COMMVER_LENGTH = 10;
    private static final int OK_COMMREV = 36;
    private static final int OK_COMMREV_LENGTH = 10;
    private static final int OK_HOST = 47;
    private static final int OK_HOST_LENGTH = 64;
    private static final int OK_DAEMON = 112;
    private static final int OK_DAEMON_LENGTH = 10;
    private static final int Q_ID = 2;
    private static final int Q_ID_LENGTH = 21;
    private static final int SH_VER = 2;
    private static final int SH_VER_LENGTH = 2;
    private static final int SH_USER = 4;
    private static final int SH_USER_LENGTH = 20;
    private static final int SH_HOST = 25;
    private static final int SH_HOST_LENGTH = 64;
    private static final int SH_DAEMON = 90;
    private static final int SH_DAEMON_LENGTH = 10;
    private static final int SH_DISPLAY = 90;
    private static final int SH_DISPLAY_LENGTH = 32;
    private static final int SH_IPADDR = 123;
    private static final int SH_IPADDR_LENGTH = 8;
    private static final int SH_FLAGS = 132;
    private static final int RE_VER = 2;
    private static final int RE_VER_LENGTH = 2;
    private static final int RE_USER = 4;
    private static final int RE_USER_LENGTH = 20;
    private static final int RE_HOST = 25;
    private static final int RE_HOST_LENGTH = 64;
    private static final int RE_DAEMON = 90;
    private static final int RE_DAEMON_LENGTH = 10;
    private static final int RE_DISPLAY = 90;
    private static final int RE_DISPLAY_LENGTH = 32;
    private static final int RE_IPADDR = 123;
    private static final int RE_IPADDR_LENGTH = 8;
    private static final int RE_FLAGS = 132;
    private static final int SL_FINDER_TYPE = 101;
    private static final int SL_FINDER_TYPE_LENGTH = 20;
    private static final int SW_FILE = 2;
    private static final int SW_FILE_LENGTH = 145;
    protected static final int TA_HOST = 2;
    protected static final int TA_HOST_LENGTH = 32;
    protected static final int TA_PORT = 35;
    protected static final int TA_PORT_LENGTH = 10;
    protected static final int TA_HOST2 = 46;
    protected static final int TA_HOST2_LENGTH = 32;
    private static final int UL_FEATURE = 2;
    private static final int UL_FEATURE_LENGTH = 30;
    private static final int UL_CODE = 33;
    private static final int UL_CODE_LENGTH = 20;
    private static final int UL_BORROW_FLAG = 54;
    private static final int UL_BORROW_FLAG_LENGTH = 1;
    private static final int U2_CODATA = 2;
    private static final int U2_CODATA_LENGTH = 32;
    private static final int UN_NAME = 2;
    private static final int UN_NAME_LENGTH = 20;
    private static final int UN_NODE = 23;
    private static final int UN_NODE_LENGTH = 32;
    private static final int UN_DISPLAY = 56;
    private static final int UN_DISPLAY_LENGTH = 32;
    private static final int UN_VERSION = 89;
    private static final int UN_VERSION_LENGTH = 10;
    private static final int UN_NUM = 100;
    private static final int UN_NUM_LENGTH = 10;
    private static final int UN_FLAGS = 111;
    private static final int UN_FLAGS_LENGTH = 3;
    private static final int UN_TIME = 114;
    private static final int UN_TIME_LENGTH = 10;
    private static final int UN_LINGER = 125;
    private static final int UN_LINGER_LENGTH = 10;
    private static final int UN_HANDLE = 136;
    private static final int UN_HANDLE_LENGTH = 10;
    private static final int VD_SUBCOMMAND = 2;
    private static final int VD_SUBCOMMAND_LENGTH = 1;
    private static final int VD_FEATURE = 3;
    private static final int VD_FEATURE_LENGTH = 30;
    private static final int VD_CODE = 34;
    private static final int VD_CODE_LENGTH = 20;
    private static final int WH_PARAMETER = 2;

    private CommRev3() {
    }

    public static CommRev getInstance() {
        if (instance == null) {
            instance = new CommRev3();
        }
        return instance;
    }

    public boolean checkHeaderChecksum(byte[] byArray) {
        return true;
    }

    public void encryptMessage(byte[] byArray, int n) {
        CommRev3.encryptBytes(byArray, n);
    }

    public void decryptMessage(byte[] byArray, MessageHeader messageHeader, int n) {
        int n2 = messageHeader.getMessageLength();
        int n3 = MessageHeader.getHeaderLength();
        if (n2 == 147) {
            CommRev3.decryptBytes(byArray, n3, 147 - n3, n);
        } else {
            if (n2 % 147 != 0) {
                throw new RuntimeException("CommRev3 message length = " + n2);
            }
            int n4 = n2 / 147;
            int n5 = 0;
            while (n5 < n4) {
                if (n5 == 0) {
                    CommRev3.decryptBytes(byArray, n3, 147 - n3, n);
                } else {
                    CommRev3.decryptBytes(byArray, n5 * 147, 147, n);
                }
                ++n5;
            }
        }
    }

    protected int getMessageType(byte[] byArray) throws FlexlmException {
        int n;
        if (byArray == null || byArray.length == 0) {
            throw new FlexlmException(-506, 1017);
        }
        switch (byArray[0]) {
            case 97: {
                n = 65537;
                break;
            }
            case 103: {
                n = 65538;
                break;
            }
            case 104: {
                n = 65539;
                break;
            }
            case 105: {
                n = 65540;
                break;
            }
            case 108: {
                n = 65541;
                break;
            }
            case 111: {
                n = 65542;
                break;
            }
            case 113: {
                n = 65543;
                break;
            }
            case 117: {
                n = 65544;
                break;
            }
            case 119: {
                n = 65545;
                break;
            }
            case 35: {
                n = 65546;
                break;
            }
            case 61: {
                n = 65547;
                break;
            }
            case 126: {
                n = 65548;
                break;
            }
            case 38: {
                n = 65549;
                break;
            }
            case 94: {
                n = 65550;
                break;
            }
            case 123: {
                n = 65551;
                break;
            }
            case 65: {
                n = 65553;
                break;
            }
            case 66: {
                n = 65554;
                break;
            }
            case 68: {
                n = 65555;
                break;
            }
            case 70: {
                n = 65556;
                break;
            }
            case 71: {
                n = 65557;
                break;
            }
            case 72: {
                n = 65558;
                break;
            }
            case 73: {
                n = 65559;
                break;
            }
            case 74: {
                n = 65560;
                break;
            }
            case 79: {
                n = 65561;
                break;
            }
            case 76: {
                n = 65562;
                break;
            }
            case 77: {
                n = 65563;
                break;
            }
            case 78: {
                n = 65564;
                break;
            }
            case 80: {
                n = 65565;
                break;
            }
            case 81: {
                n = 65566;
                break;
            }
            case 84: {
                n = 65567;
                break;
            }
            case 85: {
                n = 65569;
                break;
            }
            case 87: {
                n = 65552;
                break;
            }
            case 88: {
                n = 65568;
                break;
            }
            case 63: {
                n = 65570;
                break;
            }
            case 36: {
                n = 65571;
                break;
            }
            default: {
                throw new FlexlmException(-506, 1022);
            }
        }
        return n;
    }

    protected int getMessageLength(byte[] byArray, int n) {
        int n2;
        if (n == 65562) {
            boolean bl;
            int n3 = CommRev3.decodeDecimal(byArray, 2);
            int n4 = 134;
            int n5 = n3 / n4;
            boolean bl2 = bl = n3 % n4 == 0;
            if (!bl) {
                ++n5;
            }
            n2 = n5 * 147;
        } else {
            n2 = 147;
        }
        return n2;
    }

    public byte[] encodeCheckin(CheckinMessage checkinMessage) {
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 105;
        CommRev3.copyBytes(byArray, 2, 30, checkinMessage.getFeature().getBytes());
        CommRev3.copyBytes(byArray, 33, 20, checkinMessage.getCode().getBytes());
        String string = checkinMessage.getCheckoutData();
        if (string != null && string.length() > 0) {
            CommRev3.copyBytes(byArray, 55, 32, string.getBytes());
            byArray[54] = 49;
        }
        return byArray;
    }

    public CheckinMessage decodeCheckin(byte[] byArray) {
        throw new RuntimeException("decodeCheckin unimplemented");
    }

    public byte[] encodeCheckout(CheckoutMessage checkoutMessage) {
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 111;
        CommRev3.encodeDecimal(byArray, 2, 4, checkoutMessage.getNumLic());
        CommRev3.copyBytes(byArray, 8, 30, checkoutMessage.getFeature().getBytes());
        CommRev3.copyBytes(byArray, 39, 10, checkoutMessage.getVersion().getBytes());
        String string = checkoutMessage.getCode();
        if (string == null) {
            CommRev3.copyBytes(byArray, 72, 20, "PORT_AT_HOST_PLUS   ".getBytes());
        } else {
            CommRev3.copyBytes(byArray, 72, 20, string.getBytes());
        }
        CommRev3.encodeDecimal(byArray, 61, 10, checkoutMessage.getLinger());
        byte[] byArray2 = new byte[1];
        int n = checkoutMessage.getQueueMode();
        if (n == 0) {
            byArray2[0] = 48;
        } else if (n == 2 || n == 1) {
            byArray2[0] = 49;
        }
        byArray2[0] = (byte)(byArray2[0] | 0x40);
        CommRev3.copyBytes(byArray, 7, 1, byArray2);
        CommRev3.encodeDecimal(byArray, 50, 10, checkoutMessage.getDupGroup());
        String string2 = checkoutMessage.getCheckoutData();
        if (string2 != null) {
            CommRev3.copyBytes(byArray, 93, 32, string2.getBytes());
        }
        return byArray;
    }

    public CheckoutMessage decodeCheckout(byte[] byArray) {
        throw new RuntimeException("decodeCheckout unimplemented");
    }

    public byte[] encodeFeatBundle(FeatBundleMessage featBundleMessage) {
        throw new RuntimeException("encodeFeatBundle unimplemented");
    }

    public FeatBundleMessage decodeFeatBundle(byte[] byArray) {
        FeatBundleMessage featBundleMessage = new FeatBundleMessage();
        featBundleMessage.setRev(CommRev3.decodeDecimal(byArray, 2));
        featBundleMessage.setTimeout(CommRev3.decodeDecimal(byArray, 13));
        featBundleMessage.setLinger(CommRev3.decodeDecimal(byArray, 24));
        featBundleMessage.setDupGroup(CommRev3.decodeDecimal(byArray, 35));
        featBundleMessage.setReserved(CommRev3.decodeDecimal(byArray, 46));
        featBundleMessage.setTotalInUse(CommRev3.decodeDecimal(byArray, 57));
        featBundleMessage.setFloatInUse(CommRev3.decodeDecimal(byArray, 68));
        featBundleMessage.setUserCount(CommRev3.decodeDecimal(byArray, 79));
        featBundleMessage.setNumLicenses(CommRev3.decodeDecimal(byArray, 90));
        featBundleMessage.setQueuedCount(CommRev3.decodeDecimal(byArray, 101));
        featBundleMessage.setOverdraft(CommRev3.decodeDecimal(byArray, 112));
        featBundleMessage.setBorrowed(CommRev3.decodeDecimal(byArray, 123));
        return featBundleMessage;
    }

    public byte[] encodeFeatureAvailable(FeatureAvailableMessage featureAvailableMessage) {
        throw new RuntimeException("encodeFeatureAvailable unimplemented");
    }

    public FeatureAvailableMessage decodeFeatureAvailable(byte[] byArray) {
        FeatureAvailableMessage featureAvailableMessage = new FeatureAvailableMessage();
        featureAvailableMessage.setFeatureName(new String(byArray, 2, 31).trim());
        featureAvailableMessage.setQueuedPackage(byArray[33] != 48);
        return featureAvailableMessage;
    }

    public byte[] encodeForceCheckin(ForceCheckinMessage forceCheckinMessage) {
        byte[] byArray = CommRev3.getBuffer();
        CommRev3.copyBytes(byArray, 2, 30, forceCheckinMessage.getFeature().getBytes());
        int n = forceCheckinMessage.getHandle();
        if (n == 0) {
            byArray[0] = 117;
            CommRev3.copyBytes(byArray, 33, 20, forceCheckinMessage.getUser().getBytes());
            CommRev3.copyBytes(byArray, 54, 32, forceCheckinMessage.getHost().getBytes());
            CommRev3.copyBytes(byArray, 87, 32, forceCheckinMessage.getDisplay().getBytes());
        } else {
            String string = Integer.toString(n);
            byArray[0] = 35;
            CommRev3.copyBytes(byArray, 77, 10, string.getBytes());
        }
        return byArray;
    }

    public ForceCheckinMessage decodeForceCheckin(byte[] byArray) {
        throw new RuntimeException("decodeForceCheckin unimplemented");
    }

    public byte[] encodeGenericDaemonInfo(GenericDaemonInfoMessage genericDaemonInfoMessage) {
        throw new RuntimeException("encodeGenericDaemonInfo unimplemented");
    }

    public GenericDaemonInfoMessage decodeGenericDaemonInfo(byte[] byArray) {
        GenericDaemonInfoMessage genericDaemonInfoMessage = new GenericDaemonInfoMessage();
        genericDaemonInfoMessage.setMinUserTimeout(CommRev3.decodeDecimal(byArray, 36));
        genericDaemonInfoMessage.setMinLmRemoveInterval(CommRev3.decodeDecimal(byArray, 47));
        genericDaemonInfoMessage.setCompareOnIncrement((char)byArray[76] != ' ');
        genericDaemonInfoMessage.setCompareOnUpgrade((char)byArray[77] != ' ');
        genericDaemonInfoMessage.setDaemonVersion(CommRev3.decodeDecimal(byArray, 78));
        genericDaemonInfoMessage.setDaemonRevision(CommRev3.decodeDecimal(byArray, 89));
        genericDaemonInfoMessage.setLmgrdStart(CommRev3.decodeHexLong(byArray, 101));
        genericDaemonInfoMessage.setVendorDaemonStart(CommRev3.decodeHexLong(byArray, 110));
        genericDaemonInfoMessage.setServerTime(CommRev3.decodeHexLong(byArray, 119));
        return genericDaemonInfoMessage;
    }

    public byte[] encodeHandshake(HandshakeMessage handshakeMessage) {
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 97;
        CommRev3.encodeHex(byArray, 13, 8, (int)handshakeMessage.getCurrentTime());
        byArray[2] = handshakeMessage.getCrypt();
        System.arraycopy(handshakeMessage.getData1(), 0, byArray, 4, 8);
        System.arraycopy(handshakeMessage.getData2(), 0, byArray, 22, 8);
        System.arraycopy(handshakeMessage.getData3(), 0, byArray, 31, 8);
        System.arraycopy(handshakeMessage.getData4(), 0, byArray, 40, 8);
        CommRev3.encodePacked(byArray, 49, handshakeMessage.getGroupId());
        return byArray;
    }

    public HandshakeMessage decodeHandshake(byte[] byArray) {
        HandshakeMessage handshakeMessage = new HandshakeMessage();
        byte[] byArray2 = new byte[8];
        byte[] byArray3 = new byte[8];
        byte[] byArray4 = new byte[8];
        byte[] byArray5 = new byte[8];
        System.arraycopy(byArray, 4, byArray2, 0, 8);
        System.arraycopy(byArray, 22, byArray3, 0, 8);
        System.arraycopy(byArray, 31, byArray4, 0, 8);
        System.arraycopy(byArray, 40, byArray5, 0, 8);
        handshakeMessage.setData1(byArray2);
        handshakeMessage.setData2(byArray3);
        handshakeMessage.setData3(byArray4);
        handshakeMessage.setData4(byArray5);
        return handshakeMessage;
    }

    public byte[] encodeHeartbeat(HeartbeatMessage heartbeatMessage) {
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 103;
        return byArray;
    }

    public HeartbeatMessage decodeHeartbeat(byte[] byArray) {
        HeartbeatMessage heartbeatMessage = new HeartbeatMessage();
        return heartbeatMessage;
    }

    public byte[] encodeHeartbeatResponse(HeartbeatResponseMessage heartbeatResponseMessage) {
        throw new RuntimeException("encodeHeartbeatResponse unimplemented");
    }

    public HeartbeatResponseMessage decodeHeartbeatResponse(byte[] byArray) {
        HeartbeatResponseMessage heartbeatResponseMessage = new HeartbeatResponseMessage();
        return heartbeatResponseMessage;
    }

    public byte[] encodeHello(HelloMessage helloMessage) {
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 104;
        byArray[2] = (byte)(helloMessage.getVersion() + 48);
        byArray[3] = (byte)(helloMessage.getRevision() + 48);
        String string = helloMessage.getUsername();
        String string2 = helloMessage.getHost();
        String string3 = helloMessage.getVendor();
        String string4 = helloMessage.getDisplay();
        String string5 = "java_01";
        try {
            if (string != null) {
                CommRev3.copyBytes(byArray, 4, 20, string.getBytes("ISO-8859-1"));
            }
            if (string2 != null) {
                CommRev3.copyBytes(byArray, 25, 32, string2.getBytes("ISO-8859-1"));
            }
            if (string3 != null) {
                CommRev3.copyBytes(byArray, 58, 10, string3.getBytes("ISO-8859-1"));
            }
            if (string4 != null) {
                CommRev3.copyBytes(byArray, 69, 32, string4.getBytes("ISO-8859-1"));
            }
            if (string5 != null) {
                CommRev3.copyBytes(byArray, 126, 12, string5.getBytes("ISO-8859-1"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
        byArray[102] = 84;
        byArray[139] = 10;
        byArray[140] = 1;
        int n = helloMessage.getServerTimeout();
        if (n > 255) {
            n = 255;
        }
        CommRev3.encodeHex(byArray, 141, 2, n);
        byArray[144] = 49;
        byArray[145] = 52;
        return byArray;
    }

    public HelloMessage decodeHello(byte[] byArray) {
        throw new RuntimeException("decodeHello unimplemented");
    }

    public byte[] encodeHostId(HostIdMessage hostIdMessage) {
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 126;
        CommRev3.copyBytes(byArray, 2, 41, hostIdMessage.getHostId().getBytes());
        CommRev3.encodeDecimal(byArray, 44, 10, hostIdMessage.getHostIdType());
        return byArray;
    }

    public HostIdMessage decodeHostId(byte[] byArray) {
        throw new RuntimeException("decodeHello unimplemented");
    }

    public byte[] encodeLicenseFileData(LicenseFileDataMessage licenseFileDataMessage) {
        throw new RuntimeException("encodeLicenseFileData unimplemented");
    }

    public LicenseFileDataMessage decodeLicenseFileData(byte[] byArray) {
        LicenseFileDataMessage licenseFileDataMessage = new LicenseFileDataMessage();
        int n = CommRev3.decodeDecimal(byArray, 2);
        byte[] byArray2 = new byte[n];
        int n2 = 134;
        int n3 = 0;
        int n4 = 13;
        int n5 = n;
        while (n5 > 0) {
            int n6 = n5 < n2 ? n5 : n2;
            CommRev3.copyBytes(byArray2, n3, n6, byArray, n4);
            n3 += n6;
            n4 += 147;
            n5 -= n6;
        }
        licenseFileDataMessage.setLicenseFileData(byArray2);
        return licenseFileDataMessage;
    }

    public byte[] encodeNeedHostId(NeedHostIdMessage needHostIdMessage) {
        throw new RuntimeException("encodeNeedHostId unimplemented");
    }

    public NeedHostIdMessage decodeNeedHostId(byte[] byArray) {
        NeedHostIdMessage needHostIdMessage = new NeedHostIdMessage();
        int n = 0;
        int n2 = 0;
        byte[] byArray2 = CommRev3.getByteString(byArray, 2);
        if (byArray2 != null) {
            String string = new String(byArray2);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            int n3 = stringTokenizer.countTokens();
            if (n3 != 2) {
                throw new RuntimeException("Bad NeedHostidMessage");
            }
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("BadHostidMessage type: " + numberFormatException.getMessage());
            }
            try {
                n2 = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("BadHostidMessage offset: " + numberFormatException.getMessage());
            }
        }
        needHostIdMessage.setHostIdType(n);
        needHostIdMessage.setOffset(n2);
        return needHostIdMessage;
    }

    public byte[] encodeNewReportlog(NewReportlogMessage newReportlogMessage) {
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 123;
        CommRev3.encodeSwitchMessage(newReportlogMessage.getReportlog(), byArray);
        return byArray;
    }

    public NewReportlogMessage decodeNewReportlog(byte[] byArray) {
        throw new RuntimeException("decodeNewReportlog unimplemented");
    }

    public byte[] encodeNUsers(NUsersMessage nUsersMessage) {
        throw new RuntimeException("encodeNUsers unimplemented");
    }

    public NUsersMessage decodeNUsers(byte[] byArray) {
        NUsersMessage nUsersMessage = new NUsersMessage();
        nUsersMessage.setNUsers(CommRev3.decodeDecimal(byArray, 2));
        nUsersMessage.setNLicenses(CommRev3.decodeDecimal(byArray, 13));
        nUsersMessage.setTime(CommRev3.decodeDecimalLong(byArray, 24));
        return nUsersMessage;
    }

    public byte[] encodeOK(OKMessage oKMessage) {
        throw new RuntimeException("encodeOK unimplemented");
    }

    public OKMessage decodeOK(byte[] byArray) {
        OKMessage oKMessage = new OKMessage();
        oKMessage.setData(CommRev3.getByteString(byArray, 2));
        try {
            oKMessage.setFlexVer((byte)CommRev3.decodeDecimal(byArray, 2));
            oKMessage.setFlexRev((byte)CommRev3.decodeDecimal(byArray, 13));
            byte[] byArray2 = new byte[]{byArray[24]};
            oKMessage.setFlexPatch(new String(byArray2));
            oKMessage.setCommVer((byte)CommRev3.decodeDecimal(byArray, 25));
            oKMessage.setCommRev((byte)CommRev3.decodeDecimal(byArray, 36));
            byte[] byArray3 = CommRev3.getByteString(byArray, 47);
            oKMessage.setHost(new String(byArray3));
            byte[] byArray4 = CommRev3.getByteString(byArray, 112);
            oKMessage.setHost(new String(byArray4));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return oKMessage;
    }

    public byte[] encodeQueued(QueuedMessage queuedMessage) {
        throw new RuntimeException("encodeQueued unimplemented");
    }

    public QueuedMessage decodeQueued(byte[] byArray) {
        QueuedMessage queuedMessage = new QueuedMessage();
        queuedMessage.setFeatureIdentifier(new String(byArray, 2, 20));
        return queuedMessage;
    }

    public byte[] encodeShutdown(ShutdownMessage shutdownMessage) {
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 113;
        CommRev3.copyBytes(byArray, 4, 20, shutdownMessage.getUser().getBytes());
        CommRev3.copyBytes(byArray, 25, 64, shutdownMessage.getHost().getBytes());
        String string = shutdownMessage.getDaemon();
        if (string != null) {
            CommRev3.copyBytes(byArray, 90, 10, string.getBytes());
        }
        InetAddress inetAddress = shutdownMessage.getIpAddress();
        int n = CommRev3.packIp(inetAddress.getHostAddress());
        CommRev3.encodePacked(byArray, 123, n);
        if (shutdownMessage.getForce()) {
            byArray[132] = 2;
        }
        return byArray;
    }

    public ShutdownMessage decodeShutdown(byte[] byArray) {
        throw new RuntimeException("decodeShutdown unimplemented");
    }

    public byte[] encodeReread(RereadMessage rereadMessage) {
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 38;
        CommRev3.copyBytes(byArray, 4, 20, rereadMessage.getUser().getBytes());
        CommRev3.copyBytes(byArray, 25, 64, rereadMessage.getHost().getBytes());
        String string = rereadMessage.getDaemon();
        if (string != null) {
            CommRev3.copyBytes(byArray, 90, 10, string.getBytes());
        }
        InetAddress inetAddress = rereadMessage.getIpAddress();
        int n = CommRev3.packIp(inetAddress.getHostAddress());
        CommRev3.encodePacked(byArray, 123, n);
        return byArray;
    }

    public RereadMessage decodeReread(byte[] byArray) {
        throw new RuntimeException("decodeReread unimplemented");
    }

    public byte[] encodeSendLicenseFileData(SendLicenseFileDataMessage sendLicenseFileDataMessage) {
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 36;
        byArray[2] = (byte)(sendLicenseFileDataMessage.getVersion() + 48);
        byArray[3] = (byte)(sendLicenseFileDataMessage.getRevision() + 48);
        String string = sendLicenseFileDataMessage.getUsername();
        String string2 = sendLicenseFileDataMessage.getHost();
        String string3 = sendLicenseFileDataMessage.getVendor();
        String string4 = sendLicenseFileDataMessage.getDisplay();
        try {
            if (string != null) {
                CommRev3.copyBytes(byArray, 4, 20, string.getBytes("ISO-8859-1"));
            }
            if (string2 != null) {
                CommRev3.copyBytes(byArray, 25, 32, string2.getBytes("ISO-8859-1"));
            }
            if (string3 != null) {
                CommRev3.copyBytes(byArray, 58, 10, string3.getBytes("ISO-8859-1"));
            }
            if (string4 != null) {
                CommRev3.copyBytes(byArray, 69, 32, string4.getBytes("ISO-8859-1"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
        CommRev3.copyBytes(byArray, 101, 20, sendLicenseFileDataMessage.getFinderType().getBytes());
        return byArray;
    }

    public SendLicenseFileDataMessage decodeSendLicenseFileData(byte[] byArray) {
        throw new RuntimeException("decodeSendLicenseFileData unimplemented");
    }

    public byte[] encodeSwitchDebuglog(SwitchDebuglogMessage switchDebuglogMessage) {
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 119;
        CommRev3.encodeSwitchMessage(switchDebuglogMessage.getLog(), byArray);
        return byArray;
    }

    public SwitchDebuglogMessage decodeSwitchDebuglog(byte[] byArray) {
        throw new RuntimeException("decodeSwitchDebuglog unimplemented");
    }

    public byte[] encodeSwitchReportlog(SwitchReportlogMessage switchReportlogMessage) {
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 94;
        CommRev3.encodeSwitchMessage(switchReportlogMessage.getLog(), byArray);
        return byArray;
    }

    public SwitchReportlogMessage decodeSwitchReportlog(byte[] byArray) {
        throw new RuntimeException("decodeSwitchReportlog unimplemented");
    }

    private static void encodeSwitchMessage(String string, byte[] byArray) {
        try {
            CommRev3.copyBytes(byArray, 2, 145, string.getBytes("UTF-8"));
        }
        catch (Throwable throwable) {
            throw new RuntimeException("encodeSwitchMessage: " + throwable.getMessage());
        }
    }

    public byte[] encodeTryAnother(TryAnotherMessage tryAnotherMessage) {
        throw new RuntimeException("encodeTryAnother unimplemented");
    }

    public TryAnotherMessage decodeTryAnother(byte[] byArray) {
        TryAnotherMessage tryAnotherMessage = new TryAnotherMessage();
        byte[] byArray2 = new byte[64];
        CommRev3.copyBytes(byArray2, 0, 32, byArray, 2);
        CommRev3.copyBytes(byArray2, 32, 32, byArray, 46);
        String string = null;
        try {
            string = new String(byArray2, "ISO-8859-1").trim();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
        tryAnotherMessage.setHost(string);
        byte[] byArray3 = new byte[10];
        CommRev3.copyBytes(byArray3, 0, 10, byArray, 35);
        String string2 = new String(byArray3).trim();
        int n = 0;
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        tryAnotherMessage.setPort(n);
        return tryAnotherMessage;
    }

    public byte[] encodeUserlist(UserlistMessage userlistMessage) {
        String string;
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 108;
        String string2 = userlistMessage.getFeature();
        if (string2 != null) {
            CommRev3.copyBytes(byArray, 2, 30, string2.getBytes());
        }
        if ((string = userlistMessage.getCode()) != null) {
            CommRev3.copyBytes(byArray, 33, 20, string.getBytes());
        }
        byArray[54] = 49;
        return byArray;
    }

    public UserlistMessage decodeUserlist(byte[] byArray) {
        throw new RuntimeException("decodeUserlist unimplemented");
    }

    public byte[] encodeUsername2(Username2Message username2Message) {
        throw new RuntimeException("encodeUsername2 unimplemented");
    }

    public Username2Message decodeUsername2(byte[] byArray) {
        Username2Message username2Message = new Username2Message();
        username2Message.setCheckoutData(CommRev3.getByteString(byArray, 2));
        return username2Message;
    }

    public byte[] encodeUsername(UsernameMessage usernameMessage) {
        throw new RuntimeException("encodeUsername unimplemented");
    }

    public UsernameMessage decodeUsername(byte[] byArray) {
        UsernameMessage usernameMessage = new UsernameMessage();
        usernameMessage.setName(CommRev3.getByteString(byArray, 2));
        usernameMessage.setNode(CommRev3.getByteString(byArray, 23));
        usernameMessage.setDisplay(CommRev3.getByteString(byArray, 56));
        usernameMessage.setVersion(CommRev3.getByteString(byArray, 89));
        usernameMessage.setNumLic(CommRev3.decodeDecimal(byArray, 100));
        int n = byArray[111] << 16 & 0xFF0000;
        int n2 = byArray[112] << 8 & 0xFF00;
        byte by = byArray[113];
        usernameMessage.setFlags(n | n2 | by);
        usernameMessage.setTime(CommRev3.decodeDecimalLong(byArray, 114));
        usernameMessage.setLinger(CommRev3.decodeDecimalLong(byArray, 125));
        usernameMessage.setHandle(CommRev3.decodeDecimal(byArray, 136));
        return usernameMessage;
    }

    public byte[] encodeVDInfo(VDInfoMessage vDInfoMessage) {
        String string;
        byte[] byArray = CommRev3.getBuffer();
        byArray[0] = 61;
        byArray[2] = vDInfoMessage.getSubType();
        String string2 = vDInfoMessage.getFeature();
        if (string2 != null) {
            CommRev3.copyBytes(byArray, 3, 30, string2.getBytes());
        }
        if ((string = vDInfoMessage.getCode()) != null) {
            CommRev3.copyBytes(byArray, 34, 20, string.getBytes());
        }
        return byArray;
    }

    public VDInfoMessage decodeVDInfo(byte[] byArray) {
        throw new RuntimeException("decodeVDInfo unimplemented");
    }

    public byte[] encodeWhat(WhatMessage whatMessage) {
        throw new RuntimeException("decodeWhat unimplemented");
    }

    public WhatMessage decodeWhat(byte[] byArray) {
        WhatMessage whatMessage = new WhatMessage();
        whatMessage.setParameter(CommRev3.decodeDecimal(byArray, 2));
        return whatMessage;
    }

    public byte[] encodeNoSuchFeature(NoSuchFeatureMessage noSuchFeatureMessage) {
        throw new RuntimeException("encodeNoSuchFeature unimplemented");
    }

    public NoSuchFeatureMessage decodeNoSuchFeature(byte[] byArray) {
        NoSuchFeatureMessage noSuchFeatureMessage = new NoSuchFeatureMessage();
        noSuchFeatureMessage.setIntData(CommRev3.decodeDecimal(byArray, 2));
        return noSuchFeatureMessage;
    }

    public byte[] encodeNotAdmin(NotAdminMessage notAdminMessage) {
        throw new RuntimeException("encodeNotAdmin unimplemented");
    }

    public NotAdminMessage decodeNotAdmin(byte[] byArray) {
        NotAdminMessage notAdminMessage = new NotAdminMessage();
        notAdminMessage.setIntData(CommRev3.decodeDecimal(byArray, 2));
        return notAdminMessage;
    }

    public byte[] encodeTooSoon(TooSoonMessage tooSoonMessage) {
        throw new RuntimeException("encodeTooSoon unimplemented");
    }

    public TooSoonMessage decodeTooSoon(byte[] byArray) {
        TooSoonMessage tooSoonMessage = new TooSoonMessage();
        tooSoonMessage.setIntData(CommRev3.decodeDecimal(byArray, 2));
        return tooSoonMessage;
    }

    public byte[] encodeNoUser(NoUserMessage noUserMessage) {
        throw new RuntimeException("encodeNoUser unimplemented");
    }

    public NoUserMessage decodeNoUser(byte[] byArray) {
        NoUserMessage noUserMessage = new NoUserMessage();
        noUserMessage.setIntData(CommRev3.decodeDecimal(byArray, 2));
        return noUserMessage;
    }

    private static void copyBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        if (byArray == null || byArray2 == null) {
            return;
        }
        int n4 = 0;
        while (n4 < n2 && n + n4 < byArray.length && n3 + n4 < byArray2.length) {
            byArray[n + n4] = byArray2[n3 + n4];
            ++n4;
        }
    }

    private static void copyBytes(byte[] byArray, int n, int n2, byte[] byArray2) {
        CommRev3.copyBytes(byArray, n, n2, byArray2, 0);
    }

    private static void encodeDecimal(byte[] byArray, int n, int n2, int n3) {
        CommRev3.zeroIt(byArray, n, n2);
        byte[] byArray2 = Integer.toString(n3).getBytes();
        CommRev3.copyBytes(byArray, n, n2, byArray2);
    }

    private static int decodeDecimal(byte[] byArray, int n) {
        int n2 = 0;
        byte[] byArray2 = CommRev3.getByteString(byArray, n);
        if (byArray2 != null && byArray2.length > 0) {
            String string = new String(byArray2).trim();
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("decodeDecimal NumberFormatException: " + numberFormatException.getMessage());
            }
        }
        return n2;
    }

    protected static void zeroIt(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            byArray[n + n3] = 0;
            ++n3;
        }
    }

    public static void encodeHex(byte[] byArray, int n, int n2, int n3) {
        CommRev3.zeroIt(byArray, n, n2);
        byte[] byArray2 = Integer.toHexString(n3).getBytes();
        CommRev3.copyBytes(byArray, n, n2, byArray2);
    }

    protected static int decodeHex(byte[] byArray, int n) {
        int n2 = 0;
        byte[] byArray2 = CommRev3.getByteString(byArray, n);
        if (byArray2 != null) {
            String string = new String(byArray2).toUpperCase();
            long l = Long.parseLong(string, 16);
            n2 = (int)l;
        }
        return n2;
    }

    public static long decodeHexLong(byte[] byArray, int n) {
        long l = 0L;
        byte[] byArray2 = CommRev3.getByteString(byArray, n);
        if (byArray2 != null) {
            String string = new String(byArray2);
            if (byArray2.length > 8) {
                string = string.substring(0, 8);
            }
            l = Long.parseLong(string, 16);
        }
        return l;
    }

    public static byte[] encodeEncryptHex(int n, int n2) {
        byte[] byArray = new byte[8];
        CommRev3.encodeHex(byArray, 0, 8, n);
        CommRev3.encryptBytes(byArray, n2);
        return byArray;
    }

    public static int decryptDecodeHex(byte[] byArray, int n) {
        CommRev3.decryptBytes(byArray, n);
        return CommRev3.decodeHex(byArray, 0);
    }

    private static byte[] getBuffer() {
        return new byte[147];
    }

    private static byte[] getByteString(byte[] byArray, int n) {
        if (byArray[n] == 0) {
            return null;
        }
        int n2 = byArray.length;
        int n3 = n;
        while (n3 < byArray.length) {
            if (byArray[n3] == 0) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        byte[] byArray2 = new byte[n2 - n];
        int n4 = 0;
        while (n4 < byArray2.length) {
            byArray2[n4] = byArray[n + n4];
            ++n4;
        }
        return byArray2;
    }

    protected static void encodePacked(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < 4) {
            byArray[n + n3] = (byte)(n2 & 0xFF);
            n2 >>= 8;
            ++n3;
        }
    }

    private static long decodeDecimalLong(byte[] byArray, int n) {
        long l = 0L;
        byte[] byArray2 = CommRev3.getByteString(byArray, n);
        if (byArray2 != null) {
            String string = new String(byArray2);
            l = Long.parseLong(string);
        }
        return l;
    }

    protected void setChecksum(byte[] byArray) {
        byArray[1] = CommRev3.computeChecksum(byArray);
    }

    protected boolean checkChecksum(byte[] byArray) {
        return CommRev3.checkChecksumS(byArray);
    }

    protected static boolean checkChecksumS(byte[] byArray) {
        return byArray[1] == CommRev3.computeChecksum(byArray);
    }

    private static byte computeChecksum(byte[] byArray) {
        int n = 147;
        if (byArray.length < n) {
            n = byArray.length;
        }
        byte by = byArray[0];
        int n2 = 2;
        while (n2 < n) {
            by = (byte)(by + byArray[n2]);
            ++n2;
        }
        return by;
    }

    private static int packIp(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        byte[] byArray = new byte[4];
        int n = 0;
        while (n < 4) {
            byArray[n] = (byte)Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            n2 |= byArray[n3] << 8 * n3;
            ++n3;
        }
        return n2;
    }

    protected static void encryptBytes(byte[] byArray, int n) {
        CommRev3.encryptBytes(byArray, 0, byArray.length, n);
    }

    protected static void encryptBytes(byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = new byte[]{(byte)(n3 & 0xFF), (byte)(n3 >> 8 & 0xFF), (byte)(n3 >> 16 & 0xFF), (byte)(n3 >> 24 & 0xFF)};
        int n4 = 0;
        int n5 = n;
        while (n5 < n + n2) {
            int n6 = n5;
            byArray[n6] = (byte)(byArray[n6] ^ byArray2[n4++]);
            if (n4 > 3) {
                n4 = 0;
            }
            ++n5;
        }
    }

    public static void decryptBytes(byte[] byArray, int n) {
        CommRev3.decryptBytes(byArray, 0, byArray.length, n);
    }

    public static void decryptBytes(byte[] byArray, int n, int n2, int n3) {
        CommRev3.encryptBytes(byArray, n, n2, n3);
    }
}

