/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.hostid;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;

public class InternetId
extends HostId
implements FlexlmConstants {
    private static final int WILDCARD = -1;
    private int[] id;

    public InternetId() throws FlexlmException {
        this("INTERNET=1.2.3.4");
    }

    public InternetId(String string) throws FlexlmException {
        Object var2_2 = null;
        if (!string.startsWith(this.getKeyword() + "=")) {
            throw new FlexlmException(-504, 2001);
        }
        String string2 = string.substring(string.indexOf("=") + 1);
        if (string2.length() < 1) {
            throw new FlexlmException(-503, 2002);
        }
        this.id = string2.indexOf(":") != -1 ? InternetId.parseV6AddrString(string2) : InternetId.parseOctetString(string2);
    }

    public HostId createNew(String string) throws FlexlmException {
        return new InternetId(string);
    }

    private static int[] parseOctetString(String string) throws FlexlmException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() != 4) {
            throw new FlexlmException(-503, 2003);
        }
        int[] nArray = new int[4];
        int n = 0;
        while (n < 4) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("*")) {
                nArray[n] = -1;
            } else {
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FlexlmException(-503, 2004);
                }
                if (n2 < 0 || n2 > 255) {
                    throw new FlexlmException(-503, 2005);
                }
                nArray[n] = n2;
            }
            ++n;
        }
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    private static int[] parseV6AddrString(String var0) throws FlexlmException {
        var1_1 = new StringTokenizer(var0, ":");
        if (var1_1.countTokens() < 2 || var1_1.countTokens() > 8) {
            throw new FlexlmException(-503, 2033);
        }
        if (var0.indexOf(46) != -1) {
            if (var0.indexOf(42) != -1) {
                throw new FlexlmException(-503, 2034);
            }
            var2_2 = var0.substring(var0.lastIndexOf(58) + 1);
            return InternetId.parseOctetString(var2_2);
        }
        var2_3 = new int[32];
        if (var1_1.countTokens() != 8) {
            var3_4 = var0;
            if (var0.indexOf("::") == -1) {
                throw new FlexlmException(-503, 2035);
            }
            var4_6 = 0;
            var5_8 = 0;
            while (var5_8 < var0.length()) {
                var6_10 = var0.charAt(var5_8);
                if (var6_10 == 58) {
                    ++var4_6;
                }
                ++var5_8;
            }
            var6_10 = 8 - var4_6;
            var7_11 = new StringBuffer();
            var8_12 = 0;
            while (var8_12 < var6_10) {
                var7_11.append(":0");
                ++var8_12;
            }
            var9_13 = new StringBuffer(var0);
            var9_13 = var9_13.insert(var0.indexOf("::"), (Object)var7_11);
            var9_13 = var9_13.insert(var0.indexOf("::") + 1, "0");
            var3_4 = var9_13.toString();
            var1_1 = new StringTokenizer(var3_4, ":");
        }
        if (var1_1.countTokens() != 8) {
            throw new FlexlmException(-503, 2037);
        }
        var3_5 = 0;
        while (var3_5 < 8) {
            block18: {
                block17: {
                    var4_7 = var1_1.nextToken();
                    if (!var4_7.equals("*") && !var4_7.equals("****")) break block17;
                    var2_3[4 * var3_5 + 0] = -1;
                    var2_3[4 * var3_5 + 1] = -1;
                    var2_3[4 * var3_5 + 2] = -1;
                    var2_3[4 * var3_5 + 3] = -1;
                    break block18;
                }
                var5_9 = new StringBuffer(var4_7);
                if (var4_7.length() <= 4) ** GOTO lbl51
                throw new FlexlmException(-503, 2038);
lbl-1000:
                // 1 sources

                {
                    var5_9 = var5_9.insert(0, "0");
lbl51:
                    // 2 sources

                    ** while (var5_9.length() < 4)
                }
lbl52:
                // 1 sources

                var6_10 = 0;
                while (var6_10 < 4) {
                    var7_11 = var5_9.substring(var6_10, var6_10 + 1);
                    if (var7_11.equals("*")) {
                        var2_3[4 * var3_5 + var6_10] = -1;
                    } else {
                        var8_12 = -1;
                        try {
                            var8_12 = Integer.parseInt((String)var7_11, 16);
                        }
                        catch (NumberFormatException var9_14) {
                            throw new FlexlmException(-503, 2039);
                        }
                        if (var8_12 < 0 || var8_12 > 15) {
                            throw new FlexlmException(-503, 2040);
                        }
                        var2_3[4 * var3_5 + var6_10] = var8_12;
                    }
                    ++var6_10;
                }
            }
            ++var3_5;
        }
        return var2_3;
    }

    public boolean isCurrentHost() {
        InternetId internetId = null;
        internetId = this.getLocalIp();
        return this.matches(internetId);
    }

    public HostId[] getCurrentHostIds() {
        InternetId internetId = this.getLocalIp();
        if (internetId != null) {
            HostId[] hostIdArray = new InternetId[]{internetId};
            return hostIdArray;
        }
        return null;
    }

    protected InternetId getLocalIp() {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
        String string = inetAddress.getHostAddress();
        InternetId internetId = null;
        try {
            internetId = new InternetId(this.getKeyword() + "=" + string);
        }
        catch (FlexlmException flexlmException) {
            throw new RuntimeException("unexpected FlexlmException in InternetId.getLocalIp()");
        }
        return internetId;
    }

    public String getKeyword() {
        return "INTERNET";
    }

    public int getType() {
        return 12;
    }

    public boolean matches(HostId hostId) {
        boolean bl = true;
        if (hostId == null || !(hostId instanceof InternetId)) {
            bl = false;
        } else {
            InternetId internetId = (InternetId)hostId;
            int[] nArray = (int[])internetId.getValue();
            if (this.id.length != nArray.length) {
                return false;
            }
            int n = 0;
            while (n < this.id.length) {
                if (this.id[n] != -1 && nArray[n] != -1 && this.id[n] != nArray[n]) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public int compareValueTo(Object object) {
        int[] nArray = (int[])object;
        if (this.id.length != nArray.length) {
            return this.id.length - nArray.length;
        }
        int n = 0;
        while (n < this.id.length) {
            if (this.id[n] != nArray[n]) {
                return this.id[n] - nArray[n];
            }
            ++n;
        }
        return 0;
    }

    public Object getValue() {
        return this.id;
    }

    public int getCryptCode() {
        return 2088566432;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        String string = ".";
        if (this.id.length == 32) {
            string = ":";
        }
        if (this.id.length == 4) {
            int n = 0;
            while (n < this.id.length) {
                if (n != 0) {
                    stringBuffer.append(string);
                }
                if (this.id[n] == -1) {
                    stringBuffer.append("*");
                } else {
                    stringBuffer.append(this.id[n]);
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.id.length) {
                if (n != 0 && n % 4 == 0) {
                    stringBuffer.append(string);
                }
                if (this.id[n] == -1) {
                    stringBuffer.append("*");
                } else {
                    stringBuffer.append(Integer.toHexString(this.id[n]));
                }
                ++n;
            }
        }
        return this.getKeyword() + "=" + new String(stringBuffer);
    }

    public boolean isIP() {
        if (this.isIP4()) {
            return true;
        }
        return this.isIP6();
    }

    public boolean isIP4() {
        return this.checkOctets(4);
    }

    public boolean isIP6() {
        return this.checkOctets(32);
    }

    private boolean checkOctets(int n) {
        if (this.id.length != n) {
            return false;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            if (this.id[n2] != 0) {
                return true;
            }
            ++n2;
        }
        return bl;
    }
}

