/*!
 * DeviceCommunicator Javascript library v1.0
 *
 * Copyright (c) 2008, 2011, 2014-2015, 2017 by Cisco Systems, Inc.,
 * 170 West Tasman Drive, San Jose,
 * California, 95134, U.S.A.   All rights reserved.
 *
 * @author: rtv
 *
 */
var deviceCommunicator=(function(){var CMD_HTTP_URL="/ios_web_exec/commandset",INFO_MESSAGES=["#exit","# exit","Note: Issue","Note:","% ERROR : Not in zip format","Not all config may be removed","3G Modem is not inserted","Cannot send CHV1 to modem for verification. It will be sent when the SIM becomes active.","Building configuration","Not all config may be removed and may reappear after","set to default configuration","Translating","WAN interface will be disabled","DSL interfaces will be disabled","Cannot enable CDP on this interface","Changing media to","Mode no change","Default route without gateway","Dynamic mapping not found","Unknown physical layer","Warning:","Policy already has same proposal set","IKEv2 Profile default not found","Start IPS global disable","IPSec Default Profile","% Warning, all VPDN configurations will be lost after reload or switchover.","will be treated as host","If the interface doesn't support baby giant frames","Remove Dialer Profile Configuration first","Remove Legacy DDR Configuration first","modem reset/power cycle","Please ensure NMEA is enabled in order to get all satellite and GPS location information","modem reset/power-cycle or router-reload for the configuration change to take effect","% Profile isakmp-profile not configured","NMEA streaming ","successfully","GPS Feature disabled","GPS Feature enabled"],platformType="unknown",interfaceTypeMap,deviceType,shdiagout,ccpExpressInstallDir=$(location).attr("pathname").replace(/\/(.*)\/html\/.+/,"$1");var switchPosrts={};function addHeaderAndFooter(clis,isExec){return'! COMMANDSET VERSION="1.0"\n! OPTIONS BEGIN\n! MODE="'+(isExec?"0":"1")+'"\n! OPTIONS END\n'+clis+"\n! END\n! COMMANDSET END"}function isInfoMessage(resp){var found=false,i=INFO_MESSAGES.length;for(i=(INFO_MESSAGES.length-1);i>=0;i=(i-1)){if(resp.indexOf(INFO_MESSAGES[i])!==-1){found=true;break}}return found}function getCmdOutput(clis,isExec,asyncFlag){if(!clis){return}var retResponse="",throwError={errorCmd:"",errorResponse:""};if(asyncFlag===true){$.ajaxSetup({async:true})}else{$.ajaxSetup({async:false})}$.post(CMD_HTTP_URL,addHeaderAndFooter(clis,isExec),function(data){if(data.indexOf("! COMMANDSET")===-1){throwError.errorCmd=clis;throwError.errorResponse=data;throw throwError}if(data.indexOf('STATUS="0"')===-1){throwError.errorCmd=clis;throwError.errorResponse=data;throw throwError}var cmd="",response="",cmdBeginIndex=data.indexOf("! COMMAND BEGIN"),cmdEndIndex=data.indexOf("! COMMAND END"),respBeginIndex=data.indexOf("! OUTPUT BEGIN"),respEndIndex=data.indexOf("! OUTPUT END"),parseErrorIndex=data.indexOf("PARSE_ERROR"),error=data.substring(parseErrorIndex+13,parseErrorIndex+14);while(respBeginIndex!==-1){cmd=data.substring(cmdBeginIndex+16,cmdEndIndex);response=response+data.substring(respBeginIndex+15,respEndIndex);cmd=$.trim(cmd);response=$.trim(response);if(error!=0){throwError.errorCmd=cmd;if(error==2&&response==""){throwError.errorResponse="Invalid input detected."}else{throwError.errorResponse=response}throw throwError}if((response.indexOf("Invalid input")!==-1)||(response.indexOf("Unrecognized command")!==-1)){throwError.errorCmd=cmd;throwError.errorResponse=response;throw throwError}if((error==0)&&(!isExec)){if(!isInfoMessage(response)){response=$.trim(response);if(response!==""){throwError.errorCmd=cmd;throwError.errorResponse=response;throw throwError}}else{response=""}}cmdBeginIndex=data.indexOf("! COMMAND BEGIN",cmdBeginIndex+1);cmdEndIndex=data.indexOf("! COMMAND END",cmdEndIndex+1);respBeginIndex=data.indexOf("! OUTPUT BEGIN",respEndIndex+1);respEndIndex=data.indexOf("! OUTPUT END",respBeginIndex+1);parseErrorIndex=data.indexOf("PARSE_ERROR",parseErrorIndex+1);error=data.substring(parseErrorIndex+13,parseErrorIndex+14)}retResponse=response});if(asyncFlag===true){$.ajaxSetup({async:false})}else{$.ajaxSetup({async:true})}return retResponse}function getExecCmdOutput(clis){var commandOutput=getCmdOutput(clis,true);return commandOutput}function getConfigCmdOutput(clis,asyncFlag){shRunFormatLatest=false;shRunConfigLatest=false;chasedInterfaceDetails={};var configCommandOutput=getCmdOutput(clis,false,asyncFlag);return configCommandOutput}function getResource(resourceName){var template="",templatePath=resourceName,throwError={errorCmd:"",errorResponse:""};if(!resourceName){throwError.errorResponse="Specify non-empty resource name";throw throwError}$.ajaxSetup({async:false});$.get(templatePath,function(data){template=data});$.ajaxSetup({async:true});return template}function clubShowCmdsExecuteAndSplitOutput(commandArray,outputSeparator){var newArray=null;if(commandArray!=null&&commandArray!=undefined&&commandArray.length>0){var outputToCheck=getExecCmdOutput(commandArray.join("\n"));if(outputToCheck){newArray=outputToCheck.split(outputSeparator)}}return newArray}function getTemplate(templateName,isDelete){var templatePath="../templates/"+templateName.replace("#","")+(isDelete?"Delete":"Create")+".txt";return getResource(templatePath)}function _configureCommandsFromTemplate(template,attrValueArray,isPreview){if(!template||!attrValueArray){return}var cmds=template,argName,re,formItemCounter=0;while(formItemCounter<attrValueArray.length){argName="\\$"+attrValueArray[formItemCounter]["name"];re=new RegExp(argName,"g");cmds=cmds.replace(re,attrValueArray[formItemCounter]["value"]);formItemCounter=formItemCounter+1}if(isPreview===true){return cmds+"\n"}else{return getConfigCmdOutput(cmds)}}function configureCommandsFromTemplate(templateName,attrValueArray,isPreview){return _configureCommandsFromTemplate(getResource("../templates/"+templateName),attrValueArray,isPreview)}function configureCommandsFromTemplate2(templateName,attrValueArray,isPreview){return _configureCommandsFromTemplate(getResource("../templates2/"+templateName),attrValueArray,isPreview)}function formatCli(cli){var cliLine=cli.split("\n");var find="BREAK;";var re=new RegExp(find,"g");var tempArr=[];var tempText="";$.each(cliLine,function(index,value){tempText=value.trim();if(tempText!=""){tempArr.push(tempText)}tempText=""});var tempString=tempArr.join("\n");return tempString.replace(re,"\n")}function configureCommandsFrom_Template2(templateName,attrValueArray,isPreview){return configureCommandsFrom_TemplateMain("../templates2/",templateName,attrValueArray,isPreview)}function configureCommandsFrom_Template(templateName,attrValueArray,isPreview){return configureCommandsFrom_TemplateMain("../templates/",templateName,attrValueArray,isPreview)}function configureCommandsFrom_TemplateMain(folderName,templateName,attrValueArray,isPreview){_.templateSettings.interpolate=/\{\{(.+?)\}\}/g;var templetData=getResource(folderName+templateName);var jsonArray={};for(var countArray=0;countArray<attrValueArray.length;countArray++){var elemname=attrValueArray[countArray].name;var elemvalue=attrValueArray[countArray].value;jsonArray[elemname]=elemvalue}var cliTemp=_.template(templetData);var cliCollection=formatCli(cliTemp(jsonArray));if(isPreview){return cliCollection+"\n"}else{return getConfigCmdOutput(cliCollection)}}function readFromTemplate(templateName,attrValueArray,isPreview){return _configureCommandsFromTemplate(getResource("../"+templateName),attrValueArray,isPreview)}function configureFeature(formName,isDelete,isPreview){if(!formName){return}var template=getTemplate(formName,isDelete),arr=$(formName).formToArray();return _configureCommandsFromTemplate(template,arr,isPreview)}function getCommandsForCache(jsonFileURL){var jsonObject={};$.ajaxSetup({cache:false});$.ajax({url:jsonFileURL,async:false,dataType:"json",contentType:"application/json",type:"GET",success:function(json){jsonObject=json}});$.ajaxSetup({cache:true});return jsonObject}function getIfType(interfaceName){return interfaceName.replace(/(^[a-zA-Z]+).*$/m,"$1")}function getPhraseForInterfaceType(type,hwInterfacesXml){var phrase;hwInterfacesXml.each(function(){if($(this).attr("type")===type){phrase=$(this).attr("phrase");return false}});return phrase}function readSwitchPorts(){try{var cmdOutPut=getExecCmdOutput("sh interfaces switchport");var outArray=cmdOutPut.split("\n");var size=outArray.length;var currentIntName;for(var i=0;i<size;i++){var row=outArray[i];var rowSp=row.split(":");if(rowSp[0].trim()==="Name"){currentIntName=rowSp[1].trim()}else{if(rowSp[0].trim()==="Switchport"&&rowSp[1].trim()==="Enabled"){if(currentIntName.indexOf("Gi")!==-1){var fullIntName=currentIntName.replace("Gi","GigabitEthernet");switchPosrts[fullIntName]=currentIntName}else{if(currentIntName.indexOf("Te")!==-1){var fullIntName=currentIntName.replace("Te","TenGigabitEthernet");switchPosrts[fullIntName]=intName}else{if(currentIntName.indexOf("Fo")!==-1){var fullIntName=currentIntName.replace("Fo","FortyGigabitEthernet");switchPosrts[fullIntName]=currentIntName}else{if(currentIntName.indexOf("Fa")!==-1){var fullIntName=currentIntName.replace("Fa","FastEthernet");switchPosrts[fullIntName]=currentIntName}else{switchPosrts[currentIntName]=currentIntName}}}}}}}}catch(error){console.log("No Switchport")}}function discoverHardware(){var i,j,shVer,lines,hwDictionaryXml,hwDeviceXml,hwDevice={ifs:[]},interfaceXml,interfaceName,interfaceType,interfaceList=[],mainBoard,found=false,hwInterfacesXml,returnInterfaceMap={},digitsInPlatformType;shVer=getExecCmdOutput("show version");lines=shVer.split(/\r\n|\r|\n/);for(i=0;i<lines.length;i=i+1){if(((lines[i].indexOf("Cisco")!==-1)||(lines[i].indexOf("cisco")!==-1))&&(lines[i].indexOf("bytes of memory")!==-1)){platformType=lines[i].replace(/^Cisco\s(.\S+)\b.*/,"$1");platformType=platformType.replace(/^cisco\s(.\S+)\b.*/,"$1");break}}readSwitchPorts();hwDictionaryXml=getResource("../js/HWDictionary.xml");$(hwDictionaryXml).find("device").each(function(){if($(this).attr("name")===platformType){found=true;hwDeviceXml=$(this);deviceType=$(this).attr("DeviceType");return false}});if(found===false){$(hwDictionaryXml).find("device").each(function(){var deviceFromDictionary=$(this).attr("name");var startReg=new RegExp("^"+deviceFromDictionary,"i");if(startReg.test(platformType)){found=true;hwDeviceXml=$(this);deviceType=$(this).attr("DeviceType");return false}})}if(found===false){digitsInPlatformType=platformType.replace(/\D*(\d{3}?).*/,"$1");$(hwDictionaryXml).find("device").each(function(){if(($(this).attr("name").indexOf(digitsInPlatformType))!==-1){found=true;hwDeviceXml=$(this);return false}});if(found===false){interfaceXml=getExecCmdOutput("show ip interface brief | format");$(interfaceXml).find("entry").each(function(){interfaceName=$(this).find("Interface").text();returnInterfaceMap[interfaceName]=-1});return returnInterfaceMap}}mainBoard=hwDeviceXml.attr("Mainboard");if(mainBoard){found=false;$(hwDictionaryXml).find("networkmodule").each(function(){if($(this).attr("partno")===mainBoard){found=true;hwDeviceXml=$(this);return false}});if(found===false){interfaceXml=getExecCmdOutput("show ip interface brief | format");$(interfaceXml).find("entry").each(function(){interfaceName=$(this).find("Interface").text();returnInterfaceMap[interfaceName]=-1});return returnInterfaceMap}$(hwDeviceXml).find("ifs").each(function(){interfaceType=$(this).attr("type");hwDevice.ifs.push(interfaceType);hwDevice[interfaceType]=$(this).attr("count")})}else{$(hwDeviceXml).find("ifs").each(function(){interfaceType=$(this).attr("type");hwDevice.ifs.push(interfaceType);hwDevice[interfaceType]=$(this).attr("count")})}interfaceXml=getExecCmdOutput("show ip interface brief | format");$(interfaceXml).find("entry").each(function(){interfaceName=$(this).find("Interface").text();if(interfaceName.indexOf(".")===-1){interfaceList.push(interfaceName)}returnInterfaceMap[interfaceName]=-1});hwInterfacesXml=$(hwDictionaryXml).find("interface");for(i=0;i<interfaceList.length;i=i+1){for(j=0;j<hwDevice.ifs.length;j=j+1){if(((getPhraseForInterfaceType(hwDevice.ifs[j],hwInterfacesXml))==(getIfType(interfaceList[i])))&&(hwDevice[hwDevice.ifs[j]]>0)){returnInterfaceMap[interfaceList[i]]=parseInt(hwDevice.ifs[j],10);hwDevice[hwDevice.ifs[j]]=hwDevice[hwDevice.ifs[j]]-1;break}else{returnInterfaceMap[interfaceList[i]]=-1}}}return returnInterfaceMap}function getInterfaceTypeUsingShOutput(majorInterfaceName){if(majorInterfaceName===""){return}try{var phrase=getIfType(majorInterfaceName),response;if(phrase.indexOf("GigabitEthernet")!==-1){if(!isEmpty(switchPosrts[majorInterfaceName])){return 6}if(((platformType.indexOf("IR829")===0&&majorInterfaceName==="GigabitEthernet5")||(platformType.indexOf("IR809")===0&&majorInterfaceName==="GigabitEthernet2"))){return 11}try{response=getExecCmdOutput("service-module "+majorInterfaceName+" session ?")}catch(error){try{response=getExecCmdOutput("show interfaces "+majorInterfaceName+" switchport");if(response.indexOf("not a switchable port")!==-1){return 4}else{return 6}}catch(error){return 4}}return 8}else{if(phrase.indexOf("FastEthernet")!==-1){if(!isEmpty(switchPosrts[majorInterfaceName])){return 5}try{response=getExecCmdOutput("show interfaces "+majorInterfaceName+" switchport");if(response.indexOf("not a switchable port")!==-1){return 1}else{return 5}}catch(error){return 1}}else{if(phrase.indexOf("Ethernet")!==-1){try{response=getExecCmdOutput("show interfaces "+majorInterfaceName);if(response.indexOf("VDSL")!=-1){return 539}else{return 2}}catch(error){return 2}}else{if(phrase.indexOf("Serial")!==-1){try{response=getExecCmdOutput("show interfaces "+majorInterfaceName+" | include Hardware")}catch(error){return -1}if(response.indexOf("T1 CSU/DSU")!==-1){return 502}else{if(response.toLocaleLowerCase().indexOf("serial")>=0){return 501}else{return -1}}}else{if(phrase.toLowerCase().indexOf("atm")!==-1){return 538}else{return -1}}}}}}catch(ex){return -1}}function getInterfaceTypeMap(discoverDeviceAgain){if(discoverDeviceAgain===true){interfaceTypeMap=discoverHardware()}return interfaceTypeMap}function getInterfaceType(interfaceName,discoverDeviceAgain){var subIntIndex,majorInterfaceName,throwError={errorCmd:"",errorResponse:""};if(interfaceName===undefined){throwError.errorResponse="Specify non-empty interface name";throw throwError}if(discoverDeviceAgain===true){interfaceTypeMap=discoverHardware()}majorInterfaceName=interfaceName;subIntIndex=interfaceName.indexOf(".");if(subIntIndex!==-1){majorInterfaceName=interfaceName.substring(0,subIntIndex)}if(interfaceTypeMap[majorInterfaceName]!==-1){return interfaceTypeMap[majorInterfaceName]}interfaceTypeMap[interfaceName]=getInterfaceTypeUsingShOutput(majorInterfaceName);return interfaceTypeMap[interfaceName]}function getPlatformTypeFromShowVersionOutput(showVersionOutput){if(platformType==="unknown"){var lines=showVersionOutput.split(/\r\n|\r|\n/);for(i=0;i<lines.length;i=i+1){if(((lines[i].indexOf("Cisco")!==-1)||(lines[i].indexOf("cisco")!==-1))&&(lines[i].indexOf("bytes of memory")!==-1)){platformType=lines[i].replace(/^Cisco\s(.\S+)\b.*/,"$1");platformType=platformType.replace(/^cisco\s(.\S+)\b.*/,"$1");break}}}return platformType}function getPlatformType(){if(platformType==="unknown"){var lines=getExecCmdOutput("show version").split(/\r\n|\r|\n/);for(i=0;i<lines.length;i=i+1){if(((lines[i].indexOf("Cisco")!==-1)||(lines[i].indexOf("cisco")!==-1))&&(lines[i].indexOf("bytes of memory")!==-1)){platformType=lines[i].replace(/^Cisco\s(.\S+)\b.*/,"$1");platformType=platformType.replace(/^cisco\s(.\S+)\b.*/,"$1");break}}}return platformType}function getInstallDir(){if(ccpExpressInstallDir.indexOf("archive")==-1){return ccpExpressInstallDir}else{return ccpExpressInstallDir.replace(/archive\/(.*)/,"$1")}}function discoverFRUSlotMap(){var i,j,blocks,lines,slotPosition,slotFRUMap=[];if(isEmpty(shdiagout)){shdiagout=getExecCmdOutput("show diag")}blocks=shdiagout.split(/Product\s\(FRU\)\sNumber/);i=0;while(i<blocks.length){lines=blocks[i].split(/\r\n|\r|\n/);for(j=0;j<lines.length;j=j+1){if(lines[j].indexOf("Slot")!==-1){if(lines[j].indexOf("Slot")==0){slotPosition=lines[j].replace(/.*(\d+)\:/,"$1")+"/0"}else{var headSlot=lines[j].split("/");slotPosition=headSlot[0]+"/";slotPosition=slotPosition+(lines[j].replace(/.*(\d+)\:/,"$1"))}slotPosition=slotPosition+"/0"}}if(i<(blocks.length-1)){slotFRUMap[slotPosition]=blocks[i+1].slice(blocks[i+1].indexOf(":")+1,blocks[i+1].search("\r\n|\r|\n"))}i=i+1}return slotFRUMap}function getProductFRUNumberOfSlot(slotPosition,discoverDeviceAgain){var slotFRUMap="",headSlot;if(slotPosition.indexOf("/")==-1){slotPosition="0/"+slotPosition+"/0"}else{headSlot=slotPosition.split("/");slotPosition=headSlot[0]+"/"+headSlot[1]+"/0"}if(discoverDeviceAgain===true){slotFRUMap=discoverFRUSlotMap()}return slotFRUMap[slotPosition]}function doWriteMemory(){if(enabledWriteMemory){try{getExecCmdOutput("write memory")}catch(error){return false}}}function doWriteMemoryUnchecked(){try{getExecCmdOutput("write memory")}catch(error){return false}}function getDeviceType(){return deviceType}return{getPlatformType:getPlatformType,getInterfaceType:getInterfaceType,getExecCmdOutput:getExecCmdOutput,getConfigCmdOutput:getConfigCmdOutput,getInstallDir:getInstallDir,configureFeature:configureFeature,configureCommandsFromTemplate:configureCommandsFromTemplate,configureCommandsFromTemplate2:configureCommandsFromTemplate2,configureCommandsFrom_Template:configureCommandsFrom_Template,configureCommandsFrom_Template2:configureCommandsFrom_Template2,readFromTemplate:readFromTemplate,getProductFRUNumberOfSlot:getProductFRUNumberOfSlot,doWriteMemory:doWriteMemory,doWriteMemoryUnchecked:doWriteMemoryUnchecked,getCommandsForCache:getCommandsForCache,getDeviceType:getDeviceType,clubShowCmdsExecuteAndSplitOutput:clubShowCmdsExecuteAndSplitOutput,getPlatformTypeFromShowVersionOutput:getPlatformTypeFromShowVersionOutput,getInterfaceTypeMap:getInterfaceTypeMap}}());