/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ANS;

import cerent.cms.idl.OpticsTopology.sParameterKey;
import cerent.cms.model.ANS.ANSNode;
import cerent.cms.model.ANS.ANSValue;
import cerent.cms.model.ProvisionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANSElement
extends ANSNode
implements Comparable<Object> {
    private static final String SEPARATOR = ".";
    private final String[] myPath;
    private final String myKeyString;
    private final sParameterKey myElemKey;
    private final ANSValue myElemValue;
    private boolean reprovisions;
    private boolean destructive;
    private boolean readOnly = false;

    public ANSElement(String[] stringArray, sParameterKey sParameterKey2, ANSValue aNSValue, ANSNode aNSNode, boolean bl, boolean bl2) {
        super(ANSElement.makeFullName(stringArray), aNSNode);
        this.myPath = stringArray;
        this.myElemKey = sParameterKey2;
        this.myKeyString = this.makeKeyString(sParameterKey2);
        this.myElemValue = aNSValue;
        this.dirty = false;
        this.reprovisions = bl;
        this.destructive = bl2;
        if (this.destructive) {
            this.reprovisions = true;
        }
    }

    public ANSElement(String[] stringArray, sParameterKey sParameterKey2, ANSValue aNSValue) {
        this(stringArray, sParameterKey2, aNSValue, null, false, false);
    }

    @Override
    public int compareTo(Object object) {
        return this.myKeyString.compareTo(((ANSElement)object).getKeyStr());
    }

    public void setValue(String string) throws ProvisionError {
        if (this.myElemValue.setValue(string)) {
            if (!string.equals("UNKNOWN")) {
                this.setDirty();
            } else {
                this.makeClean();
                this.recalcDirty();
            }
        }
    }

    public boolean reprovisions() {
        return this.reprovisions;
    }

    public boolean causesReboot() {
        return this.destructive;
    }

    public void resetValue() {
        this.myElemValue.resetValue();
        this.recalcDirty();
    }

    public ANSValue getANSValue() {
        return this.myElemValue;
    }

    public sParameterKey getKey() {
        return this.myElemKey;
    }

    public String getKeyStr() {
        return this.myKeyString;
    }

    public void applyToNode() {
        this.dirty = false;
    }

    public String[] getFullPath() {
        return this.myPath;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "";
        }
        int n = this.name.lastIndexOf(SEPARATOR);
        return this.name.substring(n + 1);
    }

    public void makeClean() {
        this.dirty = false;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    @Override
    public String toString() {
        return this.getName() + " [" + this.getKeyStr() + "] = " + this.myElemValue.getValue();
    }

    public static String makeFullName(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray.length > 0) {
            stringBuilder.append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(SEPARATOR);
                stringBuilder.append(stringArray[i]);
            }
        }
        return stringBuilder.toString();
    }

    private String makeKeyString(sParameterKey sParameterKey2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Integer.toHexString(sParameterKey2.paramLocation));
        stringBuffer.append('-');
        stringBuffer.append(Integer.toString(sParameterKey2.type.value()));
        stringBuffer.append('-');
        stringBuffer.append(Integer.toString(sParameterKey2.spectrum.value()));
        stringBuffer.append('-');
        stringBuffer.append(Integer.toString(sParameterKey2.spectrumIndex).toString());
        return stringBuffer.toString();
    }
}

