/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.CmsNoPermissionException;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.util.CEMC;
import cerent.util.stats.StatsMgr;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.REBIND;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UserException;

public abstract class CachedValue
extends NonCachedValue {
    protected Object value = null;
    protected short state;

    public CachedValue(NodeModelDelegate nodeModelDelegate, String string) {
        super(nodeModelDelegate, string);
        this.changeState((short)0);
    }

    public CachedValue(NodeModelDelegate nodeModelDelegate, String string, Object object) {
        this(nodeModelDelegate, string);
        this.value = object;
        this.changeState((short)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueExternally(Object object) {
        CachedValue cachedValue = this;
        synchronized (cachedValue) {
            this.value = object;
            this.changeState((short)2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueExternally(Object object, long l) {
        CachedValue cachedValue = this;
        synchronized (cachedValue) {
            this.value = object;
            this.changeState((short)2, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        CachedValue cachedValue = this;
        synchronized (cachedValue) {
            this.value = null;
            this.changeState((short)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        CachedValue cachedValue = this;
        synchronized (cachedValue) {
            this.value = null;
            this.changeState((short)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) throws AbstractCmsIOException, UserException {
        if (this.state == 2) {
            return this.cloneValue();
        }
        if (this.node.isReadyForCorbaRequest()) {
            Throwable throwable = null;
            Object object2 = null;
            if (StatsMgr.instance().isStarted()) {
                object2 = StatsMgr.instance().beginOperation((Object)this, this.node.getNameNoCV(), true, true);
            }
            try {
                Object object3 = this;
                synchronized (object3) {
                    this.value = object == null ? this.getValue() : this.getValue(object);
                    this.changeState((short)2);
                }
                object3 = this.cloneValue();
                return object3;
            }
            catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                throwable = oBJECT_NOT_EXIST;
                throw new CmsObjectNotExistException("An attempt was made to access the " + this.getAttributeName() + " attribute for an object that does not exist.");
            }
            catch (COMM_FAILURE cOMM_FAILURE) {
                this.node.setCommunicationFailure((Exception)((Object)cOMM_FAILURE));
                if (this.state == 1) {
                    Object object4 = this.cloneValue();
                    return object4;
                }
                throwable = cOMM_FAILURE;
                throw new CmsCommFailException("A communications error (COMM_FAILURE) occurred while attempting to get the " + this.getAttributeName() + " attribute from " + this.node.getHostName() + ".");
            }
            catch (REBIND rEBIND) {
                this.node.setCommunicationFailure((Exception)((Object)rEBIND));
                if (this.state == 1) {
                    Object object5 = this.cloneValue();
                    return object5;
                }
                throwable = rEBIND;
                throw new CmsCommFailException("A rebind error occurred while attempting to get the " + this.getAttributeName() + " attribute from " + this.node.getHostName() + ".");
            }
            catch (TIMEOUT tIMEOUT) {
                this.node.setCommunicationFailure((Exception)((Object)tIMEOUT));
                if (this.state == 1) {
                    Object object6 = this.cloneValue();
                    return object6;
                }
                throwable = tIMEOUT;
                throw new CmsCommFailException("A timeout error occurred while attempting to get the " + this.getAttributeName() + " attribute from " + this.node.getHostName() + ".");
            }
            catch (TRANSIENT tRANSIENT) {
                this.node.setCommunicationFailure((Exception)((Object)tRANSIENT));
                if (this.state == 1) {
                    Object object7 = this.cloneValue();
                    return object7;
                }
                throwable = tRANSIENT;
                throw new CmsCommFailException("A transient error occurred while attempting to get the " + this.getAttributeName() + " attribute from " + this.node.getHostName() + ".");
            }
            catch (NO_PERMISSION nO_PERMISSION) {
                if (nO_PERMISSION.minor == 65533) {
                    throw new CmsNodeUpgradingException(CEMC.EID_NODE_UPGRADING_EXCEPTION.getMessage());
                }
                this.node.setPermissionFailure();
                throwable = nO_PERMISSION;
                throw new CmsNoPermissionException(this.node.getHostName() + " No Permission error while attempting to get the " + this.getAttributeName() + " attribute.");
            }
            finally {
                if (object2 != null) {
                    StatsMgr.instance().endOperation(object2, null, (Exception)throwable);
                }
            }
        }
        if (this.state == 1) {
            return this.cloneValue();
        }
        throw new CmsCommFailException("The node was not initialized while attempting to get the " + this.getAttributeName() + " attribute from " + this.node.getHostName() + ".");
    }

    public Object getCachedValue() {
        return this.value == null ? this.value : this.cloneValue();
    }

    protected Object cloneValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(Object object) throws AbstractCmsIOException, UserException {
        block18: {
            if (this.node.isReadyForCorbaRequest()) {
                Throwable throwable = null;
                Object object2 = null;
                if (StatsMgr.instance().isStarted()) {
                    object2 = StatsMgr.instance().beginOperation((Object)this, this.node.getNameNoCV(), true, false);
                }
                try {
                    CachedValue cachedValue = this;
                    synchronized (cachedValue) {
                        this.setValue(object);
                        if (this.state == 2) {
                            this.changeState((short)1);
                        }
                        break block18;
                    }
                }
                catch (OBJECT_NOT_EXIST oBJECT_NOT_EXIST) {
                    throwable = oBJECT_NOT_EXIST;
                    throw new CmsObjectNotExistException("An attempt was made to set the " + this.getAttributeName() + " attribute for an object that does not exist.");
                }
                catch (COMM_FAILURE cOMM_FAILURE) {
                    this.node.setCommunicationFailure((Exception)((Object)cOMM_FAILURE));
                    throwable = cOMM_FAILURE;
                    throw new CmsCommFailException("A communications error (COMM_FAILURE) occurred while attempting to set the " + this.getAttributeName() + " attribute on " + this.node.getHostName() + ".");
                }
                catch (REBIND rEBIND) {
                    this.node.setCommunicationFailure((Exception)((Object)rEBIND));
                    throwable = rEBIND;
                    throw new CmsCommFailException("A rebind error occurred while attempting to set the " + this.getAttributeName() + " attribute on " + this.node.getHostName() + ".");
                }
                catch (TIMEOUT tIMEOUT) {
                    this.node.setCommunicationFailure((Exception)((Object)tIMEOUT));
                    throwable = tIMEOUT;
                    throw new CmsCommFailException("A timeout error occurred while attempting to set the " + this.getAttributeName() + " attribute.");
                }
                catch (TRANSIENT tRANSIENT) {
                    this.node.setCommunicationFailure((Exception)((Object)tRANSIENT));
                    throwable = tRANSIENT;
                    throw new CmsCommFailException("A transient error occurred while attempting to set the " + this.getAttributeName() + " attribute.");
                }
                catch (NO_PERMISSION nO_PERMISSION) {
                    if (nO_PERMISSION.minor == 65533) {
                        throw new CmsNodeUpgradingException(CEMC.EID_NODE_UPGRADING_EXCEPTION.getMessage());
                    }
                    this.node.setPermissionFailure();
                    throwable = nO_PERMISSION;
                    throw new CmsNoPermissionException(this.node.getHostName() + " No Permission error while attempting to set the " + this.getAttributeName() + " attribute.");
                }
                finally {
                    if (object2 != null) {
                        StatsMgr.instance().endOperation(object2, null, (Exception)throwable);
                    }
                }
            }
            throw new CmsCommFailException("The node was not initialized while attempting to set the " + this.getAttributeName() + " attribute on " + this.node.getHostName() + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        CachedValue cachedValue = this;
        synchronized (cachedValue) {
            if (this.state == 2) {
                this.changeState((short)1);
            }
        }
    }

    public String getStateString() {
        if (this.state == 0) {
            return "UNINITIALIZED";
        }
        if (this.state == 1) {
            return "DIRTY";
        }
        if (this.state == 2) {
            return "CLEAN";
        }
        return "UNKNOWN_STATE";
    }

    public NodeModelDelegate getNode() {
        return this.node;
    }

    public String toString() {
        return this.value != null ? this.value.toString() : "CachedValue[" + this.getAttributeName() + "]";
    }

    public int getState() {
        return this.state;
    }

    protected boolean changeState(short s) {
        boolean bl;
        boolean bl2 = bl = this.state != s;
        if (bl) {
            this.state = s;
        }
        return bl;
    }

    protected boolean changeState(short s, long l) {
        return this.changeState(s);
    }

    public boolean isClean() {
        return this.state == 2;
    }
}

