/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eAdminState;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.Connections;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.FeatureNotSupported;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionConversionModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.Model;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathListIncomplete;
import cerent.cms.model.TestAccessActive;
import cerent.cms.model.TopologyUpgradeNotAllowed;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.ComparisonUtil;
import cerent.util.SDebug;
import java.util.Comparator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public abstract class ConnectionModel
extends Model
implements Comparator,
IConnectionModel {
    protected NodeModelDelegate nmd;
    protected Connections parent;
    protected EventDispatcher dispatcher;
    private String myString;
    protected IConnectionConversionModel ccm = null;

    public ConnectionModel(NodeModelDelegate nodeModelDelegate, Connections connections, SDebug sDebug) {
        super(sDebug);
        this.nmd = nodeModelDelegate;
        this.parent = connections;
        this.dispatcher = null;
        this.index = -1;
        this.myString = null;
    }

    public void init() {
        this.index = this.getObjIndex();
        super.init0();
        this.dispatcher = this.nmd.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(this.getObjectType(), this.index, (Observer)this);
        }
    }

    protected abstract ObjectType getObjectType();

    protected abstract int getObjIndex();

    public abstract ICircuitId getCircuitId();

    public int getIndex() {
        return this.index;
    }

    protected void delete() {
        if (this.db.on()) {
            this.db.println("Received Delete for connectionModel ");
        }
        this.parent.remove(this.getIndex());
        this.dispose();
    }

    public void destroy() {
        super.destroy();
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(this.getObjectType(), this.index, (Observer)this);
            this.dispatcher = null;
        }
        this.myString = null;
        super.dispose();
    }

    public boolean equals(Object object) {
        if (object instanceof ConnectionModel) {
            ConnectionModel connectionModel = (ConnectionModel)object;
            return connectionModel.getObjectType() == this.getObjectType() && connectionModel.getIndex() == this.getIndex() && connectionModel.getNodeModel().getNodeId() == this.getNodeModel().getNodeId();
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + this.getObjectType().value();
        n = 37 * n + this.getIndex();
        return n;
    }

    public int compare(Object object, Object object2) {
        if (object instanceof ConnectionModel && object2 instanceof ConnectionModel) {
            ConnectionModel connectionModel = (ConnectionModel)object;
            ConnectionModel connectionModel2 = (ConnectionModel)object2;
            if (connectionModel.getObjectType() != connectionModel2.getObjectType()) {
                return ComparisonUtil.compare((int)connectionModel.getObjectType().value(), (int)connectionModel2.getObjectType().value());
            }
            if (connectionModel.getIndex() != connectionModel2.getIndex()) {
                return ComparisonUtil.compare((int)connectionModel.getIndex(), (int)connectionModel2.getIndex());
            }
            return 0;
        }
        return -1;
    }

    protected String prettyString(ICircuitId iCircuitId) {
        if (iCircuitId == null || iCircuitId.getUniquePart() == null) {
            return "<null>";
        }
        return Integer.toHexString(iCircuitId.getNodeId()) + "::" + iCircuitId.getUniquePart().getUniqueId();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            int n = ((IObjectMessageInfo)object).getUpdateType();
            switch (n) {
                case 0: {
                    if (this.db.on()) {
                        this.db.println(this.getClass().getName() + "::update():    this DELETED");
                    }
                    this.delete();
                    break;
                }
                case 1: {
                    if (this.db.on()) {
                        this.db.println("Connection Model update():    this CHANGED");
                    }
                    this.updateLocal();
                    break;
                }
                case 2: {
                    if (!this.db.on()) break;
                    this.db.println("ConnectionModel update():    ADDED");
                    break;
                }
                default: {
                    if (!this.db.on()) break;
                    this.db.println("ConnectionModel update():    UNKNOWN NE UPDATE TYPE" + n);
                }
            }
        }
    }

    public String toString() {
        if (this.myString == null) {
            try {
                this.myString = "Connection class : " + this.getClass().getName() + " CircuitId.uniquePart " + this.getCircuitId().getUniquePart().getUniqueId();
            }
            catch (Exception exception) {
                return this.getClass().getName() + " Cannot find CircuitId";
            }
        }
        return this.myString;
    }

    public abstract int getConnectionType();

    protected abstract void printString(SDebug var1);

    public INodeModel getNodeModel() {
        return this.nmd;
    }

    public NodeModelDelegate getNodeModelDelegate() {
        return this.nmd;
    }

    public abstract List getPortModels();

    public boolean hasLoopback() {
        List list = this.getPortModels();
        for (IPortModel iPortModel : list) {
            if (!this.checkLpbkOnPortModels(iPortModel)) continue;
            return true;
        }
        return false;
    }

    private boolean checkLpbkOnPortModels(IPortModel iPortModel) {
        if (iPortModel != null) {
            IModuleModel iModuleModel = iPortModel.getModuleModel();
            if (iModuleModel instanceof IDwdmModuleModel && ((IDwdmModuleModel)iModuleModel).isADMCard() && iPortModel.getEqType() == 186) {
                int n = 0;
                IEntityModel iEntityModel = null;
                iEntityModel = iPortModel.getParent().getParent();
                n = iEntityModel.getPositionInParent();
                iEntityModel = iEntityModel.getParent();
                List list = iEntityModel.getDescendantsOfEqType(122);
                for (int i = 0; i < list.size() && (iEntityModel = (IEntityModel)list.get(i)).getPositionInParent() != n; ++i) {
                }
                if (this.db.on()) {
                    this.db.println("Checking loopback on :" + iEntityModel);
                }
                return iEntityModel instanceof IDwdmPortModel ? ((IPortModel)iEntityModel).isInLoopback() : false;
            }
            if (iPortModel.isInLoopback()) {
                return true;
            }
        }
        return false;
    }

    public boolean hasXcLoopback() throws AbstractCmsNoSuchEntityException, InvalidPath {
        return false;
    }

    public int[] getPortNumByIndex(int n) throws AbstractCmsNoSuchEntityException {
        try {
            IEntityModel iEntityModel = this.nmd.getEntityTableModel().getEntityModelByIndex(n);
            if (iEntityModel instanceof IPortModel) {
                return ((IPortModel)iEntityModel).getPortNum();
            }
            if (this.db.on()) {
                this.db.warning("The entity is not a port");
            }
            return null;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            throw abstractCmsNoSuchEntityException;
        }
    }

    public int getSlotByIndex(int n) throws AbstractCmsNoSuchEntityException {
        try {
            return this.nmd.getEntityTableModel().getEntityModelByIndex(n).getSlot();
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            throw abstractCmsNoSuchEntityException;
        }
    }

    public abstract int getShelfId();

    public abstract boolean validateNewAdminState(int var1) throws AbstractCmsIOException;

    public abstract eAdminState getAdminStateEnum() throws AbstractCmsIOException;

    public int getAdminState() throws AbstractCmsIOException {
        eAdminState eAdminState2 = this.getAdminStateEnum();
        return eAdminState2 == null ? -1 : eAdminState2.value();
    }

    public int getServiceState() {
        return -2;
    }

    public abstract void setAdminState(eAdminState var1) throws TestAccessActive, ConnectionInLoopback, AbstractCmsIOException, InvalidState;

    public void setAdminState(int n) throws TestAccessActive, ConnectionInLoopback, AbstractCmsIOException, InvalidState {
        this.setAdminState(eAdminState.from_int(n));
    }

    public String getConnectionName() {
        throw new FeatureNotSupported("ConnectionName is not supported");
    }

    public void setConnectionName(String string) throws InvalidCircuitName {
        throw new FeatureNotSupported("ConnectionName is not supported");
    }

    public boolean hasTestAccess() {
        return false;
    }

    public IConnectionConversionModel createConnectionConversionModel(List list, int n, ICircuitId iCircuitId, List list2, int n2, IConnCreateAttrs iConnCreateAttrs, int n3, boolean bl, boolean bl2) throws NoSuchConnection, Busy, PathListIncomplete, ConnectionInRoll, ConnectionInTopologyUpgrade, ConnectionInTestAccess, ConnectionInLoopback, TopologyUpgradeNotAllowed, PathInUse {
        return null;
    }

    public boolean inConnectionConversion() {
        return false;
    }

    public boolean isBlsrDri() {
        return false;
    }

    public IConnectionConversionModel getConnectionConversionModel() {
        return null;
    }

    public void changeIntendedType(IConnectionType iConnectionType) throws ConnectionTypeError, ConnectionInRoll, ConnectionInTestAccess, ConnectionInLoopback, ConnectionInTopologyUpgrade {
    }

    public void setCircuitId(ICircuitId iCircuitId) {
    }
}

