/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.model.DataTransfer;
import cerent.cms.model.NodeModelDelegate;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobProgressControl;
import cerent.util.job.JobStatus;

public class DataTransferJob
implements IJobControl {
    protected NodeModelDelegate nodeModel;
    protected String fileName;
    protected IJobProgressControl observer;
    protected int operation;
    private DataTransfer dataTransfer;
    protected String operationName;
    protected String errorMessage;

    public DataTransferJob(NodeModelDelegate nodeModelDelegate, String string, int n, IJobProgressControl iJobProgressControl) {
        this.nodeModel = nodeModelDelegate;
        this.fileName = string;
        this.observer = iJobProgressControl;
        this.operation = n;
        this.dataTransfer = null;
        this.errorMessage = null;
        this.operationName = n == 2 ? "Restore Database" : (n == 8 ? "Restore Complete Database" : "Software Upgrade");
    }

    public String getName() {
        return this.nodeModel.getHostName() + " - data transfer";
    }

    public JobStatus executeJob() {
        this.dataTransfer = new DataTransfer(this.nodeModel, this.fileName, this.operation, this.observer);
        this.dataTransfer.start();
        if (this.dataTransfer.aborted()) {
            return new JobStatus(3, (Object)new Exception("Cancelled by user"));
        }
        if (this.dataTransfer.failed()) {
            this.errorMessage = this.dataTransfer.getErrorMessage();
            return new JobStatus(2, (Object)new Exception(this.errorMessage));
        }
        return new JobStatus(4);
    }

    public void abortJob() {
        if (this.dataTransfer != null) {
            this.dataTransfer.abort();
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean isAuthorizationFailure() {
        boolean bl = this.dataTransfer != null ? this.dataTransfer.isAuthorizationFailure() : false;
        return bl;
    }
}

