/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.eAdminState;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.eTrafficDirection;
import cerent.cms.idl.Ds123Media.General;
import cerent.cms.idl.Ds123Media.eAttRequestType;
import cerent.cms.idl.Ds123Media.eBertMode;
import cerent.cms.idl.Ds123Media.eClockSource;
import cerent.cms.idl.Ds123Media.eErrorRate;
import cerent.cms.idl.Ds123Media.eLineCoding;
import cerent.cms.idl.Ds123Media.eLineType;
import cerent.cms.idl.Ds123Media.eSaBit;
import cerent.cms.idl.Ds123Media.eSendCode;
import cerent.cms.idl.Ds123Media.eSignalMode;
import cerent.cms.idl.Ds123Media.eStatsType;
import cerent.cms.idl.Ds123Media.eThresholdType;
import cerent.cms.idl.Ds123Media.eTrafficPattern;
import cerent.cms.idl.Ds123Media.portBertConfig;
import cerent.cms.idl.Ds123Media.portBertErrorInfo;
import cerent.cms.idl.Ds123Media.sConfig;
import cerent.cms.idl.Ds123Media.sDs123Attributes;
import cerent.cms.idl.Ds123Media.sInfo;
import cerent.cms.idl.Ds123Media.sNetworkPmPathStats;
import cerent.cms.idl.Ds123Media.sNetworkPmPathStatsHolder;
import cerent.cms.idl.Ds123Media.sNetworkPmPathThresholds;
import cerent.cms.idl.Ds123Media.sNetworkPmPathThresholdsHolder;
import cerent.cms.idl.Ds123Media.sStats;
import cerent.cms.idl.Ds123Media.sStatsHolder;
import cerent.cms.idl.Ds123Media.sStatsListHolder;
import cerent.cms.idl.Ds123Media.sThresholds;
import cerent.cms.idl.Ds123Media.sThresholdsHolder;
import cerent.cms.idl.Ds123Media.xBusy;
import cerent.cms.idl.Ds123Media.xConfigError;
import cerent.cms.idl.Ds123Media.xNotATT54016Mode;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.If.eLoopback;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xInvalidState;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.idl.Synchronization.Sync;
import cerent.cms.model.AbstractPersistableModelState;
import cerent.cms.model.AdminState;
import cerent.cms.model.Busy;
import cerent.cms.model.CachedValue;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds123LineInterfaceAttrs;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EntityModel;
import cerent.cms.model.IAdminLineAccess;
import cerent.cms.model.IDs123LineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.InvalidState;
import cerent.cms.model.LoopbackActive;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.NotATT54016Mode;
import cerent.cms.model.PoolModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.nedefaults.NeDefaultsModel;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import org.omg.CORBA.UserException;

public class Ds123LineModel
extends InterfaceModel
implements IDs123LineModel,
IAdminLineAccess {
    private Status status;
    private PmThresholds pmThresholds;
    private PmPathThresholds pmPathThresholds;
    private PmCPBitThresholds pmCPBitThresholds;
    private NetworkPmPathThresholds networkPmPathThresholds;
    protected Stats stats;
    private Att54016Stats att54016Stats;
    private NetworkPmPathStats networkPmPathStats;
    private AbstractPersistableModelState attrs;
    private ErrorCount errorCount;
    private ErrorRate errorRate;
    private SyncStatus syncStatus;
    private InjectErrors injectErrors;

    public Ds123LineModel(NodeModelDelegate nodeModelDelegate, int n) {
        this(nodeModelDelegate, n, (sInterface)null);
    }

    public Ds123LineModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2) {
        super(nodeModelDelegate, n, sInterface2, nodeModelDelegate.getChildDebug(Ds123LineModel.class));
        this.status = new Status(nodeModelDelegate, "Ds123LineModel.status");
        this.pmThresholds = new PmThresholds(nodeModelDelegate, "Ds123LineModel.pmThresholds");
        this.pmPathThresholds = new PmPathThresholds(nodeModelDelegate, "Ds123LineModel.pmPathThresholds");
        this.pmCPBitThresholds = new PmCPBitThresholds(nodeModelDelegate, "Ds123LineModel.pmCPBitThresholds");
        this.networkPmPathThresholds = new NetworkPmPathThresholds(nodeModelDelegate, "Ds123LineModel.networkPmPathThresholds");
        this.stats = new Stats(nodeModelDelegate, "Ds123LineModel.stats");
        this.att54016Stats = new Att54016Stats(nodeModelDelegate, "Ds123LineModel.att54016Stats");
        this.networkPmPathStats = new NetworkPmPathStats(nodeModelDelegate, "Ds123LineModel.networkPmPathStats");
        this.errorCount = new ErrorCount(nodeModelDelegate, "Ds123LineModel.errorCount");
        this.errorRate = new ErrorRate(nodeModelDelegate, "Ds123LineModel.errorRate");
        this.syncStatus = new SyncStatus(nodeModelDelegate, "Ds123LineModel.syncStatus");
        this.injectErrors = new InjectErrors(nodeModelDelegate, "Ds123LineModel.injectErrors");
    }

    public void setAttributes(sDs123Attributes sDs123Attributes2, long l) {
        super.setAttributes(sDs123Attributes2.base, l);
        this.getLoopbackCV().setValueExternally(sDs123Attributes2.loopback, l);
        this.getInhibitedLoopbackCV().setValueExternally(new Boolean(sDs123Attributes2.inhibitedLoopback), l);
        this.getSendCodeCV().setValueExternally(sDs123Attributes2.sendCode, l);
        this.getDs123InfoCV().setValueExternally(sDs123Attributes2.info, l);
        this.getConfigCV().setValueExternally(sDs123Attributes2.config, l);
        this.getDs1MappingCV().setValueExternally(sDs123Attributes2.ds1Mapping, l);
    }

    public void setAttributes(sDs123Attributes sDs123Attributes2) {
        this.setAttributes(sDs123Attributes2, -1L);
    }

    public void dispose() {
        this.dispose(this.getModelType(this._getPersistType()));
        super.dispose();
    }

    public void destroy() {
        int n = this.getModelType(this._getPersistType());
        super.destroy();
        this.destroy(n);
    }

    public void clearStats(boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, eTrafficDirection.DIR_RX};
            this.stats.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (cerent.cms.idl.If.xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearStats", userException);
        }
    }

    public void clearNetworkPmPathStats(eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation {
        try {
            Object[] objectArray = new Object[]{eIntervalType2};
            this.networkPmPathStats.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (cerent.cms.idl.If.xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearNetworkPmPathStats", userException);
        }
    }

    public static String[] getClockSourceStrings() {
        return EnumStrings.getStrings(eClockSource.class);
    }

    public static String[] getLineCodingStrings() {
        return EnumStrings.getStrings(eLineCoding.class);
    }

    public static String[] getLineTypeStrings() {
        return EnumStrings.getStrings(eLineType.class);
    }

    CachedValue getBERTConfigCV() {
        return this.getDs123LineInterfaceAttrs().getBERT();
    }

    public static String[] getSignalModeStrings() {
        return EnumStrings.getStrings(eSignalMode.class);
    }

    public eLineType getReceivedFrameFormat() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            return (eLineType)this.getReceivedFrameFormatCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getReceivedFrameFormat", userException);
        }
    }

    public eLoopback getLoopback() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (eLoopback)this.getLoopbackCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getLoopback", userException);
        }
    }

    public void setLoopback(eLoopback eLoopback2) throws WrongInterfaceType, NoSuchInterface, InvalidState, UnsupportedOperation, Busy {
        try {
            this.getLoopbackCV().set(eLoopback2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInvalidState xInvalidState2) {
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setLoopback", userException);
        }
    }

    public boolean getInhibitLoopback() {
        try {
            return (Boolean)this.getInhibitedLoopbackCV().get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getInhibitLoopback", userException);
        }
    }

    public void setInhibitLoopback(boolean bl) throws UnsupportedOperation {
        try {
            this.getInhibitedLoopbackCV().set(new Boolean(bl));
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setInhibitLoopback", userException);
        }
    }

    public boolean getInhibitBackplaneLoopback() {
        try {
            return (Boolean)this.getInhibitedBackplaneLoopbackCV().get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getInhibitBackplaneLoopback", userException);
        }
    }

    public void setInhibitBackplaneLoopback(boolean bl) throws UnsupportedOperation {
        try {
            this.getInhibitedBackplaneLoopbackCV().set(new Boolean(bl));
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setInhibitBackplaneLoopback", userException);
        }
    }

    public eSendCode getSendCode() {
        try {
            return (eSendCode)this.getSendCodeCV().get();
        }
        catch (UserException userException) {
            throw this.doUnknown("getSendCode", userException);
        }
    }

    public void setSendCode(eSendCode eSendCode2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, InvalidState, Busy, EMCProvisionError {
        try {
            this.getSendCodeCV().set(eSendCode2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xInvalidState xInvalidState2) {
            throw new InvalidState((UserException)xInvalidState2);
        }
        catch (xBusy xBusy2) {
            throw new Busy((UserException)xBusy2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setSendCode", userException);
        }
    }

    public eSaBit getE1SaBit() throws WrongInterfaceType, UnsupportedOperation, NoSuchInterface {
        try {
            return (eSaBit)this.getE1SaBitCV().get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getE1SaBit", userException);
        }
    }

    public void setE1SaBit(eSaBit eSaBit2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError {
        try {
            this.getE1SaBitCV().set(eSaBit2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (cerent.cms.idl.If.xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setE1SaBit", userException);
        }
    }

    public int getLineStatus() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Integer)this.status.get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getLineStatus", userException);
        }
    }

    public sInfo getDs123Info() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sInfo)this.getDs123InfoCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getDs123Info", userException);
        }
    }

    public sConfig getConfig() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (sConfig)this.getConfigCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getConfig", userException);
        }
    }

    public void setConfig(sConfig sConfig2) throws ConfigError, NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        if (this.db.on) {
            this.debugConfig("setConfig(" + this.getIndex() + ")", sConfig2);
        }
        try {
            this.getConfigCV().set(sConfig2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setConfig", userException);
        }
    }

    public void setPmThresholds(boolean bl, eThresholdType eThresholdType2, sThresholds sThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError, UnsupportedOperation {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eThresholdType2, sThresholds2};
            this.pmThresholds.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (cerent.cms.idl.If.xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setPmThresholds", userException);
        }
    }

    public sThresholds getPmThresholds(boolean bl, eThresholdType eThresholdType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eThresholdType2};
            return (sThresholds)this.pmThresholds.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPmThresholds", userException);
        }
    }

    public void setPmPathThresholds(boolean bl, eThresholdType eThresholdType2, sThresholds sThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError, UnsupportedOperation {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eThresholdType2, sThresholds2};
            this.pmPathThresholds.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (cerent.cms.idl.If.xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setPmPathThresholds", userException);
        }
    }

    public sThresholds getPmPathThresholds(boolean bl, eThresholdType eThresholdType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eThresholdType2};
            return (sThresholds)this.pmPathThresholds.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPmPathThresholds", userException);
        }
    }

    public void setPmCPBitThresholds(boolean bl, eThresholdType eThresholdType2, sThresholds sThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError, UnsupportedOperation {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eThresholdType2, sThresholds2};
            this.pmCPBitThresholds.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (cerent.cms.idl.If.xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setPmCPBitThresholds", userException);
        }
    }

    public sThresholds getPmCPBitThresholds(boolean bl, eThresholdType eThresholdType2) throws NoSuchInterface, WrongInterfaceType {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eThresholdType2};
            return (sThresholds)this.pmCPBitThresholds.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getPmCPBitThresholds", userException);
        }
    }

    public void setNetworkPmPathThresholds(eThresholdType eThresholdType2, sNetworkPmPathThresholds sNetworkPmPathThresholds2) throws NoSuchInterface, WrongInterfaceType, ConfigError, UnsupportedOperation {
        try {
            Object[] objectArray = new Object[]{eThresholdType2, sNetworkPmPathThresholds2};
            this.networkPmPathThresholds.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (cerent.cms.idl.If.xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setNetworkPmPathThresholds", userException);
        }
    }

    public sNetworkPmPathThresholds getNetworkPmPathThresholds(eThresholdType eThresholdType2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            Object[] objectArray = new Object[]{eThresholdType2};
            return (sNetworkPmPathThresholds)this.networkPmPathThresholds.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getNetworkPmPathThresholds", userException);
        }
    }

    public sStats getStats(boolean bl, eIntervalType eIntervalType2, short s, eStatsType eStatsType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, new Short(s), eStatsType2};
            return (sStats)this.stats.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getStats", userException);
        }
    }

    public sStats[] getAtt54016Stats(eAttRequestType eAttRequestType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError, NotATT54016Mode, UnsupportedOperation, ConfigError {
        try {
            return (sStats[])this.att54016Stats.get(eAttRequestType2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (xNotATT54016Mode xNotATT54016Mode2) {
            throw new NotATT54016Mode((UserException)xNotATT54016Mode2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (cerent.cms.idl.If.xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getAtt54016Stats", userException);
        }
    }

    public sNetworkPmPathStats getNetworkPmPathStats(eIntervalType eIntervalType2, short s) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{eIntervalType2, new Short(s)};
            return (sNetworkPmPathStats)this.networkPmPathStats.get(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getNetworkPmPathStats", userException);
        }
    }

    public short getSdBerLevel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Short)this.getSdBerLevelCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSdBerLevel", userException);
        }
    }

    public void setSdBerLevel(short s) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            this.getSdBerLevelCV().set(new Short(s));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSdBerLevel", userException);
        }
    }

    public short getSfBerLevel() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Short)this.getSfBerLevelCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSfBerLevel", userException);
        }
    }

    public void setSfBerLevel(short s) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation {
        try {
            this.getSfBerLevelCV().set(new Short(s));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSfBerLevel", userException);
        }
    }

    private void debugConfig(String string, sConfig sConfig2) {
        this.db.println(string + " --- sConfig ----");
        this.db.println("| clock source = " + EnumStrings.getStrings(eClockSource.class)[sConfig2.clockSource.value()]);
        this.db.println("| line type = " + EnumStrings.getStrings(eLineType.class)[sConfig2.lineType.value()]);
        this.db.println("| line coding = " + EnumStrings.getStrings(eLineCoding.class)[sConfig2.lineCoding.value()]);
        this.db.println("| signal mode = " + EnumStrings.getStrings(eSignalMode.class)[sConfig2.signalMode.value()]);
        this.db.println("| line length" + sConfig2.lineLength);
        this.db.println("| FDL mode mask" + sConfig2.fdlModeMask);
        this.db.println("---------------\n");
    }

    public List getConnectionsList() {
        PoolModel poolModel = (PoolModel)this.getNodeModelDelegate().getPoolModels().getPoolModel(this.getIndex());
        if (poolModel != null) {
            List list = poolModel.getConnectionsList();
            if (this.db.on()) {
                this.db.println("DS123 ConnectionsList: " + list.size() + "(size), " + list);
            }
            return list;
        }
        return new LinkedList();
    }

    protected void updateLocal(long l) {
        this.getDs123LineInterfaceAttrs().update(l);
        super.updateLocal(l);
    }

    public int getLoopbackAsInt() {
        int n = 0;
        try {
            n = this.getLoopback().value();
        }
        catch (Exception exception) {
            this.db.println("Ignoring Exceptions and returning ILoopback.NO_LOOPBACK");
        }
        return n;
    }

    public void setAdminStateNoLpbk(eAdminState eAdminState2) throws NoSuchInterface, UnsupportedOperation, WrongInterfaceType, LoopbackActive, InvalidState, SyncProvError, Busy, ProvisionError {
        if (this.getLoopbackAsInt() != 0 && !AdminState.admitsLoopback(eAdminState2) && this.getLoopbackAsInt() != 5 && this.getLoopbackAsInt() != 6) {
            this.setLoopback(eLoopback.NO_LOOPBACK);
        }
        this.setAdminState(eAdminState2);
    }

    General getDs123Ref() {
        return this.getNodeModelDelegate().getIorRepository().getDs123Ref();
    }

    Sync getSynchronizationRef() {
        return this.getNodeModelDelegate().getIorRepository().getSynchronizationRef();
    }

    CachedValue getReceivedFrameFormatCV() {
        return this.getDs123LineInterfaceAttrs().getReceivedFrameFormat();
    }

    CachedValue getLoopbackCV() {
        return this.getDs123LineInterfaceAttrs().getLoopback();
    }

    CachedValue getInhibitedLoopbackCV() {
        return this.getDs123LineInterfaceAttrs().getInhibitedLoopback();
    }

    CachedValue getInhibitedBackplaneLoopbackCV() {
        return this.getDs123LineInterfaceAttrs().getInhibitedBackplaneLoopback();
    }

    CachedValue getSendCodeCV() {
        return this.getDs123LineInterfaceAttrs().getSendCode();
    }

    CachedValue getDs123InfoCV() {
        return this.getDs123LineInterfaceAttrs().getDs123Info();
    }

    CachedValue getConfigCV() {
        return this.getDs123LineInterfaceAttrs().getConfig();
    }

    CachedValue getSdBerLevelCV() {
        return this.getDs123LineInterfaceAttrs().getSdBerLevel();
    }

    CachedValue getSfBerLevelCV() {
        return this.getDs123LineInterfaceAttrs().getSfBerLevel();
    }

    CachedValue getSyncConfigCV() {
        return this.getDs123LineInterfaceAttrs().getSyncConfig();
    }

    CachedValue getSndAISVForDs1AISEnabledCV() {
        return this.getDs123LineInterfaceAttrs().getSndAISVForDs1AISEnabled();
    }

    CachedValue getRaiseDs1AISForLOFEnabledCV() {
        return this.getDs123LineInterfaceAttrs().getRaiseDs1AISForLOFEnabled();
    }

    CachedValue getDs1RetimingEnabledCV() {
        return this.getDs123LineInterfaceAttrs().getDs1RetimingEnabled();
    }

    CachedValue getDs1MappingCV() {
        return this.getDs123LineInterfaceAttrs().getDs1Mapping();
    }

    CachedValue getE1SaBitCV() {
        return this.getDs123LineInterfaceAttrs().getE1SaBit();
    }

    private static Class _me() {
        return Ds123LineModel.class;
    }

    private static Class _state() {
        return Ds123LineInterfaceAttrs.class;
    }

    private int _getPersistType() {
        return Ds123LineInterfaceAttrs.getCookie();
    }

    private Ds123LineInterfaceAttrs getDs123LineInterfaceAttrs() {
        int n = this._getPersistType();
        return (Ds123LineInterfaceAttrs)this.retrieveAttrs(this.getModelType(n), n);
    }

    public static Field[] getAttrFields(Class clazz) {
        return Ds123LineModel.getAttrsFields(clazz, Ds123LineModel._me(), Ds123LineModel._state());
    }

    protected AbstractPersistableModelState getAttrsField(int n) {
        return n == this._getPersistType() ? this.attrs : super.getAttrsField(n);
    }

    public int getAttrFieldsInMemory(int n) {
        boolean bl;
        boolean bl2 = bl = this.attrs != null;
        if (bl) {
            n |= 1 << this._getPersistType();
        }
        n |= super.getAttrFieldsInMemory(n);
        return n;
    }

    protected void setAttrsField(AbstractPersistableModelState abstractPersistableModelState, int n) {
        if (n == this._getPersistType() || abstractPersistableModelState instanceof Ds123LineInterfaceAttrs) {
            this.attrs = abstractPersistableModelState;
        } else if (n == -1 && abstractPersistableModelState == null) {
            if (this.attrs != null) {
                this.attrs.linkModel(null);
            }
            this.attrs = abstractPersistableModelState;
            super.setAttrsField(abstractPersistableModelState, n);
        } else {
            super.setAttrsField(abstractPersistableModelState, n);
        }
    }

    protected AbstractPersistableModelState createInitialStateValue(int n) {
        if (n == -1 || n == this._getPersistType()) {
            return this.createInitialStateValue(Ds123LineModel._state());
        }
        return super.createInitialStateValue(n);
    }

    void allAttributesIndicateWriteAccess(long l) {
        this.getDs123LineInterfaceAttrs().indicateWriteAccess(l);
        super.allAttributesIndicateWriteAccess(l);
    }

    public sNetworkPmPathThresholds getDefaultNetworkPmPathThresholds(eThresholdType eThresholdType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefNetworkPmPathThr(eEqType2, eEqType3, eThresholdType2);
    }

    public sThresholds getDefaultPmCPBitThresholds(boolean bl, eThresholdType eThresholdType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefPmCPBitThr(eEqType2, eEqType3, bl, eThresholdType2);
    }

    public sThresholds getDefaultPmPathThresholds(boolean bl, eThresholdType eThresholdType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefPmPathThr(eEqType2, eEqType3, bl, eThresholdType2);
    }

    public sThresholds getDefaultPmThresholds(boolean bl, eThresholdType eThresholdType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefPmThr(eEqType2, eEqType3, bl, eThresholdType2);
    }

    public sThresholds[] getDefaultDs3xmPmPathThresholds(boolean bl, eThresholdType eThresholdType2, NeDefaultsModel neDefaultsModel) throws Exception {
        eEqType eEqType2 = this.getModuleModel().getEqTypeEnum();
        IPortModel iPortModel = this.getPortModel();
        eEqType eEqType3 = ((EntityModel)iPortModel).getEqTypeEnum();
        return neDefaultsModel.getDefDs3xmPmPathThr(eEqType2, eEqType3, bl, eThresholdType2);
    }

    public portBertConfig getBERTConfig() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, EMCProvisionError {
        try {
            return (portBertConfig)this.getBERTConfigCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getBERTConfig", userException);
        }
    }

    public int getBERTMode() {
        int n;
        portBertConfig portBertConfig2;
        block3: {
            portBertConfig2 = null;
            n = 0;
            try {
                portBertConfig2 = this.getBERTConfig();
            }
            catch (Exception exception) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (portBertConfig2 != null) {
            n = portBertConfig2.mode.value();
        }
        return n;
    }

    public void setBERT(eBertMode eBertMode2, eTrafficPattern eTrafficPattern2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, EMCProvisionError {
        try {
            Object[] objectArray = new Object[]{eBertMode2, eTrafficPattern2};
            this.getBERTConfigCV().set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("setBERT", userException);
        }
    }

    public long getErrorCount() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, EMCProvisionError {
        try {
            long l = (Long)this.errorCount.get();
            return l;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getErrorCount", userException);
        }
    }

    public int getErrorRate() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, EMCProvisionError {
        try {
            int n = (Integer)this.errorRate.get();
            return n;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getErrorCount", userException);
        }
    }

    public void clearErrorCount() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, EMCProvisionError, InternalCommError {
        try {
            this.errorCount.set();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("clearErrorCount", userException);
        }
    }

    public boolean getSyncStatus() throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, EMCProvisionError {
        try {
            boolean bl = (Boolean)this.syncStatus.get();
            return bl;
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("getSyncStatus", userException);
        }
    }

    public void injectError(eErrorRate eErrorRate2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, EMCProvisionError {
        try {
            this.injectErrors.set(eErrorRate2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (UserException userException) {
            throw this.doUnknown("injectError", userException);
        }
    }

    protected class Att54016Stats
    extends NonCachedValue {
        public Att54016Stats(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xUnsupportedOperation, xInternalCommError, xNotATT54016Mode, cerent.cms.idl.If.xConfigError {
            sStatsListHolder sStatsListHolder2 = new sStatsListHolder();
            Ds123LineModel.this.getDs123Ref().get54016Stats(Ds123LineModel.this.getIndex(), (eAttRequestType)object, sStatsListHolder2);
            return sStatsListHolder2.value;
        }

        public Object outer() {
            return Ds123LineModel.this;
        }
    }

    private class ErrorCount
    extends NonCachedValue {
        public ErrorCount(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType, xUnsupportedOperation, xProvisionError, xInternalCommError {
            portBertErrorInfo portBertErrorInfo2 = Ds123LineModel.this.getDs123Ref().getMonErrors(Ds123LineModel.this.getIndex());
            return new Long(portBertErrorInfo2.errorCount);
        }

        protected void setValue() throws xNoSuchInterface, xWrongInterfaceType, xUnsupportedOperation, xProvisionError, xInternalCommError {
            Ds123LineModel.this.getDs123Ref().clearBertErrorCount(Ds123LineModel.this.getIndex());
        }

        public Object outer() {
            return Ds123LineModel.this;
        }
    }

    private class ErrorRate
    extends NonCachedValue {
        public ErrorRate(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType, xUnsupportedOperation, xProvisionError, xInternalCommError {
            portBertErrorInfo portBertErrorInfo2 = Ds123LineModel.this.getDs123Ref().getMonErrors(Ds123LineModel.this.getIndex());
            return new Integer(portBertErrorInfo2.errorRate.value());
        }
    }

    private class InjectErrors
    extends NonCachedValue {
        public InjectErrors(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xUnsupportedOperation, xProvisionError {
            eErrorRate eErrorRate2 = (eErrorRate)object;
            Ds123LineModel.this.getDs123Ref().injectError(Ds123LineModel.this.getIndex(), eErrorRate2);
        }

        public Object outer() {
            return Ds123LineModel.this;
        }
    }

    protected class NetworkPmPathStats
    extends NonCachedValue {
        public NetworkPmPathStats(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xInternalCommError, cerent.cms.idl.If.xConfigError, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            Ds123LineModel.this.getDs123Ref().clearNetworkPmPathStats(Ds123LineModel.this.getIndex(), (eIntervalType)objectArray[0]);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xInternalCommError, xProvisionError {
            sNetworkPmPathStatsHolder sNetworkPmPathStatsHolder2 = new sNetworkPmPathStatsHolder();
            Object[] objectArray = (Object[])object;
            Ds123LineModel.this.getDs123Ref().getNetworkPmPathStats(Ds123LineModel.this.getIndex(), (eIntervalType)objectArray[0], (Short)objectArray[1], sNetworkPmPathStatsHolder2);
            return sNetworkPmPathStatsHolder2.value;
        }

        public Object outer() {
            return Ds123LineModel.this;
        }
    }

    private class NetworkPmPathThresholds
    extends NonCachedValue {
        public NetworkPmPathThresholds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            sNetworkPmPathThresholdsHolder sNetworkPmPathThresholdsHolder2 = new sNetworkPmPathThresholdsHolder();
            Ds123LineModel.this.getDs123Ref().getNetworkPmPathThresholds(Ds123LineModel.this.getIndex(), (eThresholdType)objectArray[0], sNetworkPmPathThresholdsHolder2);
            return sNetworkPmPathThresholdsHolder2.value;
        }

        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, cerent.cms.idl.If.xConfigError, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            Ds123LineModel.this.getDs123Ref().setNetworkPmPathThresholds(Ds123LineModel.this.getIndex(), (eThresholdType)objectArray[0], (sNetworkPmPathThresholds)objectArray[1]);
        }

        public Object outer() {
            return Ds123LineModel.this;
        }
    }

    private class PmCPBitThresholds
    extends NonCachedValue {
        public PmCPBitThresholds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xWrongInterfaceType {
            sThresholdsHolder sThresholdsHolder2 = new sThresholdsHolder();
            Object[] objectArray = (Object[])object;
            Ds123LineModel.this.getDs123Ref().getPmCPBitThresholds(Ds123LineModel.this.getIndex(), (Boolean)objectArray[0], (eThresholdType)objectArray[1], sThresholdsHolder2);
            return sThresholdsHolder2.value;
        }

        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, cerent.cms.idl.If.xConfigError, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            Ds123LineModel.this.getDs123Ref().setPmCPBitThresholds(Ds123LineModel.this.getIndex(), (Boolean)objectArray[0], (eThresholdType)objectArray[1], (sThresholds)objectArray[2]);
        }

        public Object outer() {
            return Ds123LineModel.this;
        }
    }

    private class PmPathThresholds
    extends NonCachedValue {
        public PmPathThresholds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xWrongInterfaceType {
            sThresholdsHolder sThresholdsHolder2 = new sThresholdsHolder();
            Object[] objectArray = (Object[])object;
            Ds123LineModel.this.getDs123Ref().getPmPathThresholds(Ds123LineModel.this.getIndex(), (Boolean)objectArray[0], (eThresholdType)objectArray[1], sThresholdsHolder2);
            return sThresholdsHolder2.value;
        }

        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, cerent.cms.idl.If.xConfigError, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            Ds123LineModel.this.getDs123Ref().setPmPathThresholds(Ds123LineModel.this.getIndex(), (Boolean)objectArray[0], (eThresholdType)objectArray[1], (sThresholds)objectArray[2]);
        }

        public Object outer() {
            return Ds123LineModel.this;
        }
    }

    private class PmThresholds
    extends NonCachedValue {
        public PmThresholds(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xWrongInterfaceType {
            sThresholdsHolder sThresholdsHolder2 = new sThresholdsHolder();
            Object[] objectArray = (Object[])object;
            Ds123LineModel.this.getDs123Ref().getPmThresholds(Ds123LineModel.this.getIndex(), (Boolean)objectArray[0], (eThresholdType)objectArray[1], sThresholdsHolder2);
            return sThresholdsHolder2.value;
        }

        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, cerent.cms.idl.If.xConfigError, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            Ds123LineModel.this.getDs123Ref().setPmThresholds(Ds123LineModel.this.getIndex(), (Boolean)objectArray[0], (eThresholdType)objectArray[1], (sThresholds)objectArray[2]);
        }

        public Object outer() {
            return Ds123LineModel.this;
        }
    }

    protected class Stats
    extends NonCachedValue {
        public Stats(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xProvisionError, xInternalCommError, cerent.cms.idl.If.xConfigError, xUnsupportedOperation {
            Object[] objectArray = (Object[])object;
            Ds123LineModel.this.getDs123Ref().clearStats(Ds123LineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], (eTrafficDirection)objectArray[2]);
        }

        protected Object getValue(Object object) throws xNoSuchInterface, xWrongInterfaceType, xInternalCommError, xProvisionError {
            sStatsHolder sStatsHolder2 = new sStatsHolder();
            Object[] objectArray = (Object[])object;
            Ds123LineModel.this.getDs123Ref().getStats(Ds123LineModel.this.getIndex(), (Boolean)objectArray[0], (eIntervalType)objectArray[1], (Short)objectArray[2], (eStatsType)objectArray[3], sStatsHolder2);
            return sStatsHolder2.value;
        }

        public Object outer() {
            return Ds123LineModel.this;
        }
    }

    private class Status
    extends NonCachedValue {
        public Status(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType {
            return new Integer(Ds123LineModel.this.getDs123Ref().getStatus(Ds123LineModel.this.getIndex()));
        }

        public Object outer() {
            return Ds123LineModel.this;
        }
    }

    private class SyncStatus
    extends NonCachedValue {
        public SyncStatus(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws xNoSuchInterface, xWrongInterfaceType, xUnsupportedOperation, xProvisionError {
            return new Boolean(Ds123LineModel.this.getDs123Ref().getSyncStatus(Ds123LineModel.this.getIndex()));
        }

        public Object outer() {
            return Ds123LineModel.this;
        }
    }
}

