/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Common.eIntervalType;
import cerent.cms.idl.Common.eTrafficDirection;
import cerent.cms.idl.Ds123Media.eDs1Mapping;
import cerent.cms.idl.Ds123Media.xBusy;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.idl.If.sInterface;
import cerent.cms.idl.If.sLineSyncConfig;
import cerent.cms.idl.If.xConfigError;
import cerent.cms.idl.If.xInternalCommError;
import cerent.cms.idl.If.xNoSuchInterface;
import cerent.cms.idl.If.xSyncProvBusy;
import cerent.cms.idl.If.xUnsupportedOperation;
import cerent.cms.idl.If.xWrongInterfaceType;
import cerent.cms.idl.OnsError.xProvisionError;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Busy;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConfigError;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.EMCProvisionError;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ModuleModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PoolModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.RanSvcModuleModel;
import cerent.cms.model.SyncProvError;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.ComparisonUtil;
import cerent.util.EID;
import cerent.util.EMC;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class Ds1LineModel
extends Ds123LineModel {
    private EventDispatcher dispatcher;

    public Ds1LineModel(NodeModelDelegate nodeModelDelegate, int n) {
        super(nodeModelDelegate, n);
        this.init();
    }

    public Ds1LineModel(NodeModelDelegate nodeModelDelegate, int n, sInterface sInterface2) {
        super(nodeModelDelegate, n, sInterface2);
        this.init();
    }

    private void init() {
        block3: {
            this.dispatcher = this.node.getDispatcher();
            try {
                int n;
                if (this.dispatcher != null && ((n = this.getModuleModel().getEqType()) == 218 || n == 233 || n == 234 || n == 157)) {
                    this.dispatcher.addObserver(ObjectType.ObjectSync, this.getIfIndex(), (Observer)this);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block3;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
    }

    public List getConnectionsList() {
        Object object;
        PoolModel poolModel;
        ModuleModel moduleModel;
        PortModel portModel;
        block13: {
            portModel = null;
            moduleModel = null;
            poolModel = null;
            try {
                portModel = (PortModel)this.getPortModel();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!this.db.on()) break block13;
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
        }
        if (portModel != null) {
            moduleModel = (ModuleModel)portModel.getModuleModel();
        }
        if (moduleModel != null) {
            object = this.getNodeModelDelegate();
            if (moduleModel.isComboModule() || moduleModel instanceof RanSvcModuleModel) {
                int n;
                Iterator iterator;
                int n2 = portModel.getIndex();
                eEqType eEqType2 = portModel.getEqTypeEnum();
                List list = moduleModel.getDescendantsOfType(eEqType2);
                if (list != null && (iterator = list.iterator()).hasNext()) {
                    n2 = ((PortModel)iterator.next()).getIndex();
                    while (iterator.hasNext()) {
                        n = ((PortModel)iterator.next()).getIndex();
                        if (ComparisonUtil.compare((int)n, (int)n2) >= 0) continue;
                        n2 = n;
                    }
                }
                int n3 = portModel.getIndex();
                if ((n = (n3 -= (n3 - n2) % 7) - 28) < n2) {
                    n = n2;
                }
                while (poolModel == null && n3 >= n) {
                    poolModel = (PoolModel)((NodeModelDelegate)object).getPoolModels().getPoolModel(n3);
                    n3 -= 7;
                }
                if (poolModel == null) {
                    poolModel = (PoolModel)((NodeModelDelegate)object).getPoolModels().getPoolModel(n2);
                }
            } else {
                int n = moduleModel.getEntityIndex();
                poolModel = (PoolModel)((NodeModelDelegate)object).getPoolModels().getPoolModel(n);
            }
        }
        if (poolModel != null) {
            object = poolModel.getConnectionsList(portModel);
            if (this.db.on()) {
                this.db.println("DS1 ConnectionsList: " + object.size() + "(size), " + object);
            }
            return object;
        }
        return new LinkedList();
    }

    public void clearStats(boolean bl, eIntervalType eIntervalType2) throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        try {
            Object[] objectArray = new Object[]{new Boolean(bl), eIntervalType2, eTrafficDirection.DIR_TXRX};
            this.stats.set(objectArray);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xInternalCommError xInternalCommError2) {
            throw new InternalCommError((UserException)xInternalCommError2);
        }
        catch (UserException userException) {
            this.db.println("Caught UserException in DS1LineModel.clearStats...");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof CmsObservable) {
            if (object instanceof IObjectMessageInfo) {
                IObjectMessageInfo iObjectMessageInfo = (IObjectMessageInfo)object;
                int n = iObjectMessageInfo.getObjectType();
                if (n == 7) {
                    this.getSyncConfigCV().update();
                    this.setChanged();
                    this.notifyObservers(ModelUpdateType.CHANGED);
                } else {
                    super.update(observable, object);
                }
            } else {
                super.update(observable, object);
            }
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectSync, this.getIndex(), (Observer)this);
        }
        super.dispose();
    }

    public sLineSyncConfig getSyncConfig() throws NoSuchInterface, UnsupportedOperation {
        sLineSyncConfig sLineSyncConfig2 = null;
        try {
            sLineSyncConfig2 = (sLineSyncConfig)this.getSyncConfigCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSyncConfig", userException);
        }
        return sLineSyncConfig2;
    }

    public void setSyncConfig(sLineSyncConfig sLineSyncConfig2) throws NoSuchInterface, UnsupportedOperation, EMCProvisionError, SyncProvError {
        try {
            this.getSyncConfigCV().set(sLineSyncConfig2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xProvisionError xProvisionError2) {
            throw new EMCProvisionError(xProvisionError2, this.node.getPlatform());
        }
        catch (xSyncProvBusy xSyncProvBusy2) {
            throw new SyncProvError("Cannot change configuration. The port is used as the system clock source by manual/force switch.");
        }
        catch (UserException userException) {
            throw this.doUnknown("setSyncConfig", userException);
        }
    }

    public boolean getSndAISVForDs1AISEnabled() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Boolean)this.getSndAISVForDs1AISEnabledCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getSndAISVForDs1AISEnabled", userException);
        }
    }

    public boolean getRaiseDs1AISForLOFEnabled() throws NoSuchInterface, WrongInterfaceType {
        try {
            return (Boolean)this.getRaiseDs1AISForLOFEnabledCV().get();
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getRaiseDs1AISForLOFEnabled", userException);
        }
    }

    public boolean getDs1RetimingEnabled() throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType {
        try {
            return (Boolean)this.getDs1RetimingEnabledCV().get();
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getDs1RetimingEnabled", userException);
        }
    }

    public void setDs1RetimingEnabled(boolean bl) throws UnsupportedOperation, NoSuchInterface, WrongInterfaceType, Busy {
        try {
            this.getDs1RetimingEnabledCV().set(new Boolean(bl));
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xBusy xBusy2) {
            throw new Busy(ErrorMsg.getString((EID)EMC.EID_FAIL_RETIMING_PORT_BUSY));
        }
        catch (UserException userException) {
            throw this.doUnknown("setDs1RetimingEnabled", userException);
        }
    }

    public eDs1Mapping getDs1Mapping() throws WrongInterfaceType, UnsupportedOperation, NoSuchInterface {
        try {
            return (eDs1Mapping)this.getDs1MappingCV().get();
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (UserException userException) {
            throw this.doUnknown("getDs1Mapping", userException);
        }
    }

    public void setDs1Mapping(eDs1Mapping eDs1Mapping2) throws NoSuchInterface, WrongInterfaceType, UnsupportedOperation, ConfigError {
        try {
            this.getDs1MappingCV().set(eDs1Mapping2);
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (xUnsupportedOperation xUnsupportedOperation2) {
            throw new UnsupportedOperation((UserException)xUnsupportedOperation2);
        }
        catch (xConfigError xConfigError2) {
            throw new ConfigError((UserException)xConfigError2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setDs1Mapping", userException);
        }
    }

    public void setSndAISVForDs1AISEnabled(boolean bl) throws NoSuchInterface, WrongInterfaceType {
        try {
            this.getSndAISVForDs1AISEnabledCV().set(new Boolean(bl));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setSndAISVForDs1AISEnabled", userException);
        }
    }

    public void setRaiseDs1AISForLOFEnabled(boolean bl) throws NoSuchInterface, WrongInterfaceType {
        try {
            this.getRaiseDs1AISForLOFEnabledCV().set(new Boolean(bl));
        }
        catch (xNoSuchInterface xNoSuchInterface2) {
            throw new NoSuchInterface((UserException)xNoSuchInterface2);
        }
        catch (xWrongInterfaceType xWrongInterfaceType2) {
            throw new WrongInterfaceType((UserException)xWrongInterfaceType2);
        }
        catch (UserException userException) {
            throw this.doUnknown("setRaiseDs1AISForLOFEnabled", userException);
        }
    }
}

