/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Equipment.eClass;
import cerent.cms.idl.Equipment.eEqType;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObjectNotExistException;
import cerent.cms.model.Ds123LineModel;
import cerent.cms.model.Ds123ModuleModel;
import cerent.cms.model.Ds123PortModel;
import cerent.cms.model.IPluggableCarrierModel;
import cerent.cms.model.IPortContainer;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InterfaceModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.PathTraceInfo;
import cerent.cms.model.PimModel;
import cerent.cms.model.PluggableSlotModel;
import cerent.cms.model.PortModel;
import cerent.cms.model.PpmModel;
import cerent.cms.model.TdmLineModel;
import cerent.cms.model.TdmPortModel;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Ds3Ec1ModuleModel
extends Ds123ModuleModel
implements IPortContainer,
IPluggableCarrierModel {
    public Ds3Ec1ModuleModel(NodeModelDelegate nodeModelDelegate, int n, eEqType eEqType2, eClass eClass2, int n2) {
        super(nodeModelDelegate, n, eEqType2, eClass2, n2);
    }

    private PortModel[] toPortArray(List list) {
        return list.toArray(new PortModel[list.size()]);
    }

    private Ds123PortModel[] toDs123PortArray(List list) {
        return list.toArray(new Ds123PortModel[list.size()]);
    }

    private TdmPortModel[] toTdmPortArray(List list) {
        return list.toArray(new TdmPortModel[list.size()]);
    }

    protected PortModel[] getPortModels(eEqType eEqType2) {
        PortModel[] portModelArray = null;
        if (eEqType2 != null) {
            switch (eEqType2.value()) {
                case 32: {
                    portModelArray = this.toDs123PortArray(this.getDescendantsOfType(eEqType2));
                    break;
                }
                case 31: {
                    portModelArray = this.toTdmPortArray(this.getDescendantsOfType(eEqType2));
                    break;
                }
                default: {
                    this.db.println("Could not get ports for DS3/EC1 Card!");
                    if (this.db.on()) {
                        SDebug.printStackTrace((Throwable)new Exception());
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else {
            portModelArray = this.toPortArray(this.getDescendantsOfClassType(7));
        }
        return portModelArray == null ? new PortModel[]{} : portModelArray;
    }

    public Ds123LineModel[] getDs3Lines() {
        return (Ds123LineModel[])this.getLineModels(eEqType.DS3);
    }

    public TdmLineModel[] getEc1Lines() {
        return (TdmLineModel[])this.getLineModels(eEqType.EC1_PORT);
    }

    public IPortContainer getBbeSlot() {
        return this;
    }

    protected InterfaceModel[] getLineModels(eEqType eEqType2) {
        InterfaceModel[] interfaceModelArray = null;
        PortModel[] portModelArray = this.getPortModels(eEqType2);
        if (eEqType2 == null) {
            interfaceModelArray = new InterfaceModel[portModelArray.length];
            for (int i = 0; i < portModelArray.length; ++i) {
                interfaceModelArray[i] = (InterfaceModel)portModelArray[i].getInterfaceModel();
            }
        } else {
            switch (eEqType2.value()) {
                case 32: {
                    if (this.db.on()) {
                        this.db.println("Finding lines for Ds123 ports...");
                    }
                    interfaceModelArray = new Ds123LineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (Ds123LineModel)portModelArray[i].getInterfaceModel();
                    }
                    break;
                }
                case 31: {
                    if (this.db.on()) {
                        this.db.println("Finding lines for Tdm ports...");
                    }
                    interfaceModelArray = new TdmLineModel[portModelArray.length];
                    for (int i = 0; i < portModelArray.length; ++i) {
                        interfaceModelArray[i] = (TdmLineModel)portModelArray[i].getInterfaceModel();
                    }
                    break;
                }
                default: {
                    this.db.println("Could not get lines for DS3/EC1 Card!");
                    if (!this.db.on()) break;
                    SDebug.printStackTrace((Throwable)new Exception());
                }
            }
        }
        return interfaceModelArray == null ? new InterfaceModel[]{} : interfaceModelArray;
    }

    public int getMaxPorts() {
        return 48;
    }

    public eEqType[] getPortTypeList(int n) {
        return new eEqType[]{eEqType.DS3, eEqType.EC1_PORT};
    }

    public boolean isComboModule() {
        return true;
    }

    public boolean allowsPortCreation() {
        return true;
    }

    public boolean allowsPortDeletion() {
        return true;
    }

    public boolean allowsPortEditing() {
        return true;
    }

    public boolean supportsLoopbackAis() {
        return true;
    }

    public boolean supportsTermLoopbackAis(IPortModel iPortModel) {
        return true;
    }

    public boolean supportsAutoTrace() {
        return true;
    }

    public List getContainedPorts() {
        List list = this.getDescendantsOfClassType(7);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                ((PortModel)iterator.next()).getInterfaceModel();
            }
            catch (CmsObjectNotExistException cmsObjectNotExistException) {
                iterator.remove();
            }
        }
        return list;
    }

    public List getAvailablePortNumbers() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List list = this.getDescendantsOfClassType(7);
        for (int i = 1; i <= this.getMaxPorts(); ++i) {
            Iterator iterator = list.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                PortModel portModel = (PortModel)iterator.next();
                if (portModel.getPositionInParent() != i) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            arrayList.add(new Integer(i));
        }
        return arrayList;
    }

    public PluggableSlotModel[] getPimSlots() {
        return new PluggableSlotModel[0];
    }

    public PluggableSlotModel[] getPpmSlots() {
        return new PluggableSlotModel[0];
    }

    public PimModel[] getPimModels() {
        return new PimModel[0];
    }

    public PpmModel[] getPpmModels() {
        return new PpmModel[0];
    }

    public PathTraceInfo[] getJ1PathTraceInfo() throws CTCUserException {
        ArrayList<PathTraceInfo> arrayList = new ArrayList<PathTraceInfo>();
        PathTraceInfo[] pathTraceInfoArray = this.getJ1PathTraceInfo(this.getDs3Lines());
        arrayList.addAll(Arrays.asList(pathTraceInfoArray));
        pathTraceInfoArray = this.getJ1PathTraceInfo(this.getEc1Lines());
        arrayList.addAll(Arrays.asList(pathTraceInfoArray));
        return arrayList.toArray(new PathTraceInfo[arrayList.size()]);
    }
}

