/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Alarm.sAlarmMessage;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.model.AlarmEventQueue;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.EventQueue;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.IObjectType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.ObjectMessageQueue;
import cerent.cms.model.event.AlarmDecoder;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.ElementEventStore;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.EnumStrings;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.KDebug;
import cerent.util.SDebug;
import cerent.util.stats.StatsMgr;
import cerent.util.threadpool.IActionClient;
import cerent.util.threadpool.IThreadWorker;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;

public class EventDispatcher {
    public static final int maxAlrBuff = 100;
    private DispatcherDebug db;
    private ObjectMessageActionClient objectMessageActionClient;
    private AlarmEventActionClient alarmEventActionClient;
    private NodeModelDelegate nodeModel;
    private Map observableList;
    private Map indexLessObservableList;
    private EventUtilities eventUtilities;
    private EventQueue alarmEventQueue;
    private EventQueue objectMessageQueue;
    private ElementAlarmStore alarmStore;
    private ElementEventStore eventStore;
    private static NodeSingletonFactory<EventDispatcher> sfactory = new NodeSingletonFactory<EventDispatcher>(EventDispatcher.class);

    public static EventDispatcher getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private EventDispatcher(NodeModelDelegate nodeModelDelegate) {
        this.nodeModel = nodeModelDelegate;
        this.alarmEventActionClient = null;
        this.objectMessageActionClient = null;
        this.eventUtilities = EventUtilities.getInstance(nodeModelDelegate);
        this.alarmEventQueue = AlarmEventQueue.getInstance(nodeModelDelegate);
        this.objectMessageQueue = ObjectMessageQueue.getInstance(nodeModelDelegate);
        this.observableList = Collections.synchronizedMap(new HashMap(101));
        this.indexLessObservableList = Collections.synchronizedMap(new HashMap(10));
        this.alarmStore = (ElementAlarmStore)this.nodeModel.getElementAlarmStore();
        this.eventStore = (ElementEventStore)this.nodeModel.getElementEventStore();
        this.db = new DispatcherDebug(nodeModelDelegate.getDebug(), "EventDispatcher");
    }

    public synchronized void start() {
        if (this.alarmEventActionClient == null) {
            this.alarmEventActionClient = new AlarmEventActionClient(this, this.nodeModel);
            this.alarmEventQueue.setActionClient(this.alarmEventActionClient);
        }
        if (this.objectMessageActionClient == null) {
            this.objectMessageActionClient = new ObjectMessageActionClient(this, this.nodeModel, this.observableList, this.indexLessObservableList);
            this.objectMessageQueue.setActionClient(this.objectMessageActionClient);
        }
        if (this.db.on()) {
            this.db.println("Dispatcher started");
        }
    }

    public void convertAlarmsToEventInfo(ArrayList arrayList, sAlarmMessage[] sAlarmMessageArray, long l, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        this.eventUtilities.convertAlarmsToEventInfo(arrayList, sAlarmMessageArray, l, bl, bl2, bl3, bl4, bl5);
    }

    private void addObserver(OID oID, Observer observer) {
        int n;
        if (this.db.on()) {
            this.db.println("addObserver: " + oID + ", " + observer);
        }
        CmsObservable cmsObservable = null;
        cmsObservable = (CmsObservable)((Object)this.observableList.get(oID));
        if (cmsObservable == null) {
            cmsObservable = new StatsObservable();
            this.observableList.put(oID, cmsObservable);
        }
        cmsObservable.addObserver(observer);
        if (this.db.on() && (n = cmsObservable.getObservers().size()) > 1) {
            this.db.println("Number of observers = " + n);
            this.db.println("Type = " + EnumStrings.getStrings(ObjectType.class)[oID.getObjectType()]);
            this.db.println("Index = " + oID.getIndex());
            Object[] objectArray = cmsObservable.getObservers().toArray();
            for (int i = 0; i < n; ++i) {
                this.db.println("Class name = " + objectArray[i].getClass().getName());
            }
        }
    }

    public void addObserver(ObjectType objectType, int n, Observer observer) {
        this.addObserver(new OID(objectType, n), observer);
    }

    public void addObserver(int n, int n2, Observer observer) {
        this.addObserver(new OID(n, n2), observer);
    }

    public void addObserver(ObjectType objectType, Observer observer) {
        CmsObservable cmsObservable = null;
        if (this.db.on) {
            this.db.println("addObserver will add the type: " + EnumStrings.getStrings(ObjectType.class)[objectType.value()] + " list of Index Less Observers.");
            this.db.println("The Observer is: " + observer);
        }
        if ((cmsObservable = (CmsObservable)((Object)this.indexLessObservableList.get(objectType))) == null) {
            cmsObservable = new StatsObservable();
            this.indexLessObservableList.put(objectType, cmsObservable);
        }
        cmsObservable.addObserver(observer);
    }

    private void deleteObserver(OID oID, Observer observer) {
        if (this.db.on) {
            this.db.println("deleteObserver: " + oID + ", " + observer);
        }
        CmsObservable cmsObservable = null;
        cmsObservable = (CmsObservable)((Object)this.observableList.get(oID));
        if (cmsObservable != null) {
            cmsObservable.deleteObserver(observer);
            if (cmsObservable.countObservers() == 0) {
                this.observableList.remove(oID);
            }
        }
        if (this.db.on) {
            this.db.println("deleteObserver: Hash table size = " + this.observableList.size());
        }
    }

    public void deleteObserver(ObjectType objectType, int n, Observer observer) {
        this.deleteObserver(new OID(objectType, n), observer);
    }

    public void deleteObserver(int n, int n2, Observer observer) {
        this.deleteObserver(new OID(n, n2), observer);
    }

    public void deleteObserver(ObjectType objectType, Observer observer) {
        CmsObservable cmsObservable = null;
        cmsObservable = (CmsObservable)((Object)this.indexLessObservableList.get(objectType));
        if (cmsObservable != null) {
            cmsObservable.deleteObserver(observer);
            if (cmsObservable.countObservers() == 0) {
                this.indexLessObservableList.remove(objectType);
            }
        }
        if (this.db.on) {
            this.db.println("deleteObserver: Hash table size = " + this.indexLessObservableList.size());
        }
    }

    private void deleteObservers() {
        CmsObservable cmsObservable = null;
        Set set = this.observableList.keySet();
        for (OID oID : set) {
            cmsObservable = (CmsObservable)((Object)this.observableList.get(oID));
            if (cmsObservable == null) continue;
            cmsObservable.deleteObservers();
            this.observableList.remove(oID);
        }
    }

    public void dumpObservables() {
        Set set = this.observableList.keySet();
        this.db.println("----[EventDispatcher] Dump of observableList keys:");
        for (OID oID : set) {
            this.db.println("----[EventDispatcher]     key: " + oID);
        }
        this.db.println("----[EventDispatcher] End of Key Dump ---");
    }

    public synchronized void reset() {
        if (this.alarmEventActionClient != null) {
            this.alarmEventQueue.setActionClient(null);
            this.alarmEventActionClient = null;
            if (this.db.on()) {
                this.db.println("reset(): alarmEventActionClient = null");
            }
        }
        if (this.objectMessageActionClient != null) {
            this.objectMessageQueue.setActionClient(null);
            this.objectMessageActionClient = null;
            if (this.db.on()) {
                this.db.println("reset(): objectMessageActionClient = null");
            }
        }
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose(): entered");
        }
        this.reset();
        if (this.db.on()) {
            this.db.println("dispose(): exited");
        }
    }

    public class AlarmEventActionClient
    implements IActionClient {
        private EventDispatcher theDisp = null;
        private NodeModelDelegate theNode = null;
        private Object acLock = null;
        private boolean destroyed = false;

        AlarmEventActionClient(EventDispatcher eventDispatcher2, NodeModelDelegate nodeModelDelegate) {
            this.theDisp = eventDispatcher2;
            this.theNode = nodeModelDelegate;
            this.acLock = new Object();
            this.destroyed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAction() {
            ArrayList<EventInfo> arrayList = new ArrayList<EventInfo>();
            Object object = this.acLock;
            synchronized (object) {
                while (true) {
                    try {
                        while (true) {
                            Object object2;
                            EventQueue eventQueue = EventDispatcher.this.alarmEventQueue;
                            synchronized (eventQueue) {
                                if (this.destroyed || EventDispatcher.this.alarmEventQueue.size() == 0) {
                                    return;
                                }
                                object2 = EventDispatcher.this.alarmEventQueue.dequeue();
                            }
                            if (object2 == null) {
                                if (EventDispatcher.this.db.on()) {
                                    EventDispatcher.this.db.println("AlarmEventQueue for " + this.theNode.getHostName() + " stopping...");
                                }
                                return;
                            }
                            EventInfo eventInfo = (EventInfo)object2;
                            if (!this.destroyed && ((EventDispatcher)EventDispatcher.this).db.on) {
                                AlarmDecoder alarmDecoder = this.theNode.getAlarmDecoder();
                                EventDispatcher.this.db.println("(EventDisp) (ALM) recv alarm: Index: " + Integer.toHexString(eventInfo.getIndex()) + "; cond: " + alarmDecoder.getConditionCode(eventInfo.getCondition()) + "; stat: " + eventInfo.getState());
                            }
                            if (!this.destroyed && eventInfo.getSeverity() >= 1) {
                                arrayList.add(eventInfo);
                            }
                            if (this.destroyed || arrayList.size() <= 100 && EventDispatcher.this.alarmEventQueue.size() != 0) continue;
                            if (((EventDispatcher)EventDispatcher.this).db.on) {
                                EventDispatcher.this.db.println("sending " + arrayList.size() + " events");
                            }
                            EventDispatcher.this.alarmStore.addEvents(arrayList);
                            EventDispatcher.this.eventStore.addEvents(arrayList);
                            arrayList.clear();
                        }
                    }
                    catch (Exception exception) {
                        if (EventDispatcher.this.db.on()) {
                            EventDispatcher.this.db.println("Exception in EventDispatcher update processing (2)");
                        }
                        EventDispatcher.this.db;
                        DispatcherDebug.printStackTrace((Throwable)exception);
                        continue;
                    }
                    break;
                }
            }
        }

        public String toString() {
            return "Node " + this.theNode.getHostName() + ": Alm/Evt AC";
        }

        public void failedAction(IThreadWorker iThreadWorker) {
        }

        public void dispose() {
            this.destroyed = true;
        }
    }

    public class DispatcherDebug
    extends SDebug {
        private boolean watchAllObjectTypes;
        private ArrayList objectTypesToWatch;
        protected String[] objectTypeNames;
        protected String[] updateTypeNames;
        public final String Hlisten = "Watch for a certain event type";
        public final String Hunlisten = "Stop watching for a certain event type";
        public final String HlistenAll = "Watch for all event types";
        public final String HlistenAllOff = "Stop watching for all event types";
        public final String HdumpAllObservables = "List observables";

        public DispatcherDebug(KDebug kDebug, String string) {
            super(kDebug, string);
            this.watchAllObjectTypes = false;
            this.objectTypesToWatch = new ArrayList();
            this.objectTypeNames = EnumStrings.getStrings(ObjectType.class);
            this.updateTypeNames = EnumStrings.getStrings(eUpdateType.class);
            this.Hlisten = "Watch for a certain event type";
            this.Hunlisten = "Stop watching for a certain event type";
            this.HlistenAll = "Watch for all event types";
            this.HlistenAllOff = "Stop watching for all event types";
            this.HdumpAllObservables = "List observables";
        }

        public final void listen(String string) {
            try {
                Field field;
                if (!string.startsWith("Object")) {
                    string = "Object" + string;
                }
                if ((field = IObjectType.class.getField(string)) != null) {
                    int n = field.getInt(IObjectType.class);
                    this.objectTypesToWatch.add(new Integer(n));
                    EventDispatcher.this.db.println("Added EventDispatcher listener: " + string);
                } else {
                    EventDispatcher.this.db.println("Invalid ObjectType entered.");
                }
            }
            catch (Exception exception) {
                EventDispatcher.this.db.println("Exception Occurred - unable to add EventDispatcher listener: " + string);
            }
        }

        public final void unlisten(String string) {
            try {
                Field field;
                if (!string.startsWith("Object")) {
                    string = "Object" + string;
                }
                if ((field = IObjectType.class.getField(string)) != null) {
                    int n = field.getInt(IObjectType.class);
                    this.unlisten(string, n);
                } else {
                    EventDispatcher.this.db.println("Invalid ObjectType entered.");
                }
            }
            catch (Exception exception) {
                EventDispatcher.this.db.println("Exception Occurred - unable to remove EventDispatcher listener: " + string);
            }
        }

        public final void listenAll() {
            this.watchAllObjectTypes = true;
            EventDispatcher.this.db.println("EventDispatcher ListenAll: On");
        }

        public final void listenAllOff() {
            this.watchAllObjectTypes = false;
            EventDispatcher.this.db.println("EventDispatcher ListenAll: Off");
        }

        public final void dumpAllObservables() {
            EventDispatcher.this.dumpObservables();
        }

        public boolean isWatchingFor(int n) {
            if (this.watchAllObjectTypes) {
                return true;
            }
            boolean bl = false;
            for (int i = 0; i < this.objectTypesToWatch.size(); ++i) {
                if ((Integer)this.objectTypesToWatch.get(i) != n) continue;
                bl = true;
            }
            return bl;
        }

        private void unlisten(String string, int n) {
            Integer n2 = null;
            for (int i = 0; i < this.objectTypesToWatch.size(); ++i) {
                Integer n3 = (Integer)this.objectTypesToWatch.get(i);
                if (n3 != n) continue;
                n2 = n3;
            }
            if (n2 != null) {
                this.objectTypesToWatch.remove(n2);
                EventDispatcher.this.db.println("Removed EventDispatcher listener: " + string);
            }
        }
    }

    private class OID {
        private int objectType;
        private int index;
        private String myString;

        public OID(int n, int n2) {
            this.objectType = n;
            this.index = n2;
            this.myString = "OID[" + EnumStrings.getStrings(ObjectType.class)[this.objectType] + ", " + Integer.toHexString(this.index) + "]";
        }

        public OID(ObjectType objectType, int n) {
            this(objectType.value(), n);
        }

        public int getObjectType() {
            return this.objectType;
        }

        public int getIndex() {
            return this.index;
        }

        public String toString() {
            return this.myString;
        }

        public int hashCode() {
            return this.index;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (object instanceof OID) {
                OID oID = (OID)object;
                bl = oID.getIndex() == this.index && oID.getObjectType() == this.objectType;
            }
            return bl;
        }
    }

    public class ObjectMessageActionClient
    implements IActionClient {
        private EventDispatcher theDisp;
        private NodeModelDelegate theNode;
        private Map theObservers;
        private Map theIndexLessObservers;
        private Object acLock;
        private boolean destroyed;

        ObjectMessageActionClient(EventDispatcher eventDispatcher2, NodeModelDelegate nodeModelDelegate, Map map, Map map2) {
            this.theDisp = eventDispatcher2;
            this.theNode = nodeModelDelegate;
            this.theObservers = map;
            this.theIndexLessObservers = map2;
            this.acLock = new Object();
            this.destroyed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doAction() {
            int n = 0;
            Object object = this.acLock;
            synchronized (object) {
                while (true) {
                    try {
                        while (true) {
                            ObjectType objectType;
                            Object object2;
                            EventQueue eventQueue = EventDispatcher.this.objectMessageQueue;
                            synchronized (eventQueue) {
                                n = EventDispatcher.this.objectMessageQueue.size();
                                if (this.destroyed || n == 0) {
                                    return;
                                }
                                object2 = EventDispatcher.this.objectMessageQueue.dequeue();
                            }
                            if (object2 == null) {
                                if (EventDispatcher.this.db.on()) {
                                    EventDispatcher.this.db.println("ObjectMessageQueue for " + this.theNode.getHostName() + " stopping...");
                                }
                                return;
                            }
                            if (EventDispatcher.this.db.on()) {
                                EventDispatcher.this.db.println("EventDispatcher: eventReceived() " + n + " events in queue");
                            }
                            IObjectMessageInfo iObjectMessageInfo = (IObjectMessageInfo)object2;
                            if (EventDispatcher.this.db.isWatchingFor(iObjectMessageInfo.getObjectType())) {
                                EventDispatcher.this.db.println("(UPDATEMESSAGE): " + this.msgInfoToString(iObjectMessageInfo));
                            }
                            boolean bl = false;
                            CmsObservable cmsObservable = (CmsObservable)((Object)this.theObservers.get(new OID(iObjectMessageInfo.getObjectType(), iObjectMessageInfo.getIndex())));
                            if (cmsObservable != null) {
                                if (EventDispatcher.this.db.on()) {
                                    EventDispatcher.this.db.println("EventDispatcher is notifying: " + (Object)((Object)cmsObservable));
                                }
                                cmsObservable.setChanged();
                                cmsObservable.notifyObservers(iObjectMessageInfo);
                                bl = true;
                            }
                            if ((cmsObservable = (CmsObservable)((Object)this.theIndexLessObservers.get(objectType = ObjectType.from_int(iObjectMessageInfo.getObjectType())))) != null) {
                                if (EventDispatcher.this.db.on()) {
                                    EventDispatcher.this.db.println("EventDispatcher is notifying: " + (Object)((Object)cmsObservable));
                                }
                                cmsObservable.setChanged();
                                cmsObservable.notifyObservers(iObjectMessageInfo);
                                bl = true;
                            }
                            if (!EventDispatcher.this.db.on() || bl) continue;
                            EventDispatcher.this.db.println("No Observers found for: " + this.msgInfoToString(iObjectMessageInfo));
                        }
                    }
                    catch (Exception exception) {
                        if (EventDispatcher.this.db.on()) {
                            EventDispatcher.this.db.println("Exception in EventDispatcher update processing (2)");
                        }
                        EventDispatcher.this.db;
                        DispatcherDebug.printStackTrace((Throwable)exception);
                        continue;
                    }
                    break;
                }
            }
        }

        private String msgInfoToString(IObjectMessageInfo iObjectMessageInfo) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            String string = gregorianCalendar.get(10) + ":" + gregorianCalendar.get(12) + ":" + gregorianCalendar.get(13) + "." + gregorianCalendar.get(14);
            return "from=" + this.theNode.getName() + ";  ObjectType=" + ((EventDispatcher)EventDispatcher.this).db.objectTypeNames[iObjectMessageInfo.getObjectType()] + "; updateType= " + ((EventDispatcher)EventDispatcher.this).db.updateTypeNames[iObjectMessageInfo.getUpdateType()] + "; index= " + Integer.toHexString(iObjectMessageInfo.getIndex()) + "; childObjectType=" + ((EventDispatcher)EventDispatcher.this).db.objectTypeNames[iObjectMessageInfo.getChildObjectType()] + "; childIndex=" + Integer.toHexString(iObjectMessageInfo.getChildIndex()) + "; timestampe= " + string + "; moduleIndex=" + Integer.toHexString(iObjectMessageInfo.getModuleIndex());
        }

        public String toString() {
            return "Node " + this.theNode.getHostName() + ": Update AC";
        }

        public void failedAction(IThreadWorker iThreadWorker) {
        }

        public void dispose() {
            this.destroyed = true;
        }
    }

    public class StatsObservable
    extends CmsObservable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendUpdate(Object object, Object object2, int n) {
            block11: {
                Object object3;
                String string = null;
                Exception exception = null;
                if (StatsMgr.instance().isUpdateStarted()) {
                    IObjectMessageInfo iObjectMessageInfo = (IObjectMessageInfo)object2;
                    object3 = StatsMgr.instance().beginOperation(EventDispatcher.this.nodeModel.getName(), ((EventDispatcher)EventDispatcher.this).db.objectTypeNames[iObjectMessageInfo.getObjectType()], iObjectMessageInfo.getUpdateType(), iObjectMessageInfo.getIndex());
                    string = this.getRealObserverClassName(object);
                    if (n > 1) {
                        string = string + " #" + n;
                    }
                } else {
                    object3 = null;
                }
                try {
                    if (object instanceof IObserver) {
                        ((IObserver)object).update((IObservable)this, object2);
                        break block11;
                    }
                    if (object instanceof Observer) {
                        ((Observer)object).update((Observable)((Object)this), object2);
                        break block11;
                    }
                    throw new Exception("target: " + object.getClass().getName() + " must be an observer type");
                }
                catch (Exception exception2) {
                    exception = exception2;
                    this.handleException(exception2, object, object2);
                }
                finally {
                    if (object3 != null) {
                        StatsMgr.instance().endOperation(object3, string, exception);
                    }
                }
            }
        }
    }
}

