/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Alarm.sAlarmMessage;
import cerent.cms.idl.Callback.EventHandlerPOA;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.Event.clientId;
import cerent.cms.idl.Event.eUpdateType;
import cerent.cms.idl.Event.sObjectChange;
import cerent.cms.idl.Event.sObjectChangesListHolder;
import cerent.cms.model.AlarmEventQueue;
import cerent.cms.model.AlarmMessageFactory;
import cerent.cms.model.CmsCommFailException;
import cerent.cms.model.EventQueue;
import cerent.cms.model.EventUtilities;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NodeSingletonFactory;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.ObjectMessageQueue;
import cerent.cms.model.event.ElementAlarmStore;
import cerent.cms.model.event.ElementEventStore;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.ObjectMessageInfo;
import cerent.cms.model.event.ObjectMessageInfoFactory;
import cerent.cms.ui.event.IAlarmDecoder;
import cerent.util.EnumStrings;
import cerent.util.InetUtil;
import cerent.util.KDebug;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.ior.IiopProfile;
import cerent.util.ior.Ior;
import cerent.util.ior.IorFactory;
import cerent.util.ior.SslTransport;
import cerent.util.ior.TaggedComponent;
import cerent.util.orb.CtcIncarnationException;
import cerent.util.orb.OngORB;
import cerent.util.proxy.CtcProxy;
import cerent.util.proxy.CtcProxyFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.UserException;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManager;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.AdapterNonExistent;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class EventReceiver
extends EventHandlerPOA {
    private static final String EVENT_RECEIVER_POA_NAME = "EventReceiverPOA";
    private SDebug db;
    private EventUtilities eventUtilities;
    private EventQueue alarmEventQueue;
    private EventQueue objectMessageQueue;
    private NodeModelDelegate nmd;
    private Register register;
    private Reregister reregister;
    private IsRegistered isRegistered;
    private UnRegister unRegister;
    private String _ior;
    private ArrayList _registrations;
    private HashMap _proxies;
    private long lastUpdateSeqProcessed;
    private static final String PREFS_PERSIST = "ctc.model.persist";
    private static NodeSingletonFactory<EventReceiver> sfactory = new NodeSingletonFactory<EventReceiver>(EventReceiver.class);
    private static boolean supportsSecureCallbacks = Preferences.instance().getBoolean("ctc.orb.callback.secure", "enable", true);

    public static EventReceiver getInstance(NodeModelDelegate nodeModelDelegate) {
        return sfactory.getInstance(nodeModelDelegate);
    }

    private EventReceiver(NodeModelDelegate nodeModelDelegate) throws CtcIncarnationException {
        this.nmd = nodeModelDelegate;
        this.db = new SDebug((KDebug)nodeModelDelegate.getDebug(), "EventReceiver");
        this.lastUpdateSeqProcessed = 0L;
        this._registrations = new ArrayList();
        this._proxies = new HashMap();
        this.eventUtilities = EventUtilities.getInstance(nodeModelDelegate);
        this.alarmEventQueue = AlarmEventQueue.getInstance(nodeModelDelegate);
        this.objectMessageQueue = ObjectMessageQueue.getInstance(nodeModelDelegate);
        this.register = new Register(nodeModelDelegate, "EventReceiver.register");
        this.reregister = new Reregister(nodeModelDelegate, "EventReceiver.reregister");
        this.isRegistered = new IsRegistered(nodeModelDelegate, "EventReceiver.isRegistered");
        this.unRegister = new UnRegister(nodeModelDelegate, "EventReceiver.unRegister");
        this.connectToORB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAlarms(int n, sAlarmMessage[] sAlarmMessageArray) {
        block15: {
            int n2;
            java.lang.Object object;
            block14: {
                if (this.alarmEventQueue == null) {
                    return;
                }
                try {
                    if (this.db.on()) {
                        this.db.println("(ALM) received updateAlarms from " + InetUtil.makeDottedString(n));
                    }
                    long l = 0L;
                    object = null;
                    String string = null;
                    long l2 = System.currentTimeMillis();
                    EventQueue eventQueue = this.alarmEventQueue;
                    synchronized (eventQueue) {
                        for (int i = 0; i < sAlarmMessageArray.length; ++i) {
                            long l3 = sAlarmMessageArray[i].timeStamp;
                            if (l3 == 0L) {
                                l = l2;
                                object = this.eventUtilities.getLocalTime(l);
                                string = this.eventUtilities.getNeTime();
                            } else {
                                l = this.eventUtilities.convertSecondsToMilliSeconds(l3);
                                object = this.eventUtilities.formatAbsoluteNeTimeasCtcTimeZoneString(l);
                                string = this.eventUtilities.formatAbsoluteNeTimeasNeTimeZoneString(l);
                            }
                            EventInfo eventInfo = new EventInfo((INodeModel)this.nmd, l, (String)object, string, AlarmMessageFactory.getIAlarmMessage(sAlarmMessageArray[i]), (IAlarmDecoder)this.nmd.getAlarmDecoder());
                            this.eventUtilities.checkForWavelength(eventInfo);
                            this.alarmEventQueue.enqueue(eventInfo, i == sAlarmMessageArray.length - 1);
                        }
                    }
                }
                catch (Throwable throwable) {
                    if (!this.db.on()) break block14;
                    this.db.println("***** Throwable caught in updateAlarms *****");
                    this.db.println("\tSender is " + n + " Alarm List is\n\t");
                    for (n2 = 0; n2 < sAlarmMessageArray.length; ++n2) {
                        object = sAlarmMessageArray[n2];
                        this.db.print(object.toString());
                        if (n2 == sAlarmMessageArray.length - 1) continue;
                        this.db.print(", ");
                    }
                    SDebug.printStackTrace((Throwable)throwable);
                }
            }
            try {
                this.alarmEventQueue.enqueueActionClient();
            }
            catch (Throwable throwable) {
                if (!this.db.on()) break block15;
                this.db.println("***** Throwable caught queueing actionClient in updateAlarms *****");
                this.db.println("\tSender is " + n + " Alarm List is\n\t");
                for (n2 = 0; n2 < sAlarmMessageArray.length; ++n2) {
                    object = sAlarmMessageArray[n2];
                    this.db.print(object.toString());
                    if (n2 == sAlarmMessageArray.length - 1) continue;
                    this.db.print(", ");
                }
                SDebug.printStackTrace((Throwable)throwable);
            }
        }
    }

    public void update(int n, ObjectType objectType, int n2, eUpdateType eUpdateType2) {
    }

    private String noObject(String string) {
        String string2 = "Object";
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    private String noMsg(String string) {
        String string2 = "Object";
        String string3 = "Msg";
        if (string.startsWith(string2)) {
            if (string.endsWith(string3)) {
                return string.substring(string2.length(), string.length() - string3.length());
            }
            return string.substring(string2.length());
        }
        if (string.endsWith(string3)) {
            return string.substring(0, string.length() - string3.length());
        }
        return string;
    }

    private void add(StringBuffer stringBuffer, int n) {
        int n2 = stringBuffer.length();
        stringBuffer.append(Integer.toHexString(n));
        while (stringBuffer.length() < n2 + 8) {
            stringBuffer.insert(n2, ' ');
        }
    }

    private boolean isEntityAdded(sObjectChange sObjectChange2) {
        return sObjectChange2.objType == ObjectType.ObjectEntity && sObjectChange2.updateType == eUpdateType.ObjectAddedMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(int n, sObjectChange sObjectChange2, sObjectChange sObjectChange3) {
        java.lang.Object object;
        java.lang.Object object2;
        boolean bl = false;
        if (sObjectChange3 != null) {
            boolean bl2 = bl = this.isEntityAdded(sObjectChange3) && this.isEntityAdded(sObjectChange2) && sObjectChange2.objIndex == sObjectChange3.objIndex;
        }
        if (this.db.on) {
            object2 = new StringBuffer();
            object = EnumStrings.getStrings(ObjectType.class);
            String[] stringArray = EnumStrings.getStrings(eUpdateType.class);
            ((StringBuffer)object2).append("(EVT)");
            ((StringBuffer)object2).append(bl ? " -" : " +");
            if (sObjectChange2.updateType == null) {
                ((StringBuffer)object2).append("null");
            } else {
                ((StringBuffer)object2).append(this.noMsg(stringArray[sObjectChange2.updateType.value()]));
            }
            ((StringBuffer)object2).append(" index=");
            this.add((StringBuffer)object2, sObjectChange2.objIndex);
            ((StringBuffer)object2).append(" child=");
            this.add((StringBuffer)object2, sObjectChange2.childIndex);
            ((StringBuffer)object2).append(" module=");
            this.add((StringBuffer)object2, sObjectChange2.moduleIndex);
            ((StringBuffer)object2).append(" type=");
            if (sObjectChange2.objType == null) {
                ((StringBuffer)object2).append("null");
            } else {
                ((StringBuffer)object2).append(this.noObject(object[sObjectChange2.objType.value()]));
            }
            ((StringBuffer)object2).append(" childType=");
            if (sObjectChange2.childObjType == null) {
                ((StringBuffer)object2).append("null");
            } else {
                ((StringBuffer)object2).append(this.noObject(object[sObjectChange2.childObjType.value()]));
            }
            ((StringBuffer)object2).append(" typeSeqNum=");
            ((StringBuffer)object2).append(sObjectChange2.typeSeqNum);
            ((StringBuffer)object2).append(" from=");
            ((StringBuffer)object2).append(Integer.toHexString(n));
            this.db.println(((StringBuffer)object2).toString());
        }
        if (sObjectChange2.childObjType != null && sObjectChange2.objType != null && sObjectChange2.updateType != null && !bl) {
            object2 = ObjectMessageInfoFactory.getObjectMessageInfo(this.nmd, sObjectChange2);
            object = this.objectMessageQueue;
            synchronized (object) {
                this.objectMessageQueue.enqueue((ObjectMessageInfo)object2);
            }
        }
        this.lastUpdateSeqProcessed = sObjectChange2.objChangeSeq;
    }

    private static String getDescription(Class clazz, int n) {
        String string = EnumStrings.getStrings((Class)clazz)[n];
        if (string.startsWith("Object")) {
            string = string.substring("Object".length());
        }
        if (string.endsWith("Msg")) {
            string = string.substring(0, string.length() - "Msg".length());
        }
        return string;
    }

    private static String getDescription(eUpdateType eUpdateType2) {
        String string = eUpdateType2 == null ? "null" : EventReceiver.getDescription(eUpdateType.class, eUpdateType2.value());
        return string;
    }

    private static String getDescription(ObjectType objectType) {
        String string = objectType == null ? "null" : EventReceiver.getDescription(ObjectType.class, objectType.value());
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int n, ObjectType objectType, int n2, ObjectType objectType2, int n3, int n4, eUpdateType eUpdateType2, long l, long l2) {
        try {
            if (this.db.on) {
                this.db.println(EventReceiver.getDescription(eUpdateType2) + " " + EventReceiver.getDescription(objectType) + " 0x" + Integer.toHexString(n2) + " child " + EventReceiver.getDescription(objectType2) + " 0x" + Integer.toHexString(n3) + " module 0x" + Integer.toHexString(n4) + " typeSeqNum=" + l2 + " from=" + InetUtil.makeDottedString(n));
            }
            if (objectType2 != null && objectType != null && eUpdateType2 != null) {
                ObjectMessageInfo objectMessageInfo = ObjectMessageInfoFactory.getObjectMessageInfo(this.nmd, objectType, n2, objectType2, n3, n4, eUpdateType2, l, l2);
                EventQueue eventQueue = this.objectMessageQueue;
                synchronized (eventQueue) {
                    this.objectMessageQueue.enqueue(objectMessageInfo);
                }
            }
            this.lastUpdateSeqProcessed = l;
        }
        catch (Throwable throwable) {
            this.db.println("Throwable caught in update()\nParms: sender = " + n + "; type = " + objectType.toString() + "; index = " + n2 + "; childType = " + objectType2.toString() + "; childIndex = " + n3 + "; updateType = " + eUpdateType2.toString());
            SDebug.printStackTrace((Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateObjects(int n, sObjectChange[] sObjectChangeArray) {
        if (this.objectMessageQueue == null) {
            return;
        }
        if (sObjectChangeArray == null) {
            if (this.db.on()) {
                this.db.println("changeList is NULL in UpdateObjects.");
            }
            return;
        }
        try {
            if (this.db.on()) {
                this.db.println("updateObjects: " + sObjectChangeArray.length + " update(s) from " + InetUtil.makeDottedString(n));
                if (sObjectChangeArray.length > 0) {
                    this.db.println("updateObjects: seq #'s: " + sObjectChangeArray[0].objChangeSeq + " - " + sObjectChangeArray[sObjectChangeArray.length - 1].objChangeSeq);
                }
            }
        }
        catch (Throwable throwable) {
            this.db.println("updateObjects: Throwable in debug info print");
            SDebug.printStackTrace((Throwable)throwable);
        }
        sObjectChange sObjectChange2 = null;
        EventQueue eventQueue = this.objectMessageQueue;
        synchronized (eventQueue) {
            for (int i = 0; i < sObjectChangeArray.length; ++i) {
                try {
                    this.update(n, sObjectChangeArray[i], sObjectChange2);
                    if (!this.isEntityAdded(sObjectChangeArray[i])) continue;
                    sObjectChange2 = sObjectChangeArray[i];
                    continue;
                }
                catch (Throwable throwable) {
                    this.db.println("Throwable caught in updateObjects(): " + sObjectChangeArray.length + " update(s) from " + InetUtil.makeDottedString(n) + ", seq #'s: " + sObjectChangeArray[0].objChangeSeq + " - " + sObjectChangeArray[sObjectChangeArray.length - 1].objChangeSeq);
                    this.db.println("Thrown when i = " + i + ", lastUpdateSeqProcessed = " + this.lastUpdateSeqProcessed);
                    SDebug.printStackTrace((Throwable)throwable);
                }
            }
            try {
                this.objectMessageQueue.enqueueActionClient();
            }
            catch (Throwable throwable) {
                this.db.println("Throwable caught in updateObjects(): " + sObjectChangeArray.length + " update(s) from " + InetUtil.makeDottedString(n));
                this.db.println("Thrown when enqueueing actionClient");
                SDebug.printStackTrace((Throwable)throwable);
            }
        }
    }

    private clientId getClientId(String string) {
        this.unRegisterCMS(string);
        String string2 = this.nmd.getCorbaHost();
        clientId clientId2 = new clientId();
        clientId2.name = string;
        clientId2.locator = this.getIor(this._ior, string2);
        this._registrations.add(0, clientId2);
        if (this.db.on) {
            try {
                this.db.println("node           = " + string2);
                this.db.println("IorRepository  = " + this.nmd.getIorRepository().getNodeRootRef());
                this.db.println("EventRef       = " + this.nmd.getIorRepository().getEventRef());
                this.db.println("myself.name    = " + clientId2.name);
                this.db.println("myself.locator = " + clientId2.locator);
            }
            catch (IOException iOException) {
                this.db.println("failed to get the node root ref: " + iOException);
            }
        }
        return clientId2;
    }

    private boolean reregisterCMS(String string) throws UserException, NO_IMPLEMENT {
        java.lang.Object[] objectArray = new java.lang.Object[2];
        java.lang.Object[] objectArray2 = new java.lang.Object[2];
        if (this.db.on()) {
            this.db.println("calling reregisterCMS for node " + this.nmd.getHostName());
            this.db.println("lastUpdateSeqProcessed = " + this.lastUpdateSeqProcessed);
        }
        try {
            objectArray[0] = this.getClientId(string);
            objectArray[1] = new Integer((int)this.lastUpdateSeqProcessed);
            objectArray2 = (java.lang.Object[])this.reregister.get(objectArray);
        }
        catch (NO_IMPLEMENT nO_IMPLEMENT) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)nO_IMPLEMENT);
            }
            throw nO_IMPLEMENT;
        }
        catch (UserException userException) {
            this.db.println("Caught a CORBA.UserException in EventReceiver.registerCMS. This should not happen.");
            SDebug.printStackTrace((Throwable)userException);
            throw userException;
        }
        boolean bl = false;
        sObjectChange[] sObjectChangeArray = null;
        if (objectArray2 != null) {
            if (objectArray2[0] != null && objectArray2[0] instanceof Boolean && objectArray2[1] instanceof sObjectChange[]) {
                bl = (Boolean)objectArray2[0];
                if (this.db.on()) {
                    this.db.println("reregisterCMS: valid=" + bl);
                }
                if ((sObjectChangeArray = (sObjectChange[])objectArray2[1]) == null) {
                    if (this.db.on()) {
                        this.db.println("Received list is null.");
                    }
                    return false;
                }
                if (sObjectChangeArray.length == 0) {
                    if (this.db.on()) {
                        this.db.println("Received list zero length");
                    }
                    return bl;
                }
                if ((long)sObjectChangeArray[0].objChangeSeq != this.lastUpdateSeqProcessed + 1L) {
                    bl = false;
                    if (this.db.on()) {
                        this.db.println("UpdateSeq mismatch, last seen = " + this.lastUpdateSeqProcessed + ", first in list = " + sObjectChangeArray[0].objChangeSeq + ", valid is now false");
                    }
                } else if (this.db.on()) {
                    this.db.println("Received list contains " + sObjectChangeArray.length + " items");
                    this.db.println("Received list seq number = {" + sObjectChangeArray[0].objChangeSeq + "," + sObjectChangeArray[sObjectChangeArray.length - 1].objChangeSeq + "}");
                }
            } else if (this.db.on()) {
                this.db.println("Return value is null or does not contain expected values");
            }
        } else if (this.db.on()) {
            this.db.println("Return value is null -- expected an array");
        }
        if (bl && sObjectChangeArray != null && sObjectChangeArray.length > 0) {
            ElementAlarmStore elementAlarmStore = (ElementAlarmStore)this.nmd.getElementAlarmStore();
            this.updateObjects(2130706433, sObjectChangeArray);
            elementAlarmStore.flushAlarmStore();
            elementAlarmStore.getPendingAlarms();
            ElementEventStore elementEventStore = (ElementEventStore)this.nmd.getElementEventStore();
            if (this.db.on()) {
                this.db.println("Event Receiver:  sending alarm store flush notification " + elementEventStore);
            }
            elementEventStore.sendReregisterNotification();
        }
        return bl;
    }

    public void registerCMS(String string) throws UnsupportedEncodingException, UnknownHostException {
        try {
            Long l = (Long)this.register.get(this.getClientId(string));
            this.lastUpdateSeqProcessed = l;
            if (this.db.on) {
                this.db.println("  sequence Num from NE = " + l);
            }
        }
        catch (UserException userException) {
            this.db.println("Caught a CORBA.UserException in EventReceiver.registerCMS. This should not happen.");
            SDebug.printStackTrace((Throwable)userException);
        }
    }

    public boolean isCMSRegistered(String string) {
        boolean bl;
        block12: {
            if (this._registrations.size() == 0) {
                return false;
            }
            bl = false;
            clientId clientId2 = (clientId)this._registrations.get(0);
            try {
                bl = (Boolean)this.isRegistered.get(clientId2);
                if (bl) break block12;
                if (this.db.on()) {
                    this.db.println("isCMSRegistered: the call to isRegistered(myself) return false.");
                    this.db.println("Calling reregisterCMS(name)");
                }
                try {
                    bl = this.reregisterCMS(string);
                    if (!bl) {
                        if (this.db.on()) {
                            this.db.println("isCMSregistered: re-register failed");
                        }
                        this.unRegisterCMS(string);
                    }
                }
                catch (UserException userException) {
                    if (this.db.on()) {
                        this.db.println("isCMSRegistered: " + userException.toString());
                        SDebug.printStackTrace((Throwable)userException);
                    }
                    bl = false;
                }
                catch (NO_IMPLEMENT nO_IMPLEMENT) {
                    bl = false;
                }
            }
            catch (UserException userException) {
                if (this.db.on()) {
                    this.db.println("Caught a CORBA.UserException in EventReceiver.isCmsRegistered. This should not happen.");
                    SDebug.printStackTrace((Throwable)userException);
                }
                bl = false;
            }
        }
        if (!bl) {
            this.db.println("isCMSRegistered returning false");
        }
        return bl;
    }

    private void deleteProxies() {
        Iterator iterator = this._proxies.values().iterator();
        while (iterator.hasNext()) {
            CtcProxy ctcProxy = (CtcProxy)iterator.next();
            if (ctcProxy.isProxying()) {
                ctcProxy.setSecure(false);
                try {
                    ctcProxy.getSocket().close();
                }
                catch (IOException iOException) {
                    this.db.println("deleteProxies: " + iOException);
                }
            }
            iterator.remove();
        }
    }

    public void unRegisterCMS(String string) {
        Iterator iterator = this._registrations.iterator();
        while (iterator.hasNext()) {
            try {
                clientId clientId2 = (clientId)iterator.next();
                this.unRegister.set(clientId2);
                if (((Boolean)this.isRegistered.get(clientId2)).booleanValue()) {
                    this.db.println("Failed to unregister: " + clientId2.name + "/" + clientId2.locator);
                    continue;
                }
                iterator.remove();
            }
            catch (UserException userException) {
                this.db.println("Caught a CORBA.UserException in EventReceiver.unRegisterCMS. This should not happen.");
                SDebug.printStackTrace((Throwable)userException);
            }
        }
        this.deleteProxies();
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose(): start");
        }
        this.disconnectFromORB();
        this.eventUtilities = null;
        this.alarmEventQueue.clear();
        this.alarmEventQueue = null;
        this.objectMessageQueue = null;
        this.lastUpdateSeqProcessed = 0L;
        this._set_delegate(null);
        this.nmd = null;
        this.db.dispose();
    }

    public POA _default_POA() {
        return this.getEventReceiverPOA();
    }

    private boolean doesSupportSecureCallbacks(String string) {
        return supportsSecureCallbacks;
    }

    private boolean checkComponents(IiopProfile iiopProfile, String string, String string2, HashMap hashMap) throws IOException {
        java.lang.Object object;
        int n;
        boolean bl = false;
        boolean bl2 = this.doesSupportSecureCallbacks(string);
        int n2 = iiopProfile.getNumComponents();
        int[] nArray = null;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (!iiopProfile.getComponentAt(n).isSslTransportComponent()) continue;
            SslTransport sslTransport = (SslTransport)iiopProfile.getComponentAt(n).getComponent();
            if (!bl2) {
                if (this.db.on()) {
                    this.db.println("By pref setting, removing secure component...only GIOP call be used for callbacks");
                }
                if (nArray == null) {
                    nArray = new int[n2];
                }
                nArray[n3++] = n;
                continue;
            }
            object = "ssliop://" + iiopProfile.getHost() + ":" + sslTransport.getSslPort();
            CtcProxy ctcProxy = (CtcProxy)hashMap.get(object);
            if (ctcProxy == null) {
                ctcProxy = CtcProxyFactory.accept((String)iiopProfile.getHost(), (int)sslTransport.getSslPort(), (String)string, (boolean)true);
                hashMap.put(object, ctcProxy);
            }
            if (string2 == null && ctcProxy.isProxying()) {
                if (this.db.on()) {
                    this.db.println("checkComponents(" + string + "): proxying " + ctcProxy.getHost() + ":" + ctcProxy.getPort() + "->" + iiopProfile.getHost() + ":" + sslTransport.getSslPort());
                }
                bl = true;
                iiopProfile.setHost(ctcProxy.getHost());
                sslTransport.setSslPort(ctcProxy.getPort());
                continue;
            }
            if (string2 == null || iiopProfile.getHost().equals(string2)) continue;
            if (this.db.on()) {
                this.db.println("checkComponents(" + string + "): static " + string2 + ":" + sslTransport.getSslPort() + "->" + iiopProfile.getHost() + ":" + sslTransport.getSslPort());
            }
            bl = true;
            iiopProfile.setHost(string2);
        }
        if (nArray != null) {
            int n4;
            bl = true;
            n = 0;
            int n5 = 0;
            object = new TaggedComponent[n2 - n3];
            for (n4 = 0; n4 < n3; ++n4) {
                void var14_16 = nArray[n4];
                for (int i = n5; i < var14_16; ++i) {
                    object[n++] = iiopProfile.getComponentAt(i);
                }
                n5 = var14_16 + true;
            }
            for (n4 = n5; n4 < n2; ++n4) {
                object[n++] = iiopProfile.getComponentAt(n4);
            }
            iiopProfile.setComponents((TaggedComponent[])object);
        }
        return bl;
    }

    private boolean checkProfiles(Ior ior, String string, String string2, HashMap hashMap) throws IOException {
        boolean bl = false;
        for (int i = 0; i < ior.getNumProfiles(); ++i) {
            if (!ior.getProfileAt(i).isIiopProfile()) continue;
            IiopProfile iiopProfile = (IiopProfile)ior.getProfileAt(i).getProfile();
            String string3 = "iiop://" + iiopProfile.getHost() + ":" + iiopProfile.getPort();
            CtcProxy ctcProxy = (CtcProxy)hashMap.get(string3);
            if (ctcProxy == null) {
                ctcProxy = CtcProxyFactory.accept((String)iiopProfile.getHost(), (int)iiopProfile.getPort(), (String)string);
                hashMap.put(string3, ctcProxy);
            }
            if (string2 == null && ctcProxy.isProxying()) {
                if (this.db.on()) {
                    this.db.println("checkProfiles(" + string + "): proxying " + ctcProxy.getHost() + ":" + ctcProxy.getPort() + "->" + iiopProfile.getHost() + ":" + iiopProfile.getPort());
                }
                bl = true;
                iiopProfile.setHost(ctcProxy.getHost());
                iiopProfile.setPort(ctcProxy.getPort());
            } else if (string2 != null && !iiopProfile.getHost().equals(string2)) {
                if (this.db.on()) {
                    this.db.println("checkComponents(" + string + "): static " + string2 + ":" + iiopProfile.getPort() + "->" + iiopProfile.getHost() + ":" + iiopProfile.getPort());
                }
                bl = true;
                iiopProfile.setHost(string2);
            }
            bl |= this.checkComponents(iiopProfile, string, string2, hashMap);
        }
        return bl;
    }

    private String getIor(String string, String string2) {
        String string3 = string;
        try {
            boolean bl = false;
            Ior ior = IorFactory.parse(string);
            String string4 = Preferences.instance().getProperty("ctc.proxy", "bindAddress", null);
            this.db.finest("Parsed IOR:");
            this.db.finest(ior.toString());
            bl = this.checkProfiles(ior, string2, string4, this._proxies);
            if (bl) {
                string3 = IorFactory.stringify(ior);
                this.db.finest("Changed IOR:");
                this.db.finest(ior.toString());
            } else if (this.db.on()) {
                this.db.println("getIor(" + string2 + "): no IOR Change");
            }
        }
        catch (Exception exception) {
            this.db.println("getIor() failed: " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        return string3;
    }

    private void connectToORB() throws CtcIncarnationException {
        try {
            this.getEventReceiverPOA().activate_object((Servant)this);
            this._ior = OngORB.instance().object_to_string((Object)this._this());
        }
        catch (ServantAlreadyActive servantAlreadyActive) {
            throw new CtcIncarnationException(servantAlreadyActive.toString());
        }
        catch (WrongPolicy wrongPolicy) {
            throw new CtcIncarnationException(wrongPolicy.toString());
        }
    }

    private void disconnectFromORB() throws CtcIncarnationException {
        try {
            this.unRegisterCMS("");
            this._ior = null;
        }
        catch (CmsCommFailException cmsCommFailException) {
            // empty catch block
        }
        try {
            POA pOA = this.getEventReceiverPOA();
            pOA.deactivate_object(pOA.servant_to_id((Servant)this));
        }
        catch (ObjectNotActive objectNotActive) {
            throw new CtcIncarnationException(objectNotActive.toString());
        }
        catch (WrongPolicy wrongPolicy) {
            throw new CtcIncarnationException(wrongPolicy.toString());
        }
        catch (ServantNotActive servantNotActive) {
            throw new CtcIncarnationException(servantNotActive.toString());
        }
    }

    private POA getEventReceiverPOA() {
        POA pOA;
        try {
            POA pOA2 = POAHelper.narrow((Object)OngORB.instance().resolve_initial_references("RootPOA"));
            pOA = pOA2.find_POA(EVENT_RECEIVER_POA_NAME, false);
        }
        catch (InvalidName invalidName) {
            throw new CtcIncarnationException(invalidName.toString());
        }
        catch (AdapterNonExistent adapterNonExistent) {
            pOA = this.createEventReceiverPOA();
        }
        return pOA;
    }

    private POA createEventReceiverPOA() {
        POA pOA;
        try {
            POA pOA2 = POAHelper.narrow((Object)OngORB.instance().resolve_initial_references("RootPOA"));
            POAManager pOAManager = pOA2.the_POAManager();
            Policy[] policyArray = new Policy[]{pOA2.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID), pOA2.create_id_uniqueness_policy(IdUniquenessPolicyValue.UNIQUE_ID), pOA2.create_request_processing_policy(RequestProcessingPolicyValue.USE_ACTIVE_OBJECT_MAP_ONLY), pOA2.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN), pOA2.create_lifespan_policy(LifespanPolicyValue.TRANSIENT)};
            pOA = pOA2.create_POA(EVENT_RECEIVER_POA_NAME, pOAManager, policyArray);
            pOAManager.activate();
        }
        catch (InvalidName invalidName) {
            throw new CtcIncarnationException(invalidName.toString());
        }
        catch (AdapterAlreadyExists adapterAlreadyExists) {
            throw new CtcIncarnationException(adapterAlreadyExists.toString());
        }
        catch (InvalidPolicy invalidPolicy) {
            throw new CtcIncarnationException(invalidPolicy.toString());
        }
        catch (AdapterInactive adapterInactive) {
            throw new CtcIncarnationException(adapterInactive.toString());
        }
        return pOA;
    }

    class IsRegistered
    extends NonCachedValue {
        public IsRegistered(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected java.lang.Object getValue(java.lang.Object object) throws UserException {
            return new Boolean(EventReceiver.this.nmd.getIorRepository().getEventRef().IsClientRegistered((clientId)object));
        }

        public java.lang.Object outer() {
            return EventReceiver.this;
        }
    }

    class Register
    extends NonCachedValue {
        public Register(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected java.lang.Object getValue(java.lang.Object object) throws UserException {
            return new Long(EventReceiver.this.nmd.getIorRepository().getEventRef().RegisterClient((clientId)object));
        }

        public java.lang.Object outer() {
            return EventReceiver.this;
        }
    }

    class Reregister
    extends NonCachedValue {
        public Reregister(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected java.lang.Object getValue(java.lang.Object object) throws UserException {
            java.lang.Object[] objectArray = (java.lang.Object[])object;
            java.lang.Object[] objectArray2 = new java.lang.Object[2];
            BooleanHolder booleanHolder = new BooleanHolder();
            sObjectChangesListHolder sObjectChangesListHolder2 = new sObjectChangesListHolder();
            EventReceiver.this.nmd.getIorRepository().getEventRef().registerCachingClient((clientId)objectArray[0], (Integer)objectArray[1], booleanHolder, sObjectChangesListHolder2);
            objectArray2[0] = new Boolean(booleanHolder.value);
            objectArray2[1] = sObjectChangesListHolder2.value;
            return objectArray2;
        }

        public java.lang.Object outer() {
            return EventReceiver.this;
        }
    }

    class UnRegister
    extends NonCachedValue {
        public UnRegister(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected void setValue(java.lang.Object object) throws UserException {
            EventReceiver.this.nmd.getIorRepository().getEventRef().UnRegisterClient((clientId)object);
        }

        public java.lang.Object outer() {
            return EventReceiver.this;
        }
    }
}

