/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Circuits.sCircuitId;
import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.SonetFactory;
import cerent.cms.idl.SonetTopology.StsConnection;
import cerent.cms.idl.SonetTopology.sStsConnectionItem;
import cerent.cms.idl.SonetTopology.xNoSuchConnection;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.ConnectionModelsDelegate;
import cerent.cms.model.Connections;
import cerent.cms.model.EventDispatcher;
import cerent.cms.model.HoConnectionModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.event.IObjectMessageInfo;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class HoConnections
extends Connections
implements Observer {
    private static final String MY_DEBUG_KEY = "HoConnections";
    ConnectionModelsDelegate container;
    NodeModelDelegate node;
    GetStsConnections getStsConnections;
    GetConnectionObjIndex getConnectionObjIndex;
    GetStsConnectionsList getStsConnectionsList;
    GetStsConnectionIndexes getStsConnectionIndexes;
    GetStsConnectionItem getStsConnectionItem;
    private boolean isInitedRealState;
    private EventDispatcher dispatcher;
    private HoConnDebug db;
    private SDebug hoConnModelDebug;

    public HoConnections(ConnectionModelsDelegate connectionModelsDelegate) {
        this.container = connectionModelsDelegate;
        this.node = connectionModelsDelegate.node;
        this.db = new HoConnDebug(this.node.db);
        this.hoConnModelDebug = this.node.getChildDebug(HoConnectionModel.class);
        this.getStsConnections = new GetStsConnections(this.node, "HoConnections.getStsConnections");
        this.getConnectionObjIndex = new GetConnectionObjIndex(this.node, "HoConnections.getConnectionObjIndex");
        this.getStsConnectionsList = new GetStsConnectionsList(this.node, "HoConnections.getHoConnectionsList");
        this.getStsConnectionIndexes = new GetStsConnectionIndexes(this.node, "HoConnections.getStsConnectionIndexes");
        this.getStsConnectionItem = new GetStsConnectionItem(this.node, "HoConnections.getStsConnectionItem");
        this.dispatcher = null;
    }

    private SonetFactory getSonetFactoryRef() {
        return this.container.getSonetFactoryRef();
    }

    public void init() {
        this.dispatcher = this.node.getDispatcher();
        if (this.dispatcher != null) {
            this.dispatcher.addObserver(ObjectType.ObjectStsConnectionList, 0, (Observer)this);
        }
    }

    private synchronized void initReal() {
        this.isInitedRealState = true;
        this.discover(this.connectionModels);
        Iterator iterator = this.connectionModels.values().iterator();
        while (iterator.hasNext()) {
            ((HoConnectionModel)iterator.next()).init();
        }
    }

    public void dispose() {
        if (this.dispatcher != null) {
            this.dispatcher.deleteObserver(ObjectType.ObjectStsConnectionList, 0, (Observer)this);
        }
        this.isInitedRealState = false;
        super.dispose();
    }

    public Collection getConnectionModels() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return this.connectionModels.values();
    }

    protected boolean updateStructure() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return this.updateStsStructure();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HoConnectionModel add(StsConnection stsConnection) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        HoConnectionModel hoConnectionModel = null;
        if (stsConnection == null) {
            return null;
        }
        HoConnections hoConnections = this;
        synchronized (hoConnections) {
            block14: {
                hoConnectionModel = this.findHoConnectionModel(stsConnection);
                if (hoConnectionModel == null) {
                    try {
                        Integer n;
                        block13: {
                            hoConnectionModel = new HoConnectionModel(this.node, stsConnection, (Connections)this, this.hoConnModelDebug);
                            n = new Integer(hoConnectionModel.getObjIndex());
                            try {
                                hoConnectionModel.setAttributes(this.getStsConnectionItem(n));
                            }
                            catch (xNoSuchConnection xNoSuchConnection2) {
                                if (!this.db.on) break block13;
                                this.db.println("Caught noSuchConnection for index " + n);
                                HoConnDebug.printStackTrace((Throwable)((Object)xNoSuchConnection2));
                            }
                        }
                        hoConnectionModel.init();
                        this.connectionModels.put(n, hoConnectionModel);
                        this.setChanged();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (this.db.on()) {
                            this.db.println("Exception in add-StsConn " + (Object)((Object)abstractCmsIOException));
                            this.printStackTrace((Exception)((Object)abstractCmsIOException));
                        }
                        if (hoConnectionModel == null) break block14;
                        hoConnectionModel.dispose();
                        hoConnectionModel = null;
                    }
                }
            }
            if (hoConnectionModel != null) {
                if (this.db.on) {
                    this.db.println("marking Pools dirty ");
                }
                hoConnectionModel.markPoolsDirty();
            }
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        return hoConnectionModel;
    }

    public synchronized HoConnectionModel findHoConnectionModel(sCircuitId sCircuitId2) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        return (HoConnectionModel)this.findConnectionModel(this.connectionModels.values(), sCircuitId2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HoConnectionModel findHoConnectionModel(StsConnection stsConnection) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        Object var2_2 = null;
        if (stsConnection != null) {
            HoConnections hoConnections = this;
            synchronized (hoConnections) {
                try {
                    Integer n = (Integer)this.getConnectionObjIndex.get(stsConnection);
                    var2_2 = this.connectionModels.get(n);
                }
                catch (UserException userException) {
                    HoConnDebug.printStackTrace((Throwable)userException);
                }
            }
        }
        if (var2_2 == null && this.db.on()) {
            this.db.println("Could not find the StsConnection in the cache ");
        }
        return var2_2;
    }

    private synchronized void discover(Map map) {
        sStsConnectionItem[] sStsConnectionItemArray = null;
        sStsConnectionItemArray = this.getStsConnectionItems();
        if (sStsConnectionItemArray == null) {
            this.db.println("Error in getting StsConnections (null) StsConnections::discover");
            return;
        }
        for (int i = 0; i < sStsConnectionItemArray.length; ++i) {
            if (sStsConnectionItemArray[i] == null) continue;
            Integer n = new Integer(sStsConnectionItemArray[i].objIndex);
            map.put(n, new HoConnectionModel(this.node, sStsConnectionItemArray[i], (Connections)this, this.hoConnModelDebug));
        }
    }

    private sStsConnectionItem[] getStsConnectionItems() {
        sStsConnectionItem[] sStsConnectionItemArray = new sStsConnectionItem[]{};
        try {
            sStsConnectionItemArray = (sStsConnectionItem[])this.getStsConnectionsList.get();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            this.db.println("Error in getting stsConnections " + (Object)((Object)abstractCmsIOException));
            HoConnDebug.printStackTrace((Throwable)abstractCmsIOException);
            return null;
        }
        catch (UserException userException) {
            HoConnDebug.printStackTrace((Throwable)userException);
            return null;
        }
        return sStsConnectionItemArray;
    }

    private void discoverStsConnectionItems(HashMap hashMap) {
        sStsConnectionItem[] sStsConnectionItemArray = this.getStsConnectionItems();
        if (sStsConnectionItemArray == null) {
            return;
        }
        for (int i = 0; i < sStsConnectionItemArray.length; ++i) {
            hashMap.put(new Integer(sStsConnectionItemArray[i].objIndex), sStsConnectionItemArray[i]);
        }
    }

    private synchronized boolean updateStsStructure() {
        HoConnectionModel hoConnectionModel;
        Object object;
        Object object2;
        Collection collection;
        boolean bl = false;
        if (this.db.on()) {
            this.db.println("Entry:: ConnectionModels::updateStsStructure()");
        }
        if ((collection = this.getStsConnectionIndexes()) == null) {
            this.db.println("Cannot get StsConnections from NE cannot process updateStsStructure");
            return bl;
        }
        Collection collection2 = HoConnections.getAddedObjects(collection, this.connectionModels.keySet());
        Iterator iterator = collection2.iterator();
        if (collection2.size() > 0) {
            if (this.db.on()) {
                this.db.println("New ho found # " + collection2.size());
            }
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                if (this.db.on()) {
                    this.db.println(" Sts # " + object2);
                }
                try {
                    object = this.getStsConnectionItem((Integer)object2);
                }
                catch (xNoSuchConnection xNoSuchConnection2) {
                    if (!this.db.on) continue;
                    this.db.println("Caught NoSuch Connection for Ho " + object2);
                    this.db.println("Continuing ...");
                    continue;
                }
                hoConnectionModel = new HoConnectionModel(this.node, (sStsConnectionItem)object, (Connections)this, this.hoConnModelDebug);
                this.connectionModels.put(object2, hoConnectionModel);
                hoConnectionModel.init();
            }
            bl = true;
        }
        if ((object2 = HoConnections.getDeletedObjects(collection, this.connectionModels.keySet())).size() > 0) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                object = (Integer)iterator.next();
                if (this.db.on()) {
                    this.db.println("Deleted sts found # " + object2.size());
                }
                if (this.db.on()) {
                    this.db.println("Deleted sts index " + object);
                }
                if ((hoConnectionModel = (HoConnectionModel)this.connectionModels.get(object)) == null) continue;
                hoConnectionModel.delete();
            }
        }
        if (this.db.on()) {
            this.db.println("Exit:: ConnectionModels::updateStsStructure()");
        }
        return bl;
    }

    public void update(Observable observable, Object object) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        int n = ((IObjectMessageInfo)object).getUpdateType();
        switch (n) {
            case 1: {
                if (this.db.on) {
                    this.db.println("Got a changed Message for HoConn");
                }
                this.container.updateLocal();
                break;
            }
            case 2: {
                if (this.db.on) {
                    this.db.println("Got an update Structure Message");
                }
                if (!this.updateStsStructure()) break;
                if (this.db.on) {
                    this.db.println("Going to notify about update");
                }
                this.setChanged();
                this.notifyObservers(ModelUpdateType.ADDED);
                break;
            }
            case 0: {
                break;
            }
            default: {
                String string = "Unknown update message (" + n + ") on HoConnections";
                this.db.println(string);
                HoConnDebug.printStackTrace((Throwable)new IllegalArgumentException(string));
            }
        }
    }

    public List getEtherStitchedConnections() {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        ArrayList<HoConnectionModel> arrayList = new ArrayList<HoConnectionModel>();
        for (HoConnectionModel hoConnectionModel : this.connectionModels.values()) {
            if (hoConnectionModel.getConnectionType() != 8) continue;
            arrayList.add(hoConnectionModel);
        }
        return arrayList;
    }

    private Collection getStsConnectionIndexes() {
        try {
            return this.toCollection((int[])this.getStsConnectionIndexes.get());
        }
        catch (UserException userException) {
            HoConnDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private sStsConnectionItem getStsConnectionItem(Integer n) throws xNoSuchConnection {
        try {
            return (sStsConnectionItem)this.getStsConnectionItem.get(n);
        }
        catch (xNoSuchConnection xNoSuchConnection2) {
            throw xNoSuchConnection2;
        }
        catch (UserException userException) {
            HoConnDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private class GetConnectionObjIndex
    extends NonCachedValue {
        public GetConnectionObjIndex(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        public Object getValue(Object object) throws UserException {
            int n = ((StsConnection)object).objIndex();
            return new Integer(n);
        }

        public Object outer() {
            return HoConnections.this;
        }
    }

    private class GetStsConnectionIndexes
    extends NonCachedValue {
        public GetStsConnectionIndexes(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            if (((HoConnections)HoConnections.this).db.on) {
                HoConnections.this.db.println("Calling getStsConnectionIndexes");
            }
            return HoConnections.this.getSonetFactoryRef().getStsConnectionIndexes();
        }

        public Object outer() {
            return HoConnections.this;
        }
    }

    private class GetStsConnectionItem
    extends NonCachedValue {
        public GetStsConnectionItem(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return HoConnections.this.getSonetFactoryRef().getStsConnectionItem((Integer)object);
        }

        public Object outer() {
            return HoConnections.this;
        }
    }

    private class GetStsConnections
    extends NonCachedValue {
        public GetStsConnections(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoConnections.this.getSonetFactoryRef().getStsConnections();
        }

        public Object outer() {
            return HoConnections.this;
        }
    }

    private class GetStsConnectionsList
    extends NonCachedValue {
        public GetStsConnectionsList(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoConnections.this.getSonetFactoryRef().getStsConnectionList();
        }

        public Object outer() {
            return HoConnections.this;
        }
    }

    public class HoConnDebug
    extends SDebug {
        HoConnDebug(KDebug kDebug) {
            super(kDebug, HoConnections.MY_DEBUG_KEY);
        }

        public final void update() {
            HoConnections.this.updateStsStructure();
            HoConnections.this.setChanged();
            HoConnections.this.notifyObservers(ModelUpdateType.ADDED);
        }

        public final void printConnections() {
            HoConnections.this.db.println("Printing List of HO Connections \n");
            HoConnections.this.printConnectionString(this);
        }
    }
}

