/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model;

import cerent.cms.idl.Common.ObjectType;
import cerent.cms.idl.SonetTopology.StsVcatTerm;
import cerent.cms.idl.SonetTopology.sStsVcatTermItem;
import cerent.cms.idl.SonetTopology.xNoSuchVcat;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractVcatTermsMap;
import cerent.cms.model.HoVcatTermModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchVcat;
import cerent.cms.model.NodeModelDelegate;
import cerent.cms.model.NonCachedValue;
import cerent.cms.model.VcatTermModel;
import cerent.cms.model.VcatTermModelsDelegate;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observer;
import org.omg.CORBA.UserException;

public class HoVcatTermsMap
extends AbstractVcatTermsMap
implements Observer {
    private static final String MY_DEBUG_KEY = "HoVcatTermsMap";
    GetStsVcatTerms getStsVcatTerms;
    GetStsVcatTermItemFromPort getStsVcatTermItemFromPort;

    public HoVcatTermsMap(VcatTermModelsDelegate vcatTermModelsDelegate) {
        super(vcatTermModelsDelegate);
        this.db = new HoVcatTermDebug(this.node.db);
        this.getStsVcatTerms = new GetStsVcatTerms(this.node, "HoVcatTermsMap.getStsVcatTerms");
        this.getStsVcatTermItemFromPort = new GetStsVcatTermItemFromPort(this.node, "HoVcatTermsMap.getStsVcatTermItemFromPort");
    }

    protected ObjectType getObjectType() {
        return ObjectType.ObjectStsVcatTermList;
    }

    protected boolean updateStructure() {
        return this.updateStsStructure();
    }

    protected HoVcatTermModel add(StsVcatTerm stsVcatTerm, int n) {
        sStsVcatTermItem sStsVcatTermItem2 = null;
        try {
            sStsVcatTermItem2 = this.getStsVcatTermItemFromPort(new Integer(n));
        }
        catch (NoSuchVcat noSuchVcat) {
            if (this.db.on()) {
                this.db.println("Exception occured in add-stsVcatTerm " + (Object)((Object)noSuchVcat));
                this.db.println("Unabe to find vcat on port:" + Integer.toHexString(n));
                this.printStackTrace((Exception)((Object)noSuchVcat));
            }
            return null;
        }
        return this.add(sStsVcatTermItem2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HoVcatTermModel add(sStsVcatTermItem sStsVcatTermItem2) {
        if (!this.isInitedRealState) {
            this.initReal();
        }
        HoVcatTermModel hoVcatTermModel = null;
        if (sStsVcatTermItem2 == null) {
            return null;
        }
        HoVcatTermsMap hoVcatTermsMap = this;
        synchronized (hoVcatTermsMap) {
            block9: {
                hoVcatTermModel = (HoVcatTermModel)this.findVcatTermModelInCache(sStsVcatTermItem2.objIndex);
                if (hoVcatTermModel == null) {
                    try {
                        hoVcatTermModel = new HoVcatTermModel(this.node, sStsVcatTermItem2, this);
                        hoVcatTermModel.init();
                        this.vcatTermModels.put(new Integer(sStsVcatTermItem2.objIndex), hoVcatTermModel);
                        this.setChanged();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (this.db.on()) {
                            this.db.println("Exception occured in add-stsVcatTerm " + (Object)((Object)abstractCmsIOException));
                            this.printStackTrace((Exception)((Object)abstractCmsIOException));
                        }
                        if (hoVcatTermModel == null) break block9;
                        hoVcatTermModel.dispose();
                        hoVcatTermModel = null;
                    }
                }
            }
        }
        this.notifyObservers(ModelUpdateType.ADDED);
        return hoVcatTermModel;
    }

    protected synchronized void discover(Map map) {
        sStsVcatTermItem[] sStsVcatTermItemArray = this.getStsVcatTerms();
        if (sStsVcatTermItemArray == null) {
            if (this.db.on()) {
                this.db.println("Error in getting StsVcatTerms (null) VcatTermModels::discoverStsVcatTerms");
            }
            return;
        }
        for (int i = 0; i < sStsVcatTermItemArray.length; ++i) {
            if (sStsVcatTermItemArray[i] == null) continue;
            Integer n = new Integer(sStsVcatTermItemArray[i].objIndex);
            if (map.get(n) != null) {
                String string = ((HoVcatTermModel)map.get(n)).getVcatName();
                if (this.db.on()) {
                    this.db.println("Error in Node DB: duplication of VCG indexes !! circuit name1 = " + string + " circuit name2 = " + sStsVcatTermItemArray[i].name + " index = " + n);
                    this.db.println(string + "will be reported as PARTIAL by NCP");
                }
            }
            map.put(n, new HoVcatTermModel(this.node, sStsVcatTermItemArray[i], this));
        }
    }

    private Map getStsVcatTermsMap() {
        sStsVcatTermItem[] sStsVcatTermItemArray = this.getStsVcatTerms();
        if (sStsVcatTermItemArray == null) {
            if (this.db.on()) {
                this.db.println("Error in getting StsVcatTerms (null) VcatTermModels::discoverStsVcatTerms");
            }
            return null;
        }
        HashMap<Integer, sStsVcatTermItem> hashMap = new HashMap<Integer, sStsVcatTermItem>();
        for (int i = 0; i < sStsVcatTermItemArray.length; ++i) {
            if (sStsVcatTermItemArray[i] == null) continue;
            Integer n = new Integer(sStsVcatTermItemArray[i].objIndex);
            hashMap.put(n, sStsVcatTermItemArray[i]);
        }
        return hashMap;
    }

    private sStsVcatTermItem[] getStsVcatTerms() {
        sStsVcatTermItem[] sStsVcatTermItemArray;
        if (this.node.getPlatform().is600()) {
            return null;
        }
        try {
            sStsVcatTermItemArray = (sStsVcatTermItem[])this.getStsVcatTerms.get();
        }
        catch (UserException userException) {
            if (this.db.on()) {
                this.db.println("Error in getting StsVcatTerms " + (Object)((Object)userException));
                SDebug.printStackTrace((Throwable)userException);
            }
            return null;
        }
        return sStsVcatTermItemArray;
    }

    private synchronized boolean updateStsStructure() {
        Object object;
        Object object2;
        if (this.db.on()) {
            this.db.println("Entry:: VcatTermModels::updateStsStructure");
        }
        boolean bl = false;
        Map map = this.getStsVcatTermsMap();
        if (map == null) {
            if (this.db.on()) {
                this.db.println("Could not find StsVcatTerm Indexes returning ..");
            }
            return false;
        }
        Collection collection = HoVcatTermsMap.getAddedObjects(map.keySet(), this.vcatTermModels.keySet());
        Iterator iterator = collection.iterator();
        if (collection.size() > 0) {
            if (this.db.on()) {
                this.db.println("New sts found # " + collection.size());
            }
            while (iterator.hasNext()) {
                object2 = (Integer)iterator.next();
                if (this.db.on) {
                    this.db.println("Adding Sts # " + object2 + " to List");
                }
                object = (sStsVcatTermItem)map.get(object2);
                HoVcatTermModel hoVcatTermModel = new HoVcatTermModel(this.node, (sStsVcatTermItem)object, this);
                hoVcatTermModel.init();
                this.vcatTermModels.put(object2, hoVcatTermModel);
            }
            bl = true;
        }
        if ((object2 = HoVcatTermsMap.getDeletedObjects(map.keySet(), this.vcatTermModels.keySet())).size() > 0) {
            iterator = object2.iterator();
            bl = true;
            if (this.db.on()) {
                this.db.println("Sts Deleted found # " + object2.size());
            }
            while (iterator.hasNext()) {
                object = (HoVcatTermModel)this.vcatTermModels.get(iterator.next());
                ((VcatTermModel)object).delete();
            }
        }
        if (this.db.on()) {
            this.db.println("Exit:: VcatTermModels::updateStsStructure");
        }
        return bl;
    }

    protected sStsVcatTermItem getStsVcatTermItemFromPort(Integer n) throws NoSuchVcat {
        try {
            return (sStsVcatTermItem)this.getStsVcatTermItemFromPort.get(n);
        }
        catch (xNoSuchVcat xNoSuchVcat2) {
            throw new NoSuchVcat((UserException)xNoSuchVcat2);
        }
        catch (UserException userException) {
            SDebug.printStackTrace((Throwable)userException);
            return null;
        }
    }

    private class GetStsVcatTermItemFromPort
    extends NonCachedValue {
        public GetStsVcatTermItemFromPort(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue(Object object) throws UserException {
            return HoVcatTermsMap.this.getSonetFactoryRef().getStsVcatTerm((Integer)object);
        }

        public Object outer() {
            return HoVcatTermsMap.this;
        }
    }

    private class GetStsVcatTerms
    extends NonCachedValue {
        public GetStsVcatTerms(NodeModelDelegate nodeModelDelegate, String string) {
            super(nodeModelDelegate, string);
        }

        protected Object getValue() throws UserException {
            return HoVcatTermsMap.this.getSonetFactoryRef().getAllStsVcatTerms();
        }

        public Object outer() {
            return HoVcatTermsMap.this;
        }
    }

    public class HoVcatTermDebug
    extends SDebug {
        HoVcatTermDebug(SDebug sDebug) {
            super((KDebug)sDebug, HoVcatTermsMap.MY_DEBUG_KEY);
        }

        public final void update() {
            HoVcatTermsMap.this.updateStsStructure();
        }

        public final void printVcatTerms() {
            HoVcatTermsMap.this.db.println("Printing List of LO VcatTerms \n");
            HoVcatTermsMap.this.printVcatTermsMapString(this);
        }
    }
}

